import { CfnVirtualRouter } from './appmesh.generated';
import { Construct } from '@aws-cdk/core';
/**
 * Properties for a VirtualRouter listener.
 *
 * @stability stable
 */
export interface VirtualRouterListenerConfig {
    /**
     * Single listener config for a VirtualRouter.
     *
     * @stability stable
     */
    readonly listener: CfnVirtualRouter.VirtualRouterListenerProperty;
}
/**
 * Represents the properties needed to define listeners for a VirtualRouter.
 *
 * @stability stable
 */
export declare abstract class VirtualRouterListener {
    /**
     * Returns an HTTP Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @stability stable
     */
    static http(port?: number): VirtualRouterListener;
    /**
     * Returns an HTTP2 Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @stability stable
     */
    static http2(port?: number): VirtualRouterListener;
    /**
     * Returns a GRPC Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @stability stable
     */
    static grpc(port?: number): VirtualRouterListener;
    /**
     * Returns a TCP Listener for a VirtualRouter.
     *
     * @param port the optional port of the listener, 8080 by default.
     * @stability stable
     */
    static tcp(port?: number): VirtualRouterListener;
    /**
     * Called when the VirtualRouterListener type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity
     *
     * @stability stable
     */
    abstract bind(scope: Construct): VirtualRouterListenerConfig;
}
