/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.List;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.statement.AssertStatement;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.BreakStatement;
import org.jd.core.v1.model.javasyntax.statement.ByteCodeStatement;
import org.jd.core.v1.model.javasyntax.statement.CommentStatement;
import org.jd.core.v1.model.javasyntax.statement.ContinueStatement;
import org.jd.core.v1.model.javasyntax.statement.DoWhileStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ForEachStatement;
import org.jd.core.v1.model.javasyntax.statement.ForStatement;
import org.jd.core.v1.model.javasyntax.statement.IfElseStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.LabelStatement;
import org.jd.core.v1.model.javasyntax.statement.LambdaExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.LocalVariableDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.statement.SynchronizedStatement;
import org.jd.core.v1.model.javasyntax.statement.ThrowStatement;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.statement.TypeDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileTryStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.DeclaredSyntheticLocalVariableVisitor;
import org.jd.core.v1.util.DefaultList;

public class RemoveFinallyStatementsVisitor
implements StatementVisitor {
    protected DeclaredSyntheticLocalVariableVisitor declaredSyntheticLocalVariableVisitor = new DeclaredSyntheticLocalVariableVisitor();
    protected LocalVariableMaker localVariableMaker;
    protected int statementCountInFinally;
    protected int statementCountToRemove;

    public RemoveFinallyStatementsVisitor(LocalVariableMaker localVariableMaker) {
        this.localVariableMaker = localVariableMaker;
    }

    public void init() {
        this.statementCountInFinally = 0;
        this.statementCountToRemove = 0;
    }

    @Override
    public void visit(Statements statements) {
        Statements stmts = statements;
        int size = statements.size();
        if (size > 0) {
            int i = size;
            int oldStatementCountToRemove = this.statementCountToRemove;
            Statement lastStatement = (Statement)stmts.getLast();
            Class<?> lastStatementClass = lastStatement.getClass();
            if (lastStatementClass == ReturnExpressionStatement.class || lastStatementClass == ReturnStatement.class) {
                this.statementCountToRemove = this.statementCountInFinally;
                --i;
            } else if (lastStatementClass == ThrowStatement.class) {
                this.statementCountToRemove = 0;
                --i;
            } else if (lastStatementClass == ContinueStatement.class || lastStatementClass == BreakStatement.class) {
                --i;
            } else {
                WhileStatement whileStatement = RemoveFinallyStatementsVisitor.getInfiniteWhileStatement(lastStatement);
                if (whileStatement != null) {
                    this.statementCountToRemove = 0;
                    --i;
                    whileStatement.getStatements().accept(this);
                }
            }
            this.declaredSyntheticLocalVariableVisitor.init();
            if (this.statementCountToRemove > 0) {
                List<Statement> list;
                if (i > this.statementCountToRemove) {
                    list = statements.subList(i - this.statementCountToRemove, i);
                    for (Statement statement : list) {
                        statement.accept(this.declaredSyntheticLocalVariableVisitor);
                    }
                    lastStatement.accept(this.declaredSyntheticLocalVariableVisitor);
                    list.clear();
                    i -= this.statementCountToRemove;
                    this.statementCountToRemove = 0;
                } else {
                    list = statements;
                    for (Statement statement : list) {
                        statement.accept(this.declaredSyntheticLocalVariableVisitor);
                    }
                    list.clear();
                    if (i < size) {
                        list.add(lastStatement);
                    }
                    this.statementCountToRemove -= i;
                    i = 0;
                }
            }
            while (i-- > 0) {
                ((Statement)stmts.get(i)).accept(this);
                if (this.statementCountToRemove <= 0 || i + this.statementCountToRemove >= statements.size()) continue;
                statements.subList(i + 1, i + 1 + this.statementCountToRemove).clear();
                this.statementCountToRemove = 0;
            }
            this.statementCountToRemove = oldStatementCountToRemove;
        }
    }

    private static WhileStatement getInfiniteWhileStatement(Statement statement) {
        if (statement.getClass() == LabelStatement.class) {
            statement = ((LabelStatement)statement).getStatement();
        }
        if (statement == null || statement.getClass() != WhileStatement.class) {
            return null;
        }
        WhileStatement whileStatement = (WhileStatement)statement;
        if (whileStatement.getCondition().getClass() != BooleanExpression.class) {
            return null;
        }
        BooleanExpression booleanExpression = (BooleanExpression)whileStatement.getCondition();
        if (booleanExpression.isFalse()) {
            return null;
        }
        return whileStatement;
    }

    @Override
    public void visit(IfElseStatement statement) {
        statement.getStatements().accept(this);
        statement.getElseStatements().accept(this);
    }

    @Override
    public void visit(SwitchStatement statement) {
        for (SwitchStatement.Block block : statement.getBlocks()) {
            block.getStatements().accept(this);
        }
    }

    @Override
    public void visit(TryStatement statement) {
        ClassFileTryStatement ts = (ClassFileTryStatement)statement;
        Statements tryStatements = (Statements)ts.getTryStatements();
        Statements finallyStatements = (Statements)ts.getFinallyStatements();
        this.safeAccept(finallyStatements);
        if (ts.isJsr() || finallyStatements == null || finallyStatements.size() == 0) {
            tryStatements.accept(this);
            this.safeAcceptListStatement(statement.getCatchClauses());
        } else if (ts.isEclipse()) {
            DefaultList<TryStatement.CatchClause> catchClauses = statement.getCatchClauses();
            int oldStatementCountInFinally = this.statementCountInFinally;
            int finallyStatementsSize = finallyStatements.size();
            this.statementCountInFinally += finallyStatementsSize;
            this.removeFinallyStatements(tryStatements);
            this.statementCountToRemove = finallyStatementsSize;
            if (catchClauses != null) {
                for (TryStatement.CatchClause cc : catchClauses) {
                    this.removeFinallyStatements((Statements)cc.getStatements());
                }
            }
            this.statementCountInFinally = oldStatementCountInFinally;
            if (statement.getResources() != null) {
                ts.setFinallyStatements(null);
            }
        } else {
            DefaultList<TryStatement.CatchClause> catchClauses = statement.getCatchClauses();
            int oldStatementCountInFinally = this.statementCountInFinally;
            int oldStatementCountToRemove = this.statementCountToRemove;
            int finallyStatementsSize = finallyStatements.size();
            this.statementCountInFinally += finallyStatementsSize;
            this.statementCountToRemove += finallyStatementsSize;
            this.removeFinallyStatements(tryStatements);
            if (catchClauses != null) {
                for (TryStatement.CatchClause cc : catchClauses) {
                    this.removeFinallyStatements((Statements)cc.getStatements());
                }
            }
            this.statementCountInFinally = oldStatementCountInFinally;
            this.statementCountToRemove = oldStatementCountToRemove;
            if (statement.getResources() != null) {
                ts.setFinallyStatements(null);
            }
        }
    }

    public void removeFinallyStatements(Statements list) {
        if (list.size() == 1 && ((Statement)list.get(0)).getClass() == ClassFileTryStatement.class) {
            int oldStatementCountToRemove = this.statementCountToRemove;
            assert (((Statement)list.getFirst()).getClass() == ClassFileTryStatement.class);
            this.statementCountToRemove = 0;
            list.accept(this);
            this.statementCountToRemove = oldStatementCountToRemove;
        } else {
            list.accept(this);
        }
    }

    @Override
    public void visit(DoWhileStatement statement) {
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(ForEachStatement statement) {
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(ForStatement statement) {
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(IfStatement statement) {
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(SynchronizedStatement statement) {
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(TryStatement.CatchClause statement) {
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(WhileStatement statement) {
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(SwitchStatement.LabelBlock statement) {
        statement.getStatements().accept(this);
    }

    @Override
    public void visit(SwitchStatement.MultiLabelsBlock statement) {
        statement.getStatements().accept(this);
    }

    @Override
    public void visit(AssertStatement statement) {
    }

    @Override
    public void visit(BreakStatement statement) {
    }

    @Override
    public void visit(ByteCodeStatement statement) {
    }

    @Override
    public void visit(CommentStatement statement) {
    }

    @Override
    public void visit(ContinueStatement statement) {
    }

    @Override
    public void visit(ExpressionStatement statement) {
    }

    @Override
    public void visit(LabelStatement statement) {
    }

    @Override
    public void visit(LambdaExpressionStatement statement) {
    }

    @Override
    public void visit(LocalVariableDeclarationStatement statement) {
    }

    @Override
    public void visit(ReturnExpressionStatement statement) {
    }

    @Override
    public void visit(ReturnStatement statement) {
    }

    @Override
    public void visit(SwitchStatement.DefaultLabel statement) {
    }

    @Override
    public void visit(SwitchStatement.ExpressionLabel statement) {
    }

    @Override
    public void visit(ThrowStatement statement) {
    }

    @Override
    public void visit(TryStatement.Resource statement) {
    }

    @Override
    public void visit(TypeDeclarationStatement statement) {
    }

    protected void safeAccept(BaseStatement list) {
        if (list != null) {
            list.accept(this);
        }
    }

    protected void safeAcceptListStatement(List<? extends Statement> list) {
        if (list != null) {
            for (Statement statement : list) {
                statement.accept(this);
            }
        }
    }
}

