"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosRule = exports.RosDeliveryChannel = exports.RosCompliancePack = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosCompliancePackProps`
 *
 * @param properties - the TypeScript properties of a `RosCompliancePackProps`
 *
 * @returns the result of the validation.
 */
function RosCompliancePackPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('compliancePackName', ros.requiredValidator)(properties.compliancePackName));
    errors.collect(ros.propertyValidator('compliancePackName', ros.validateString)(properties.compliancePackName));
    errors.collect(ros.propertyValidator('description', ros.requiredValidator)(properties.description));
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('configRules', ros.listValidator(RosCompliancePack_ConfigRulesPropertyValidator))(properties.configRules));
    errors.collect(ros.propertyValidator('compliancePackTemplateId', ros.validateString)(properties.compliancePackTemplateId));
    errors.collect(ros.propertyValidator('riskLevel', ros.requiredValidator)(properties.riskLevel));
    errors.collect(ros.propertyValidator('riskLevel', ros.validateNumber)(properties.riskLevel));
    return errors.wrap('supplied properties not correct for "RosCompliancePackProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Config::CompliancePack` resource
 *
 * @param properties - the TypeScript properties of a `RosCompliancePackProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Config::CompliancePack` resource.
 */
// @ts-ignore TS6133
function rosCompliancePackPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosCompliancePackPropsValidator(properties).assertSuccess();
    }
    return {
        CompliancePackName: ros.stringToRosTemplate(properties.compliancePackName),
        Description: ros.stringToRosTemplate(properties.description),
        RiskLevel: ros.numberToRosTemplate(properties.riskLevel),
        CompliancePackTemplateId: ros.stringToRosTemplate(properties.compliancePackTemplateId),
        ConfigRules: ros.listMapper(rosCompliancePackConfigRulesPropertyToRosTemplate)(properties.configRules),
    };
}
/**
 * A ROS template type:  `ALIYUN::Config::CompliancePack`
 */
class RosCompliancePack extends ros.RosResource {
    /**
     * Create a new `ALIYUN::Config::CompliancePack`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCompliancePack.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAccountId = this.getAtt('AccountId');
        this.attrCompliancePackId = this.getAtt('CompliancePackId');
        this.attrCompliancePackName = this.getAtt('CompliancePackName');
        this.attrCompliancePackTemplateId = this.getAtt('CompliancePackTemplateId');
        this.attrDescription = this.getAtt('Description');
        this.attrRiskLevel = this.getAtt('RiskLevel');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.compliancePackName = props.compliancePackName;
        this.description = props.description;
        this.riskLevel = props.riskLevel;
        this.compliancePackTemplateId = props.compliancePackTemplateId;
        this.configRules = props.configRules;
    }
    get rosProperties() {
        return {
            compliancePackName: this.compliancePackName,
            description: this.description,
            riskLevel: this.riskLevel,
            compliancePackTemplateId: this.compliancePackTemplateId,
            configRules: this.configRules,
        };
    }
    renderProperties(props) {
        return rosCompliancePackPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCompliancePack = RosCompliancePack;
/**
 * The resource type name for this resource class.
 */
RosCompliancePack.ROS_RESOURCE_TYPE_NAME = "ALIYUN::Config::CompliancePack";
/**
 * Determine whether the given properties match those of a `ConfigRuleParametersProperty`
 *
 * @param properties - the TypeScript properties of a `ConfigRuleParametersProperty`
 *
 * @returns the result of the validation.
 */
function RosCompliancePack_ConfigRuleParametersPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('parameterValue', ros.validateString)(properties.parameterValue));
    errors.collect(ros.propertyValidator('required', ros.validateBoolean)(properties.required));
    errors.collect(ros.propertyValidator('parameterName', ros.validateString)(properties.parameterName));
    return errors.wrap('supplied properties not correct for "ConfigRuleParametersProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Config::CompliancePack.ConfigRuleParameters` resource
 *
 * @param properties - the TypeScript properties of a `ConfigRuleParametersProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Config::CompliancePack.ConfigRuleParameters` resource.
 */
// @ts-ignore TS6133
function rosCompliancePackConfigRuleParametersPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCompliancePack_ConfigRuleParametersPropertyValidator(properties).assertSuccess();
    return {
        ParameterValue: ros.stringToRosTemplate(properties.parameterValue),
        Required: ros.booleanToRosTemplate(properties.required),
        ParameterName: ros.stringToRosTemplate(properties.parameterName),
    };
}
/**
 * Determine whether the given properties match those of a `ConfigRulesProperty`
 *
 * @param properties - the TypeScript properties of a `ConfigRulesProperty`
 *
 * @returns the result of the validation.
 */
function RosCompliancePack_ConfigRulesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('configRuleId', ros.validateString)(properties.configRuleId));
    errors.collect(ros.propertyValidator('configRuleName', ros.validateString)(properties.configRuleName));
    errors.collect(ros.propertyValidator('managedRuleIdentifier', ros.validateString)(properties.managedRuleIdentifier));
    errors.collect(ros.propertyValidator('configRuleParameters', ros.listValidator(RosCompliancePack_ConfigRuleParametersPropertyValidator))(properties.configRuleParameters));
    return errors.wrap('supplied properties not correct for "ConfigRulesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Config::CompliancePack.ConfigRules` resource
 *
 * @param properties - the TypeScript properties of a `ConfigRulesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Config::CompliancePack.ConfigRules` resource.
 */
// @ts-ignore TS6133
function rosCompliancePackConfigRulesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCompliancePack_ConfigRulesPropertyValidator(properties).assertSuccess();
    return {
        ConfigRuleId: ros.stringToRosTemplate(properties.configRuleId),
        ConfigRuleName: ros.stringToRosTemplate(properties.configRuleName),
        ManagedRuleIdentifier: ros.stringToRosTemplate(properties.managedRuleIdentifier),
        ConfigRuleParameters: ros.listMapper(rosCompliancePackConfigRuleParametersPropertyToRosTemplate)(properties.configRuleParameters),
    };
}
/**
 * Determine whether the given properties match those of a `RosDeliveryChannelProps`
 *
 * @param properties - the TypeScript properties of a `RosDeliveryChannelProps`
 *
 * @returns the result of the validation.
 */
function RosDeliveryChannelPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('deliveryChannelName', ros.validateString)(properties.deliveryChannelName));
    errors.collect(ros.propertyValidator('deliveryChannelTargetArn', ros.requiredValidator)(properties.deliveryChannelTargetArn));
    errors.collect(ros.propertyValidator('deliveryChannelTargetArn', ros.validateString)(properties.deliveryChannelTargetArn));
    errors.collect(ros.propertyValidator('deliveryChannelAssumeRoleArn', ros.requiredValidator)(properties.deliveryChannelAssumeRoleArn));
    errors.collect(ros.propertyValidator('deliveryChannelAssumeRoleArn', ros.validateString)(properties.deliveryChannelAssumeRoleArn));
    errors.collect(ros.propertyValidator('deliveryChannelType', ros.requiredValidator)(properties.deliveryChannelType));
    if (properties.deliveryChannelType && (typeof properties.deliveryChannelType) !== 'object') {
        errors.collect(ros.propertyValidator('deliveryChannelType', ros.validateAllowedValues)({
            data: properties.deliveryChannelType,
            allowedValues: ["MNS", "OSS", "SLS"],
        }));
    }
    errors.collect(ros.propertyValidator('deliveryChannelType', ros.validateString)(properties.deliveryChannelType));
    errors.collect(ros.propertyValidator('deliveryChannelCondition', ros.validateString)(properties.deliveryChannelCondition));
    return errors.wrap('supplied properties not correct for "RosDeliveryChannelProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Config::DeliveryChannel` resource
 *
 * @param properties - the TypeScript properties of a `RosDeliveryChannelProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Config::DeliveryChannel` resource.
 */
// @ts-ignore TS6133
function rosDeliveryChannelPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDeliveryChannelPropsValidator(properties).assertSuccess();
    }
    return {
        DeliveryChannelAssumeRoleArn: ros.stringToRosTemplate(properties.deliveryChannelAssumeRoleArn),
        DeliveryChannelTargetArn: ros.stringToRosTemplate(properties.deliveryChannelTargetArn),
        DeliveryChannelType: ros.stringToRosTemplate(properties.deliveryChannelType),
        DeliveryChannelCondition: ros.stringToRosTemplate(properties.deliveryChannelCondition),
        DeliveryChannelName: ros.stringToRosTemplate(properties.deliveryChannelName),
        Description: ros.stringToRosTemplate(properties.description),
    };
}
/**
 * A ROS template type:  `ALIYUN::Config::DeliveryChannel`
 */
class RosDeliveryChannel extends ros.RosResource {
    /**
     * Create a new `ALIYUN::Config::DeliveryChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDeliveryChannel.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDeliveryChannelId = this.getAtt('DeliveryChannelId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.deliveryChannelAssumeRoleArn = props.deliveryChannelAssumeRoleArn;
        this.deliveryChannelTargetArn = props.deliveryChannelTargetArn;
        this.deliveryChannelType = props.deliveryChannelType;
        this.deliveryChannelCondition = props.deliveryChannelCondition;
        this.deliveryChannelName = props.deliveryChannelName;
        this.description = props.description;
    }
    get rosProperties() {
        return {
            deliveryChannelAssumeRoleArn: this.deliveryChannelAssumeRoleArn,
            deliveryChannelTargetArn: this.deliveryChannelTargetArn,
            deliveryChannelType: this.deliveryChannelType,
            deliveryChannelCondition: this.deliveryChannelCondition,
            deliveryChannelName: this.deliveryChannelName,
            description: this.description,
        };
    }
    renderProperties(props) {
        return rosDeliveryChannelPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDeliveryChannel = RosDeliveryChannel;
/**
 * The resource type name for this resource class.
 */
RosDeliveryChannel.ROS_RESOURCE_TYPE_NAME = "ALIYUN::Config::DeliveryChannel";
/**
 * Determine whether the given properties match those of a `RosRuleProps`
 *
 * @param properties - the TypeScript properties of a `RosRuleProps`
 *
 * @returns the result of the validation.
 */
function RosRulePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('tagKeyScope', ros.validateString)(properties.tagKeyScope));
    errors.collect(ros.propertyValidator('tagValueScope', ros.validateString)(properties.tagValueScope));
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('excludeResourceIdsScope', ros.validateString)(properties.excludeResourceIdsScope));
    errors.collect(ros.propertyValidator('tagKeyLogicScope', ros.validateString)(properties.tagKeyLogicScope));
    errors.collect(ros.propertyValidator('sourceOwner', ros.requiredValidator)(properties.sourceOwner));
    errors.collect(ros.propertyValidator('sourceOwner', ros.validateString)(properties.sourceOwner));
    errors.collect(ros.propertyValidator('sourceIdentifier', ros.requiredValidator)(properties.sourceIdentifier));
    errors.collect(ros.propertyValidator('sourceIdentifier', ros.validateString)(properties.sourceIdentifier));
    errors.collect(ros.propertyValidator('maximumExecutionFrequency', ros.validateString)(properties.maximumExecutionFrequency));
    errors.collect(ros.propertyValidator('regionIdsScope', ros.validateString)(properties.regionIdsScope));
    errors.collect(ros.propertyValidator('configRuleTriggerTypes', ros.requiredValidator)(properties.configRuleTriggerTypes));
    errors.collect(ros.propertyValidator('configRuleTriggerTypes', ros.validateString)(properties.configRuleTriggerTypes));
    errors.collect(ros.propertyValidator('resourceGroupIdsScope', ros.validateString)(properties.resourceGroupIdsScope));
    errors.collect(ros.propertyValidator('riskLevel', ros.requiredValidator)(properties.riskLevel));
    errors.collect(ros.propertyValidator('riskLevel', ros.validateNumber)(properties.riskLevel));
    errors.collect(ros.propertyValidator('resourceTypesScope', ros.requiredValidator)(properties.resourceTypesScope));
    errors.collect(ros.propertyValidator('resourceTypesScope', ros.listValidator(ros.validateString))(properties.resourceTypesScope));
    errors.collect(ros.propertyValidator('ruleName', ros.requiredValidator)(properties.ruleName));
    errors.collect(ros.propertyValidator('ruleName', ros.validateString)(properties.ruleName));
    errors.collect(ros.propertyValidator('inputParameters', ros.hashValidator(ros.validateAny))(properties.inputParameters));
    return errors.wrap('supplied properties not correct for "RosRuleProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Config::Rule` resource
 *
 * @param properties - the TypeScript properties of a `RosRuleProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Config::Rule` resource.
 */
// @ts-ignore TS6133
function rosRulePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosRulePropsValidator(properties).assertSuccess();
    }
    return {
        ConfigRuleTriggerTypes: ros.stringToRosTemplate(properties.configRuleTriggerTypes),
        ResourceTypesScope: ros.listMapper(ros.stringToRosTemplate)(properties.resourceTypesScope),
        RiskLevel: ros.numberToRosTemplate(properties.riskLevel),
        RuleName: ros.stringToRosTemplate(properties.ruleName),
        SourceIdentifier: ros.stringToRosTemplate(properties.sourceIdentifier),
        SourceOwner: ros.stringToRosTemplate(properties.sourceOwner),
        Description: ros.stringToRosTemplate(properties.description),
        ExcludeResourceIdsScope: ros.stringToRosTemplate(properties.excludeResourceIdsScope),
        InputParameters: ros.hashMapper(ros.objectToRosTemplate)(properties.inputParameters),
        MaximumExecutionFrequency: ros.stringToRosTemplate(properties.maximumExecutionFrequency),
        RegionIdsScope: ros.stringToRosTemplate(properties.regionIdsScope),
        ResourceGroupIdsScope: ros.stringToRosTemplate(properties.resourceGroupIdsScope),
        TagKeyLogicScope: ros.stringToRosTemplate(properties.tagKeyLogicScope),
        TagKeyScope: ros.stringToRosTemplate(properties.tagKeyScope),
        TagValueScope: ros.stringToRosTemplate(properties.tagValueScope),
    };
}
/**
 * A ROS template type:  `ALIYUN::Config::Rule`
 */
class RosRule extends ros.RosResource {
    /**
     * Create a new `ALIYUN::Config::Rule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosRule.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrConfigRuleArn = this.getAtt('ConfigRuleArn');
        this.attrConfigRuleId = this.getAtt('ConfigRuleId');
        this.attrConfigRuleTriggerTypes = this.getAtt('ConfigRuleTriggerTypes');
        this.attrDescription = this.getAtt('Description');
        this.attrEventSource = this.getAtt('EventSource');
        this.attrExcludeResourceIdsScope = this.getAtt('ExcludeResourceIdsScope');
        this.attrInputParameters = this.getAtt('InputParameters');
        this.attrMaximumExecutionFrequency = this.getAtt('MaximumExecutionFrequency');
        this.attrRegionIdsScope = this.getAtt('RegionIdsScope');
        this.attrResourceGroupIdsScope = this.getAtt('ResourceGroupIdsScope');
        this.attrResourceTypesScope = this.getAtt('ResourceTypesScope');
        this.attrRiskLevel = this.getAtt('RiskLevel');
        this.attrRuleName = this.getAtt('RuleName');
        this.attrSourceIdentifier = this.getAtt('SourceIdentifier');
        this.attrSourceOwner = this.getAtt('SourceOwner');
        this.attrTagKeyScope = this.getAtt('TagKeyScope');
        this.attrTagValueScope = this.getAtt('TagValueScope');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.configRuleTriggerTypes = props.configRuleTriggerTypes;
        this.resourceTypesScope = props.resourceTypesScope;
        this.riskLevel = props.riskLevel;
        this.ruleName = props.ruleName;
        this.sourceIdentifier = props.sourceIdentifier;
        this.sourceOwner = props.sourceOwner;
        this.description = props.description;
        this.excludeResourceIdsScope = props.excludeResourceIdsScope;
        this.inputParameters = props.inputParameters;
        this.maximumExecutionFrequency = props.maximumExecutionFrequency;
        this.regionIdsScope = props.regionIdsScope;
        this.resourceGroupIdsScope = props.resourceGroupIdsScope;
        this.tagKeyLogicScope = props.tagKeyLogicScope;
        this.tagKeyScope = props.tagKeyScope;
        this.tagValueScope = props.tagValueScope;
    }
    get rosProperties() {
        return {
            configRuleTriggerTypes: this.configRuleTriggerTypes,
            resourceTypesScope: this.resourceTypesScope,
            riskLevel: this.riskLevel,
            ruleName: this.ruleName,
            sourceIdentifier: this.sourceIdentifier,
            sourceOwner: this.sourceOwner,
            description: this.description,
            excludeResourceIdsScope: this.excludeResourceIdsScope,
            inputParameters: this.inputParameters,
            maximumExecutionFrequency: this.maximumExecutionFrequency,
            regionIdsScope: this.regionIdsScope,
            resourceGroupIdsScope: this.resourceGroupIdsScope,
            tagKeyLogicScope: this.tagKeyLogicScope,
            tagKeyScope: this.tagKeyScope,
            tagValueScope: this.tagValueScope,
        };
    }
    renderProperties(props) {
        return rosRulePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosRule = RosRule;
/**
 * The resource type name for this resource class.
 */
RosRule.ROS_RESOURCE_TYPE_NAME = "ALIYUN::Config::Rule";
//# sourceMappingURL=data:application/json;base64,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