# coding: utf-8

"""
    TKG Kubernetes API

    This API provides to vCD tenants the means to provision (create and update) Tanzu Kubernetes Grid clusters. This is complementary to the defined-entity APIs:    GET /cloudapi/1.0.0/entities/urn:vcloud:entity:vmware.tkgcluster:1.0.0:{id} which allows to retrieve the clusters created by the API presented here. This is why you will not find here a GET operation for the corresponding entity.   # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class TkgClusterSpecSettingsStorage(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'classes': 'list[str]',
        'default_class': 'str'
    }

    attribute_map = {
        'classes': 'classes',
        'default_class': 'defaultClass'
    }

    def __init__(self, classes=None, default_class=None):  # noqa: E501
        """TkgClusterSpecSettingsStorage - a model defined in Swagger"""  # noqa: E501

        self._classes = None
        self._default_class = None
        self.discriminator = None

        if classes is not None:
            self.classes = classes
        if default_class is not None:
            self.default_class = default_class

    @property
    def classes(self):
        """Gets the classes of this TkgClusterSpecSettingsStorage.  # noqa: E501

        Specifies named persistent volume (PV) storage classes for container workloads. Select a storage class associated with the placement-policy (as defined by the element placementPolicy above).   # noqa: E501

        :return: The classes of this TkgClusterSpecSettingsStorage.  # noqa: E501
        :rtype: list[str]
        """
        return self._classes

    @classes.setter
    def classes(self, classes):
        """Sets the classes of this TkgClusterSpecSettingsStorage.

        Specifies named persistent volume (PV) storage classes for container workloads. Select a storage class associated with the placement-policy (as defined by the element placementPolicy above).   # noqa: E501

        :param classes: The classes of this TkgClusterSpecSettingsStorage.  # noqa: E501
        :type: list[str]
        """

        self._classes = classes

    @property
    def default_class(self):
        """Gets the default_class of this TkgClusterSpecSettingsStorage.  # noqa: E501

        Specifies a named storage class to be annotated as the default in the cluster. If you do not specify it, there is no default. You do not have to specify one or more classes to specify a defaultClass. Select a storage class associated with the placement-policy (as defined by the element placementPolicy above).   # noqa: E501

        :return: The default_class of this TkgClusterSpecSettingsStorage.  # noqa: E501
        :rtype: str
        """
        return self._default_class

    @default_class.setter
    def default_class(self, default_class):
        """Sets the default_class of this TkgClusterSpecSettingsStorage.

        Specifies a named storage class to be annotated as the default in the cluster. If you do not specify it, there is no default. You do not have to specify one or more classes to specify a defaultClass. Select a storage class associated with the placement-policy (as defined by the element placementPolicy above).   # noqa: E501

        :param default_class: The default_class of this TkgClusterSpecSettingsStorage.  # noqa: E501
        :type: str
        """

        self._default_class = default_class

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TkgClusterSpecSettingsStorage):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
