"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRouteIntegration = exports.HttpIntegration = exports.PayloadFormatVersion = exports.HttpConnectionType = exports.IntegrationCredentials = exports.HttpIntegrationSubtype = exports.HttpIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Supported integration types
 */
var HttpIntegrationType;
(function (HttpIntegrationType) {
    /**
     * Integration type is an HTTP proxy.
     *
     * For integrating the route or method request with an HTTP endpoint, with the
     * client request passed through as-is. This is also referred to as HTTP proxy
     * integration. For HTTP API private integrations, use an HTTP_PROXY integration.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-http.html
     */
    HttpIntegrationType["HTTP_PROXY"] = "HTTP_PROXY";
    /**
     * Integration type is an AWS proxy.
     *
     * For integrating the route or method request with a Lambda function or other
     * AWS service action. This integration is also referred to as a Lambda proxy
     * integration.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     */
    HttpIntegrationType["AWS_PROXY"] = "AWS_PROXY";
})(HttpIntegrationType = exports.HttpIntegrationType || (exports.HttpIntegrationType = {}));
/**
 * Supported integration subtypes
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html
 */
var HttpIntegrationSubtype;
(function (HttpIntegrationSubtype) {
    /**
     * EventBridge PutEvents integration
     */
    HttpIntegrationSubtype["EVENTBRIDGE_PUT_EVENTS"] = "EventBridge-PutEvents";
    /**
     * SQS SendMessage integration
     */
    HttpIntegrationSubtype["SQS_SEND_MESSAGE"] = "SQS-SendMessage";
    /**
     * SQS ReceiveMessage integration,
     */
    HttpIntegrationSubtype["SQS_RECEIVE_MESSAGE"] = "SQS-ReceiveMessage";
    /**
     * SQS DeleteMessage integration,
     */
    HttpIntegrationSubtype["SQS_DELETE_MESSAGE"] = "SQS-DeleteMessage";
    /**
     * SQS PurgeQueue integration
     */
    HttpIntegrationSubtype["SQS_PURGE_QUEUE"] = "SQS-PurgeQueue";
    /**
     * AppConfig GetConfiguration integration
     */
    HttpIntegrationSubtype["APPCONFIG_GET_CONFIGURATION"] = "AppConfig-GetConfiguration";
    /**
     * Kinesis PutRecord integration
     */
    HttpIntegrationSubtype["KINESIS_PUT_RECORD"] = "Kinesis-PutRecord";
    /**
     * Step Functions StartExecution integration
     */
    HttpIntegrationSubtype["STEPFUNCTIONS_START_EXECUTION"] = "StepFunctions-StartExecution";
    /**
     * Step Functions StartSyncExecution integration
     */
    HttpIntegrationSubtype["STEPFUNCTIONS_START_SYNC_EXECUTION"] = "StepFunctions-StartSyncExecution";
    /**
     * Step Functions StopExecution integration
     */
    HttpIntegrationSubtype["STEPFUNCTIONS_STOP_EXECUTION"] = "StepFunctions-StopExecution";
})(HttpIntegrationSubtype = exports.HttpIntegrationSubtype || (exports.HttpIntegrationSubtype = {}));
/**
 * Credentials used for AWS Service integrations.
 */
class IntegrationCredentials {
    /**
     * Use the specified role for integration requests
     */
    static fromRole(role) {
        return { credentialsArn: role.roleArn };
    }
    /** Use the calling user's identity to call the integration */
    static useCallerIdentity() {
        return { credentialsArn: 'arn:aws:iam::*:user/*' };
    }
}
exports.IntegrationCredentials = IntegrationCredentials;
_a = JSII_RTTI_SYMBOL_1;
IntegrationCredentials[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.IntegrationCredentials", version: "2.15.0-alpha.0" };
/**
 * Supported connection types
 */
var HttpConnectionType;
(function (HttpConnectionType) {
    /**
     * For private connections between API Gateway and resources in a VPC
     */
    HttpConnectionType["VPC_LINK"] = "VPC_LINK";
    /**
     * For connections through public routable internet
     */
    HttpConnectionType["INTERNET"] = "INTERNET";
})(HttpConnectionType = exports.HttpConnectionType || (exports.HttpConnectionType = {}));
/**
 * Payload format version for lambda proxy integration
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 */
class PayloadFormatVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * A custom payload version.
     * Typically used if there is a version number that the CDK doesn't support yet
     */
    static custom(version) {
        return new PayloadFormatVersion(version);
    }
}
exports.PayloadFormatVersion = PayloadFormatVersion;
_b = JSII_RTTI_SYMBOL_1;
PayloadFormatVersion[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.PayloadFormatVersion", version: "2.15.0-alpha.0" };
/** Version 1.0 */
PayloadFormatVersion.VERSION_1_0 = new PayloadFormatVersion('1.0');
/** Version 2.0 */
PayloadFormatVersion.VERSION_2_0 = new PayloadFormatVersion('2.0');
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class HttpIntegration extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        var _e, _f, _g;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpIntegrationProps(props);
        if (!props.integrationSubtype && !props.integrationUri) {
            throw new Error('Either `integrationSubtype` or `integrationUri` must be specified.');
        }
        const integ = new aws_apigatewayv2_1.CfnIntegration(this, 'Resource', {
            apiId: props.httpApi.apiId,
            integrationType: props.integrationType,
            integrationSubtype: props.integrationSubtype,
            integrationUri: props.integrationUri,
            integrationMethod: props.method,
            connectionId: props.connectionId,
            connectionType: props.connectionType,
            payloadFormatVersion: (_e = props.payloadFormatVersion) === null || _e === void 0 ? void 0 : _e.version,
            requestParameters: (_f = props.parameterMapping) === null || _f === void 0 ? void 0 : _f.mappings,
            credentialsArn: (_g = props.credentials) === null || _g === void 0 ? void 0 : _g.credentialsArn,
        });
        if (props.secureServerName) {
            integ.tlsConfig = {
                serverNameToVerify: props.secureServerName,
            };
        }
        this.integrationId = integ.ref;
        this.httpApi = props.httpApi;
    }
}
exports.HttpIntegration = HttpIntegration;
_c = JSII_RTTI_SYMBOL_1;
HttpIntegration[_c] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpIntegration", version: "2.15.0-alpha.0" };
/**
 * The interface that various route integration classes will inherit.
 */
class HttpRouteIntegration {
    /**
     * Initialize an integration for a route on http api.
     * @param id id of the underlying `HttpIntegration` construct.
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.httpApi.node.addr !== options.route.httpApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new HttpIntegration(options.scope, this.id, {
                httpApi: options.route.httpApi,
                integrationType: config.type,
                integrationSubtype: config.subtype,
                integrationUri: config.uri,
                method: config.method,
                connectionId: config.connectionId,
                connectionType: config.connectionType,
                payloadFormatVersion: config.payloadFormatVersion,
                secureServerName: config.secureServerName,
                parameterMapping: config.parameterMapping,
                credentials: config.credentials,
            });
        }
        return { integrationId: this.integration.integrationId };
    }
}
exports.HttpRouteIntegration = HttpRouteIntegration;
_d = JSII_RTTI_SYMBOL_1;
HttpRouteIntegration[_d] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpRouteIntegration", version: "2.15.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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