#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['dstl', 'dstl.cli', 'dstl.prodigy', 'dstl.translate']

package_data = \
{'': ['*']}

install_requires = \
['httpx >=0.14,<1.0',
 'pydantic >=1.5,<1.6',
 'spacy >=2.3,<2.4',
 'torch >=1.6.0,<1.7.0',
 'transformers >=3.0.0,<3.1.0',
 'typer >=0.3.1,<1.0']

extras_require = \
{'all': ['colorama', 'click-completion'],
 'dev': ['jupyterlab >= 1.2.0, <1.3',
         'ipywidgets',
         'autoflake >=1.3.1,<2.0.0',
         'flake8 >=3.8.3,<4.0.0'],
 'doc': ['mkdocs >=1.1.2,<2.0.0',
         'mkdocs-material >=5.4.0,<6.0.0',
         'markdown-include >=0.5.1,<0.6.0',
         'mkdocstrings'],
 'test': ['pytest == 5.3.0',
          'pytest-cov',
          'coverage',
          'pytest-xdist',
          'pytest-sugar',
          'mypy',
          'black',
          'isort']}

entry_points = \
{'console_scripts': ['dstl = dstl.cli:app'],
 'prodigy_recipes': ['ner.translate = dstl:prodigy_recipes.ner_translate']}

setup(name='dstl',
      version='0.0.2',
      description='DataSet TransLation (DSTL) provides utilities to translate annotated natural language data from one language to another.',
      author='Kabir Khan',
      author_email='kabirkhan1137@outlook.com',
      url='https://github.com/kabirkhan/dstl',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.6',
     )
