# coding: utf-8

"""
    Speech Services API v2.0

    Speech Services API v2.0.  # noqa: E501

    OpenAPI spec version: v2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class CustomSpeechEndpointsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_endpoint(self, endpoint_definition, **kwargs):  # noqa: E501
        """Creates a new endpoint.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_endpoint(endpoint_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpeechEndpointDefinition endpoint_definition: The details of the endpoint. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_endpoint_with_http_info(endpoint_definition, **kwargs)  # noqa: E501
        else:
            (data) = self.create_endpoint_with_http_info(endpoint_definition, **kwargs)  # noqa: E501
            return data

    def create_endpoint_with_http_info(self, endpoint_definition, **kwargs):  # noqa: E501
        """Creates a new endpoint.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_endpoint_with_http_info(endpoint_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SpeechEndpointDefinition endpoint_definition: The details of the endpoint. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['endpoint_definition']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'endpoint_definition' is set
        if ('endpoint_definition' not in params or
                params['endpoint_definition'] is None):
            raise ValueError("Missing the required parameter `endpoint_definition` when calling `create_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'endpoint_definition' in params:
            body_params = params['endpoint_definition']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['subscription_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/api/speechtotext/v2.0/endpoints', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_endpoint_data_export(self, endpoint_id, endpoint_data_definition, **kwargs):  # noqa: E501
        """Create a new endpoint data export task.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_endpoint_data_export(endpoint_id, endpoint_data_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The identifier of the endpoint. (required)
        :param EndpointDataDefinition endpoint_data_definition: The details of the new endpoint data export. (required)
        :return: ErrorContent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_endpoint_data_export_with_http_info(endpoint_id, endpoint_data_definition, **kwargs)  # noqa: E501
        else:
            (data) = self.create_endpoint_data_export_with_http_info(endpoint_id, endpoint_data_definition, **kwargs)  # noqa: E501
            return data

    def create_endpoint_data_export_with_http_info(self, endpoint_id, endpoint_data_definition, **kwargs):  # noqa: E501
        """Create a new endpoint data export task.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_endpoint_data_export_with_http_info(endpoint_id, endpoint_data_definition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The identifier of the endpoint. (required)
        :param EndpointDataDefinition endpoint_data_definition: The details of the new endpoint data export. (required)
        :return: ErrorContent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['endpoint_id', 'endpoint_data_definition']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_endpoint_data_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in params or
                params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `create_endpoint_data_export`")  # noqa: E501
        # verify the required parameter 'endpoint_data_definition' is set
        if ('endpoint_data_definition' not in params or
                params['endpoint_data_definition'] is None):
            raise ValueError("Missing the required parameter `endpoint_data_definition` when calling `create_endpoint_data_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'endpoint_id' in params:
            path_params['endpointId'] = params['endpoint_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'endpoint_data_definition' in params:
            body_params = params['endpoint_data_definition']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['subscription_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/api/speechtotext/v2.0/endpoints/{endpointId}/data', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ErrorContent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_endpoint(self, id, **kwargs):  # noqa: E501
        """Deletes the endpoint identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_endpoint(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_endpoint_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_endpoint_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_endpoint_with_http_info(self, id, **kwargs):  # noqa: E501
        """Deletes the endpoint identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_endpoint_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['subscription_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/api/speechtotext/v2.0/endpoints/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_endpoint_data(self, endpoint_id, **kwargs):  # noqa: E501
        """Deletes the transcriptions and captured audio files associated with the endpoint identified by the given ID.  # noqa: E501

        Deletion will happen in the background and can take up to a day.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_endpoint_data(endpoint_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The identifier of the endpoint. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_endpoint_data_with_http_info(endpoint_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_endpoint_data_with_http_info(endpoint_id, **kwargs)  # noqa: E501
            return data

    def delete_endpoint_data_with_http_info(self, endpoint_id, **kwargs):  # noqa: E501
        """Deletes the transcriptions and captured audio files associated with the endpoint identified by the given ID.  # noqa: E501

        Deletion will happen in the background and can take up to a day.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_endpoint_data_with_http_info(endpoint_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The identifier of the endpoint. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['endpoint_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_endpoint_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in params or
                params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `delete_endpoint_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'endpoint_id' in params:
            path_params['endpointId'] = params['endpoint_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['subscription_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/api/speechtotext/v2.0/endpoints/{endpointId}/data', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_endpoint_data_export(self, endpoint_id, id, **kwargs):  # noqa: E501
        """Deletes the endpoint data export task identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_endpoint_data_export(endpoint_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The identifier of the endpoint. (required)
        :param str id: The identifier of the endpoint data export. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_endpoint_data_export_with_http_info(endpoint_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_endpoint_data_export_with_http_info(endpoint_id, id, **kwargs)  # noqa: E501
            return data

    def delete_endpoint_data_export_with_http_info(self, endpoint_id, id, **kwargs):  # noqa: E501
        """Deletes the endpoint data export task identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_endpoint_data_export_with_http_info(endpoint_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The identifier of the endpoint. (required)
        :param str id: The identifier of the endpoint data export. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['endpoint_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_endpoint_data_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in params or
                params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `delete_endpoint_data_export`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_endpoint_data_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'endpoint_id' in params:
            path_params['endpointId'] = params['endpoint_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['subscription_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/api/speechtotext/v2.0/endpoints/{endpointId}/data/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_endpoint(self, id, **kwargs):  # noqa: E501
        """Gets the endpoint identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoint(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_endpoint_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_endpoint_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_endpoint_with_http_info(self, id, **kwargs):  # noqa: E501
        """Gets the endpoint identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoint_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['subscription_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/api/speechtotext/v2.0/endpoints/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Endpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_endpoint_data_export(self, endpoint_id, id, **kwargs):  # noqa: E501
        """Gets the specified endpoint data export task for the authenticated user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoint_data_export(endpoint_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The identifier of the endpoint. (required)
        :param str id: The identifier of the data export. (required)
        :return: EndpointData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_endpoint_data_export_with_http_info(endpoint_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_endpoint_data_export_with_http_info(endpoint_id, id, **kwargs)  # noqa: E501
            return data

    def get_endpoint_data_export_with_http_info(self, endpoint_id, id, **kwargs):  # noqa: E501
        """Gets the specified endpoint data export task for the authenticated user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoint_data_export_with_http_info(endpoint_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The identifier of the endpoint. (required)
        :param str id: The identifier of the data export. (required)
        :return: EndpointData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['endpoint_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_endpoint_data_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in params or
                params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `get_endpoint_data_export`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_endpoint_data_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'endpoint_id' in params:
            path_params['endpointId'] = params['endpoint_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['subscription_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/api/speechtotext/v2.0/endpoints/{endpointId}/data/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EndpointData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_endpoint_data_exports(self, endpoint_id, **kwargs):  # noqa: E501
        """Gets the list of endpoint data export tasks for the authenticated user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoint_data_exports(endpoint_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The identifier of the endpoint. (required)
        :return: list[EndpointData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_endpoint_data_exports_with_http_info(endpoint_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_endpoint_data_exports_with_http_info(endpoint_id, **kwargs)  # noqa: E501
            return data

    def get_endpoint_data_exports_with_http_info(self, endpoint_id, **kwargs):  # noqa: E501
        """Gets the list of endpoint data export tasks for the authenticated user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoint_data_exports_with_http_info(endpoint_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The identifier of the endpoint. (required)
        :return: list[EndpointData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['endpoint_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_endpoint_data_exports" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in params or
                params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `get_endpoint_data_exports`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'endpoint_id' in params:
            path_params['endpointId'] = params['endpoint_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['subscription_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/api/speechtotext/v2.0/endpoints/{endpointId}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EndpointData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_endpoints(self, **kwargs):  # noqa: E501
        """Gets the list of endpoints for the authenticated subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoints(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Endpoint]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_endpoints_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_endpoints_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_endpoints_with_http_info(self, **kwargs):  # noqa: E501
        """Gets the list of endpoints for the authenticated subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoints_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Endpoint]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['subscription_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/api/speechtotext/v2.0/endpoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Endpoint]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_supported_locales_for_endpoints(self, **kwargs):  # noqa: E501
        """Gets a list of supported locales for endpoint creations.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_supported_locales_for_endpoints(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_supported_locales_for_endpoints_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_supported_locales_for_endpoints_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_supported_locales_for_endpoints_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a list of supported locales for endpoint creations.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_supported_locales_for_endpoints_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_supported_locales_for_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['subscription_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/api/speechtotext/v2.0/endpoints/locales', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_endpoint(self, id, endpoint_update, **kwargs):  # noqa: E501
        """Updates the metadata of the endpoint identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_endpoint(id, endpoint_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :param EndpointMetadataUpdate endpoint_update: The updated values for the endpoint. (required)
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_endpoint_with_http_info(id, endpoint_update, **kwargs)  # noqa: E501
        else:
            (data) = self.update_endpoint_with_http_info(id, endpoint_update, **kwargs)  # noqa: E501
            return data

    def update_endpoint_with_http_info(self, id, endpoint_update, **kwargs):  # noqa: E501
        """Updates the metadata of the endpoint identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_endpoint_with_http_info(id, endpoint_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :param EndpointMetadataUpdate endpoint_update: The updated values for the endpoint. (required)
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'endpoint_update']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_endpoint`")  # noqa: E501
        # verify the required parameter 'endpoint_update' is set
        if ('endpoint_update' not in params or
                params['endpoint_update'] is None):
            raise ValueError("Missing the required parameter `endpoint_update` when calling `update_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'endpoint_update' in params:
            body_params = params['endpoint_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['subscription_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/api/speechtotext/v2.0/endpoints/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Endpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
