# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dodgem']

package_data = \
{'': ['*']}

install_requires = \
['blessings>=1.7,<2.0',
 'click>=8.0.4,<9.0.0',
 'semver>=2.13.0,<3.0.0',
 'tomlkit>=0.10.2,<0.11.0']

entry_points = \
{'console_scripts': ['dodgem = dodgem.dodgem:main']}

setup_kwargs = {
    'name': 'dodgem',
    'version': '1.2.0',
    'description': 'Version bumper for Python.',
    'long_description': '<div id="top"></div>\n\n\n\n<!-- PROJECT SHIELDS -->\n[![Contributors][contributors-shield]][contributors-url]\n[![Forks][forks-shield]][forks-url]\n[![Stargazers][stars-shield]][stars-url]\n[![Issues][issues-shield]][issues-url]\n[![MIT License][license-shield]][license-url]\n[![LinkedIn][linkedin-shield]][linkedin-url]\n\n\n\n<!-- PROJECT LOGO -->\n<br />\n<div align="center">\n  <a href="https://github.com/lambdacasserole/dodgem">\n    <img src="https://raw.githubusercontent.com/lambdacasserole/dodgem/main/logo.svg" alt="Logo" width="128" height="128">\n  </a>\n\n  <h3 align="center">dodgem</h3>\n\n  <p align="center">\n    Version bumper for Python project files.\n    <br />\n    <a href="https://github.com/lambdacasserole/dodgem/issues">Report Bug</a>\n    ·\n    <a href="https://github.com/lambdacasserole/dodgem/issues">Request Feature</a>\n  </p>\n</div>\n\n\n\n<!-- TABLE OF CONTENTS -->\n<details>\n  <summary>Table of Contents</summary>\n  <ol>\n    <li>\n      <a href="#about-the-project">About The Project</a>\n      <ul>\n        <li><a href="#built-with">Built With</a></li>\n      </ul>\n    </li>\n    <li>\n      <a href="#getting-started">Getting Started</a>\n      <ul>\n        <li><a href="#prerequisites">Prerequisites</a></li>\n        <li><a href="#installation">Installation</a></li>\n      </ul>\n    </li>\n    <li>\n      <a href="#usage">Usage</a>\n      <ul>\n        <li><a href="#example-bump-minor-version">Example: Bump Minor Version</a></li>\n        <li><a href="#example-from-commit-message">Example: From Commit Message</a></li>\n        <li><a href="#example-custom-tags">Example: Custom Tags</a></li>\n      </ul>\n    </li>\n    <li><a href="#roadmap">Roadmap</a></li>\n    <li><a href="#contributing">Contributing</a></li>\n    <li><a href="#license">License</a></li>\n    <li><a href="#contact">Contact</a></li>\n    <li><a href="#acknowledgments">Acknowledgments</a></li>\n  </ol>\n</details>\n\n\n\n<!-- ABOUT THE PROJECT -->\n## About The Project\n\n![dodgem usage][product-screenshot]\n\nSometimes you need to bump the version in your Python project files automatically. For example, you might:\n\n* Have a CI/CD pipeline, and want to automatically bump the patch version of your library on merge to your `develop` branch\n* Have a workflow (e.g. on Bitbucket Pipelines, GitHub actions etc.) that allows developers to automatically perform version bumps by including tags in their commit message (e.g. `[major]`, `[minor]`)\n* Just want to reduce the chances of human error when bumping version numbers manually\n\nDodgem is a command-line utility for doing all of the above, and a bit more, aiming to eventually cover as many Python project file formats as possible, but currently supporting:\n\n* `setuptools` (`setup.py`) with the `version=` named argument\n* `pyproject.toml` managed by the [Poetry](https://python-poetry.org/) dependency manager\n\nNamed after (version) [bumper cars](https://en.wikipedia.org/wiki/Bumper_cars) which are also sometimes called dodgems in some dialects of English.\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n### Built With\n\nThis project uses:\n\n* [Click](https://click.palletsprojects.com/en/8.1.x/) for its CLI\n* [Poetry](https://python-poetry.org/) for dependency management\n* [Blessings](https://github.com/erikrose/blessings) for colorized and formatted CLI output\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- GETTING STARTED -->\n## Getting Started\n\nGetting started is straightforward. Dodgem aims to automatically detect as much as possible.\n\n### Prerequisites\n\nYou\'ll need Python 3.7 or newer with pip to install Dodgem.\n\n### Installation\n\nInstall Dodgem using pip or your favourite Python dependency manager and you\'re done.\n\n```bash\npip3 install dodgem\n```\n\nTest your installation with:\n\n```bash\ndodgem --help\n```\n\nYou should see help documentation printed.\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- USAGE EXAMPLES -->\n## Usage\n\nYou can use `dodgem --help` for detailed information on using the utility:\n\n```\nUsage: dodgem [OPTIONS]\n\n  Bump version numbers in a project file.\n\nOptions:\n  --file TEXT              The file to parse (defaults to automatic\n                           detection).\n  --file-type TEXT         The file type to parse (defaults to automatic).\n  --file-format TEXT       The file format to parse (defaults to automatic).\n  --commit-message TEXT    The commit message to infer the version bump from.\n  --no-auto-patch BOOLEAN  If given, disables automatic patch version bump if\n                           commit message provided.\n  --major-tag TEXT         The commit message tag indicating a major version\n                           bump.\n  --minor-tag TEXT         The commit message tag indicating a minor version\n                           bump.\n  --patch-tag TEXT         The commit message tag indicating a patch version\n                           bump.\n  --ignore-tag-case        Ignores capitalization in commit message tags.\n  --quiet                  Suppresses all extraneous output.\n  --bump-major             If given, performs a major version bump.\n  --bump-minor             If given, performs a minor version bump.\n  --bump-patch             If given, performs a patch version bump.\n  --dry                    If given, does not write the version change to\n                           disk.\n  --help                   Show this message and exit.\n```\n\n### Example: Bump Minor Version\n\nBump the minor version of your project like this:\n\n```bash\ndodgem --bump-minor\n```\n\nIf you don\'t want to commit the change to disk, use `--dry` like so:\n\n```bash\ndodgem --bump-minor --dry\n```\n\nIf the informational output given by the CLI is getting in the way of downstream processing, use `--quiet`:\n\n```bash\ndodgem --bump-minor --quiet\n```\n\n### Example: From Commit Message\n\nDodgem can bump your project version based on a commit message. By default.\n\n* If the message contains `[major]` then a major version bump will be performed\n* If the message contains `[minor]` then a minor version bump will be performed\n* Otherwise, a patch version bump will be performed\n\nFor example, to use your last `git` commit message to bump your projects version.\n\n```bash\ndodgem --commit-message="$(git log -1)"\n```\n\n### Example: Custom Tags\n\nIf the default `[major]` and `[minor]` tags don\'t suit you, and you\'d perfer `(major)`, `(minor)` and an _explicit_ `(patch)` tag:\n\n```bash\ndodgem --commit-message="$(git log -1)" --major-tag=\'(major)\' --minor-tag=\'(minor)\' --patch-tag=\'(patch)\' --no-auto-patch\n```\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- ROADMAP -->\n## Roadmap\n\n- [x] Support `setuptools` (`setup.py`)\n- [x] Support [Poetry](https://python-poetry.org/)\n\nSee the [open issues](https://github.com/lambdacasserole/dodgem/issues) for a full list of proposed features (and known issues).\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- CONTRIBUTING -->\n## Contributing\n\nAny contributions are very welcome. Please fork the project and open a PR, or open an issue if you\'ve found a bug and/or would like to suggest a feature.\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- LICENSE -->\n## License\n\nDistributed under the MIT License. See `LICENSE.txt` for more information.\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- CONTACT -->\n## Contact\n\nSaul Johnson - [@lambdacasserole](https://twitter.com/lambdacasserole) - saul.a.johnson@gmail.com\n\nProject Link: [https://github.com/lambdacasserole/dodgem](https://github.com/lambdacasserole/dodgem)\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- ACKNOWLEDGMENTS -->\n## Acknowledgments\n\nThe following resources are awesome:\n\n* [Best-README-Template](https://github.com/othneildrew/Best-README-Template) was used for this readme\n* [tomlkit](https://github.com/sdispater/tomlkit/) was used for parsing TOML in a way that preserves comments, order, formatting etc.\n* [semver](https://github.com/python-semver/python-semver) was used for parsing and bumping semver numbers\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- MARKDOWN LINKS & IMAGES -->\n<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->\n[contributors-shield]: https://img.shields.io/github/contributors/lambdacasserole/dodgem.svg?style=for-the-badge\n[contributors-url]: https://github.com/lambdacasserole/dodgem/graphs/contributors\n[forks-shield]: https://img.shields.io/github/forks/lambdacasserole/dodgem.svg?style=for-the-badge\n[forks-url]: https://github.com/lambdacasserole/dodgem/network/members\n[stars-shield]: https://img.shields.io/github/stars/lambdacasserole/dodgem.svg?style=for-the-badge\n[stars-url]: https://github.com/lambdacasserole/dodgem/stargazers\n[issues-shield]: https://img.shields.io/github/issues/lambdacasserole/dodgem.svg?style=for-the-badge\n[issues-url]: https://github.com/lambdacasserole/dodgem/issues\n[license-shield]: https://img.shields.io/github/license/lambdacasserole/dodgem.svg?style=for-the-badge\n[license-url]: https://github.com/lambdacasserole/dodgem/blob/master/LICENSE.txt\n[linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555\n[linkedin-url]: https://linkedin.com/in/sauljohnson\n[product-screenshot]: https://raw.githubusercontent.com/lambdacasserole/dodgem/main/usage.svg\n',
    'author': 'Saul Johnson',
    'author_email': 'saul.a.johnson@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/lambdacasserole/dodgem.git',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
