# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2018-03-07 15:06
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='City',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.CharField(max_length=255, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('active', models.BooleanField(default=True)),
                ('language', models.CharField(choices=[(b'ar', 'Arabe'), (b'cn', 'Chines'), (b'en', 'English'), (b'pt', 'Portugu\xeas'), (b'es', 'Espanhol'), (b'ru', 'Russia')], max_length=5)),
                ('name', models.CharField(max_length=50, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.CharField(max_length=255, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('active', models.BooleanField(default=True)),
                ('language', models.CharField(choices=[(b'ar', 'Arabe'), (b'cn', 'Chines'), (b'en', 'English'), (b'pt', 'Portugu\xeas'), (b'es', 'Espanhol'), (b'ru', 'Russia')], max_length=5)),
                ('name', models.CharField(max_length=50, unique=True)),
                ('flag', models.FileField(blank=True, null=True, upload_to=b'')),
            ],
        ),
        migrations.CreateModel(
            name='CountryCode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.CharField(max_length=255, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('active', models.BooleanField(default=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('code', models.CharField(max_length=2, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='State',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.CharField(max_length=255, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('active', models.BooleanField(default=True)),
                ('language', models.CharField(choices=[(b'ar', 'Arabe'), (b'cn', 'Chines'), (b'en', 'English'), (b'pt', 'Portugu\xeas'), (b'es', 'Espanhol'), (b'ru', 'Russia')], max_length=5)),
                ('name', models.CharField(max_length=50)),
                ('code', models.CharField(max_length=50)),
                ('country', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='location.Country')),
            ],
        ),
        migrations.AddField(
            model_name='country',
            name='code',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='location.CountryCode'),
        ),
        migrations.AddField(
            model_name='city',
            name='state',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='location.State'),
        ),
        migrations.AlterUniqueTogether(
            name='state',
            unique_together=set([('language', 'code')]),
        ),
        migrations.AlterUniqueTogether(
            name='country',
            unique_together=set([('language', 'code')]),
        ),
    ]
