""" Migrations
"""

# Generated by Django 3.2 on 2022-02-03 18:32

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    """Migration"""

    initial = True

    dependencies = [
        ("core_main_app", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="OaiProviderMetadataFormat",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("metadata_prefix", models.CharField(max_length=200)),
                ("schema", models.CharField(max_length=200)),
                ("xml_schema", models.TextField(blank=True)),
                ("metadata_namespace", models.CharField(max_length=200)),
                ("is_default", models.BooleanField(blank=True)),
                ("is_template", models.BooleanField(blank=True)),
                (
                    "template",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core_main_app.template",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="OaiRequestPage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("resumption_token", models.CharField(max_length=255, unique=True)),
                ("metadata_format", models.CharField(max_length=255)),
                ("template_id_list", models.JSONField(default=list)),
                (
                    "oai_set",
                    models.CharField(
                        blank=True, default=None, max_length=255, null=True
                    ),
                ),
                (
                    "from_date",
                    models.DateTimeField(blank=True, default=None, null=True),
                ),
                (
                    "until_date",
                    models.DateTimeField(blank=True, default=None, null=True),
                ),
                ("expiration_date", models.DateTimeField(default=None, null=True)),
                ("page_number", models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name="OaiSettings",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("repository_name", models.CharField(max_length=255)),
                ("repository_identifier", models.CharField(max_length=255)),
                ("enable_harvesting", models.BooleanField()),
            ],
            options={
                "verbose_name": "Oai settings",
                "verbose_name_plural": "Oai settings",
            },
        ),
        migrations.CreateModel(
            name="OaiData",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("oai_date_stamp", models.DateTimeField(default=None, null=True)),
                ("status", models.CharField(max_length=200)),
                (
                    "data",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core_main_app.data",
                    ),
                ),
                (
                    "template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core_main_app.template",
                    ),
                ),
            ],
            options={
                "verbose_name": "Oai data",
                "verbose_name_plural": "Oai data",
            },
        ),
        migrations.CreateModel(
            name="OaiXslTemplate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "oai_metadata_format",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core_oaipmh_provider_app.oaiprovidermetadataformat",
                    ),
                ),
                (
                    "template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core_main_app.template",
                    ),
                ),
                (
                    "xslt",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core_main_app.xsltransformation",
                    ),
                ),
            ],
            options={
                "unique_together": {("oai_metadata_format", "xslt", "template")},
            },
        ),
        migrations.CreateModel(
            name="OaiProviderSet",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("set_spec", models.CharField(max_length=200)),
                ("set_name", models.CharField(max_length=200)),
                ("description", models.TextField(blank=True)),
                (
                    "templates_manager",
                    models.ManyToManyField(to="core_main_app.TemplateVersionManager"),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("set_spec", "set_name")},
            },
        ),
    ]
