# coding: utf-8
#
# MIT License
#
# Copyright (c) 2022 KuFlow
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.#
"""
    KuFlow Public API

    # Introduction This document contains the KuFlow REST API reference. This API is a fundamental part in the integration of external systems with KuFlow and is used, among others, by the different implementations of the Workers that connect to our network.  # API Versioning  A versioning strategy allows our clients to continue using the existing REST API and migrate their applications to the newer API when they are ready.  The scheme followed is a simplification of *Semver* where only MAJOR versions are differentiated from MINOR or PATCH versions, i.e. a version number of only two levels is used. With this approach, you only have to migrate your applications if you want to upgrade to a MAJOR version of the KuFlow API. In case you want to upgrade to a MINOR version, you can do so without any incompatibility issues.  The versioning of the api is done through the URI Path, that is, the version number is included in the URI Path. The URL structure would be as follows:  ```bash https://{endpoint}/vMAJOR.MINOR/{api-path} ```  # Idempotency  The API is designed to support idempotency in order to achieve a correct resilience in the implementation of its clients. The way to achieve this is very simple, in the methods that create resources, you simply have to specify a UUID in the input data and the API will respond by creating or returning the resource if it previously existed. With this mechanism, your systems can implement retry logic without worrying about performing data tradeoffs.  # OpenAPI Specification  This API is documented in OpenAPI format. This file allows you to create REST clients with the technology of your choice automatically. In our code repositories you can find an example of this automation using Feign for JAVA.   # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kuflow@kuflow.com
    Generated by: https://openapi-generator.tech
"""

from dataclasses import dataclass
from decimal import Decimal
import enum
import email
import json
import mimetypes  # KF: Fix Content-disposition and Content-Type
import os
import io
import atexit
from multiprocessing.pool import ThreadPool
import re
import tempfile
import typing
import urllib3
from urllib3._collections import HTTPHeaderDict
from urllib.parse import quote
from urllib3.fields import RequestField as RequestFieldBase


from kuflow_rest_client import rest
from kuflow_rest_client.configuration import Configuration
from kuflow_rest_client.exceptions import ApiTypeError, ApiValueError
from kuflow_rest_client.schemas import (
    NoneClass,
    BoolClass,
    Schema,
    FileIO,
    BinarySchema,
    date,
    datetime,
    none_type,
    frozendict,
    Unset,
    unset,
)


class RequestField(RequestFieldBase):
    def __eq__(self, other):
        if not isinstance(other, RequestField):
            return False
        return self.__dict__ == other.__dict__


class JSONEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, (str, int, float)):
            # instances based on primitive classes
            return obj
        elif isinstance(obj, Decimal):
            if obj.as_tuple().exponent >= 0:
                return int(obj)
            return float(obj)
        elif isinstance(obj, NoneClass):
            return None
        elif isinstance(obj, BoolClass):
            return bool(obj)
        elif isinstance(obj, (dict, frozendict)):
            return {key: self.default(val) for key, val in obj.items()}
        elif isinstance(obj, (list, tuple)):
            return [self.default(item) for item in obj]
        raise ApiValueError(
            "Unable to prepare type {} for serialization".format(obj.__class__.__name__)
        )


class ParameterInType(enum.Enum):
    QUERY = "query"
    HEADER = "header"
    PATH = "path"
    COOKIE = "cookie"


class ParameterStyle(enum.Enum):
    MATRIX = "matrix"
    LABEL = "label"
    FORM = "form"
    SIMPLE = "simple"
    SPACE_DELIMITED = "spaceDelimited"
    PIPE_DELIMITED = "pipeDelimited"
    DEEP_OBJECT = "deepObject"


class ParameterSerializerBase:
    @staticmethod
    def __serialize_number(
        in_data: typing.Union[int, float], name: str, prefix=""
    ) -> typing.Tuple[typing.Tuple[str, str]]:
        return tuple([(name, prefix + str(in_data))])

    @staticmethod
    def __serialize_str(
        in_data: str, name: str, prefix=""
    ) -> typing.Tuple[typing.Tuple[str, str]]:
        return tuple([(name, prefix + quote(in_data))])

    @staticmethod
    def __serialize_bool(
        in_data: bool, name: str, prefix=""
    ) -> typing.Tuple[typing.Tuple[str, str]]:
        if in_data:
            return tuple([(name, prefix + "true")])
        return tuple([(name, prefix + "false")])

    @staticmethod
    def __urlencode(in_data: typing.Any) -> str:
        return quote(str(in_data))

    def __serialize_list(
        self,
        in_data: typing.List[typing.Any],
        style: ParameterStyle,
        name: str,
        explode: bool,
        empty_val: typing.Union[typing.Tuple[str, str], typing.Tuple] = tuple(),
        prefix: str = "",
        separator: str = ",",
    ) -> typing.Tuple[typing.Union[typing.Tuple[str, str], typing.Tuple], ...]:
        if not in_data:
            return empty_val
        if explode and style in {
            ParameterStyle.FORM,
            ParameterStyle.MATRIX,
            ParameterStyle.SPACE_DELIMITED,
            ParameterStyle.PIPE_DELIMITED,
        }:
            if style is ParameterStyle.FORM:
                return tuple((name, prefix + self.__urlencode(val)) for val in in_data)
            else:
                joined_vals = prefix + separator.join(
                    name + "=" + self.__urlencode(val) for val in in_data
                )
        else:
            joined_vals = prefix + separator.join(map(self.__urlencode, in_data))
        return tuple([(name, joined_vals)])

    def __form_item_representation(self, in_data: typing.Any) -> typing.Optional[str]:
        if isinstance(in_data, none_type):
            return None
        elif isinstance(in_data, list):
            if not in_data:
                return None
            raise ApiValueError(
                "Unable to generate a form representation of {}".format(in_data)
            )
        elif isinstance(in_data, dict):
            if not in_data:
                return None
            raise ApiValueError(
                "Unable to generate a form representation of {}".format(in_data)
            )
        elif isinstance(in_data, (bool, bytes)):
            raise ApiValueError(
                "Unable to generate a form representation of {}".format(in_data)
            )
        # str, float, int
        return self.__urlencode(in_data)

    def __serialize_dict(
        self,
        in_data: typing.Dict[str, typing.Any],
        style: ParameterStyle,
        name: str,
        explode: bool,
        empty_val: typing.Union[typing.Tuple[str, str], typing.Tuple] = tuple(),
        prefix: str = "",
        separator: str = ",",
    ) -> typing.Tuple[typing.Tuple[str, str]]:
        if not in_data:
            return empty_val
        if all(val is None for val in in_data.values()):
            return empty_val

        form_items = {}
        if style is ParameterStyle.FORM:
            for key, val in in_data.items():
                new_val = self.__form_item_representation(val)
                if new_val is None:
                    continue
                form_items[key] = new_val

        if explode:
            if style is ParameterStyle.FORM:
                return tuple((key, prefix + val) for key, val in form_items.items())
            elif style in {
                ParameterStyle.SIMPLE,
                ParameterStyle.LABEL,
                ParameterStyle.MATRIX,
                ParameterStyle.SPACE_DELIMITED,
                ParameterStyle.PIPE_DELIMITED,
            }:
                joined_vals = prefix + separator.join(
                    key + "=" + self.__urlencode(val) for key, val in in_data.items()
                )
            else:
                raise ApiValueError(
                    f"Invalid style {style} for dict serialization with explode=True"
                )
        elif style is ParameterStyle.FORM:
            joined_vals = prefix + separator.join(
                key + separator + val for key, val in form_items.items()
            )
        else:
            joined_vals = prefix + separator.join(
                key + separator + self.__urlencode(val) for key, val in in_data.items()
            )
        return tuple([(name, joined_vals)])

    def _serialize_x(
        self,
        in_data: typing.Union[None, int, float, str, bool, dict, list],
        style: ParameterStyle,
        name: str,
        explode: bool,
        empty_val: typing.Union[typing.Tuple[str, str], typing.Tuple] = (),
        prefix: str = "",
        separator: str = ",",
    ) -> typing.Tuple[typing.Tuple[str, str], ...]:
        if isinstance(in_data, none_type):
            return empty_val
        elif isinstance(in_data, bool):
            # must be before int check
            return self.__serialize_bool(in_data, name=name, prefix=prefix)
        elif isinstance(in_data, (int, float)):
            return self.__serialize_number(in_data, name=name, prefix=prefix)
        elif isinstance(in_data, str):
            return self.__serialize_str(in_data, name=name, prefix=prefix)
        elif isinstance(in_data, list):
            return self.__serialize_list(
                in_data,
                style=style,
                name=name,
                explode=explode,
                empty_val=empty_val,
                prefix=prefix,
                separator=separator,
            )
        elif isinstance(in_data, dict):
            return self.__serialize_dict(
                in_data,
                style=style,
                name=name,
                explode=explode,
                empty_val=empty_val,
                prefix=prefix,
                separator=separator,
            )


class StyleFormSerializer(ParameterSerializerBase):
    def _serialize_form(
        self,
        in_data: typing.Union[None, int, float, str, bool, dict, list],
        name: str,
        explode: bool,
    ) -> typing.Tuple[typing.Tuple[str, str], ...]:
        return self._serialize_x(
            in_data, style=ParameterStyle.FORM, name=name, explode=explode
        )


class StyleSimpleSerializer(ParameterSerializerBase):
    def _serialize_simple_tuple(
        self,
        in_data: typing.Union[None, int, float, str, bool, dict, list],
        name: str,
        explode: bool,
        in_type: ParameterInType,
    ) -> typing.Tuple[typing.Tuple[str, str], ...]:
        if in_type is ParameterInType.HEADER:
            empty_val = ()
        else:
            empty_val = ((name, ""),)
        return self._serialize_x(
            in_data,
            style=ParameterStyle.SIMPLE,
            name=name,
            explode=explode,
            empty_val=empty_val,
        )


@dataclass
class ParameterBase:
    name: str
    in_type: ParameterInType
    required: bool
    style: typing.Optional[ParameterStyle]
    explode: typing.Optional[bool]
    allow_reserved: typing.Optional[bool]
    schema: typing.Optional[typing.Type[Schema]]
    content: typing.Optional[typing.Dict[str, typing.Type[Schema]]]

    __style_to_in_type = {
        ParameterStyle.MATRIX: {ParameterInType.PATH},
        ParameterStyle.LABEL: {ParameterInType.PATH},
        ParameterStyle.FORM: {ParameterInType.QUERY, ParameterInType.COOKIE},
        ParameterStyle.SIMPLE: {ParameterInType.PATH, ParameterInType.HEADER},
        ParameterStyle.SPACE_DELIMITED: {ParameterInType.QUERY},
        ParameterStyle.PIPE_DELIMITED: {ParameterInType.QUERY},
        ParameterStyle.DEEP_OBJECT: {ParameterInType.QUERY},
    }
    __in_type_to_default_style = {
        ParameterInType.QUERY: ParameterStyle.FORM,
        ParameterInType.PATH: ParameterStyle.SIMPLE,
        ParameterInType.HEADER: ParameterStyle.SIMPLE,
        ParameterInType.COOKIE: ParameterStyle.FORM,
    }
    __disallowed_header_names = {"Accept", "Content-Type", "Authorization"}
    _json_encoder = JSONEncoder()
    _json_content_type = "application/json"

    @classmethod
    def __verify_style_to_in_type(
        cls, style: typing.Optional[ParameterStyle], in_type: ParameterInType
    ):
        if style is None:
            return
        in_type_set = cls.__style_to_in_type[style]
        if in_type not in in_type_set:
            raise ValueError(
                "Invalid style and in_type combination. For style={} only in_type={} are allowed".format(
                    style, in_type_set
                )
            )

    def __init__(
        self,
        name: str,
        in_type: ParameterInType,
        required: bool = False,
        style: typing.Optional[ParameterStyle] = None,
        explode: bool = False,
        allow_reserved: typing.Optional[bool] = None,
        schema: typing.Optional[typing.Type[Schema]] = None,
        content: typing.Optional[typing.Dict[str, typing.Type[Schema]]] = None,
    ):
        if schema is None and content is None:
            raise ValueError("Value missing; Pass in either schema or content")
        if schema and content:
            raise ValueError(
                "Too many values provided. Both schema and content were provided. Only one may be input"
            )
        if name in self.__disallowed_header_names and in_type is ParameterInType.HEADER:
            raise ValueError(
                "Invalid name, name may not be one of {}".format(
                    self.__disallowed_header_names
                )
            )
        self.__verify_style_to_in_type(style, in_type)
        if content is None and style is None:
            style = self.__in_type_to_default_style[in_type]
        if (
            content is not None
            and in_type in self.__in_type_to_default_style
            and len(content) != 1
        ):
            raise ValueError("Invalid content length, content length must equal 1")
        self.in_type = in_type
        self.name = name
        self.required = required
        self.style = style
        self.explode = explode
        self.allow_reserved = allow_reserved
        self.schema = schema
        self.content = content

    @staticmethod
    def _remove_empty_and_cast(
        in_data: typing.Tuple[typing.Tuple[str, str]],
    ) -> typing.Dict[str, str]:
        data = tuple(t for t in in_data if t)
        if not data:
            return dict()
        return dict(data)

    def _serialize_json(
        self, in_data: typing.Union[None, int, float, str, bool, dict, list]
    ) -> typing.Tuple[typing.Tuple[str, str]]:
        return tuple([(self.name, json.dumps(in_data))])


class PathParameter(ParameterBase, StyleSimpleSerializer):
    def __init__(
        self,
        name: str,
        required: bool = False,
        style: typing.Optional[ParameterStyle] = None,
        explode: bool = False,
        allow_reserved: typing.Optional[bool] = None,
        schema: typing.Optional[typing.Type[Schema]] = None,
        content: typing.Optional[typing.Dict[str, typing.Type[Schema]]] = None,
    ):
        super().__init__(
            name,
            in_type=ParameterInType.PATH,
            required=required,
            style=style,
            explode=explode,
            allow_reserved=allow_reserved,
            schema=schema,
            content=content,
        )

    def __serialize_label(
        self, in_data: typing.Union[None, int, float, str, bool, dict, list]
    ) -> typing.Dict[str, str]:
        empty_val = ((self.name, ""),)
        prefix = "."
        separator = "."
        return self._remove_empty_and_cast(
            self._serialize_x(
                in_data,
                style=ParameterStyle.LABEL,
                name=self.name,
                explode=self.explode,
                empty_val=empty_val,
                prefix=prefix,
                separator=separator,
            )
        )

    def __serialize_matrix(
        self, in_data: typing.Union[None, int, float, str, bool, dict, list]
    ) -> typing.Dict[str, str]:
        separator = ","
        if in_data == "":
            prefix = ";" + self.name
        elif isinstance(in_data, (dict, list)) and self.explode:
            prefix = ";"
            separator = ";"
        else:
            prefix = ";" + self.name + "="
        empty_val = ((self.name, ""),)
        return self._remove_empty_and_cast(
            self._serialize_x(
                in_data,
                style=ParameterStyle.MATRIX,
                name=self.name,
                explode=self.explode,
                prefix=prefix,
                empty_val=empty_val,
                separator=separator,
            )
        )

    def _serialize_simple(
        self,
        in_data: typing.Union[None, int, float, str, bool, dict, list],
    ) -> typing.Dict[str, str]:
        tuple_data = self._serialize_simple_tuple(
            in_data, self.name, self.explode, self.in_type
        )
        return self._remove_empty_and_cast(tuple_data)

    def serialize(
        self,
        in_data: typing.Union[
            Schema,
            Decimal,
            int,
            float,
            str,
            date,
            datetime,
            None,
            bool,
            list,
            tuple,
            dict,
            frozendict,
        ],
    ) -> typing.Dict[str, str]:
        if self.schema:
            cast_in_data = self.schema(in_data)
            cast_in_data = self._json_encoder.default(cast_in_data)
            """
            simple -> path
                path:
                    returns path_params: dict
            label -> path
                returns path_params
            matrix -> path
                returns path_params
            """
            if self.style:
                if self.style is ParameterStyle.SIMPLE:
                    return self._serialize_simple(cast_in_data)
                elif self.style is ParameterStyle.LABEL:
                    return self.__serialize_label(cast_in_data)
                elif self.style is ParameterStyle.MATRIX:
                    return self.__serialize_matrix(cast_in_data)
        # self.content will be length one
        for content_type, schema in self.content.items():
            cast_in_data = schema(in_data)
            cast_in_data = self._json_encoder.default(cast_in_data)
            if content_type == self._json_content_type:
                tuple_data = self._serialize_json(cast_in_data)
                return self._remove_empty_and_cast(tuple_data)
            raise NotImplementedError(
                "Serialization of {} has not yet been implemented".format(content_type)
            )


class QueryParameter(ParameterBase, StyleFormSerializer):
    def __init__(
        self,
        name: str,
        required: bool = False,
        style: typing.Optional[ParameterStyle] = None,
        explode: bool = False,
        allow_reserved: typing.Optional[bool] = None,
        schema: typing.Optional[typing.Type[Schema]] = None,
        content: typing.Optional[typing.Dict[str, typing.Type[Schema]]] = None,
    ):
        super().__init__(
            name,
            in_type=ParameterInType.QUERY,
            required=required,
            style=style,
            explode=explode,
            allow_reserved=allow_reserved,
            schema=schema,
            content=content,
        )

    def __serialize_space_delimited(
        self, in_data: typing.Union[None, int, float, str, bool, dict, list]
    ) -> typing.Tuple[typing.Tuple[str, str], ...]:
        separator = "%20"
        empty_val = ()
        return self._serialize_x(
            in_data,
            style=ParameterStyle.SPACE_DELIMITED,
            name=self.name,
            explode=self.explode,
            separator=separator,
            empty_val=empty_val,
        )

    def __serialize_pipe_delimited(
        self, in_data: typing.Union[None, int, float, str, bool, dict, list]
    ) -> typing.Tuple[typing.Tuple[str, str], ...]:
        separator = "|"
        empty_val = ()
        return self._serialize_x(
            in_data,
            style=ParameterStyle.PIPE_DELIMITED,
            name=self.name,
            explode=self.explode,
            separator=separator,
            empty_val=empty_val,
        )

    def serialize(
        self,
        in_data: typing.Union[
            Schema,
            Decimal,
            int,
            float,
            str,
            date,
            datetime,
            None,
            bool,
            list,
            tuple,
            dict,
            frozendict,
        ],
    ) -> typing.Tuple[typing.Tuple[str, str]]:
        if self.schema:
            cast_in_data = self.schema(in_data)
            cast_in_data = self._json_encoder.default(cast_in_data)
            """
            form -> query
                query:
                    - GET/HEAD/DELETE: could use fields
                    - PUT/POST: must use urlencode to send parameters
                    returns fields: tuple
            spaceDelimited -> query
                returns fields
            pipeDelimited -> query
                returns fields
            deepObject -> query, https://github.com/OAI/OpenAPI-Specification/issues/1706
                returns fields
            """
            if self.style:
                # TODO update query ones to omit setting values when [] {} or None is input
                if self.style is ParameterStyle.FORM:
                    return self._serialize_form(
                        cast_in_data, explode=self.explode, name=self.name
                    )
                elif self.style is ParameterStyle.SPACE_DELIMITED:
                    return self.__serialize_space_delimited(cast_in_data)
                elif self.style is ParameterStyle.PIPE_DELIMITED:
                    return self.__serialize_pipe_delimited(cast_in_data)
        # self.content will be length one
        for content_type, schema in self.content.items():
            cast_in_data = schema(in_data)
            cast_in_data = self._json_encoder.default(cast_in_data)
            if content_type == self._json_content_type:
                return self._serialize_json(cast_in_data)
            raise NotImplementedError(
                "Serialization of {} has not yet been implemented".format(content_type)
            )


class CookieParameter(ParameterBase, StyleFormSerializer):
    def __init__(
        self,
        name: str,
        required: bool = False,
        style: typing.Optional[ParameterStyle] = None,
        explode: bool = False,
        allow_reserved: typing.Optional[bool] = None,
        schema: typing.Optional[typing.Type[Schema]] = None,
        content: typing.Optional[typing.Dict[str, typing.Type[Schema]]] = None,
    ):
        super().__init__(
            name,
            in_type=ParameterInType.COOKIE,
            required=required,
            style=style,
            explode=explode,
            allow_reserved=allow_reserved,
            schema=schema,
            content=content,
        )

    def serialize(
        self,
        in_data: typing.Union[
            Schema,
            Decimal,
            int,
            float,
            str,
            date,
            datetime,
            None,
            bool,
            list,
            tuple,
            dict,
            frozendict,
        ],
    ) -> typing.Tuple[typing.Tuple[str, str]]:
        if self.schema:
            cast_in_data = self.schema(in_data)
            cast_in_data = self._json_encoder.default(cast_in_data)
            """
            form -> cookie
                returns fields: tuple
            """
            if self.style:
                return self._serialize_form(
                    cast_in_data, explode=self.explode, name=self.name
                )
        # self.content will be length one
        for content_type, schema in self.content.items():
            cast_in_data = schema(in_data)
            cast_in_data = self._json_encoder.default(cast_in_data)
            if content_type == self._json_content_type:
                return self._serialize_json(cast_in_data)
            raise NotImplementedError(
                "Serialization of {} has not yet been implemented".format(content_type)
            )


class HeaderParameter(ParameterBase, StyleSimpleSerializer):
    def __init__(
        self,
        name: str,
        required: bool = False,
        style: typing.Optional[ParameterStyle] = None,
        explode: bool = False,
        allow_reserved: typing.Optional[bool] = None,
        schema: typing.Optional[typing.Type[Schema]] = None,
        content: typing.Optional[typing.Dict[str, typing.Type[Schema]]] = None,
    ):
        super().__init__(
            name,
            in_type=ParameterInType.HEADER,
            required=required,
            style=style,
            explode=explode,
            allow_reserved=allow_reserved,
            schema=schema,
            content=content,
        )

    @staticmethod
    def __to_headers(
        in_data: typing.Tuple[typing.Tuple[str, str], ...]
    ) -> HTTPHeaderDict[str, str]:
        data = tuple(t for t in in_data if t)
        headers = HTTPHeaderDict()
        if not data:
            return headers
        headers.extend(data)
        return headers

    def _serialize_simple(
        self,
        in_data: typing.Union[None, int, float, str, bool, dict, list],
    ) -> HTTPHeaderDict[str, str]:
        tuple_data = self._serialize_simple_tuple(
            in_data, self.name, self.explode, self.in_type
        )
        return self.__to_headers(tuple_data)

    def serialize(
        self,
        in_data: typing.Union[
            Schema,
            Decimal,
            int,
            float,
            str,
            date,
            datetime,
            None,
            bool,
            list,
            tuple,
            dict,
            frozendict,
        ],
    ) -> HTTPHeaderDict[str, str]:
        if self.schema:
            cast_in_data = self.schema(in_data)
            cast_in_data = self._json_encoder.default(cast_in_data)
            """
            simple -> header
                headers: PoolManager needs a mapping, tuple is close
                    returns headers: dict
            """
            if self.style:
                return self._serialize_simple(cast_in_data)
        # self.content will be length one
        for content_type, schema in self.content.items():
            cast_in_data = schema(in_data)
            cast_in_data = self._json_encoder.default(cast_in_data)
            if content_type == self._json_content_type:
                tuple_data = self._serialize_json(cast_in_data)
                return self.__to_headers(tuple_data)
            raise NotImplementedError(
                "Serialization of {} has not yet been implemented".format(content_type)
            )


class Encoding:
    def __init__(
        self,
        content_type: str,
        headers: typing.Optional[typing.Dict[str, HeaderParameter]] = None,
        style: typing.Optional[ParameterStyle] = None,
        explode: bool = False,
        allow_reserved: bool = False,
    ):
        self.content_type = content_type
        self.headers = headers
        self.style = style
        self.explode = explode
        self.allow_reserved = allow_reserved


@dataclass
class MediaType:
    """
    Used to store request and response body schema information
    encoding:
        A map between a property name and its encoding information.
        The key, being the property name, MUST exist in the schema as a property.
        The encoding object SHALL only apply to requestBody objects when the media type is
        multipart or application/x-www-form-urlencoded.
    """

    schema: typing.Optional[typing.Type[Schema]] = None
    encoding: typing.Optional[typing.Dict[str, Encoding]] = None


@dataclass
class ApiResponse:
    response: urllib3.HTTPResponse
    body: typing.Union[Unset, typing.Type[Schema]]
    headers: typing.Union[Unset, typing.List[HeaderParameter]]

    def __init__(
        self,
        response: urllib3.HTTPResponse,
        body: typing.Union[Unset, typing.Type[Schema]],
        headers: typing.Union[Unset, typing.List[HeaderParameter]],
    ):
        """
        pycharm needs this to prevent 'Unexpected argument' warnings
        """
        self.response = response
        self.body = body
        self.headers = headers


@dataclass
class ApiResponseWithoutDeserialization(ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[Unset, typing.Type[Schema]] = unset
    headers: typing.Union[Unset, typing.List[HeaderParameter]] = unset


class JSONDetector:
    @staticmethod
    def content_type_is_json(content_type: str) -> bool:
        """
        for when content_type strings also include charset info like:
        application/json; charset=UTF-8
        """
        content_type_piece = content_type.split(";")[0]
        if content_type_piece == "application/json":
            return True
        return False


class OpenApiResponse(JSONDetector):
    def __init__(
        self,
        response_cls: typing.Type[ApiResponse] = ApiResponse,
        content: typing.Optional[typing.Dict[str, MediaType]] = None,
        headers: typing.Optional[typing.List[HeaderParameter]] = None,
    ):
        self.headers = headers
        if content is not None and len(content) == 0:
            raise ValueError(
                "Invalid value for content, the content dict must have >= 1 entry"
            )
        self.content = content
        self.response_cls = response_cls

    @staticmethod
    def __deserialize_json(response: urllib3.HTTPResponse) -> typing.Any:
        # python must be >= 3.9 so we can pass in bytes into json.loads
        return json.loads(response.data)

    @staticmethod
    def __file_name_from_content_disposition(
        content_disposition: typing.Optional[str],
    ) -> typing.Optional[str]:
        if content_disposition is None:
            return None
        match = re.search('filename="(.+?)"', content_disposition)
        if not match:
            return None
        return match.group(1)

    def __deserialize_application_octet_stream(
        self, response: urllib3.HTTPResponse
    ) -> typing.Union[bytes, io.BufferedReader]:
        """
        urllib3 use cases:
        1. when preload_content=True (stream=False) then supports_chunked_reads is False and bytes are returned
        2. when preload_content=False (stream=True) then supports_chunked_reads is True and
            a file will be written and returned
        """
        if response.supports_chunked_reads():
            file_name = self.__file_name_from_content_disposition(
                response.headers.get("content-disposition")
            )

            if file_name is None:
                _fd, path = tempfile.mkstemp()
            else:
                path = os.path.join(tempfile.gettempdir(), file_name)
            # TODO get file_name from the filename at the end of the url if it exists
            with open(path, "wb") as new_file:
                chunk_size = 1024
                while True:
                    data = response.read(chunk_size)
                    if not data:
                        break
                    new_file.write(data)
            # release_conn is needed for streaming connections only
            response.release_conn()
            new_file = open(path, "rb")
            return new_file
        else:
            return response.data

    @staticmethod
    def __deserialize_multipart_form_data(
        response: urllib3.HTTPResponse,
    ) -> typing.Dict[str, typing.Any]:
        msg = email.message_from_bytes(response.data)
        return {
            part.get_param("name", header="Content-Disposition"): part.get_payload(
                decode=True
            ).decode(part.get_content_charset())
            if part.get_content_charset()
            else part.get_payload()
            for part in msg.get_payload()
        }

    def deserialize(
        self, response: urllib3.HTTPResponse, configuration: Configuration
    ) -> ApiResponse:
        content_type = response.getheader("content-type")
        # KF: Remove if Kuflow return only "application/json"
        content_type = "application/json"
        # KF: END Remove if Kuflow return only "application/json"
        deserialized_body = unset
        streamed = response.supports_chunked_reads()

        deserialized_headers = unset
        if self.headers is not None:
            # TODO add header deserialiation here
            pass

        if self.content is not None:
            if content_type not in self.content:
                raise ApiValueError(
                    f"Invalid content_type={content_type} returned for response with "
                    "status_code={str(response.status)}"
                )
            body_schema = self.content[content_type].schema
            if body_schema is None:
                # some specs do not define response content media type schemas
                return self.response_cls(
                    response=response, headers=deserialized_headers, body=unset
                )

            if self.content_type_is_json(content_type):
                body_data = self.__deserialize_json(response)
            elif content_type == "application/octet-stream":
                body_data = self.__deserialize_application_octet_stream(response)
            elif content_type.startswith("multipart/form-data"):
                body_data = self.__deserialize_multipart_form_data(response)
                content_type = "multipart/form-data"
            else:
                raise NotImplementedError(
                    "Deserialization of {} has not yet been implemented".format(
                        content_type
                    )
                )
            deserialized_body = body_schema._from_openapi_data(
                body_data, _configuration=configuration
            )
        elif streamed:
            response.release_conn()

        return self.response_cls(
            response=response, headers=deserialized_headers, body=deserialized_body
        )


class ApiClient:
    """Generic API client for OpenAPI client library builds.

    OpenAPI generic API client. This client handles the client-
    server communication, and is invariant across implementations. Specifics of
    the methods and models for each application are generated from the OpenAPI
    templates.

    NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech
    Do not edit the class manually.

    :param configuration: .Configuration object for this client
    :param header_name: a header to pass when making calls to the API.
    :param header_value: a header value to pass when making calls to
        the API.
    :param cookie: a cookie to include in the header when making calls
        to the API
    :param pool_threads: The number of threads to use for async requests
        to the API. More threads means more concurrent API requests.
    """

    _pool = None
    __json_encoder = JSONEncoder()

    def __init__(
        self,
        configuration: typing.Optional[Configuration] = None,
        header_name: typing.Optional[str] = None,
        header_value: typing.Optional[str] = None,
        cookie: typing.Optional[str] = None,
        pool_threads: int = 1,
    ):
        if configuration is None:
            configuration = Configuration()
        self.configuration = configuration
        self.pool_threads = pool_threads

        self.rest_client = rest.RESTClientObject(configuration)
        self.default_headers = {}
        if header_name is not None:
            self.default_headers[header_name] = header_value
        self.cookie = cookie
        # Set default User-Agent.
        self.user_agent = "OpenAPI-Generator/0.2.1/python"

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_value, traceback):
        self.close()

    def close(self):
        if self._pool:
            self._pool.close()
            self._pool.join()
            self._pool = None
            if hasattr(atexit, "unregister"):
                atexit.unregister(self.close)

    @property
    def pool(self):
        """Create thread pool on first request
        avoids instantiating unused threadpool for blocking clients.
        """
        if self._pool is None:
            atexit.register(self.close)
            self._pool = ThreadPool(self.pool_threads)
        return self._pool

    @property
    def user_agent(self):
        """User agent for this API client"""
        return self.default_headers["User-Agent"]

    @user_agent.setter
    def user_agent(self, value):
        self.default_headers["User-Agent"] = value

    def set_default_header(self, header_name, header_value):
        self.default_headers[header_name] = header_value

    def __call_api(
        self,
        resource_path: str,
        method: str,
        path_params: typing.Optional[typing.Dict[str, typing.Any]] = None,
        query_params: typing.Optional[typing.Tuple[typing.Tuple[str, str], ...]] = None,
        headers: typing.Optional[HTTPHeaderDict] = None,
        body: typing.Optional[typing.Union[str, bytes]] = None,
        fields: typing.Optional[typing.Tuple[typing.Tuple[str, str], ...]] = None,
        auth_settings: typing.Optional[typing.List[str]] = None,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        host: typing.Optional[str] = None,
    ) -> urllib3.HTTPResponse:

        # header parameters
        headers = headers or {}
        headers.update(self.default_headers)
        if self.cookie:
            headers["Cookie"] = self.cookie

        # path parameters
        if path_params:
            for k, v in path_params.items():
                # specified safe chars, encode everything
                resource_path = resource_path.replace(
                    "{%s}" % k,
                    quote(str(v), safe=self.configuration.safe_chars_for_path_param),
                )

        # auth setting
        self.update_params_for_auth(
            headers, query_params, auth_settings, resource_path, method, body
        )

        # request url
        if host is None:
            url = self.configuration.host + resource_path
        else:
            # use server/host defined in path or operation instead
            url = host + resource_path

        # perform request and return response
        response = self.request(
            method,
            url,
            query_params=query_params,
            headers=headers,
            fields=fields,
            body=body,
            stream=stream,
            timeout=timeout,
        )
        return response

    def call_api(
        self,
        resource_path: str,
        method: str,
        path_params: typing.Optional[typing.Dict[str, typing.Any]] = None,
        query_params: typing.Optional[typing.Tuple[typing.Tuple[str, str], ...]] = None,
        headers: typing.Optional[HTTPHeaderDict] = None,
        body: typing.Optional[typing.Union[str, bytes]] = None,
        fields: typing.Optional[typing.Tuple[typing.Tuple[str, str], ...]] = None,
        auth_settings: typing.Optional[typing.List[str]] = None,
        async_req: typing.Optional[bool] = None,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        host: typing.Optional[str] = None,
    ) -> urllib3.HTTPResponse:
        """Makes the HTTP request (synchronous) and returns deserialized data.

        To make an async_req request, set the async_req parameter.

        :param resource_path: Path to method endpoint.
        :param method: Method to call.
        :param path_params: Path parameters in the url.
        :param query_params: Query parameters in the url.
        :param headers: Header parameters to be
            placed in the request header.
        :param body: Request body.
        :param fields: Request post form parameters,
            for `application/x-www-form-urlencoded`, `multipart/form-data`.
        :param auth_settings: Auth Settings names for the request.
        :param async_req: execute request asynchronously
        :type async_req: bool, optional TODO remove, unused
        :param stream: if True, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Also when True, if the openapi spec describes a file download,
                                 the data will be written to a local filesystme file and the BinarySchema
                                 instance will also inherit from FileSchema and FileIO
                                 Default is False.
        :type stream: bool, optional
        :param timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param host: api endpoint host
        :return:
            If async_req parameter is True,
            the request will be called asynchronously.
            The method will return the request thread.
            If parameter async_req is False or missing,
            then the method will return the response directly.
        """

        if not async_req:
            return self.__call_api(
                resource_path,
                method,
                path_params,
                query_params,
                headers,
                body,
                fields,
                auth_settings,
                stream,
                timeout,
                host,
            )

        return self.pool.apply_async(
            self.__call_api,
            (
                resource_path,
                method,
                path_params,
                query_params,
                headers,
                body,
                json,
                fields,
                auth_settings,
                stream,
                timeout,
                host,
            ),
        )

    def request(
        self,
        method: str,
        url: str,
        query_params: typing.Optional[typing.Tuple[typing.Tuple[str, str], ...]] = None,
        headers: typing.Optional[HTTPHeaderDict] = None,
        fields: typing.Optional[typing.Tuple[typing.Tuple[str, str], ...]] = None,
        body: typing.Optional[typing.Union[str, bytes]] = None,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> urllib3.HTTPResponse:
        """Makes the HTTP request using RESTClient."""
        if method == "GET":
            return self.rest_client.GET(
                url,
                query_params=query_params,
                stream=stream,
                timeout=timeout,
                headers=headers,
            )
        elif method == "HEAD":
            return self.rest_client.HEAD(
                url,
                query_params=query_params,
                stream=stream,
                timeout=timeout,
                headers=headers,
            )
        elif method == "OPTIONS":
            return self.rest_client.OPTIONS(
                url,
                query_params=query_params,
                headers=headers,
                fields=fields,
                stream=stream,
                timeout=timeout,
                body=body,
            )
        elif method == "POST":
            return self.rest_client.POST(
                url,
                query_params=query_params,
                headers=headers,
                fields=fields,
                stream=stream,
                timeout=timeout,
                body=body,
            )
        elif method == "PUT":
            return self.rest_client.PUT(
                url,
                query_params=query_params,
                headers=headers,
                fields=fields,
                stream=stream,
                timeout=timeout,
                body=body,
            )
        elif method == "PATCH":
            return self.rest_client.PATCH(
                url,
                query_params=query_params,
                headers=headers,
                fields=fields,
                stream=stream,
                timeout=timeout,
                body=body,
            )
        elif method == "DELETE":
            return self.rest_client.DELETE(
                url,
                query_params=query_params,
                headers=headers,
                stream=stream,
                timeout=timeout,
                body=body,
            )
        else:
            raise ApiValueError(
                "http method must be `GET`, `HEAD`, `OPTIONS`,"
                " `POST`, `PATCH`, `PUT` or `DELETE`."
            )

    def update_params_for_auth(
        self, headers, querys, auth_settings, resource_path, method, body
    ):
        """Updates header and query params based on authentication setting.

        :param headers: Header parameters dict to be updated.
        :param querys: Query parameters tuple list to be updated.
        :param auth_settings: Authentication setting identifiers list.
        :param resource_path: A string representation of the HTTP request resource path.
        :param method: A string representation of the HTTP request method.
        :param body: A object representing the body of the HTTP request.
            The object type is the return value of _encoder.default().
        """
        if not auth_settings:
            return

        for auth in auth_settings:
            auth_setting = self.configuration.auth_settings().get(auth)
            if auth_setting:
                if auth_setting["in"] == "cookie":
                    headers.add("Cookie", auth_setting["value"])
                elif auth_setting["in"] == "header":
                    if auth_setting["type"] != "http-signature":
                        headers.add(auth_setting["key"], auth_setting["value"])
                elif auth_setting["in"] == "query":
                    querys.append((auth_setting["key"], auth_setting["value"]))
                else:
                    raise ApiValueError(
                        "Authentication token must be in `query` or `header`"
                    )


class Api:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client: typing.Optional[ApiClient] = None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @staticmethod
    def _verify_typed_dict_inputs(
        cls: typing.Type[typing.TypedDict], data: typing.Dict[str, typing.Any]
    ):
        """
        Ensures that:
        - required keys are present
        - additional properties are not input
        - value stored under required keys do not have the value unset
        Note: detailed value checking is done in schema classes
        """
        missing_required_keys = []
        required_keys_with_unset_values = []
        for required_key in cls.__required_keys__:
            if required_key not in data:
                missing_required_keys.append(required_key)
                continue
            value = data[required_key]
            if value is unset:
                required_keys_with_unset_values.append(required_key)
        if missing_required_keys:
            raise ApiTypeError(
                "{} missing {} required arguments: {}".format(
                    cls.__name__, len(missing_required_keys), missing_required_keys
                )
            )
        if required_keys_with_unset_values:
            raise ApiValueError(
                "{} contains invalid unset values for {} required keys: {}".format(
                    cls.__name__,
                    len(required_keys_with_unset_values),
                    required_keys_with_unset_values,
                )
            )

        disallowed_additional_keys = []
        for key in data:
            if key in cls.__required_keys__ or key in cls.__optional_keys__:
                continue
            disallowed_additional_keys.append(key)
        if disallowed_additional_keys:
            raise ApiTypeError(
                "{} got {} unexpected keyword arguments: {}".format(
                    cls.__name__,
                    len(disallowed_additional_keys),
                    disallowed_additional_keys,
                )
            )

    def get_host(
        self,
        operation_id: str,
        servers: typing.Tuple[typing.Dict[str, str], ...] = tuple(),
        host_index: typing.Optional[int] = None,
    ) -> typing.Optional[str]:
        configuration = self.api_client.configuration
        try:
            if host_index is None:
                index = configuration.server_operation_index.get(
                    operation_id, configuration.server_index
                )
            else:
                index = host_index
            server_variables = configuration.server_operation_variables.get(
                operation_id, configuration.server_variables
            )
            host = configuration.get_host_from_settings(
                index, variables=server_variables, servers=servers
            )
        except IndexError:
            if servers:
                raise ApiValueError(
                    "Invalid host index. Must be 0 <= index < %s" % len(servers)
                )
            host = None
        return host


class SerializedRequestBody(typing.TypedDict, total=False):
    body: typing.Union[str, bytes]
    fields: typing.Tuple[typing.Union[RequestField, tuple[str, str]], ...]


class RequestBody(StyleFormSerializer, JSONDetector):
    """
    A request body parameter
    content: content_type to MediaType Schema info
    """

    __json_encoder = JSONEncoder()

    def __init__(
        self,
        content: typing.Dict[str, MediaType],
        required: bool = False,
    ):
        self.required = required
        if len(content) == 0:
            raise ValueError(
                "Invalid value for content, the content dict must have >= 1 entry"
            )
        self.content = content

    def __serialize_json(self, in_data: typing.Any) -> typing.Dict[str, bytes]:
        in_data = self.__json_encoder.default(in_data)
        json_str = json.dumps(
            in_data, separators=(",", ":"), ensure_ascii=False
        ).encode("utf-8")
        return dict(body=json_str)

    @staticmethod
    def __serialize_text_plain(in_data: typing.Any) -> typing.Dict[str, str]:
        if isinstance(in_data, frozendict):
            raise ValueError("Unable to serialize type frozendict to text/plain")
        elif isinstance(in_data, tuple):
            raise ValueError("Unable to serialize type tuple to text/plain")
        elif isinstance(in_data, NoneClass):
            raise ValueError("Unable to serialize type NoneClass to text/plain")
        elif isinstance(in_data, BoolClass):
            raise ValueError("Unable to serialize type BoolClass to text/plain")
        return dict(body=str(in_data))

    def __multipart_json_item(self, key: str, value: Schema) -> RequestField:
        json_value = self.__json_encoder.default(value)
        return RequestField(
            name=key,
            data=json.dumps(json_value),
            headers={"Content-Type": "application/json"},
        )

    def __multipart_form_item(self, key: str, value: Schema) -> RequestField:
        if isinstance(value, str):
            return RequestField(
                name=key, data=str(value), headers={"Content-Type": "text/plain"}
            )
        elif isinstance(value, bytes):
            return RequestField(
                name=key,
                data=value,
                headers={"Content-Type": "application/octet-stream"},
            )
        elif isinstance(value, FileIO):
            # KF: Fix Content-disposition and Content-Type
            name = key
            filename = os.path.basename(value.name)
            data = value.read()
            mimetype = mimetypes.guess_type(filename)[0] or "application/octet-stream"
            value.close()
            return tuple([name, tuple([filename, data, mimetype])])
            # request_field = RequestField(
            #     name=key,
            #     data=value.read(),
            #     filename=os.path.basename(value.name),
            #     headers={"Content-Type": "application/octet-stream"},
            # )
            # value.close()
            # return request_field
        else:
            # KF: Fix Content-disposition
            request_field = self.__multipart_json_item(key=key, value=value)
            request_field.make_multipart(content_type="application/json")
            return request_field
            # return self.__multipart_json_item(key=key, value=value)

    def __serialize_multipart_form_data(
        self, in_data: Schema
    ) -> typing.Dict[str, typing.Tuple[RequestField, ...]]:
        if not isinstance(in_data, frozendict):
            raise ValueError(
                f"Unable to serialize {in_data} to multipart/form-data because it is not a dict of data"
            )
        """
        In a multipart/form-data request body, each schema property, or each element of a schema array property,
        takes a section in the payload with an internal header as defined by RFC7578. The serialization strategy
        for each property of a multipart/form-data request body can be specified in an associated Encoding Object.

        When passing in multipart types, boundaries MAY be used to separate sections of the content being
        transferred – thus, the following default Content-Types are defined for multipart:

        If the (object) property is a primitive, or an array of primitive values, the default Content-Type is text/plain
        If the property is complex, or an array of complex values, the default Content-Type is application/json
            Question: how is the array of primitives encoded?
        If the property is a type: string with a contentEncoding, the default Content-Type is application/octet-stream
        """
        fields = []
        for key, value in in_data.items():
            if isinstance(value, tuple):
                if value:
                    # values use explode = True, so the code makes a RequestField for each item with name=key
                    for item in value:
                        request_field = self.__multipart_form_item(key=key, value=item)
                        fields.append(request_field)
                else:
                    # send an empty array as json because exploding will not send it
                    request_field = self.__multipart_json_item(key=key, value=value)
                    fields.append(request_field)
            else:
                request_field = self.__multipart_form_item(key=key, value=value)
                fields.append(request_field)

        return dict(fields=tuple(fields))

    def __serialize_application_octet_stream(
        self, in_data: BinarySchema
    ) -> typing.Dict[str, bytes]:
        if isinstance(in_data, bytes):
            return dict(body=in_data)
        # FileIO type
        result = dict(body=in_data.read())
        in_data.close()
        return result

    def __serialize_application_x_www_form_data(
        self, in_data: typing.Any
    ) -> typing.Dict[str, tuple[tuple[str, str], ...]]:
        if not isinstance(in_data, frozendict):
            raise ValueError(
                f"Unable to serialize {in_data} to application/x-www-form-urlencoded because it is not a dict of data"
            )
        cast_in_data = self.__json_encoder.default(in_data)
        fields = self._serialize_form(cast_in_data, explode=True, name="")
        if not fields:
            return {}
        return {"fields": fields}

    def serialize(
        self, in_data: typing.Any, content_type: str
    ) -> SerializedRequestBody:
        """
        If a str is returned then the result will be assigned to data when making the request
        If a tuple is returned then the result will be used as fields input in encode_multipart_formdata
        Return a tuple of

        The key of the return dict is
        - body for application/json
        - encode_multipart and fields for multipart/form-data
        """
        media_type = self.content[content_type]
        if isinstance(in_data, media_type.schema):
            cast_in_data = in_data
        elif isinstance(in_data, (dict, frozendict)) and in_data:
            cast_in_data = media_type.schema(**in_data)
        else:
            cast_in_data = media_type.schema(in_data)
        # TODO check for and use encoding if it exists
        # and content_type is multipart or application/x-www-form-urlencoded
        if self.content_type_is_json(content_type):
            return self.__serialize_json(cast_in_data)
        elif content_type == "text/plain":
            return self.__serialize_text_plain(cast_in_data)
        elif content_type == "multipart/form-data":
            return self.__serialize_multipart_form_data(cast_in_data)
        elif content_type == "application/x-www-form-urlencoded":
            return self.__serialize_application_x_www_form_data(cast_in_data)
        elif content_type == "application/octet-stream":
            return self.__serialize_application_octet_stream(cast_in_data)
        raise NotImplementedError(
            "Serialization has not yet been implemented for {}".format(content_type)
        )
