# Generated by Django 3.2.16 on 2023-01-09 10:44

import datetime
from django.db import migrations, models
import django.db.models.deletion
from django.utils.timezone import utc
import grimoirelab_toolkit.datetime
import sortinghat.core.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CustomPermissions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'permissions': (('execute_job', 'Can execute a job'),),
                'managed': False,
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('created_at', sortinghat.core.models.CreationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('last_modified', sortinghat.core.models.LastModificationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('code', models.CharField(max_length=2, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=191)),
                ('alpha3', models.CharField(max_length=3)),
            ],
            options={
                'db_table': 'countries',
                'unique_together': {('alpha3',)},
            },
        ),
        migrations.CreateModel(
            name='Individual',
            fields=[
                ('created_at', sortinghat.core.models.CreationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('last_modified', sortinghat.core.models.LastModificationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('mk', models.CharField(max_length=128, primary_key=True, serialize=False)),
                ('is_locked', models.BooleanField(default=False)),
            ],
            options={
                'db_table': 'individuals',
                'ordering': ('last_modified', 'created_at', 'profile__name'),
            },
        ),
        migrations.CreateModel(
            name='Transaction',
            fields=[
                ('tuid', models.CharField(max_length=128, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128)),
                ('created_at', models.DateTimeField()),
                ('closed_at', models.DateTimeField(null=True)),
                ('is_closed', models.BooleanField(default=False)),
                ('authored_by', models.CharField(max_length=128, null=True)),
            ],
            options={
                'db_table': 'transactions',
                'ordering': ('created_at', 'tuid'),
            },
        ),
        migrations.CreateModel(
            name='RecommenderExclusionTerm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', sortinghat.core.models.CreationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('last_modified', sortinghat.core.models.LastModificationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('term', models.CharField(max_length=191)),
            ],
            options={
                'db_table': 'recommender_exclusion_terms',
                'unique_together': {('term',)},
            },
        ),
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', sortinghat.core.models.CreationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('last_modified', sortinghat.core.models.LastModificationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('name', models.CharField(max_length=128, null=True)),
                ('email', models.CharField(max_length=128, null=True)),
                ('gender', models.CharField(max_length=32, null=True)),
                ('gender_acc', models.PositiveIntegerField(null=True)),
                ('is_bot', models.BooleanField(default=False)),
                ('country', models.ForeignKey(db_column='country_code', null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.country')),
                ('individual', models.OneToOneField(db_column='mk', on_delete=django.db.models.deletion.CASCADE, related_name='profile', to='core.individual')),
            ],
            options={
                'db_table': 'profiles',
            },
        ),
        migrations.CreateModel(
            name='Operation',
            fields=[
                ('ouid', models.CharField(max_length=128, primary_key=True, serialize=False)),
                ('op_type', models.CharField(choices=[('ADD', 'ADD'), ('DELETE', 'DELETE'), ('UPDATE', 'UPDATE')], max_length=128)),
                ('entity_type', models.CharField(max_length=128)),
                ('target', models.CharField(max_length=128)),
                ('timestamp', models.DateTimeField()),
                ('args', models.JSONField()),
                ('trx', models.ForeignKey(db_column='tuid', on_delete=django.db.models.deletion.CASCADE, related_name='operations', to='core.transaction')),
            ],
            options={
                'db_table': 'operations',
                'ordering': ('timestamp', 'ouid', 'trx'),
            },
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('path', models.CharField(max_length=255, unique=True)),
                ('depth', models.PositiveIntegerField()),
                ('numchild', models.PositiveIntegerField(default=0)),
                ('created_at', sortinghat.core.models.CreationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('last_modified', sortinghat.core.models.LastModificationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('name', models.CharField(max_length=191)),
                ('type', models.CharField(choices=[('organization', 'Organization'), ('team', 'Team')], max_length=12)),
                ('parent_org', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='teams', to='core.group')),
            ],
            options={
                'db_table': 'groups',
                'unique_together': {('name', 'parent_org')},
            },
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('core.group',),
        ),
        migrations.CreateModel(
            name='Team',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('core.group',),
        ),
        migrations.CreateModel(
            name='MergeRecommendation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', sortinghat.core.models.CreationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('last_modified', sortinghat.core.models.LastModificationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('applied', models.BooleanField(default=None, null=True)),
                ('individual1', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='match_recommendation_individual_1', to='core.individual')),
                ('individual2', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='match_recommendation_individual_2', to='core.individual')),
            ],
            options={
                'db_table': 'merge_recommendations',
                'unique_together': {('individual1', 'individual2')},
            },
        ),
        migrations.CreateModel(
            name='Identity',
            fields=[
                ('created_at', sortinghat.core.models.CreationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('last_modified', sortinghat.core.models.LastModificationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('uuid', models.CharField(max_length=128, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, null=True)),
                ('email', models.CharField(max_length=128, null=True)),
                ('username', models.CharField(max_length=128, null=True)),
                ('source', models.CharField(max_length=32)),
                ('individual', models.ForeignKey(db_column='mk', on_delete=django.db.models.deletion.CASCADE, related_name='identities', to='core.individual')),
            ],
            options={
                'db_table': 'identities',
                'unique_together': {('name', 'email', 'username', 'source')},
            },
        ),
        migrations.CreateModel(
            name='GenderRecommendation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', sortinghat.core.models.CreationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('last_modified', sortinghat.core.models.LastModificationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('gender', models.CharField(max_length=128)),
                ('accuracy', models.PositiveIntegerField()),
                ('applied', models.BooleanField(default=None, null=True)),
                ('individual', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.individual')),
            ],
            options={
                'db_table': 'gender_recommendations',
                'unique_together': {('individual',)},
            },
        ),
        migrations.CreateModel(
            name='Enrollment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', sortinghat.core.models.CreationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('last_modified', sortinghat.core.models.LastModificationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('start', models.DateTimeField(default=datetime.datetime(1900, 1, 1, 0, 0, tzinfo=utc))),
                ('end', models.DateTimeField(default=datetime.datetime(2100, 1, 1, 0, 0, tzinfo=utc))),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='enrollments', to='core.group')),
                ('individual', models.ForeignKey(db_column='mk', on_delete=django.db.models.deletion.CASCADE, related_name='enrollments', to='core.individual')),
            ],
            options={
                'db_table': 'enrollments',
                'ordering': ('start', 'end'),
                'unique_together': {('individual', 'group', 'start', 'end')},
            },
        ),
        migrations.CreateModel(
            name='Domain',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', sortinghat.core.models.CreationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('last_modified', sortinghat.core.models.LastModificationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('domain', models.CharField(max_length=128)),
                ('is_top_domain', models.BooleanField(default=False)),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='domains', to='core.group')),
            ],
            options={
                'db_table': 'domains_organizations',
                'ordering': ('domain',),
                'unique_together': {('domain',)},
            },
        ),
        migrations.CreateModel(
            name='AffiliationRecommendation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', sortinghat.core.models.CreationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('last_modified', sortinghat.core.models.LastModificationDateTimeField(default=grimoirelab_toolkit.datetime.datetime_utcnow, editable=False)),
                ('applied', models.BooleanField(default=None, null=True)),
                ('individual', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.individual')),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.group')),
            ],
            options={
                'db_table': 'affiliation_recommendations',
                'unique_together': {('individual', 'organization')},
            },
        ),
    ]
