# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['dotbot_firefox']
install_requires = \
['dotbot>=1.19.0,<2.0.0']

setup_kwargs = {
    'name': 'dotbot-firefox',
    'version': '1.0.0',
    'description': 'Configure your Firefox profile(s) using dotbot',
    'long_description': '..  dotbot-firefox -- Configure your Firefox profile(s) using dotbot.\n..  Copyright 2022 Kurt McKee <contactme@kurtmckee.org>\n..  SPDX-License-Identifier: MIT\n\n\ndotbot-firefox\n##############\n\nConfigure your Firefox profile(s) using `dotbot`_.\n\n-------------------------------------------------------------------------------\n\n\nTable of contents\n=================\n\n*   `What you can do with it`_\n*   `Installation`_\n*   `Configuration`_\n*   `Firefox profile locations`_\n*   `Development`_\n\n\nWhat you can do with it\n=======================\n\nWhen Firefox starts, it will look for a ``user.js`` file in your profile directory.\nIf found, the ``user.js`` settings will be copied to ``prefs.js`` and used.\n\nYou can enforce a consistent Firefox configuration across all your profiles\nby using dotbot-firefox to create symlinks to a custom ``user.js``.\nThe plugin will find Firefox profile directories that contain a ``prefs.js`` file\nand will use dotbot\'s builtin Link plugin to create the symlinks.\n\n\nInstallation\n============\n\nThere are two ways to install and use the plugin:\n\n1.  Install it as a Python package.\n2.  Add it as a git submodule in your dotfiles repository.\n3.  Copy ``dotbot_firefox.py`` into your dotfiles directory.\n\n\nPython package\n--------------\n\nIf you want to install dotbot-firefox as a Python package\n(for example, if you\'re using a virtual environment),\nthen you can install the plugin using ``pip``:\n\n..  code-block::\n\n    pip install dotbot-firefox\n\nThen, when running dotbot, use the ``-p`` or ``--plugin`` option\nto tell dotbot to load the plugin:\n\n..  code-block::\n\n    dotbot [...] --plugin dotbot_firefox [...]\n\nIf you\'re using one of dotbot\'s ``install`` scripts,\nyou\'ll need to edit that file to add the ``--plugin`` option.\n\n\nGit submodule\n-------------\n\nIf you want to track dotbot-firefox as a git submodule\n(for example, if you manage your dotfiles using git)\nthen you can add the plugin repository as a submodule using ``git``:\n\n..  code-block::\n\n    git submodule add https://github.com/kurtmckee/dotbot-firefox.git\n\nThis will clone the repository to a directory named ``dotbot-firefox``.\nThen, when running dotbot, use the ``-p`` or ``--plugin`` option\nto tell dotbot to load the plugin:\n\n..  code-block::\n\n    dotbot [...] --plugin dotbot-firefox/dotbot_firefox.py [...]\n\nNote that you may need to initialize the plugin\'s git submodule\nwhen you clone your dotfiles repository or pull new changes\nto another computer.\nThe command for this will look something like:\n\n..  code-block::\n\n    git submodule update --init dotbot-firefox\n\n\nCopy ``dotbot_firefox.py``\n--------------------------\n\nIf desired, you can copy ``dotbot_firefox.py`` to your dotfiles directory.\nYou might choose to do this if you already use other plugins\nand have configured dotbot to load all plugins from a plugin directory.\n\nIf you copy ``dotbot_firefox.py`` to the root of your dotfiles directory\nthen, when running dotbot, use the ``-p`` or ``--plugin`` option\nto tell dotbot to load the plugin:\n\n..  code-block::\n\n    dotbot [...] --plugin dotbot_firefox.py [...]\n\nIf you copy ``dotbot_firefox.py`` to a directory containing other plugins,\nyou can use dotbot\'s ``--plugin-dir`` option to load all plugins in the directory.\nIn the example below, the plugin directory is named ``dotbot-plugins``:\n\n..  code-block::\n\n    dotbot [...] --plugin-dir dotbot-plugins [...]\n\n\nConfiguration\n=============\n\nFirst, create a ``user.js`` file in the dotfiles directory that dotbot manages.\nFor example, it could contain this configuration to set your homepage:\n\n..  code-block:: js\n\n    user_pref("browser.startup.homepage", "https://dashboard.example");\n\n(MozillaZine maintains an extensive list of `Firefox configuration settings`_.)\n\nThen, add a ``firefox`` directive to your dotbot config with a ``user.js`` key.\nThe value of the key follows the syntax of the `dotbot Link plugin`_.\n\n..  code-block:: yaml\n\n    # Example 1:\n    # "user.js" can be specified as a string.\n    firefox:\n      user.js: firefox/user.js\n\n\n    # Example 2:\n    # "user.js" can have no value, and will be found\n    # in the same directory as your dotbot config file.\n    firefox:\n      user.js:\n\n\n    # Example 3:\n    # The extended Link plugin syntax is supported.\n    firefox:\n      user.js:\n        path: firefox/user.js\n        force: true\n\n\nFirefox profile locations\n=========================\n\nThe dotbot-firefox plugin is aware of the following default directories:\n\n*   ``%APPDATA%\\Mozilla\\Firefox\\Profiles`` (Windows)\n*   ``~/Library/Application Support/Firefox/Profiles`` (Mac OS)\n*   ``~/.mozilla/firefox`` (Linux)\n*   ``~/snap/firefox/common/.mozilla/firefox`` (Firefox Snap for Linux)\n\nOnly profile subdirectories that contain a ``prefs.js`` file\nwill be considered valid by the plugin.\n\n\nDevelopment\n===========\n\nTo set up a development environment, clone the dotbot-firefox plugin\'s git repository.\nThen, follow these steps to create a virtual environment and run the unit tests locally:\n\n..  code-block:: shell\n\n    # Create the virtual environment\n    $ python -m venv .venv\n\n    # Activate the virtual environment (Linux)\n    $ . .venv/bin/activate\n\n    # Activate the virtual environment (Windows)\n    $ & .venv/Scripts/Activate.ps1\n\n    # Update pip and setuptools, and install wheel\n    (.venv) $ pip install -U pip setuptools wheel\n\n    # Install poetry\n    (.venv) $ pip install poetry\n\n    # Install all dependencies\n    (.venv) $ poetry install\n\n    # Run the unit tests locally\n    (.venv) $ tox\n\n\n..  Links\n..  =====\n..\n..  _dotbot: https://github.com/anishathalye/dotbot\n..  _dotbot Link plugin: https://github.com/anishathalye/dotbot#link\n..  _Firefox configuration settings: https://kb.mozillazine.org/About:config_entries\n',
    'author': 'Kurt McKee',
    'author_email': 'contactme@kurtmckee.org',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'py_modules': modules,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
