"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MINIMAL_EC2_SSM_SESSION_MANAGER_POLICY_STATEMENT = exports.MINIMAL_ECS_SSM_SESSION_MANAGER_POLICY_STATEMENT = exports.MINIMAL_SSM_SESSION_MANAGER_POLICY_STATEMENT = exports.SingletonLogType = void 0;
exports.singletonLambda = singletonLambda;
exports.singletonLogGroup = singletonLogGroup;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
/**
 * Initialize or return a singleton Lambda function instance.
 *
 * @internal
 */
function singletonLambda(functionType, scope, id, props) {
    const constructName = `${id}-dcc036c8-876b-451e-a2c1-552f9e06e9e1`;
    const existing = cdk.Stack.of(scope).node.tryFindChild(constructName);
    if (existing) {
        // Just assume this is true
        return existing;
    }
    return new functionType(cdk.Stack.of(scope), constructName, props);
}
/**
 * Central log group type.
 *
 * @internal
 */
var SingletonLogType;
(function (SingletonLogType) {
    SingletonLogType["RUNNER_IMAGE_BUILD"] = "Runner Image Build Helpers Log";
    SingletonLogType["ORCHESTRATOR"] = "Orchestrator Log";
    SingletonLogType["SETUP"] = "Setup Log";
})(SingletonLogType || (exports.SingletonLogType = SingletonLogType = {}));
/**
 * Initialize or return central log group instance.
 *
 * @internal
 */
function singletonLogGroup(scope, type) {
    const existing = cdk.Stack.of(scope).node.tryFindChild(type);
    if (existing) {
        // Just assume this is true
        return existing;
    }
    return new aws_cdk_lib_1.aws_logs.LogGroup(cdk.Stack.of(scope), type, {
        retention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        removalPolicy: cdk.RemovalPolicy.DESTROY,
    });
}
/**
 * The absolute minimum permissions required for SSM Session Manager to work. Unlike `AmazonSSMManagedInstanceCore`, it doesn't give permission to read all SSM parameters.
 *
 * @internal
 */
exports.MINIMAL_SSM_SESSION_MANAGER_POLICY_STATEMENT = new aws_cdk_lib_1.aws_iam.PolicyStatement({
    actions: [
        'ssmmessages:CreateControlChannel',
        'ssmmessages:CreateDataChannel',
        'ssmmessages:OpenControlChannel',
        'ssmmessages:OpenDataChannel',
    ],
    resources: ['*'],
});
/**
 * The absolute minimum permissions required for SSM Session Manager on ECS to work. Unlike `AmazonSSMManagedInstanceCore`, it doesn't give permission to read all SSM parameters.
 *
 * @internal
 */
exports.MINIMAL_ECS_SSM_SESSION_MANAGER_POLICY_STATEMENT = new aws_cdk_lib_1.aws_iam.PolicyStatement({
    actions: [
        'ssmmessages:CreateControlChannel',
        'ssmmessages:CreateDataChannel',
        'ssmmessages:OpenControlChannel',
        'ssmmessages:OpenDataChannel',
        's3:GetEncryptionConfiguration',
    ],
    resources: ['*'],
});
/**
 * The absolute minimum permissions required for SSM Session Manager on EC2 to work. Unlike `AmazonSSMManagedInstanceCore`, it doesn't give permission to read all SSM parameters.
 *
 * @internal
 */
exports.MINIMAL_EC2_SSM_SESSION_MANAGER_POLICY_STATEMENT = new aws_cdk_lib_1.aws_iam.PolicyStatement({
    actions: [
        'ssmmessages:CreateControlChannel',
        'ssmmessages:CreateDataChannel',
        'ssmmessages:OpenControlChannel',
        'ssmmessages:OpenDataChannel',
        's3:GetEncryptionConfiguration',
        'ssm:UpdateInstanceInformation',
    ],
    resources: ['*'],
});
//# sourceMappingURL=data:application/json;base64,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