import { aws_iam as iam, aws_lambda as lambda, aws_logs as logs } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Initialize or return a singleton Lambda function instance.
 *
 * @internal
 */
export declare function singletonLambda<FunctionType extends lambda.Function>(functionType: new (s: Construct, i: string, p?: lambda.FunctionOptions) => FunctionType, scope: Construct, id: string, props?: lambda.FunctionOptions): FunctionType;
/**
 * Central log group type.
 *
 * @internal
 */
export declare enum SingletonLogType {
    RUNNER_IMAGE_BUILD = "Runner Image Build Helpers Log",
    ORCHESTRATOR = "Orchestrator Log",
    SETUP = "Setup Log"
}
/**
 * Initialize or return central log group instance.
 *
 * @internal
 */
export declare function singletonLogGroup(scope: Construct, type: SingletonLogType): logs.ILogGroup;
/**
 * The absolute minimum permissions required for SSM Session Manager to work. Unlike `AmazonSSMManagedInstanceCore`, it doesn't give permission to read all SSM parameters.
 *
 * @internal
 */
export declare const MINIMAL_SSM_SESSION_MANAGER_POLICY_STATEMENT: iam.PolicyStatement;
/**
 * The absolute minimum permissions required for SSM Session Manager on ECS to work. Unlike `AmazonSSMManagedInstanceCore`, it doesn't give permission to read all SSM parameters.
 *
 * @internal
 */
export declare const MINIMAL_ECS_SSM_SESSION_MANAGER_POLICY_STATEMENT: iam.PolicyStatement;
/**
 * The absolute minimum permissions required for SSM Session Manager on EC2 to work. Unlike `AmazonSSMManagedInstanceCore`, it doesn't give permission to read all SSM parameters.
 *
 * @internal
 */
export declare const MINIMAL_EC2_SSM_SESSION_MANAGER_POLICY_STATEMENT: iam.PolicyStatement;
