"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
const lambda_github_1 = require("./lambda-github");
class RunnerTokenError extends Error {
    constructor(msg) {
        super(msg);
        this.name = 'RunnerTokenError';
        Object.setPrototypeOf(this, RunnerTokenError.prototype);
    }
}
async function handler(event) {
    try {
        const { githubSecrets, octokit, } = await (0, lambda_github_1.getOctokit)(event.installationId);
        let token;
        let registrationUrl;
        if (githubSecrets.runnerLevel === 'repo' || githubSecrets.runnerLevel === undefined) {
            token = await getRegistrationTokenForRepo(octokit, event.owner, event.repo);
            registrationUrl = `https://${githubSecrets.domain}/${event.owner}/${event.repo}`;
        }
        else if (githubSecrets.runnerLevel === 'org') {
            token = await getRegistrationTokenForOrg(octokit, event.owner);
            registrationUrl = `https://${githubSecrets.domain}/${event.owner}`;
        }
        else {
            throw new RunnerTokenError('Invalid runner level');
        }
        return {
            domain: githubSecrets.domain,
            token,
            registrationUrl,
        };
    }
    catch (error) {
        console.error(error);
        throw new RunnerTokenError(error.message);
    }
}
async function getRegistrationTokenForOrg(octokit, owner) {
    const response = await octokit.rest.actions.createRegistrationTokenForOrg({
        org: owner,
    });
    return response.data.token;
}
async function getRegistrationTokenForRepo(octokit, owner, repo) {
    const response = await octokit.rest.actions.createRegistrationTokenForRepo({
        owner: owner,
        repo: repo,
    });
    return response.data.token;
}
//# sourceMappingURL=data:application/json;base64,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