"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSecretValue = getSecretValue;
exports.getSecretJsonValue = getSecretJsonValue;
exports.updateSecretValue = updateSecretValue;
exports.customResourceRespond = customResourceRespond;
const client_secrets_manager_1 = require("@aws-sdk/client-secrets-manager");
const sm = new client_secrets_manager_1.SecretsManagerClient();
async function getSecretValue(arn) {
    if (!arn) {
        throw new Error('Missing secret ARN');
    }
    const secret = await sm.send(new client_secrets_manager_1.GetSecretValueCommand({ SecretId: arn }));
    if (!secret.SecretString) {
        throw new Error(`No SecretString in ${arn}`);
    }
    return secret.SecretString;
}
async function getSecretJsonValue(arn) {
    return JSON.parse(await getSecretValue(arn));
}
async function updateSecretValue(arn, value) {
    if (!arn) {
        throw new Error('Missing secret ARN');
    }
    await sm.send(new client_secrets_manager_1.UpdateSecretCommand({ SecretId: arn, SecretString: value }));
}
async function customResourceRespond(event, responseStatus, reason, physicalResourceId, data) {
    const responseBody = JSON.stringify({
        Status: responseStatus,
        Reason: reason,
        PhysicalResourceId: physicalResourceId,
        StackId: event.StackId,
        RequestId: event.RequestId,
        LogicalResourceId: event.LogicalResourceId,
        NoEcho: false,
        Data: data,
    });
    console.log('Responding', responseBody);
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    const parsedUrl = require('url').parse(event.ResponseURL);
    const requestOptions = {
        hostname: parsedUrl.hostname,
        path: parsedUrl.path,
        method: 'PUT',
        headers: {
            'content-type': '',
            'content-length': responseBody.length,
        },
    };
    return new Promise((resolve, reject) => {
        try {
            // eslint-disable-next-line @typescript-eslint/no-require-imports
            const request = require('https').request(requestOptions, resolve);
            request.on('error', reject);
            request.write(responseBody);
            request.end();
        }
        catch (e) {
            reject(e);
        }
    });
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWhlbHBlcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvbGFtYmRhLWhlbHBlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFnQkEsd0NBWUM7QUFFRCxnREFFQztBQUVELDhDQU1DO0FBRUQsc0RBc0NDO0FBaEZELDRFQUFtSDtBQWNuSCxNQUFNLEVBQUUsR0FBRyxJQUFJLDZDQUFvQixFQUFFLENBQUM7QUFFL0IsS0FBSyxVQUFVLGNBQWMsQ0FBQyxHQUF1QjtJQUMxRCxJQUFJLENBQUMsR0FBRyxFQUFFLENBQUM7UUFDVCxNQUFNLElBQUksS0FBSyxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVELE1BQU0sTUFBTSxHQUFHLE1BQU0sRUFBRSxDQUFDLElBQUksQ0FBQyxJQUFJLDhDQUFxQixDQUFDLEVBQUUsUUFBUSxFQUFFLEdBQUcsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUUzRSxJQUFJLENBQUMsTUFBTSxDQUFDLFlBQVksRUFBRSxDQUFDO1FBQ3pCLE1BQU0sSUFBSSxLQUFLLENBQUMsc0JBQXNCLEdBQUcsRUFBRSxDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVELE9BQU8sTUFBTSxDQUFDLFlBQVksQ0FBQztBQUM3QixDQUFDO0FBRU0sS0FBSyxVQUFVLGtCQUFrQixDQUFDLEdBQXVCO0lBQzlELE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLGNBQWMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0FBQy9DLENBQUM7QUFFTSxLQUFLLFVBQVUsaUJBQWlCLENBQUMsR0FBdUIsRUFBRSxLQUFhO0lBQzVFLElBQUksQ0FBQyxHQUFHLEVBQUUsQ0FBQztRQUNULE1BQU0sSUFBSSxLQUFLLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQsTUFBTSxFQUFFLENBQUMsSUFBSSxDQUFDLElBQUksNENBQW1CLENBQUMsRUFBRSxRQUFRLEVBQUUsR0FBRyxFQUFFLFlBQVksRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7QUFDakYsQ0FBQztBQUVNLEtBQUssVUFBVSxxQkFBcUIsQ0FBQyxLQUFrRCxFQUFFLGNBQXNCLEVBQ3BILE1BQWMsRUFBRSxrQkFBMEIsRUFBRSxJQUFTO0lBQ3JELE1BQU0sWUFBWSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUM7UUFDbEMsTUFBTSxFQUFFLGNBQWM7UUFDdEIsTUFBTSxFQUFFLE1BQU07UUFDZCxrQkFBa0IsRUFBRSxrQkFBa0I7UUFDdEMsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1FBQ3RCLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztRQUMxQixpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1FBQzFDLE1BQU0sRUFBRSxLQUFLO1FBQ2IsSUFBSSxFQUFFLElBQUk7S0FDWCxDQUFDLENBQUM7SUFFSCxPQUFPLENBQUMsR0FBRyxDQUFDLFlBQVksRUFBRSxZQUFZLENBQUMsQ0FBQztJQUV4QyxpRUFBaUU7SUFDakUsTUFBTSxTQUFTLEdBQUcsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDMUQsTUFBTSxjQUFjLEdBQUc7UUFDckIsUUFBUSxFQUFFLFNBQVMsQ0FBQyxRQUFRO1FBQzVCLElBQUksRUFBRSxTQUFTLENBQUMsSUFBSTtRQUNwQixNQUFNLEVBQUUsS0FBSztRQUNiLE9BQU8sRUFBRTtZQUNQLGNBQWMsRUFBRSxFQUFFO1lBQ2xCLGdCQUFnQixFQUFFLFlBQVksQ0FBQyxNQUFNO1NBQ3RDO0tBQ0YsQ0FBQztJQUVGLE9BQU8sSUFBSSxPQUFPLENBQUMsQ0FBQyxPQUFPLEVBQUUsTUFBTSxFQUFFLEVBQUU7UUFDckMsSUFBSSxDQUFDO1lBQ0gsaUVBQWlFO1lBQ2pFLE1BQU0sT0FBTyxHQUFHLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1lBQ2xFLE9BQU8sQ0FBQyxFQUFFLENBQUMsT0FBTyxFQUFFLE1BQU0sQ0FBQyxDQUFDO1lBQzVCLE9BQU8sQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLENBQUM7WUFDNUIsT0FBTyxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBQ2hCLENBQUM7UUFBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1lBQ1gsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ1osQ0FBQztJQUNILENBQUMsQ0FBQyxDQUFDO0FBQ0wsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEdldFNlY3JldFZhbHVlQ29tbWFuZCwgU2VjcmV0c01hbmFnZXJDbGllbnQsIFVwZGF0ZVNlY3JldENvbW1hbmQgfSBmcm9tICdAYXdzLXNkay9jbGllbnQtc2VjcmV0cy1tYW5hZ2VyJztcblxuZXhwb3J0IGludGVyZmFjZSBTdGVwRnVuY3Rpb25MYW1iZGFJbnB1dCB7XG4gIHJlYWRvbmx5IG93bmVyOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJlcG86IHN0cmluZztcbiAgcmVhZG9ubHkgcnVubmVyTmFtZTogc3RyaW5nO1xuICByZWFkb25seSBpbnN0YWxsYXRpb25JZD86IG51bWJlcjtcbiAgcmVhZG9ubHkgbGFiZWxzOiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgZXJyb3I/OiB7XG4gICAgcmVhZG9ubHkgRXJyb3I6IHN0cmluZztcbiAgICByZWFkb25seSBDYXVzZTogc3RyaW5nO1xuICB9O1xufVxuXG5jb25zdCBzbSA9IG5ldyBTZWNyZXRzTWFuYWdlckNsaWVudCgpO1xuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gZ2V0U2VjcmV0VmFsdWUoYXJuOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgaWYgKCFhcm4pIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ01pc3Npbmcgc2VjcmV0IEFSTicpO1xuICB9XG5cbiAgY29uc3Qgc2VjcmV0ID0gYXdhaXQgc20uc2VuZChuZXcgR2V0U2VjcmV0VmFsdWVDb21tYW5kKHsgU2VjcmV0SWQ6IGFybiB9KSk7XG5cbiAgaWYgKCFzZWNyZXQuU2VjcmV0U3RyaW5nKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKGBObyBTZWNyZXRTdHJpbmcgaW4gJHthcm59YCk7XG4gIH1cblxuICByZXR1cm4gc2VjcmV0LlNlY3JldFN0cmluZztcbn1cblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGdldFNlY3JldEpzb25WYWx1ZShhcm46IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICByZXR1cm4gSlNPTi5wYXJzZShhd2FpdCBnZXRTZWNyZXRWYWx1ZShhcm4pKTtcbn1cblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIHVwZGF0ZVNlY3JldFZhbHVlKGFybjogc3RyaW5nIHwgdW5kZWZpbmVkLCB2YWx1ZTogc3RyaW5nKSB7XG4gIGlmICghYXJuKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdNaXNzaW5nIHNlY3JldCBBUk4nKTtcbiAgfVxuXG4gIGF3YWl0IHNtLnNlbmQobmV3IFVwZGF0ZVNlY3JldENvbW1hbmQoeyBTZWNyZXRJZDogYXJuLCBTZWNyZXRTdHJpbmc6IHZhbHVlIH0pKTtcbn1cblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGN1c3RvbVJlc291cmNlUmVzcG9uZChldmVudDogQVdTTGFtYmRhLkNsb3VkRm9ybWF0aW9uQ3VzdG9tUmVzb3VyY2VFdmVudCwgcmVzcG9uc2VTdGF0dXM6IHN0cmluZyxcbiAgcmVhc29uOiBzdHJpbmcsIHBoeXNpY2FsUmVzb3VyY2VJZDogc3RyaW5nLCBkYXRhOiBhbnkpIHtcbiAgY29uc3QgcmVzcG9uc2VCb2R5ID0gSlNPTi5zdHJpbmdpZnkoe1xuICAgIFN0YXR1czogcmVzcG9uc2VTdGF0dXMsXG4gICAgUmVhc29uOiByZWFzb24sXG4gICAgUGh5c2ljYWxSZXNvdXJjZUlkOiBwaHlzaWNhbFJlc291cmNlSWQsXG4gICAgU3RhY2tJZDogZXZlbnQuU3RhY2tJZCxcbiAgICBSZXF1ZXN0SWQ6IGV2ZW50LlJlcXVlc3RJZCxcbiAgICBMb2dpY2FsUmVzb3VyY2VJZDogZXZlbnQuTG9naWNhbFJlc291cmNlSWQsXG4gICAgTm9FY2hvOiBmYWxzZSxcbiAgICBEYXRhOiBkYXRhLFxuICB9KTtcblxuICBjb25zb2xlLmxvZygnUmVzcG9uZGluZycsIHJlc3BvbnNlQm9keSk7XG5cbiAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIEB0eXBlc2NyaXB0LWVzbGludC9uby1yZXF1aXJlLWltcG9ydHNcbiAgY29uc3QgcGFyc2VkVXJsID0gcmVxdWlyZSgndXJsJykucGFyc2UoZXZlbnQuUmVzcG9uc2VVUkwpO1xuICBjb25zdCByZXF1ZXN0T3B0aW9ucyA9IHtcbiAgICBob3N0bmFtZTogcGFyc2VkVXJsLmhvc3RuYW1lLFxuICAgIHBhdGg6IHBhcnNlZFVybC5wYXRoLFxuICAgIG1ldGhvZDogJ1BVVCcsXG4gICAgaGVhZGVyczoge1xuICAgICAgJ2NvbnRlbnQtdHlwZSc6ICcnLFxuICAgICAgJ2NvbnRlbnQtbGVuZ3RoJzogcmVzcG9uc2VCb2R5Lmxlbmd0aCxcbiAgICB9LFxuICB9O1xuXG4gIHJldHVybiBuZXcgUHJvbWlzZSgocmVzb2x2ZSwgcmVqZWN0KSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBAdHlwZXNjcmlwdC1lc2xpbnQvbm8tcmVxdWlyZS1pbXBvcnRzXG4gICAgICBjb25zdCByZXF1ZXN0ID0gcmVxdWlyZSgnaHR0cHMnKS5yZXF1ZXN0KHJlcXVlc3RPcHRpb25zLCByZXNvbHZlKTtcbiAgICAgIHJlcXVlc3Qub24oJ2Vycm9yJywgcmVqZWN0KTtcbiAgICAgIHJlcXVlc3Qud3JpdGUocmVzcG9uc2VCb2R5KTtcbiAgICAgIHJlcXVlc3QuZW5kKCk7XG4gICAgfSBjYXRjaCAoZSkge1xuICAgICAgcmVqZWN0KGUpO1xuICAgIH1cbiAgfSk7XG59XG4iXX0=