import { Octokit } from '@octokit/rest';
export declare function baseUrlFromDomain(domain: string): string;
type RunnerLevel = 'repo' | 'org' | undefined;
export interface GitHubSecrets {
    domain: string;
    appId: number;
    personalAuthToken: string;
    runnerLevel: RunnerLevel;
}
export declare function getOctokit(installationId?: number): Promise<{
    octokit: Octokit;
    githubSecrets: GitHubSecrets;
}>;
export declare function getAppOctokit(): Promise<(import("@octokit/core").Octokit & {
    paginate: import("@octokit/plugin-paginate-rest").PaginateInterface;
} & import("@octokit/plugin-rest-endpoint-methods/dist-types/generated/method-types").RestEndpointMethods & import("@octokit/plugin-rest-endpoint-methods/dist-types/types").Api) | undefined>;
export declare function getRunner(octokit: Octokit, runnerLevel: RunnerLevel, owner: string, repo: string, name: string): Promise<{
    id: number;
    runner_group_id?: number;
    name: string;
    os: string;
    status: string;
    busy: boolean;
    labels: import("@octokit/openapi-types").components["schemas"]["runner-label"][];
} | undefined>;
export declare function deleteRunner(octokit: Octokit, runnerLevel: RunnerLevel, owner: string, repo: string, runnerId: number): Promise<void>;
export declare function redeliver(octokit: Octokit, deliveryId: number): Promise<void>;
export {};
