"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunnerImageBuilderBase = exports.RunnerImageBuilderType = void 0;
exports.uniqueImageBuilderName = uniqueImageBuilderName;
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * @internal
 */
function uniqueImageBuilderName(scope) {
    return cdk.Names.uniqueResourceName(scope, {
        maxLength: 126,
        separator: '-',
        allowedSpecialCharacters: '_-',
    });
}
var RunnerImageBuilderType;
(function (RunnerImageBuilderType) {
    /**
     * Build runner images using AWS CodeBuild.
     *
     * Faster than AWS Image Builder, but can only be used to build Linux Docker images.
     */
    RunnerImageBuilderType["CODE_BUILD"] = "CodeBuild";
    /**
     * Build runner images using AWS Image Builder.
     *
     * Slower than CodeBuild, but can be used to build any type of image including AMIs and Windows images.
     */
    RunnerImageBuilderType["AWS_IMAGE_BUILDER"] = "AwsImageBuilder";
})(RunnerImageBuilderType || (exports.RunnerImageBuilderType = RunnerImageBuilderType = {}));
/**
 * @internal
 */
class RunnerImageBuilderBase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.components = [];
        if (props?.components) {
            this.components.push(...props.components);
        }
    }
    addComponent(component) {
        this.components.push(component);
    }
    removeComponent(component) {
        this.components = this.components.filter(c => c.name !== component.name);
    }
}
exports.RunnerImageBuilderBase = RunnerImageBuilderBase;
//# sourceMappingURL=data:application/json;base64,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