"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
const client_sns_1 = require("@aws-sdk/client-sns");
const sns = new client_sns_1.SNSClient();
async function handler(event) {
    console.log(event);
    for (const record of event.Records) {
        let message = JSON.parse(record.Sns.Message);
        if (message.state.status === 'FAILED') {
            await sns.send(new client_sns_1.PublishCommand({
                TopicArn: process.env.TARGET_TOPIC_ARN,
                Message: record.Sns.Message,
            }));
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmlsdGVyLWZhaWxlZC1idWlsZHMubGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2ltYWdlLWJ1aWxkZXJzL2F3cy1pbWFnZS1idWlsZGVyL2ZpbHRlci1mYWlsZWQtYnVpbGRzLmxhbWJkYS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUtBLDBCQVdDO0FBaEJELG9EQUFnRTtBQUdoRSxNQUFNLEdBQUcsR0FBRyxJQUFJLHNCQUFTLEVBQUUsQ0FBQztBQUVyQixLQUFLLFVBQVUsT0FBTyxDQUFDLEtBQXlCO0lBQ3JELE9BQU8sQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDbkIsS0FBSyxNQUFNLE1BQU0sSUFBSSxLQUFLLENBQUMsT0FBTyxFQUFFLENBQUM7UUFDbkMsSUFBSSxPQUFPLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQzdDLElBQUksT0FBTyxDQUFDLEtBQUssQ0FBQyxNQUFNLEtBQUssUUFBUSxFQUFFLENBQUM7WUFDdEMsTUFBTSxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksMkJBQWMsQ0FBQztnQkFDaEMsUUFBUSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsZ0JBQWdCO2dCQUN0QyxPQUFPLEVBQUUsTUFBTSxDQUFDLEdBQUcsQ0FBQyxPQUFPO2FBQzVCLENBQUMsQ0FBQyxDQUFDO1FBQ04sQ0FBQztJQUNILENBQUM7QUFDSCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU05TQ2xpZW50LCBQdWJsaXNoQ29tbWFuZCB9IGZyb20gJ0Bhd3Mtc2RrL2NsaWVudC1zbnMnO1xuaW1wb3J0ICogYXMgQVdTTGFtYmRhIGZyb20gJ2F3cy1sYW1iZGEnO1xuXG5jb25zdCBzbnMgPSBuZXcgU05TQ2xpZW50KCk7XG5cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBoYW5kbGVyKGV2ZW50OiBBV1NMYW1iZGEuU05TRXZlbnQpIHtcbiAgY29uc29sZS5sb2coZXZlbnQpO1xuICBmb3IgKGNvbnN0IHJlY29yZCBvZiBldmVudC5SZWNvcmRzKSB7XG4gICAgbGV0IG1lc3NhZ2UgPSBKU09OLnBhcnNlKHJlY29yZC5TbnMuTWVzc2FnZSk7XG4gICAgaWYgKG1lc3NhZ2Uuc3RhdGUuc3RhdHVzID09PSAnRkFJTEVEJykge1xuICAgICAgYXdhaXQgc25zLnNlbmQobmV3IFB1Ymxpc2hDb21tYW5kKHtcbiAgICAgICAgVG9waWNBcm46IHByb2Nlc3MuZW52LlRBUkdFVF9UT1BJQ19BUk4sXG4gICAgICAgIE1lc3NhZ2U6IHJlY29yZC5TbnMuTWVzc2FnZSxcbiAgICAgIH0pKTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==