# -*- coding: utf-8 -*-
#
# Author:  Dominik Gresch <greschd@gmx.ch>
# Date:    15.10.2014 14:49:25 CEST
# File:    tb_hamilton.py

from common import *

import re
import platform
import types
import unittest


class FpPhonyTestCase(CommonTestCase):
    def __init__(self, *args, **kwargs):
        if(re.match('Windows', platform.platform(), re.IGNORECASE)):
            self._sep = '\\'
        else:
            self._sep = '/'

        super(FpPhonyTestCase, self).__init__(*args, **kwargs)

    def testphony1(self):
        sys = z2pack.fp.System(
            'samples' + self._sep + 'wannier90.mmn',
            lambda x: '',
            "kpts",
            "",
            build_folder='samples' + self._sep + 'build')

        surface = sys.surface(lambda kx: [0, kx / 2, 0], [0, 0, 1], pickle_file=None)

        surface.wcc_calc(pos_tol=None, gap_tol=None, verbose=False)
        self.assertFullAlmostEqual(
            surface.get_res(), {'t_par': [0.0, 0.10000000000000001, 0.20000000000000001, 0.30000000000000004, 0.40000000000000002, 0.5, 0.60000000000000009, 0.70000000000000007, 0.80000000000000004, 0.90000000000000002, 1.0], 'wcc': [[1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025]], 'lambda_': [array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]])], 'kpt': [[0.0, 0.0, 0.0], [0.0, 0.050000000000000003, 0.0], [0.0, 0.10000000000000001, 0.0], [0.0, 0.15000000000000002, 0.0], [0.0, 0.20000000000000001, 0.0], [0.0, 0.25, 0.0], [0.0, 0.30000000000000004, 0.0], [0.0, 0.35000000000000003, 0.0], [0.0, 0.40000000000000002, 0.0], [0.0, 0.45000000000000001, 0.0], [0.0, 0.5, 0.0]], 'gap': [0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905]})

    def testphony2(self):
        sys = z2pack.fp.System(
            'samples' + self._sep + 'varw90.mmn',
            lambda x: '',
            "kpts",
            "",
            build_folder='samples' + self._sep + 'build',
            file_names='wannier90.mmn')

        surface = sys.surface(lambda kx: [0, kx / 2, 0], [0, 0, 1], pickle_file=None)

        surface.wcc_calc(pos_tol=None, gap_tol=None, verbose=False)
        self.assertFullAlmostEqual(
            surface.get_res(), {'t_par': [0.0, 0.10000000000000001, 0.20000000000000001, 0.30000000000000004, 0.40000000000000002, 0.5, 0.60000000000000009, 0.70000000000000007, 0.80000000000000004, 0.90000000000000002, 1.0], 'wcc': [[1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025], [1.5161969212760058e-13, 0.15757835196859474, 0.15757835196880809, 0.49999999999943007, 0.4999999999999602, 0.50000000000004452, 0.50000000000060962, 0.84242164803120345, 0.84242164803141328, 0.99999999999982025]], 'lambda_': [array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]]), array([[  6.53697919e-02 +6.73646963e-14j,
          3.57682986e-13 +4.08974991e-13j,
         -2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
         -3.04528878e-01 -3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
          2.09737224e-01 +1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          3.63984142e-02 -1.51134228e-01j,
          6.70237791e-02 -4.55700460e-01j],
       [ -3.56288011e-13 +4.02260920e-13j,
          6.53697919e-02 -5.80941003e-14j,
         -4.96739749e-01 -8.00269525e-02j,
         -2.79887000e-01 +1.41606948e-01j,
         -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 -3.62902305e-01j,
         -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 +1.59411141e-01j,
         -6.69590492e-02 -4.55709975e-01j,
          3.63769463e-02 +1.51139396e-01j],
       [  2.79887000e-01 -1.41606948e-01j,
          4.96739749e-01 -8.00269525e-02j,
          5.48611284e-01 -5.25756522e-13j,
         -5.94725658e-13 +9.81582003e-13j,
          9.04500652e-02 -1.99513370e-02j,
          6.64006504e-02 -5.58272398e-02j,
         -1.46453732e-01 -1.93663866e-02j,
         -1.27358132e-01 +3.33930746e-02j,
         -1.92797221e-01 -3.85490434e-01j,
         -1.89092584e-01 -2.65872373e-01j],
       [ -4.96739749e-01 -8.00269525e-02j,
          2.79887000e-01 +1.41606948e-01j,
          5.96654670e-13 +9.77991993e-13j,
          5.48611284e-01 +4.88298638e-13j,
          6.64006504e-02 +5.58272398e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -1.27358132e-01 -3.33930746e-02j,
          1.46453732e-01 -1.93663866e-02j,
          1.89130347e-01 -2.65845511e-01j,
         -1.92851976e-01 +3.85463044e-01j],
       [ -3.04528878e-01 +3.62902305e-01j,
         -1.56771925e-01 -3.76228903e-02j,
         -9.04500652e-02 -1.99513370e-02j,
         -6.64006504e-02 +5.58272398e-02j,
          5.23788287e-02 +1.05448419e-14j,
         -6.63849618e-13 +8.51102039e-13j,
         -4.28397988e-01 +9.70778059e-02j,
          6.15374773e-02 -3.58352670e-01j,
         -4.08949399e-02 -3.63930973e-03j,
         -4.24245844e-01 -4.73180739e-01j],
       [ -1.56771925e-01 +3.76228903e-02j,
          3.04528878e-01 +3.62902305e-01j,
         -6.64006504e-02 -5.58272398e-02j,
          9.04500652e-02 -1.99513370e-02j,
          6.69121659e-13 +8.55747764e-13j,
          5.23788287e-02 +1.31538010e-13j,
         -6.15374773e-02 -3.58352670e-01j,
         -4.28397988e-01 -9.70778059e-02j,
         -4.24313052e-01 +4.73120473e-01j,
          4.08954564e-02 -3.63350084e-03j],
       [  2.09737224e-01 -1.59411141e-01j,
         -2.60857005e-01 +1.41366590e-01j,
          1.46453732e-01 -1.93663866e-02j,
          1.27358132e-01 -3.33930746e-02j,
         -4.28397988e-01 -9.70778059e-02j,
         -6.15374773e-02 +3.58352670e-01j,
         -6.46841131e-01 -1.06278528e-12j,
         -5.94441163e-13 +1.13635490e-12j,
         -7.08875485e-02 -1.90371483e-02j,
          1.57583004e-01 +1.72141826e-01j],
       [ -2.60857005e-01 -1.41366590e-01j,
         -2.09737224e-01 -1.59411141e-01j,
          1.27358132e-01 +3.33930746e-02j,
         -1.46453732e-01 -1.93663866e-02j,
          6.15374773e-02 +3.58352670e-01j,
         -4.28397988e-01 +9.70778059e-02j,
          5.88154525e-13 +1.12228629e-12j,
         -6.46841131e-01 +1.11479576e-12j,
          1.57607454e-01 -1.72119441e-01j,
          7.08902519e-02 -1.90270790e-02j],
       [  3.63984142e-02 +1.51134228e-01j,
         -6.69590492e-02 +4.55709975e-01j,
          1.92797221e-01 -3.85490434e-01j,
         -1.89130347e-01 -2.65845511e-01j,
         -4.08949399e-02 +3.63930973e-03j,
         -4.24313052e-01 -4.73120473e-01j,
         -7.08875485e-02 +1.90371483e-02j,
          1.57607454e-01 +1.72119441e-01j,
          7.77037941e-02 +4.09037387e-13j,
         -1.42345163e-12 +8.69949945e-13j],
       [  6.70237791e-02 +4.55700460e-01j,
          3.63769463e-02 -1.51139396e-01j,
          1.89092584e-01 -2.65872373e-01j,
          1.92851976e-01 +3.85463044e-01j,
         -4.24245844e-01 +4.73180739e-01j,
          4.08954564e-02 +3.63350084e-03j,
          1.57583004e-01 -1.72141826e-01j,
          7.08902519e-02 +1.90270790e-02j,
          1.42263523e-12 +8.67497968e-13j,
          7.77037941e-02 -1.86077716e-13j]])], 'kpt': [[0.0, 0.0, 0.0], [0.0, 0.050000000000000003, 0.0], [0.0, 0.10000000000000001, 0.0], [0.0, 0.15000000000000002, 0.0], [0.0, 0.20000000000000001, 0.0], [0.0, 0.25, 0.0], [0.0, 0.30000000000000004, 0.0], [0.0, 0.35000000000000003, 0.0], [0.0, 0.40000000000000002, 0.0], [0.0, 0.45000000000000001, 0.0], [0.0, 0.5, 0.0]], 'gap': [0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905, 0.32878917598411905]})


    def testphony3(self):
        sys = z2pack.fp.System(
            'samples' + self._sep + 'varw90.mmn',
            lambda x: '',
            "kpts",
            "",
            build_folder='samples' + self._sep + 'build',
            mmn_path='varw90.mmn')

        surface = sys.surface(lambda kx: [0, kx / 2, 0], [0, 0, 1], pickle_file=None)

        self.assertRaises(ValueError, surface.wcc_calc, verbose=False)
        self.assertFullAlmostEqual(
            surface.get_res(), {'t_par': [0.0, 0.10000000000000001, 0.20000000000000001, 0.30000000000000004, 0.40000000000000002, 0.5, 0.60000000000000009, 0.70000000000000007, 0.80000000000000004, 0.90000000000000002, 1.0], 'wcc': [[], [], [], [], [], [], [], [], [], [], []], 'lambda_': [[], [], [], [], [], [], [], [], [], [], []], 'kpt': [[0.0, 0.0, 0.0], [0.0, 0.050000000000000003, 0.0], [0.0, 0.10000000000000001, 0.0], [0.0, 0.15000000000000002, 0.0], [0.0, 0.20000000000000001, 0.0], [0.0, 0.25, 0.0], [0.0, 0.30000000000000004, 0.0], [0.0, 0.35000000000000003, 0.0], [0.0, 0.40000000000000002, 0.0], [0.0, 0.45000000000000001, 0.0], [0.0, 0.5, 0.0]], 'gap': [None, None, None, None, None, None, None, None, None, None, None]})

    def test_warnings(self):
        """
        test the warning that is given if new style surfaces are used
        """
        sys = z2pack.fp.System(
            'samples' + self._sep + 'varw90.mmn',
            lambda x: '',
            "kpts",
            "",
            build_folder='samples' + self._sep + 'build',
            mmn_path='varw90.mmn')

        with warnings.catch_warnings(record=True) as w:
            warnings.simplefilter('always')
            surface = sys.surface(lambda kx, ky: [ky, kx / 2, 0], pickle_file=None)
            assert len(w) == 1
            assert w[-1].category == UserWarning
            assert "recommended to use string_vec != None" in str(w[-1].message)

if __name__ == "__main__":
    unittest.main()
