# Python Dev Utility Modules

This is a collection of Python utility modules aimed at streamlining development workflows and making the development process more enjoyable.

## Overview

This collection includes various utility modules designed to perform common development tasks, such as file manipulation, text formatting, and command-line interface (CLI) handling.

## Modules

| Module    | Description                                                           |
|-----------|-----------------------------------------------------------------------|
| `writer.py` | A module providing utility functions for writing files.               |
|            | **Functions:**                                                        |
|            | - `write_file_with_prompt`: Write content to a file, prompting the user if the file already exists. |
| `banner.py` | A module for creating formatted banners for CLI output.               |
|            | **Functions:**                                                        |
|            | - `print_banner`: Print a formatted banner to the console.            |

Got it! Here's the updated README section:

---

## Setup

To use these utility modules in your Python projects, follow these steps:

1. Clone this repository to your local machine:

   ```bash
   git clone https://gist.github.com/devinci-it/d432708e796d6e6160efe13ee6cc7bbc/
   ```

2. Rename and navigate to the cloned directory:

   ```bash
   mv ./d432708e796d6e6160efe13ee6cc7bbc ./dev_utils
   cd dev_utils
   ```

3. Install the modules using pip:

   ```bash
   pip install .
   ```

4. The main functions from some modules are automatically imported in the `__init__.py` file for convenience.
   You can modify these aliases as needed or use them directly in your scripts.

5. Start using the utility functions in your projects!

## Note

This collection of utility modules is an ongoing project, and additional modules will be published as they are developed. These modules are personally used and developed to streamline and enhance the development experience.
