import tornado
import json
from jupyter_server.base.handlers import JupyterHandler
from jupyter_server.extension.handler import ExtensionHandlerMixin
import pprint
from ._version import _fetchVersion

class RouteHandler(ExtensionHandlerMixin, JupyterHandler):

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

    # The following decorator should be present on all verb methods (head, get, post,
    # patch, put, delete, options) to ensure only authorized user can request the
    # Jupyter server
    @tornado.web.authenticated
    def get(self, resource):

        try:
            self.add_header('Content-Type', 'application/json')
            
            if resource == 'version':
                self.finish(json.dumps(_fetchVersion()))
            elif resource == 'config':
                self.finish(json.dumps(self.config))
            else:
                self.set_status(404)

        except Exception as e:
            self.set_status(500)
            self.finish(json.dumps(str(e)))