# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['release_tools', 'tests']

package_data = \
{'': ['*'], 'tests': ['data/*']}

install_requires = \
['PyYAML>=5.4.1,<6.0.0',
 'click>=7.0,<8.0',
 'semver>=2.9,<3.0',
 'tomlkit>=0.5.8,<0.6.0']

entry_points = \
{'console_scripts': ['changelog = release_tools.changelog:changelog',
                     'notes = release_tools.notes:notes',
                     'publish = release_tools.publish:publish',
                     'semverup = release_tools.semverup:semverup']}

setup_kwargs = {
    'name': 'release-tools',
    'version': '0.4.0',
    'description': 'Set of tools to generate Python releases.',
    'long_description': '# Release Tools [![Build Status](https://github.com/Bitergia/release-tools/workflows/tests/badge.svg)](https://github.com/Bitergia/release-tools/actions?query=workflow:tests+branch:master+event:push) [![codecov](https://codecov.io/gh/Bitergia/release-tools/branch/master/graph/badge.svg?token=T60WC78FPR)](https://codecov.io/gh/Bitergia/release-tools)\n\nSet of tools to generate Python releases.\n\nWith this package, Python maintainers are able to automate\nmany of the boring and time consuming tasks related with\npackages and releases.\n\nThese tools are based in the way GitLab project generates its\nreleases. You have more information about their motivation\n[here](https://gitlab.com/gitlab-org/gitlab-foss/issues/17826).\n\nThis software is licensed under GPL3 or later.\n\n\n## Features\n\nThis package allows us to:\n\n * Automate the creation of release notes\n * Bump up the release version based on the release notes\n * Publish a release in a Git repository\n\n\n## Requirements\n\n * Python >= 3.7\n * Poetry >= 1.0\n\n\n## Installation\n\nTo install the release tools from the source code you\'ll need\nto install `poetry`. We use [poetry](https://python-poetry.org/)\nfor dependency management and packaging. You can install it\nfollowing its [documentation](https://python-poetry.org/docs/#installation).\n\nOnce you have installed it, you can download the source code with git:\n\n```\n# Get release-tools source code\n$ git clone https://github.com/Bitergia/release-tools\n```\n\nMove to the directory and install the software and the dependencies:\n\n```\n$ cd release-tools\n$ poetry install\n```\n\n## Workflow\n\nTogether with these tools, this package provides an **opinionated\nway** to generate the release of a Python package. We think\nreleases must be automated and provide useful information\nto end users so they can understand better the changes between\nversions. Our tools fulfill those requirements.\n\nThere are also some **assumptions** to take into account:\n\n* We use git repositories.\n* We use [semantic versioning](https://semver.org/) for numbering our packages.\\\n  Version numbers are defined in the variable `__version__` which is\n  stored on a file called `_version.py`. This file must be tracked on the git\n  repository.\n* We use `poetry` and the file `pyproject.toml`\n  (see [PEP518](https://www.python.org/dev/peps/pep-0518/)) to manage\n  build system dependencies. If you don\'t have this file, you can use\n  the command `poetry init` to create it from scratch. This file must\n  be tracked on the git repository.\n\nThe **workflow** is defined by the next steps:\n\n```\n    changelog -> semverup -> notes -> publish\n```\n\n- Developers use `changelog` script to generate changelog **entry\n  notes**. They contain basic information about their changes in\n  the code (e.g a new feature; a fixed bug). The notes should\n  **explain** the change to a reader who has **zero context** about\n  software details.\\\n  We **recommend** to create one of these entries for each pull\n  request or merge request.\\\n  These notes are stored under the directory `releases/unreleased`.\n- Once we are ready to create a new release, we call `semverup`.\n  It will increase the **version** according to semantic versioning\n  and the type of changelog entries generated between releases.\n- When the version is increased, we run `notes` to generate the\n  **release notes** using the unreleased changelog entries.\n- Finally, we **publish** the release in the Git repository creating\n  a **commit** that will contain the new release notes and the new\n  version files. A **tag** is also created with the new version number.\n  To do it, we call to `publish` script. This script also removes\n  the entries in `released/unreleased` directory.\n\nThis is an example of the basic usage:\n```\n# Create some changelog entries\n$ changelog -t "Fix bug #666" -c fixed\nChangelog entry \'fix-bug-#666.yml\' created\n\n$ changelog -t "Add support for deleting entries" -c added\nChangelog entry \'add-support-for-deleting-entries.yml\' created\n\n# Increase the version number\n$ semverup\n0.2.0\n\n# Generate the release notes\n$ notes "WebApp" 0.2.0\nRelease notes file \'0.2.0.md\' created\n\n# Publish the release in a public repository\n$ publish 0.2.0 "John Smith <jsmith@example.com>" --push origin\nCleaning directories...done\nAdding files to the release commit...done\nCreating release commit...done\nPublishing release in origin...done\n```\n\n## Tools\n\n### changelog\n\nThis interactive tool creates note entries about the changes in\nthe code. Developers can use this tool to create these notes that\nwill be included in the changelog or in the release notes.\nYou will need to run this script inside of the Git where you store\nthe project.\n\nIt will guide you to create a new entry. You can select the title\nand the type of the change.\n\n```\n>> Please specify the title of your change: Fix bug #666\n```\n```\n>> Please specify the category of your change\n\n1. New feature\n2. Bug fix\n3. Feature change\n4. New deprecation\n5. Feature removal\n6. Security fix\n7. Performance improvement\n8. Other\n\n: 2\n```\n\nAt the end of the process, a text editor will open to let you review\nthe entry and make the final changes. The editor will be the default\ndefined in your system.\n\n```\ntitle: \'Fix bug #666\'\ncategory: fixed\nauthor: John Smith <jsmith@example.com>\nissue: 666\nnotes: >\n  The bug was making impossible to cast a spell on\n  a magician.\n```\n\nNew entries will be stored in "releases/unreleased" directory.\nThis directory must be available under the Git root path.\n\n```\nChangelog entry \'fix-bug-#666.yml\' created\n```\n\nIf you don\'t want to create a new entry and see only the final result,\nplease active \'--dry-run\' flag.\n\n```\n$ changelog --dry-run\n```\n\nYou can skip some parts of the process providing information\nin advance such as the title (`-t`) or the category (`-c`)\nof the entry.\n\n```\n$ changelog -t "Fix bug #666" -c fixed\n```\n\n### semverup\n\nThis script increments the version number following semver specification\nand using the note entries generated with `changelog` tool.\n\n```\n$ semverup\n0.2.0\n```\n\n### notes\n\nWhen you run this script, it will generate the release notes of the\npackage tracked by the current Git repository.\n\nYou\'ll need to provide the `name` of the package and the `version`\nof the new release. The script will generate a Markdown document\nunder the `releases` directory using the changelog entries stored\non `releases/unreleased`. Take into account the argument `name`\nis only used as the title of the document.\n\n```\n$ notes "MyApp" 0.2.0\nRelease notes file \'0.2.0.md\' created\n```\n\nIf you also want to add the content of these release notes to the `NEWS`\nfile, use the flag `--news`.\n\n```\n$ notes "MyApp" 0.2.0 --news\nRelease notes file \'0.2.0.md\' created\nNews file updated to 0.2.0\n```\n\nIf you just want to see the final result of the notes\nbut not generate a new file, please activate `--dry-run` flag.\n\n```\n$ notes "MyApp" 0.2.0 --dry-run\n## MyApp 0.2.0 - (2020-03-04)\n\n**Bug fixes:**\n\n * Fix bug #666\n   The bug was making impossible to cast a spell on\n   a magician.\n```\n\nIf you want to add the contributor names of these release notes to the \nAUTHORS file, use the flag `--authors`.\n\n```\n$ notes "MyApp" 0.2.0 --authors\nRelease notes file \'0.2.0.md\' created\nAuthors file updated\n```\n\n### publish\n\nThis script will generate a new release in the repository.\nThis will consist on creating a commit and a tag with the\nnew release notes and the updated version files.\n\nTo run it, you\'ll need to provide the version number and\nthe author of the new release.\n\n```\n$ publish 0.2.0 "Jonh Smith <jsmith@example.com>"\nCleaning directories...done\nAdding files to the release commit...done\nCreating release commit...done\n```\n\nBy default the command doesn\'t push the commit release to a\nremote repository. To force it, use the parameter `--push`\nincluding the name of the remote where commits will be pushed.\n\n```\n$ publish 0.2.0 "John Smith <jsmith@example.com>" --push origin\nCleaning directories...done\nAdding files to the release commit...done\nCreating release commit...done\nPublishing release in origin...done\n```\n\nIt is also possible to push only the commit release and its tag.\nTo do so, set `--only-push` together with `--push` option.\n\n```\n$ publish 0.2.0 "John Smith <jsmith@example.com>" --push origin --only-push\nPublishing release in origin...done\n```\n\n\n## Troubleshooting\n\n### How can I change the default editor used by `changelog`?\n\nBy default, `changelog` will use the editor defined in the `EDITOR`\nenvironment variable. You can define your own editor updating this\nvariable.\n\n```\nexport EDITOR=/bin/nano\n```\n\nIf this variable doesn\'t exist it will try with `vim` or `nano`\nin that order.\n\n### What\'s the format of the changelog entries?\n\nChangelog entries use  [YAML format](https://yaml.org/).\n\nRemember you can write blocks of text using `>` character at the beginning\nof each block. See the next example:\n\n```\ntitle: \'Example of notes\'\ncategory: fixed\nauthor: John Smith <jsmith@example.com>\nissue: 1\nnotes: >\n  Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod\n  tempor incididunt ut labore et dolore magna aliqua.\n  Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi\n  ut aliquip ex ea commodo consequat.\n```\n\n### Error: version file not found\n\nThe tools did not found a `_version.py` file. This file must also\nbe tracked on your repository. It must contain a variable named\n`__version__`. The value must be a string following semantic\nversioning format.\n\n```\n$ cat _version.py\n__version__ = "3.6.5"\n```\n\n### Error: version number \'\\<version\\>\' in \'\\<filepath\\>\' is not a valid semver string\n\nThe format of the version number is invalid. We use semantic\nversioning format to set version numbers. The value must be a `str`.\nChange the version number and check the\n[semantic versioning rules](https://semver.org/) in case of doubt.\n\n\n### Error: pyproject file not found\n\nThe tools did not found a `pyproject.toml` file. This file must also\nbe tracked on your repository. It contains information needed by `poetry`\nto build the software package. If you don\'t have this file\nyou can create a new one using `poetry init`.\n\n```\n$ poetry init\n```\n\n### Error: pathspec \'\\<filepath\\>\' did not match any files; code error: 128\n\nThe file `<filepath>` must be tracked by your git repository. Add it to\nyour repo. Usually you\'ll get this error if you forgot to add your\nchangelog entry notes to the repository.\n\n### Error: tag \'\\<tag\\>\' already exists; code error: 128\n\nIf you have a existing tag with the same version, you can expect \nthis error. You can delete the tag using `git tag -d version` and \ncreate the release commit again using publish.\n\n```\n$ git tag -d 0.2.0\n$ publish 0.2.0 "John Smith <jsmith@example.com>" --push origin\n```\n\n### Error: error: src refspec \'\\<branch\\>\' does not match any\n\nYou can expect this error if you are not using `master` as your default \nbranch. You can change this in the codebase (push method of the publish.py) \nif you are using any other branch as default.\n\nIf you are using `main` as default branch, change `master` to `main`.\n\n```\n-   project.repo.push(remote, \'master\')\n+   project.repo.push(remote, \'main\')\n```\n\nYou can use `publish` and set `--only-push` together with `--push` option \nas the release is committed but not pushed yet.\n\n```\n$ publish 0.2.0 "John Smith <jsmith@example.com>" --push origin --only-push\nPublishing release in origin...done\n```\n\n\n### Error: Authentication failed for \'\\<github-url\\>\'; code error: 128\n\nIf the release commit is created and you failed to publish the release \nbecause of invalid credentials for git, you can use `publish` and \nset `--only-push` together with `--push` option as the release is committed\nbut not pushed yet.\n\n```\n$ publish 0.2.0 "John Smith <jsmith@example.com>" --push origin --only-push\nPublishing release in origin...done\n```\n\n\n## License\n\nLicensed under GNU General Public License (GPL), version 3 or later.\n',
    'author': 'Santiago Dueñas',
    'author_email': 'sduenas@bitergia.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
