
---

## 🚀 gitmess: Automated Git Commit Messages with GPT! 🚀

### 📝 Prerequisites:

Before using `gitmess`, you must set up your OpenAI API key:

#### Linux/macOS:
```bash
export OPENAI_API_KEY=<your_api_key>
```

#### Windows (Command Prompt):
```bash
set OPENAI_API_KEY=<your_api_key>
```

#### Windows (PowerShell):
```powershell
$env:OPENAI_API_KEY="<your_api_key>"
```

### 🖥 Usage:

#### Generating an automatic commit message:
```bash
gm
```

#### Activating Auto-Push:
After committing, you can choose to automatically push your commits to the repository. To activate the auto-push feature, use:
```bash
gm --set-push-auto
```

#### Checking the installed version:
To ensure that gitmess has been installed correctly and to check its version, use:
```bash
gm -v
```
This will display the currently installed version of gitmess.

---

### 🎯 Description

**gitmess** is a revolutionary tool designed to supercharge developers' git workflows by automatically generating commit messages with the power of GPT. Keeping with the `conventionalcommits v1.0.0` standard, gitmess ensures that your commits remain consistent, meaningful, and time-efficient!

---

### 🛠 Features:

1. 🔥 **Auto-Generated Commit Messages**: No more time wasted thinking about the perfect commit message.
2. 📏 **Conventionalcommits v1.0.0 Standard**: Ensures that your commits align with best practices.
3. 🤖 **GPT-powered**: Leverages the capabilities of GPT to generate relevant commit messages.

---

### 🌟 Benefits:

- 🕐 **Save Time**: No need to think about commit messages anymore.
- 🔄 **Consistency**: Follow the `conventionalcommits v1.0.0` standard every time.
- 🚀 **Enhance Workflow**: Streamline your git process.

---

### 📥 Installation:

#### Windows:
1. Open Command Prompt as administrator.
2. Run the following command:
   ```bash
   curl -LO https://raw.githubusercontent.com/0xjesus/gitmess/main/install.bat && install.bat
   ```

#### macOS:
1. Open the Terminal.
2. Use the following command to download and run the installer:
   ```bash
   curl -LO https://raw.githubusercontent.com/0xjesus/gitmess/main/install_gitmess.sh && chmod +x install_gitmess.sh && ./install_gitmess.sh
   ```

#### Linux:
1. Open the Terminal.
2. Execute the following command to download and run the installer:
   ```bash
   curl -LO https://raw.githubusercontent.com/0xjesus/gitmess/main/install_script.sh && chmod +x install_script.sh && ./install_script.sh
   ```

---

### 🤔 Frequently Asked Questions:

**Q:** How does gitmess use GPT?

**A:** gitmess analyzes your changes and uses GPT's natural language processing capabilities to craft the perfect commit message.

---

### 📜 License:

This project is licensed under the MIT License. See the `LICENSE` file for more details.

---

🌐 **Happy coding and commit with style using gitmess!** 🌐

---
