import unittest

from pyvalidator.is_passport_number import is_passport_number
from . import print_test_ok


class TestIsPassportNumber(unittest.TestCase):

    def test_valid_passport_number(self):
        for i in [
            ['AF0549358', "AM"],
            ['C1253473', "ID"],
            ['B5948378', "ID"],
            ['A4859472', "ID"],
            ['AAC811035', "AR"],
            ['P 1630837', "AT"],
            ['P 4366918', "AT"],
            ['N0995852', "AU"],
            ['L4819236', "AU"],
            ['A1234567', "BA"],
            ['346395366', "BG"],
            ['039903356', "BG"],
            ['FZ973689', "BR"],
            ['GH231233', "BR"],
            ['MP3899901', "BY"],
            ['GA302922', "CA"],
            ['S1100409', "CH"],
            ['X4028791', "CH"],
            ['E00160027', "CN"],
            ['EA1234567', "CN"],
            ['K00000413', "CY"],
            ['99003853', "CZ"],
            ['42747260', "CZ"],
            ['C01X00T47', "DE"],
            ['900010172', "DK"],
            ['855609385', "DZ"],
            ['K4218285', "EE"],
            ['KB0167630', "EE"],
            ['AF238143', "ES"],
            ['XP8271602', "FI"],
            ['XD8500003', "FI"],
            ['10CV28144', "FR"],
            ['05RP34083', "FR"],
            ['925076473', "GB"],
            ['107182890', "GB"],
            ['104121156', "GB"],
            ['AE0000005', "GR"],
            ['AK0219304', "GR"],
            ['007007007', "HR"],
            ['ZA084505', "HU"],
            ['D23145890', "IE"],
            ['X65097105', "IE"],
            ['X0019390', "IN"],
            ['A-1234567', "IN"],
            ['J97634522', "IR"],
            ['A01234567', "IR"],
            ['A1197783', "IS"],
            ['A2040611', "IS"],
            ['YA8335453', "IT"],
            ['KK0000000', "IT"],
            ['NH1106002', "JP"],
            ['TE3180251', "JP"],
            ['XS1234567', "JP"],
            ['M35772699', "KR"],
            ['20200997', "LT"],
            ['LB311756', "LT"],
            ['JCU9J4T2', "LU"],
            ['LV9000339', "LV"],
            ['LV4017173', "LV"],
            ['RJ45H4V2', "LY"],
            ['1026564', "MT"],
            ['AB0808212', "MZ"],
            ['08AB12123', "MZ"],
            ['A00000000', "MY"],
            ['H12345678', "MY"],
            ['XTR110131', "NL"],
            ['XR1001R58', "NL"],
            ['ZS 0000177', "PL"],
            ['AN 3000011', "PL"],
            ['I700044', "PT"],
            ['K453286', "PT"],
            ['05485968', "RO"],
            ['040005646', "RO"],
            ['014213789', "RS"],
            ['2 32 636829', "RU"],
            ['012 345321', "RU"],
            ['59000001', "SE"],
            ['PB0036440', "SL"],
            ['P0000000', "SK"],
            ['U 06764100', "TR"],
            ['EH345655', "UA"],
            ['AP841503', "UA"],
            ['790369937', "US"],
            ['340007237', "US"],
        ]:
            self.assertTrue(is_passport_number(*i))
        print_test_ok()

    def test_invalid_passport_number(self):
        for i in [
            ['A1054935', "AM"],
            ['D39481728', "ID"],
            ['A-3847362', "ID"],
            ['324132132', "ID"],
            ['A11811035', "AR"],
            ['0 1630837', "AT"],
            ['1A012345', "AU"],
            ['ABC123456', "BA"],
            ['ABC123456', "BG"],
            ['ABX29332', "BR"],
            ['345333454', "BY"],
            ['FG53334542', "BY"],
            ['AB0123456', "CA"],
            ['AB123456', "CH"],
            ['E-1234567', "CN"],
            ['GO1234567', "CN"],
            ['K10100', "CY"],
            ['012345678', "CZ"],
            ['AB123456', "CZ"],
            ['A012345678', "DE"],
            ['AS0123456', "DZ"],
            ['K01234567', "EE"],
            ['AF01234567', "ES"],
            ['ABC012345', "FI"],
            ['A01234567', "FI"],
            ['012345678', "FR"],
            ['AB0123456', "FR"],
            ['A012345678', "GB"],
            ['K000000000', "GB"],
            ['A01234567', "GR"],
            ['A01234567', "HR"],
            ['A01234567', "HU"],
            ['012345678', "HU"],
            ['XND012345', "IE"],
            ['AB-1234567', "IN"],
            ['0123456789', "IN"],
            ['0123456789', "IN"],
            ['A0123456', "IR"],
            ['A0123456Z', "IR"],
            ['K0000000', "IS"],
            ['01234567', "IS"],
            ['01234567', "IT"],
            ['X12345678', "JP"],
            ['012345678', "JP"],
            ['X12345678', "KR"],
            ['LB01234567', "LT"],
            ['JCU9J4T', "LU"],
            ['LV01234567', "LV"],
            ['4017173LV', "LV"],
            ['P79JF34', "LY"],
            ['MT01234', "MT"],
            ['1AB011241', "MZ"],
            ['ABAB01121', "MZ"],
            ['A1234567', "MY"],
            ['C01234567', "MY"],
            ['XTR11013R', "NL"],
            ['A1 0000177', "PL"],
            ['K4532861', "PT"],
            ['0511060461', "RO"],
            ['R05485968', "RO"],
            ['01A 3D5321', "RS"],
            ['01A 3D5321', "RU"],
            ['A 2R YU46J0', "RU"],
            ['SE012345', "SE"],
            ['SL0123456', "SL"],
            ['SK012345', "SK"],
            ['06764100U', "TR"],
            ['01234567', "UA"],
            ['012345EH', "UA"],
            ['A012345P', "UA"],
            ['US0123456', "US"],
            ['US0123456', "US"],
            ['7903699371', "US"],
        ]:
            self.assertFalse(is_passport_number(*i))
        print_test_ok()
