
"""
Django settings for user project.

Generated by 'django-admin startproject' using Django 3.1.4.

For more information on this file, see
https://docs.djangoproject.com/en/3.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.1/ref/settings/
"""
from .base import *  # noqa: F401, F403
import os  # noqa: F401

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = config('SECRET_KEY')  # noqa


# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = False

ALLOWED_HOSTS = ['*']


# Application definition

INSTALLED_APPS.extend([  # noqa: F405
    'drf_yasg',
])

INTERNAL_IPS = [
    '127.0.0.1',
]

# Database
# https://docs.djangoproject.com/en/3.1/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': config('DATABASE_ENGINE'),        # noqa: F405
        'NAME': config('DATABASE_NAME'),            # noqa: F405
        'USER': config('DATABASE_USER'),            # noqa: F405
        'PASSWORD': config('DATABASE_PASSWORD'),    # noqa: F405
        'HOST': config('DATABASE_HOST'),            # noqa: F405
        'PORT': config('DATABASE_PORT'),            # noqa: F405
        'OPTIONS': config('DATABASE_OPTIONS')       # noqa: F405
    },
}

EMAIL_BACKEND = config('EMAIL_BACKEND')             # noqa: F405
EMAIL_HOST_USER = config('EMAIL_HOST_USER')         # noqa: F405
EMAIL_HOST = config('EMAIL_HOST')                   # noqa: F405
EMAIL_HOST_PASSWORD = config('EMAIL_HOST_PASSWORD')  # noqa
EMAIL_PORT = config('EMAIL_PORT')                   # noqa: F405
EMAIL_USE_TLS = config('EMAIL_USE_TLS')             # noqa: F405
EMAIL_USE_LOCALTIME = config('EMAIL_USE_LOCALTIME')  # noqa: F405

SERVER_EMAIL = 'crouber_test@crouber.com'
DEFAULT_FROM_EMAIL = SERVER_EMAIL
