# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://docs.intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.25.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ZacksInstitutionalHoldingOwnerDetail(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'cik': 'str',
        'address': 'str',
        'city_state': 'str',
        'location_code': 'str',
        'phone_number': 'str',
        'postal_code': 'str',
        'url': 'str',
        'investment_style': 'str',
        'number_of_holdings': 'float',
        'total_holdings_value': 'float',
        'portfolio_turnover_percent': 'float',
        'is_fund': 'str',
        'fund_ticker': 'str',
        'has_fund_manager': 'str',
        'fund_manager_city': 'str',
        'fund_manager_name': 'str',
        'fund_manager_state': 'str',
        'files_13f': 'str',
        'is_etf': 'str',
        'last_updated_on': 'date'
    }

    attribute_map = {
        'name': 'name',
        'cik': 'cik',
        'address': 'address',
        'city_state': 'city_state',
        'location_code': 'location_code',
        'phone_number': 'phone_number',
        'postal_code': 'postal_code',
        'url': 'url',
        'investment_style': 'investment_style',
        'number_of_holdings': 'number_of_holdings',
        'total_holdings_value': 'total_holdings_value',
        'portfolio_turnover_percent': 'portfolio_turnover_percent',
        'is_fund': 'is_fund',
        'fund_ticker': 'fund_ticker',
        'has_fund_manager': 'has_fund_manager',
        'fund_manager_city': 'fund_manager_city',
        'fund_manager_name': 'fund_manager_name',
        'fund_manager_state': 'fund_manager_state',
        'files_13f': 'files_13f',
        'is_etf': 'is_etf',
        'last_updated_on': 'last_updated_on'
    }

    def __init__(self, name=None, cik=None, address=None, city_state=None, location_code=None, phone_number=None, postal_code=None, url=None, investment_style=None, number_of_holdings=None, total_holdings_value=None, portfolio_turnover_percent=None, is_fund=None, fund_ticker=None, has_fund_manager=None, fund_manager_city=None, fund_manager_name=None, fund_manager_state=None, files_13f=None, is_etf=None, last_updated_on=None):  # noqa: E501
        """ZacksInstitutionalHoldingOwnerDetail - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._cik = None
        self._address = None
        self._city_state = None
        self._location_code = None
        self._phone_number = None
        self._postal_code = None
        self._url = None
        self._investment_style = None
        self._number_of_holdings = None
        self._total_holdings_value = None
        self._portfolio_turnover_percent = None
        self._is_fund = None
        self._fund_ticker = None
        self._has_fund_manager = None
        self._fund_manager_city = None
        self._fund_manager_name = None
        self._fund_manager_state = None
        self._files_13f = None
        self._is_etf = None
        self._last_updated_on = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if cik is not None:
            self.cik = cik
        if address is not None:
            self.address = address
        if city_state is not None:
            self.city_state = city_state
        if location_code is not None:
            self.location_code = location_code
        if phone_number is not None:
            self.phone_number = phone_number
        if postal_code is not None:
            self.postal_code = postal_code
        if url is not None:
            self.url = url
        if investment_style is not None:
            self.investment_style = investment_style
        if number_of_holdings is not None:
            self.number_of_holdings = number_of_holdings
        if total_holdings_value is not None:
            self.total_holdings_value = total_holdings_value
        if portfolio_turnover_percent is not None:
            self.portfolio_turnover_percent = portfolio_turnover_percent
        if is_fund is not None:
            self.is_fund = is_fund
        if fund_ticker is not None:
            self.fund_ticker = fund_ticker
        if has_fund_manager is not None:
            self.has_fund_manager = has_fund_manager
        if fund_manager_city is not None:
            self.fund_manager_city = fund_manager_city
        if fund_manager_name is not None:
            self.fund_manager_name = fund_manager_name
        if fund_manager_state is not None:
            self.fund_manager_state = fund_manager_state
        if files_13f is not None:
            self.files_13f = files_13f
        if is_etf is not None:
            self.is_etf = is_etf
        if last_updated_on is not None:
            self.last_updated_on = last_updated_on

    @property
    def name(self):
        """Gets the name of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's name  # noqa: E501

        :return: The name of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._name
        
    @property
    def name_dict(self):
        """Gets the name of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's name as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The name of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.name
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'name': value }

        
        return result
        

    @name.setter
    def name(self, name):
        """Sets the name of this ZacksInstitutionalHoldingOwnerDetail.

        The owner's name  # noqa: E501

        :param name: The name of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def cik(self):
        """Gets the cik of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The Central Index Key (CIK) assigned to the company by the SEC as a unique identifier, used in SEC filings  # noqa: E501

        :return: The cik of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._cik
        
    @property
    def cik_dict(self):
        """Gets the cik of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The Central Index Key (CIK) assigned to the company by the SEC as a unique identifier, used in SEC filings as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The cik of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.cik
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'cik': value }

        
        return result
        

    @cik.setter
    def cik(self, cik):
        """Sets the cik of this ZacksInstitutionalHoldingOwnerDetail.

        The Central Index Key (CIK) assigned to the company by the SEC as a unique identifier, used in SEC filings  # noqa: E501

        :param cik: The cik of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._cik = cik

    @property
    def address(self):
        """Gets the address of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's address  # noqa: E501

        :return: The address of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._address
        
    @property
    def address_dict(self):
        """Gets the address of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's address as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The address of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.address
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'address': value }

        
        return result
        

    @address.setter
    def address(self, address):
        """Sets the address of this ZacksInstitutionalHoldingOwnerDetail.

        The owner's address  # noqa: E501

        :param address: The address of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._address = address

    @property
    def city_state(self):
        """Gets the city_state of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's city and state (City, ST)  # noqa: E501

        :return: The city_state of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._city_state
        
    @property
    def city_state_dict(self):
        """Gets the city_state of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's city and state (City, ST) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The city_state of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.city_state
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'city_state': value }

        
        return result
        

    @city_state.setter
    def city_state(self, city_state):
        """Sets the city_state of this ZacksInstitutionalHoldingOwnerDetail.

        The owner's city and state (City, ST)  # noqa: E501

        :param city_state: The city_state of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._city_state = city_state

    @property
    def location_code(self):
        """Gets the location_code of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's location code. ('D' = Domestic, 'C' = Canadian, 'F' = Foreign)  # noqa: E501

        :return: The location_code of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._location_code
        
    @property
    def location_code_dict(self):
        """Gets the location_code of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's location code. ('D' = Domestic, 'C' = Canadian, 'F' = Foreign) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The location_code of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.location_code
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'location_code': value }

        
        return result
        

    @location_code.setter
    def location_code(self, location_code):
        """Sets the location_code of this ZacksInstitutionalHoldingOwnerDetail.

        The owner's location code. ('D' = Domestic, 'C' = Canadian, 'F' = Foreign)  # noqa: E501

        :param location_code: The location_code of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._location_code = location_code

    @property
    def phone_number(self):
        """Gets the phone_number of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's phone number  # noqa: E501

        :return: The phone_number of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._phone_number
        
    @property
    def phone_number_dict(self):
        """Gets the phone_number of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's phone number as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The phone_number of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.phone_number
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'phone_number': value }

        
        return result
        

    @phone_number.setter
    def phone_number(self, phone_number):
        """Sets the phone_number of this ZacksInstitutionalHoldingOwnerDetail.

        The owner's phone number  # noqa: E501

        :param phone_number: The phone_number of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._phone_number = phone_number

    @property
    def postal_code(self):
        """Gets the postal_code of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's postal code  # noqa: E501

        :return: The postal_code of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._postal_code
        
    @property
    def postal_code_dict(self):
        """Gets the postal_code of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's postal code as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The postal_code of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.postal_code
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'postal_code': value }

        
        return result
        

    @postal_code.setter
    def postal_code(self, postal_code):
        """Sets the postal_code of this ZacksInstitutionalHoldingOwnerDetail.

        The owner's postal code  # noqa: E501

        :param postal_code: The postal_code of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._postal_code = postal_code

    @property
    def url(self):
        """Gets the url of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's website url  # noqa: E501

        :return: The url of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._url
        
    @property
    def url_dict(self):
        """Gets the url of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's website url as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The url of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.url
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'url': value }

        
        return result
        

    @url.setter
    def url(self, url):
        """Sets the url of this ZacksInstitutionalHoldingOwnerDetail.

        The owner's website url  # noqa: E501

        :param url: The url of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def investment_style(self):
        """Gets the investment_style of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's investment style ('I' = Income, 'V' = Value, 'G' = Growth, 'B' =  Growth at a Reasonable Price, 'A' = Aggressive Growth, 'P' = Passive/Index, 'D' = Deep Value)  # noqa: E501

        :return: The investment_style of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._investment_style
        
    @property
    def investment_style_dict(self):
        """Gets the investment_style of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The owner's investment style ('I' = Income, 'V' = Value, 'G' = Growth, 'B' =  Growth at a Reasonable Price, 'A' = Aggressive Growth, 'P' = Passive/Index, 'D' = Deep Value) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The investment_style of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.investment_style
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'investment_style': value }

        
        return result
        

    @investment_style.setter
    def investment_style(self, investment_style):
        """Sets the investment_style of this ZacksInstitutionalHoldingOwnerDetail.

        The owner's investment style ('I' = Income, 'V' = Value, 'G' = Growth, 'B' =  Growth at a Reasonable Price, 'A' = Aggressive Growth, 'P' = Passive/Index, 'D' = Deep Value)  # noqa: E501

        :param investment_style: The investment_style of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._investment_style = investment_style

    @property
    def number_of_holdings(self):
        """Gets the number_of_holdings of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        Count of equity holdings only, doesn't include bonds or other funds held  # noqa: E501

        :return: The number_of_holdings of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: float
        """
        return self._number_of_holdings
        
    @property
    def number_of_holdings_dict(self):
        """Gets the number_of_holdings of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        Count of equity holdings only, doesn't include bonds or other funds held as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The number_of_holdings of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.number_of_holdings
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'number_of_holdings': value }

        
        return result
        

    @number_of_holdings.setter
    def number_of_holdings(self, number_of_holdings):
        """Sets the number_of_holdings of this ZacksInstitutionalHoldingOwnerDetail.

        Count of equity holdings only, doesn't include bonds or other funds held  # noqa: E501

        :param number_of_holdings: The number_of_holdings of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: float
        """

        self._number_of_holdings = number_of_holdings

    @property
    def total_holdings_value(self):
        """Gets the total_holdings_value of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        Market value of equity holdings in 1,000s. Sum of shares held times last close price.  # noqa: E501

        :return: The total_holdings_value of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: float
        """
        return self._total_holdings_value
        
    @property
    def total_holdings_value_dict(self):
        """Gets the total_holdings_value of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        Market value of equity holdings in 1,000s. Sum of shares held times last close price. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_holdings_value of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_holdings_value
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_holdings_value': value }

        
        return result
        

    @total_holdings_value.setter
    def total_holdings_value(self, total_holdings_value):
        """Sets the total_holdings_value of this ZacksInstitutionalHoldingOwnerDetail.

        Market value of equity holdings in 1,000s. Sum of shares held times last close price.  # noqa: E501

        :param total_holdings_value: The total_holdings_value of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: float
        """

        self._total_holdings_value = total_holdings_value

    @property
    def portfolio_turnover_percent(self):
        """Gets the portfolio_turnover_percent of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        Annual portfolio turnover in terms of percentage of total value.  # noqa: E501

        :return: The portfolio_turnover_percent of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: float
        """
        return self._portfolio_turnover_percent
        
    @property
    def portfolio_turnover_percent_dict(self):
        """Gets the portfolio_turnover_percent of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        Annual portfolio turnover in terms of percentage of total value. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The portfolio_turnover_percent of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.portfolio_turnover_percent
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'portfolio_turnover_percent': value }

        
        return result
        

    @portfolio_turnover_percent.setter
    def portfolio_turnover_percent(self, portfolio_turnover_percent):
        """Sets the portfolio_turnover_percent of this ZacksInstitutionalHoldingOwnerDetail.

        Annual portfolio turnover in terms of percentage of total value.  # noqa: E501

        :param portfolio_turnover_percent: The portfolio_turnover_percent of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: float
        """

        self._portfolio_turnover_percent = portfolio_turnover_percent

    @property
    def is_fund(self):
        """Gets the is_fund of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        If 'Y', the owner is a fund? ('Y' = Yes, 'N' = No)  # noqa: E501

        :return: The is_fund of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._is_fund
        
    @property
    def is_fund_dict(self):
        """Gets the is_fund of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        If 'Y', the owner is a fund? ('Y' = Yes, 'N' = No) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The is_fund of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.is_fund
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'is_fund': value }

        
        return result
        

    @is_fund.setter
    def is_fund(self, is_fund):
        """Sets the is_fund of this ZacksInstitutionalHoldingOwnerDetail.

        If 'Y', the owner is a fund? ('Y' = Yes, 'N' = No)  # noqa: E501

        :param is_fund: The is_fund of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._is_fund = is_fund

    @property
    def fund_ticker(self):
        """Gets the fund_ticker of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        Fund ticker if the institution is a fund  # noqa: E501

        :return: The fund_ticker of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._fund_ticker
        
    @property
    def fund_ticker_dict(self):
        """Gets the fund_ticker of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        Fund ticker if the institution is a fund as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The fund_ticker of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.fund_ticker
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'fund_ticker': value }

        
        return result
        

    @fund_ticker.setter
    def fund_ticker(self, fund_ticker):
        """Sets the fund_ticker of this ZacksInstitutionalHoldingOwnerDetail.

        Fund ticker if the institution is a fund  # noqa: E501

        :param fund_ticker: The fund_ticker of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._fund_ticker = fund_ticker

    @property
    def has_fund_manager(self):
        """Gets the has_fund_manager of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        Does the fund have a manager. ('Y' = Yes, 'N' = No)  # noqa: E501

        :return: The has_fund_manager of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._has_fund_manager
        
    @property
    def has_fund_manager_dict(self):
        """Gets the has_fund_manager of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        Does the fund have a manager. ('Y' = Yes, 'N' = No) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The has_fund_manager of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.has_fund_manager
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'has_fund_manager': value }

        
        return result
        

    @has_fund_manager.setter
    def has_fund_manager(self, has_fund_manager):
        """Sets the has_fund_manager of this ZacksInstitutionalHoldingOwnerDetail.

        Does the fund have a manager. ('Y' = Yes, 'N' = No)  # noqa: E501

        :param has_fund_manager: The has_fund_manager of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._has_fund_manager = has_fund_manager

    @property
    def fund_manager_city(self):
        """Gets the fund_manager_city of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The fund manager's city  # noqa: E501

        :return: The fund_manager_city of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._fund_manager_city
        
    @property
    def fund_manager_city_dict(self):
        """Gets the fund_manager_city of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The fund manager's city as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The fund_manager_city of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.fund_manager_city
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'fund_manager_city': value }

        
        return result
        

    @fund_manager_city.setter
    def fund_manager_city(self, fund_manager_city):
        """Sets the fund_manager_city of this ZacksInstitutionalHoldingOwnerDetail.

        The fund manager's city  # noqa: E501

        :param fund_manager_city: The fund_manager_city of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._fund_manager_city = fund_manager_city

    @property
    def fund_manager_name(self):
        """Gets the fund_manager_name of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The fund manager's name  # noqa: E501

        :return: The fund_manager_name of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._fund_manager_name
        
    @property
    def fund_manager_name_dict(self):
        """Gets the fund_manager_name of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The fund manager's name as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The fund_manager_name of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.fund_manager_name
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'fund_manager_name': value }

        
        return result
        

    @fund_manager_name.setter
    def fund_manager_name(self, fund_manager_name):
        """Sets the fund_manager_name of this ZacksInstitutionalHoldingOwnerDetail.

        The fund manager's name  # noqa: E501

        :param fund_manager_name: The fund_manager_name of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._fund_manager_name = fund_manager_name

    @property
    def fund_manager_state(self):
        """Gets the fund_manager_state of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The fund manager's state  # noqa: E501

        :return: The fund_manager_state of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._fund_manager_state
        
    @property
    def fund_manager_state_dict(self):
        """Gets the fund_manager_state of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The fund manager's state as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The fund_manager_state of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.fund_manager_state
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'fund_manager_state': value }

        
        return result
        

    @fund_manager_state.setter
    def fund_manager_state(self, fund_manager_state):
        """Sets the fund_manager_state of this ZacksInstitutionalHoldingOwnerDetail.

        The fund manager's state  # noqa: E501

        :param fund_manager_state: The fund_manager_state of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._fund_manager_state = fund_manager_state

    @property
    def files_13f(self):
        """Gets the files_13f of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        If 'Y', the company files the SEC 13F report. ('Y' = Yes, 'N' = No)  # noqa: E501

        :return: The files_13f of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._files_13f
        
    @property
    def files_13f_dict(self):
        """Gets the files_13f of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        If 'Y', the company files the SEC 13F report. ('Y' = Yes, 'N' = No) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The files_13f of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.files_13f
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'files_13f': value }

        
        return result
        

    @files_13f.setter
    def files_13f(self, files_13f):
        """Sets the files_13f of this ZacksInstitutionalHoldingOwnerDetail.

        If 'Y', the company files the SEC 13F report. ('Y' = Yes, 'N' = No)  # noqa: E501

        :param files_13f: The files_13f of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._files_13f = files_13f

    @property
    def is_etf(self):
        """Gets the is_etf of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        If 'Y', the owner is an ETF. ('Y' = Yes, 'N' = No)  # noqa: E501

        :return: The is_etf of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """
        return self._is_etf
        
    @property
    def is_etf_dict(self):
        """Gets the is_etf of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        If 'Y', the owner is an ETF. ('Y' = Yes, 'N' = No) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The is_etf of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.is_etf
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'is_etf': value }

        
        return result
        

    @is_etf.setter
    def is_etf(self, is_etf):
        """Sets the is_etf of this ZacksInstitutionalHoldingOwnerDetail.

        If 'Y', the owner is an ETF. ('Y' = Yes, 'N' = No)  # noqa: E501

        :param is_etf: The is_etf of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: str
        """

        self._is_etf = is_etf

    @property
    def last_updated_on(self):
        """Gets the last_updated_on of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The the last updated date  # noqa: E501

        :return: The last_updated_on of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: date
        """
        return self._last_updated_on
        
    @property
    def last_updated_on_dict(self):
        """Gets the last_updated_on of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501

        The the last updated date as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The last_updated_on of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.last_updated_on
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'last_updated_on': value }

        
        return result
        

    @last_updated_on.setter
    def last_updated_on(self, last_updated_on):
        """Sets the last_updated_on of this ZacksInstitutionalHoldingOwnerDetail.

        The the last updated date  # noqa: E501

        :param last_updated_on: The last_updated_on of this ZacksInstitutionalHoldingOwnerDetail.  # noqa: E501
        :type: date
        """

        self._last_updated_on = last_updated_on

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ZacksInstitutionalHoldingOwnerDetail):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
