# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://docs.intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.25.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class OptionUnusualTrade(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'symbol': 'str',
        'timestamp': 'date',
        'type': 'str',
        'total_value': 'float',
        'contract_type': 'str',
        'contract_expiration': 'date',
        'contract_strike': 'float'
    }

    attribute_map = {
        'symbol': 'symbol',
        'timestamp': 'timestamp',
        'type': 'type',
        'total_value': 'total_value',
        'contract_type': 'contract_type',
        'contract_expiration': 'contract_expiration',
        'contract_strike': 'contract_strike'
    }

    def __init__(self, symbol=None, timestamp=None, type=None, total_value=None, contract_type=None, contract_expiration=None, contract_strike=None):  # noqa: E501
        """OptionUnusualTrade - a model defined in Swagger"""  # noqa: E501

        self._symbol = None
        self._timestamp = None
        self._type = None
        self._total_value = None
        self._contract_type = None
        self._contract_expiration = None
        self._contract_strike = None
        self.discriminator = None

        if symbol is not None:
            self.symbol = symbol
        if timestamp is not None:
            self.timestamp = timestamp
        if type is not None:
            self.type = type
        if total_value is not None:
            self.total_value = total_value
        if contract_type is not None:
            self.contract_type = contract_type
        if contract_expiration is not None:
            self.contract_expiration = contract_expiration
        if contract_strike is not None:
            self.contract_strike = contract_strike

    @property
    def symbol(self):
        """Gets the symbol of this OptionUnusualTrade.  # noqa: E501

        The underlying option security symbol for the trade  # noqa: E501

        :return: The symbol of this OptionUnusualTrade.  # noqa: E501
        :rtype: str
        """
        return self._symbol
        
    @property
    def symbol_dict(self):
        """Gets the symbol of this OptionUnusualTrade.  # noqa: E501

        The underlying option security symbol for the trade as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The symbol of this OptionUnusualTrade.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.symbol
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'symbol': value }

        
        return result
        

    @symbol.setter
    def symbol(self, symbol):
        """Sets the symbol of this OptionUnusualTrade.

        The underlying option security symbol for the trade  # noqa: E501

        :param symbol: The symbol of this OptionUnusualTrade.  # noqa: E501
        :type: str
        """

        self._symbol = symbol

    @property
    def timestamp(self):
        """Gets the timestamp of this OptionUnusualTrade.  # noqa: E501

        The UTC timestamp of order placement  # noqa: E501

        :return: The timestamp of this OptionUnusualTrade.  # noqa: E501
        :rtype: date
        """
        return self._timestamp
        
    @property
    def timestamp_dict(self):
        """Gets the timestamp of this OptionUnusualTrade.  # noqa: E501

        The UTC timestamp of order placement as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The timestamp of this OptionUnusualTrade.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.timestamp
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'timestamp': value }

        
        return result
        

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this OptionUnusualTrade.

        The UTC timestamp of order placement  # noqa: E501

        :param timestamp: The timestamp of this OptionUnusualTrade.  # noqa: E501
        :type: date
        """

        self._timestamp = timestamp

    @property
    def type(self):
        """Gets the type of this OptionUnusualTrade.  # noqa: E501

        The type of unusual trade  # noqa: E501

        :return: The type of this OptionUnusualTrade.  # noqa: E501
        :rtype: str
        """
        return self._type
        
    @property
    def type_dict(self):
        """Gets the type of this OptionUnusualTrade.  # noqa: E501

        The type of unusual trade as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The type of this OptionUnusualTrade.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'type': value }

        
        return result
        

    @type.setter
    def type(self, type):
        """Sets the type of this OptionUnusualTrade.

        The type of unusual trade  # noqa: E501

        :param type: The type of this OptionUnusualTrade.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def total_value(self):
        """Gets the total_value of this OptionUnusualTrade.  # noqa: E501

        The aggregated value of all option contract premiums included in the trade  # noqa: E501

        :return: The total_value of this OptionUnusualTrade.  # noqa: E501
        :rtype: float
        """
        return self._total_value
        
    @property
    def total_value_dict(self):
        """Gets the total_value of this OptionUnusualTrade.  # noqa: E501

        The aggregated value of all option contract premiums included in the trade as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_value of this OptionUnusualTrade.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_value
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_value': value }

        
        return result
        

    @total_value.setter
    def total_value(self, total_value):
        """Sets the total_value of this OptionUnusualTrade.

        The aggregated value of all option contract premiums included in the trade  # noqa: E501

        :param total_value: The total_value of this OptionUnusualTrade.  # noqa: E501
        :type: float
        """

        self._total_value = total_value

    @property
    def contract_type(self):
        """Gets the contract_type of this OptionUnusualTrade.  # noqa: E501

        The type of Option (put or call)  # noqa: E501

        :return: The contract_type of this OptionUnusualTrade.  # noqa: E501
        :rtype: str
        """
        return self._contract_type
        
    @property
    def contract_type_dict(self):
        """Gets the contract_type of this OptionUnusualTrade.  # noqa: E501

        The type of Option (put or call) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The contract_type of this OptionUnusualTrade.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.contract_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'contract_type': value }

        
        return result
        

    @contract_type.setter
    def contract_type(self, contract_type):
        """Sets the contract_type of this OptionUnusualTrade.

        The type of Option (put or call)  # noqa: E501

        :param contract_type: The contract_type of this OptionUnusualTrade.  # noqa: E501
        :type: str
        """
        allowed_values = ["put", "call"]  # noqa: E501
        if contract_type not in allowed_values:
            raise ValueError(
                "Invalid value for `contract_type` ({0}), must be one of {1}"  # noqa: E501
                .format(contract_type, allowed_values)
            )

        self._contract_type = contract_type

    @property
    def contract_expiration(self):
        """Gets the contract_expiration of this OptionUnusualTrade.  # noqa: E501

        The expiration date for the options contract  # noqa: E501

        :return: The contract_expiration of this OptionUnusualTrade.  # noqa: E501
        :rtype: date
        """
        return self._contract_expiration
        
    @property
    def contract_expiration_dict(self):
        """Gets the contract_expiration of this OptionUnusualTrade.  # noqa: E501

        The expiration date for the options contract as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The contract_expiration of this OptionUnusualTrade.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.contract_expiration
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'contract_expiration': value }

        
        return result
        

    @contract_expiration.setter
    def contract_expiration(self, contract_expiration):
        """Sets the contract_expiration of this OptionUnusualTrade.

        The expiration date for the options contract  # noqa: E501

        :param contract_expiration: The contract_expiration of this OptionUnusualTrade.  # noqa: E501
        :type: date
        """

        self._contract_expiration = contract_expiration

    @property
    def contract_strike(self):
        """Gets the contract_strike of this OptionUnusualTrade.  # noqa: E501

        The strike price of the option contract  # noqa: E501

        :return: The contract_strike of this OptionUnusualTrade.  # noqa: E501
        :rtype: float
        """
        return self._contract_strike
        
    @property
    def contract_strike_dict(self):
        """Gets the contract_strike of this OptionUnusualTrade.  # noqa: E501

        The strike price of the option contract as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The contract_strike of this OptionUnusualTrade.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.contract_strike
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'contract_strike': value }

        
        return result
        

    @contract_strike.setter
    def contract_strike(self, contract_strike):
        """Sets the contract_strike of this OptionUnusualTrade.

        The strike price of the option contract  # noqa: E501

        :param contract_strike: The contract_strike of this OptionUnusualTrade.  # noqa: E501
        :type: float
        """

        self._contract_strike = contract_strike

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OptionUnusualTrade):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
