# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://docs.intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.25.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from intrinio_sdk.models.company_summary import CompanySummary  # noqa: F401,E501
from intrinio_sdk.models.owner_summary import OwnerSummary  # noqa: F401,E501


class InsiderTransaction(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'director': 'bool',
        'officer': 'bool',
        'ten_percent_owner': 'bool',
        'other_relation': 'bool',
        'officer_title': 'str',
        'derivative_transaction': 'bool',
        'ticker': 'str',
        'security_title': 'str',
        'conversion_exercise_price': 'float',
        'transaction_type_code': 'str',
        'acquisition_disposition_code': 'str',
        'amount_of_shares': 'float',
        'underlying_security_title': 'str',
        'underlying_shares': 'float',
        'transaction_price': 'float',
        'total_shares_owned': 'float',
        'ownership_type_code': 'str',
        'company': 'CompanySummary',
        'owner': 'OwnerSummary'
    }

    attribute_map = {
        'director': 'director',
        'officer': 'officer',
        'ten_percent_owner': 'ten_percent_owner',
        'other_relation': 'other_relation',
        'officer_title': 'officer_title',
        'derivative_transaction': 'derivative_transaction',
        'ticker': 'ticker',
        'security_title': 'security_title',
        'conversion_exercise_price': 'conversion_exercise_price',
        'transaction_type_code': 'transaction_type_code',
        'acquisition_disposition_code': 'acquisition_disposition_code',
        'amount_of_shares': 'amount_of_shares',
        'underlying_security_title': 'underlying_security_title',
        'underlying_shares': 'underlying_shares',
        'transaction_price': 'transaction_price',
        'total_shares_owned': 'total_shares_owned',
        'ownership_type_code': 'ownership_type_code',
        'company': 'company',
        'owner': 'owner'
    }

    def __init__(self, director=None, officer=None, ten_percent_owner=None, other_relation=None, officer_title=None, derivative_transaction=None, ticker=None, security_title=None, conversion_exercise_price=None, transaction_type_code=None, acquisition_disposition_code=None, amount_of_shares=None, underlying_security_title=None, underlying_shares=None, transaction_price=None, total_shares_owned=None, ownership_type_code=None, company=None, owner=None):  # noqa: E501
        """InsiderTransaction - a model defined in Swagger"""  # noqa: E501

        self._director = None
        self._officer = None
        self._ten_percent_owner = None
        self._other_relation = None
        self._officer_title = None
        self._derivative_transaction = None
        self._ticker = None
        self._security_title = None
        self._conversion_exercise_price = None
        self._transaction_type_code = None
        self._acquisition_disposition_code = None
        self._amount_of_shares = None
        self._underlying_security_title = None
        self._underlying_shares = None
        self._transaction_price = None
        self._total_shares_owned = None
        self._ownership_type_code = None
        self._company = None
        self._owner = None
        self.discriminator = None

        if director is not None:
            self.director = director
        if officer is not None:
            self.officer = officer
        if ten_percent_owner is not None:
            self.ten_percent_owner = ten_percent_owner
        if other_relation is not None:
            self.other_relation = other_relation
        if officer_title is not None:
            self.officer_title = officer_title
        if derivative_transaction is not None:
            self.derivative_transaction = derivative_transaction
        if ticker is not None:
            self.ticker = ticker
        if security_title is not None:
            self.security_title = security_title
        if conversion_exercise_price is not None:
            self.conversion_exercise_price = conversion_exercise_price
        if transaction_type_code is not None:
            self.transaction_type_code = transaction_type_code
        if acquisition_disposition_code is not None:
            self.acquisition_disposition_code = acquisition_disposition_code
        if amount_of_shares is not None:
            self.amount_of_shares = amount_of_shares
        if underlying_security_title is not None:
            self.underlying_security_title = underlying_security_title
        if underlying_shares is not None:
            self.underlying_shares = underlying_shares
        if transaction_price is not None:
            self.transaction_price = transaction_price
        if total_shares_owned is not None:
            self.total_shares_owned = total_shares_owned
        if ownership_type_code is not None:
            self.ownership_type_code = ownership_type_code
        if company is not None:
            self.company = company
        if owner is not None:
            self.owner = owner

    @property
    def director(self):
        """Gets the director of this InsiderTransaction.  # noqa: E501

        (true/false) A boolean indicating whether or not the owner is a director in the company  # noqa: E501

        :return: The director of this InsiderTransaction.  # noqa: E501
        :rtype: bool
        """
        return self._director
        
    @property
    def director_dict(self):
        """Gets the director of this InsiderTransaction.  # noqa: E501

        (true/false) A boolean indicating whether or not the owner is a director in the company as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The director of this InsiderTransaction.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.director
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'director': value }

        
        return result
        

    @director.setter
    def director(self, director):
        """Sets the director of this InsiderTransaction.

        (true/false) A boolean indicating whether or not the owner is a director in the company  # noqa: E501

        :param director: The director of this InsiderTransaction.  # noqa: E501
        :type: bool
        """

        self._director = director

    @property
    def officer(self):
        """Gets the officer of this InsiderTransaction.  # noqa: E501

        (true/false) A boolean indicating whether or not the owner is a officer in the company  # noqa: E501

        :return: The officer of this InsiderTransaction.  # noqa: E501
        :rtype: bool
        """
        return self._officer
        
    @property
    def officer_dict(self):
        """Gets the officer of this InsiderTransaction.  # noqa: E501

        (true/false) A boolean indicating whether or not the owner is a officer in the company as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The officer of this InsiderTransaction.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.officer
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'officer': value }

        
        return result
        

    @officer.setter
    def officer(self, officer):
        """Sets the officer of this InsiderTransaction.

        (true/false) A boolean indicating whether or not the owner is a officer in the company  # noqa: E501

        :param officer: The officer of this InsiderTransaction.  # noqa: E501
        :type: bool
        """

        self._officer = officer

    @property
    def ten_percent_owner(self):
        """Gets the ten_percent_owner of this InsiderTransaction.  # noqa: E501

        (true/false) A boolean indicating whether or not the owner has a ten percent or greater interest in the company  # noqa: E501

        :return: The ten_percent_owner of this InsiderTransaction.  # noqa: E501
        :rtype: bool
        """
        return self._ten_percent_owner
        
    @property
    def ten_percent_owner_dict(self):
        """Gets the ten_percent_owner of this InsiderTransaction.  # noqa: E501

        (true/false) A boolean indicating whether or not the owner has a ten percent or greater interest in the company as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The ten_percent_owner of this InsiderTransaction.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.ten_percent_owner
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'ten_percent_owner': value }

        
        return result
        

    @ten_percent_owner.setter
    def ten_percent_owner(self, ten_percent_owner):
        """Sets the ten_percent_owner of this InsiderTransaction.

        (true/false) A boolean indicating whether or not the owner has a ten percent or greater interest in the company  # noqa: E501

        :param ten_percent_owner: The ten_percent_owner of this InsiderTransaction.  # noqa: E501
        :type: bool
        """

        self._ten_percent_owner = ten_percent_owner

    @property
    def other_relation(self):
        """Gets the other_relation of this InsiderTransaction.  # noqa: E501

        (true/false) A boolean indicating whether or not the owner has another relationship with the company beside, direct, officer, or significant owner in the company  # noqa: E501

        :return: The other_relation of this InsiderTransaction.  # noqa: E501
        :rtype: bool
        """
        return self._other_relation
        
    @property
    def other_relation_dict(self):
        """Gets the other_relation of this InsiderTransaction.  # noqa: E501

        (true/false) A boolean indicating whether or not the owner has another relationship with the company beside, direct, officer, or significant owner in the company as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The other_relation of this InsiderTransaction.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.other_relation
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'other_relation': value }

        
        return result
        

    @other_relation.setter
    def other_relation(self, other_relation):
        """Sets the other_relation of this InsiderTransaction.

        (true/false) A boolean indicating whether or not the owner has another relationship with the company beside, direct, officer, or significant owner in the company  # noqa: E501

        :param other_relation: The other_relation of this InsiderTransaction.  # noqa: E501
        :type: bool
        """

        self._other_relation = other_relation

    @property
    def officer_title(self):
        """Gets the officer_title of this InsiderTransaction.  # noqa: E501

        The officer title of the owner in the company  # noqa: E501

        :return: The officer_title of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """
        return self._officer_title
        
    @property
    def officer_title_dict(self):
        """Gets the officer_title of this InsiderTransaction.  # noqa: E501

        The officer title of the owner in the company as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The officer_title of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.officer_title
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'officer_title': value }

        
        return result
        

    @officer_title.setter
    def officer_title(self, officer_title):
        """Sets the officer_title of this InsiderTransaction.

        The officer title of the owner in the company  # noqa: E501

        :param officer_title: The officer_title of this InsiderTransaction.  # noqa: E501
        :type: str
        """

        self._officer_title = officer_title

    @property
    def derivative_transaction(self):
        """Gets the derivative_transaction of this InsiderTransaction.  # noqa: E501

        (true) A boolean indicating the transaction is a derivative transaction, which may or may not become common stock due to various possible exercise or conversion requirements  # noqa: E501

        :return: The derivative_transaction of this InsiderTransaction.  # noqa: E501
        :rtype: bool
        """
        return self._derivative_transaction
        
    @property
    def derivative_transaction_dict(self):
        """Gets the derivative_transaction of this InsiderTransaction.  # noqa: E501

        (true) A boolean indicating the transaction is a derivative transaction, which may or may not become common stock due to various possible exercise or conversion requirements as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The derivative_transaction of this InsiderTransaction.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.derivative_transaction
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'derivative_transaction': value }

        
        return result
        

    @derivative_transaction.setter
    def derivative_transaction(self, derivative_transaction):
        """Sets the derivative_transaction of this InsiderTransaction.

        (true) A boolean indicating the transaction is a derivative transaction, which may or may not become common stock due to various possible exercise or conversion requirements  # noqa: E501

        :param derivative_transaction: The derivative_transaction of this InsiderTransaction.  # noqa: E501
        :type: bool
        """

        self._derivative_transaction = derivative_transaction

    @property
    def ticker(self):
        """Gets the ticker of this InsiderTransaction.  # noqa: E501

        The ticker symbol for the company’s common stock  # noqa: E501

        :return: The ticker of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """
        return self._ticker
        
    @property
    def ticker_dict(self):
        """Gets the ticker of this InsiderTransaction.  # noqa: E501

        The ticker symbol for the company’s common stock as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The ticker of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.ticker
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'ticker': value }

        
        return result
        

    @ticker.setter
    def ticker(self, ticker):
        """Sets the ticker of this InsiderTransaction.

        The ticker symbol for the company’s common stock  # noqa: E501

        :param ticker: The ticker of this InsiderTransaction.  # noqa: E501
        :type: str
        """

        self._ticker = ticker

    @property
    def security_title(self):
        """Gets the security_title of this InsiderTransaction.  # noqa: E501

        The name of the derivative security transacted  # noqa: E501

        :return: The security_title of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """
        return self._security_title
        
    @property
    def security_title_dict(self):
        """Gets the security_title of this InsiderTransaction.  # noqa: E501

        The name of the derivative security transacted as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The security_title of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.security_title
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'security_title': value }

        
        return result
        

    @security_title.setter
    def security_title(self, security_title):
        """Sets the security_title of this InsiderTransaction.

        The name of the derivative security transacted  # noqa: E501

        :param security_title: The security_title of this InsiderTransaction.  # noqa: E501
        :type: str
        """

        self._security_title = security_title

    @property
    def conversion_exercise_price(self):
        """Gets the conversion_exercise_price of this InsiderTransaction.  # noqa: E501

        The conversion or exercise price of the derivative security transacted  # noqa: E501

        :return: The conversion_exercise_price of this InsiderTransaction.  # noqa: E501
        :rtype: float
        """
        return self._conversion_exercise_price
        
    @property
    def conversion_exercise_price_dict(self):
        """Gets the conversion_exercise_price of this InsiderTransaction.  # noqa: E501

        The conversion or exercise price of the derivative security transacted as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The conversion_exercise_price of this InsiderTransaction.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.conversion_exercise_price
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'conversion_exercise_price': value }

        
        return result
        

    @conversion_exercise_price.setter
    def conversion_exercise_price(self, conversion_exercise_price):
        """Sets the conversion_exercise_price of this InsiderTransaction.

        The conversion or exercise price of the derivative security transacted  # noqa: E501

        :param conversion_exercise_price: The conversion_exercise_price of this InsiderTransaction.  # noqa: E501
        :type: float
        """

        self._conversion_exercise_price = conversion_exercise_price

    @property
    def transaction_type_code(self):
        """Gets the transaction_type_code of this InsiderTransaction.  # noqa: E501

        A symbol representing the transaction type; P = Purchase | S = Sale | A  = Award | M = Conversion to Common | C = Conversion | X = Exercise of Derivative More Transaction Codes  # noqa: E501

        :return: The transaction_type_code of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """
        return self._transaction_type_code
        
    @property
    def transaction_type_code_dict(self):
        """Gets the transaction_type_code of this InsiderTransaction.  # noqa: E501

        A symbol representing the transaction type; P = Purchase | S = Sale | A  = Award | M = Conversion to Common | C = Conversion | X = Exercise of Derivative More Transaction Codes as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The transaction_type_code of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.transaction_type_code
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'transaction_type_code': value }

        
        return result
        

    @transaction_type_code.setter
    def transaction_type_code(self, transaction_type_code):
        """Sets the transaction_type_code of this InsiderTransaction.

        A symbol representing the transaction type; P = Purchase | S = Sale | A  = Award | M = Conversion to Common | C = Conversion | X = Exercise of Derivative More Transaction Codes  # noqa: E501

        :param transaction_type_code: The transaction_type_code of this InsiderTransaction.  # noqa: E501
        :type: str
        """

        self._transaction_type_code = transaction_type_code

    @property
    def acquisition_disposition_code(self):
        """Gets the acquisition_disposition_code of this InsiderTransaction.  # noqa: E501

        A symbol representing whether or not the derivative securities are Acquired or Disposed; A = Acquisition | D = Disposition  # noqa: E501

        :return: The acquisition_disposition_code of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """
        return self._acquisition_disposition_code
        
    @property
    def acquisition_disposition_code_dict(self):
        """Gets the acquisition_disposition_code of this InsiderTransaction.  # noqa: E501

        A symbol representing whether or not the derivative securities are Acquired or Disposed; A = Acquisition | D = Disposition as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The acquisition_disposition_code of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.acquisition_disposition_code
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'acquisition_disposition_code': value }

        
        return result
        

    @acquisition_disposition_code.setter
    def acquisition_disposition_code(self, acquisition_disposition_code):
        """Sets the acquisition_disposition_code of this InsiderTransaction.

        A symbol representing whether or not the derivative securities are Acquired or Disposed; A = Acquisition | D = Disposition  # noqa: E501

        :param acquisition_disposition_code: The acquisition_disposition_code of this InsiderTransaction.  # noqa: E501
        :type: str
        """

        self._acquisition_disposition_code = acquisition_disposition_code

    @property
    def amount_of_shares(self):
        """Gets the amount_of_shares of this InsiderTransaction.  # noqa: E501

        The number of derivative securities involved in the subject transaction  # noqa: E501

        :return: The amount_of_shares of this InsiderTransaction.  # noqa: E501
        :rtype: float
        """
        return self._amount_of_shares
        
    @property
    def amount_of_shares_dict(self):
        """Gets the amount_of_shares of this InsiderTransaction.  # noqa: E501

        The number of derivative securities involved in the subject transaction as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The amount_of_shares of this InsiderTransaction.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.amount_of_shares
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'amount_of_shares': value }

        
        return result
        

    @amount_of_shares.setter
    def amount_of_shares(self, amount_of_shares):
        """Sets the amount_of_shares of this InsiderTransaction.

        The number of derivative securities involved in the subject transaction  # noqa: E501

        :param amount_of_shares: The amount_of_shares of this InsiderTransaction.  # noqa: E501
        :type: float
        """

        self._amount_of_shares = amount_of_shares

    @property
    def underlying_security_title(self):
        """Gets the underlying_security_title of this InsiderTransaction.  # noqa: E501

        The name of the underlying non-derivative security related to this derivative transaction  # noqa: E501

        :return: The underlying_security_title of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """
        return self._underlying_security_title
        
    @property
    def underlying_security_title_dict(self):
        """Gets the underlying_security_title of this InsiderTransaction.  # noqa: E501

        The name of the underlying non-derivative security related to this derivative transaction as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The underlying_security_title of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.underlying_security_title
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'underlying_security_title': value }

        
        return result
        

    @underlying_security_title.setter
    def underlying_security_title(self, underlying_security_title):
        """Sets the underlying_security_title of this InsiderTransaction.

        The name of the underlying non-derivative security related to this derivative transaction  # noqa: E501

        :param underlying_security_title: The underlying_security_title of this InsiderTransaction.  # noqa: E501
        :type: str
        """

        self._underlying_security_title = underlying_security_title

    @property
    def underlying_shares(self):
        """Gets the underlying_shares of this InsiderTransaction.  # noqa: E501

        The number of non-derivative shares involved in the subject transaction  # noqa: E501

        :return: The underlying_shares of this InsiderTransaction.  # noqa: E501
        :rtype: float
        """
        return self._underlying_shares
        
    @property
    def underlying_shares_dict(self):
        """Gets the underlying_shares of this InsiderTransaction.  # noqa: E501

        The number of non-derivative shares involved in the subject transaction as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The underlying_shares of this InsiderTransaction.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.underlying_shares
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'underlying_shares': value }

        
        return result
        

    @underlying_shares.setter
    def underlying_shares(self, underlying_shares):
        """Sets the underlying_shares of this InsiderTransaction.

        The number of non-derivative shares involved in the subject transaction  # noqa: E501

        :param underlying_shares: The underlying_shares of this InsiderTransaction.  # noqa: E501
        :type: float
        """

        self._underlying_shares = underlying_shares

    @property
    def transaction_price(self):
        """Gets the transaction_price of this InsiderTransaction.  # noqa: E501

        The price of the derivative securities  # noqa: E501

        :return: The transaction_price of this InsiderTransaction.  # noqa: E501
        :rtype: float
        """
        return self._transaction_price
        
    @property
    def transaction_price_dict(self):
        """Gets the transaction_price of this InsiderTransaction.  # noqa: E501

        The price of the derivative securities as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The transaction_price of this InsiderTransaction.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.transaction_price
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'transaction_price': value }

        
        return result
        

    @transaction_price.setter
    def transaction_price(self, transaction_price):
        """Sets the transaction_price of this InsiderTransaction.

        The price of the derivative securities  # noqa: E501

        :param transaction_price: The transaction_price of this InsiderTransaction.  # noqa: E501
        :type: float
        """

        self._transaction_price = transaction_price

    @property
    def total_shares_owned(self):
        """Gets the total_shares_owned of this InsiderTransaction.  # noqa: E501

        The total number of derivative securities owned following the subject transaction  # noqa: E501

        :return: The total_shares_owned of this InsiderTransaction.  # noqa: E501
        :rtype: float
        """
        return self._total_shares_owned
        
    @property
    def total_shares_owned_dict(self):
        """Gets the total_shares_owned of this InsiderTransaction.  # noqa: E501

        The total number of derivative securities owned following the subject transaction as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The total_shares_owned of this InsiderTransaction.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.total_shares_owned
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'total_shares_owned': value }

        
        return result
        

    @total_shares_owned.setter
    def total_shares_owned(self, total_shares_owned):
        """Sets the total_shares_owned of this InsiderTransaction.

        The total number of derivative securities owned following the subject transaction  # noqa: E501

        :param total_shares_owned: The total_shares_owned of this InsiderTransaction.  # noqa: E501
        :type: float
        """

        self._total_shares_owned = total_shares_owned

    @property
    def ownership_type_code(self):
        """Gets the ownership_type_code of this InsiderTransaction.  # noqa: E501

        A symbol representing the ownership of the securities transacted; D = Direct Ownership | I = Indirect Ownership  # noqa: E501

        :return: The ownership_type_code of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """
        return self._ownership_type_code
        
    @property
    def ownership_type_code_dict(self):
        """Gets the ownership_type_code of this InsiderTransaction.  # noqa: E501

        A symbol representing the ownership of the securities transacted; D = Direct Ownership | I = Indirect Ownership as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The ownership_type_code of this InsiderTransaction.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.ownership_type_code
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'ownership_type_code': value }

        
        return result
        

    @ownership_type_code.setter
    def ownership_type_code(self, ownership_type_code):
        """Sets the ownership_type_code of this InsiderTransaction.

        A symbol representing the ownership of the securities transacted; D = Direct Ownership | I = Indirect Ownership  # noqa: E501

        :param ownership_type_code: The ownership_type_code of this InsiderTransaction.  # noqa: E501
        :type: str
        """

        self._ownership_type_code = ownership_type_code

    @property
    def company(self):
        """Gets the company of this InsiderTransaction.  # noqa: E501

        The company associated with the filing  # noqa: E501

        :return: The company of this InsiderTransaction.  # noqa: E501
        :rtype: CompanySummary
        """
        return self._company
        
    @property
    def company_dict(self):
        """Gets the company of this InsiderTransaction.  # noqa: E501

        The company associated with the filing as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The company of this InsiderTransaction.  # noqa: E501
        :rtype: CompanySummary
        """

        result = None

        value = self.company
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'company': value }

        
        return result
        

    @company.setter
    def company(self, company):
        """Sets the company of this InsiderTransaction.

        The company associated with the filing  # noqa: E501

        :param company: The company of this InsiderTransaction.  # noqa: E501
        :type: CompanySummary
        """

        self._company = company

    @property
    def owner(self):
        """Gets the owner of this InsiderTransaction.  # noqa: E501

        The owner associated with the filing  # noqa: E501

        :return: The owner of this InsiderTransaction.  # noqa: E501
        :rtype: OwnerSummary
        """
        return self._owner
        
    @property
    def owner_dict(self):
        """Gets the owner of this InsiderTransaction.  # noqa: E501

        The owner associated with the filing as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The owner of this InsiderTransaction.  # noqa: E501
        :rtype: OwnerSummary
        """

        result = None

        value = self.owner
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'owner': value }

        
        return result
        

    @owner.setter
    def owner(self, owner):
        """Sets the owner of this InsiderTransaction.

        The owner associated with the filing  # noqa: E501

        :param owner: The owner of this InsiderTransaction.  # noqa: E501
        :type: OwnerSummary
        """

        self._owner = owner

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InsiderTransaction):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
