# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://docs.intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.25.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from intrinio_sdk.models.security_summary import SecuritySummary  # noqa: F401,E501


class EarningsRecord(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'quarter': 'str',
        'time_of_day': 'str',
        'broadcast_url': 'str',
        'transcript_url': 'str',
        'transcript_quarter': 'str',
        'transcript_fiscal_year': 'str',
        'conference_call_date': 'date',
        'conference_call_time': 'str',
        'conference_call_phone_number': 'str',
        'conference_call_passcode': 'str',
        'last_confirmation_date': 'date',
        'board_of_directors_meeting_date': 'date',
        'board_of_directors_meeting_type': 'str',
        'company_website': 'str',
        'q1_date': 'date',
        'q2_date': 'date',
        'q3_date': 'date',
        'q4_date': 'date',
        'type': 'str',
        'next_earnings_date': 'date',
        'next_earnings_quarter': 'str',
        'next_earnings_fiscal_year': 'int',
        'preliminary_earnings_date': 'date',
        'security': 'SecuritySummary'
    }

    attribute_map = {
        'quarter': 'quarter',
        'time_of_day': 'time_of_day',
        'broadcast_url': 'broadcast_url',
        'transcript_url': 'transcript_url',
        'transcript_quarter': 'transcript_quarter',
        'transcript_fiscal_year': 'transcript_fiscal_year',
        'conference_call_date': 'conference_call_date',
        'conference_call_time': 'conference_call_time',
        'conference_call_phone_number': 'conference_call_phone_number',
        'conference_call_passcode': 'conference_call_passcode',
        'last_confirmation_date': 'last_confirmation_date',
        'board_of_directors_meeting_date': 'board_of_directors_meeting_date',
        'board_of_directors_meeting_type': 'board_of_directors_meeting_type',
        'company_website': 'company_website',
        'q1_date': 'q1_date',
        'q2_date': 'q2_date',
        'q3_date': 'q3_date',
        'q4_date': 'q4_date',
        'type': 'type',
        'next_earnings_date': 'next_earnings_date',
        'next_earnings_quarter': 'next_earnings_quarter',
        'next_earnings_fiscal_year': 'next_earnings_fiscal_year',
        'preliminary_earnings_date': 'preliminary_earnings_date',
        'security': 'security'
    }

    def __init__(self, quarter=None, time_of_day=None, broadcast_url=None, transcript_url=None, transcript_quarter=None, transcript_fiscal_year=None, conference_call_date=None, conference_call_time=None, conference_call_phone_number=None, conference_call_passcode=None, last_confirmation_date=None, board_of_directors_meeting_date=None, board_of_directors_meeting_type=None, company_website=None, q1_date=None, q2_date=None, q3_date=None, q4_date=None, type=None, next_earnings_date=None, next_earnings_quarter=None, next_earnings_fiscal_year=None, preliminary_earnings_date=None, security=None):  # noqa: E501
        """EarningsRecord - a model defined in Swagger"""  # noqa: E501

        self._quarter = None
        self._time_of_day = None
        self._broadcast_url = None
        self._transcript_url = None
        self._transcript_quarter = None
        self._transcript_fiscal_year = None
        self._conference_call_date = None
        self._conference_call_time = None
        self._conference_call_phone_number = None
        self._conference_call_passcode = None
        self._last_confirmation_date = None
        self._board_of_directors_meeting_date = None
        self._board_of_directors_meeting_type = None
        self._company_website = None
        self._q1_date = None
        self._q2_date = None
        self._q3_date = None
        self._q4_date = None
        self._type = None
        self._next_earnings_date = None
        self._next_earnings_quarter = None
        self._next_earnings_fiscal_year = None
        self._preliminary_earnings_date = None
        self._security = None
        self.discriminator = None

        if quarter is not None:
            self.quarter = quarter
        if time_of_day is not None:
            self.time_of_day = time_of_day
        if broadcast_url is not None:
            self.broadcast_url = broadcast_url
        if transcript_url is not None:
            self.transcript_url = transcript_url
        if transcript_quarter is not None:
            self.transcript_quarter = transcript_quarter
        if transcript_fiscal_year is not None:
            self.transcript_fiscal_year = transcript_fiscal_year
        if conference_call_date is not None:
            self.conference_call_date = conference_call_date
        if conference_call_time is not None:
            self.conference_call_time = conference_call_time
        if conference_call_phone_number is not None:
            self.conference_call_phone_number = conference_call_phone_number
        if conference_call_passcode is not None:
            self.conference_call_passcode = conference_call_passcode
        if last_confirmation_date is not None:
            self.last_confirmation_date = last_confirmation_date
        if board_of_directors_meeting_date is not None:
            self.board_of_directors_meeting_date = board_of_directors_meeting_date
        if board_of_directors_meeting_type is not None:
            self.board_of_directors_meeting_type = board_of_directors_meeting_type
        if company_website is not None:
            self.company_website = company_website
        if q1_date is not None:
            self.q1_date = q1_date
        if q2_date is not None:
            self.q2_date = q2_date
        if q3_date is not None:
            self.q3_date = q3_date
        if q4_date is not None:
            self.q4_date = q4_date
        if type is not None:
            self.type = type
        if next_earnings_date is not None:
            self.next_earnings_date = next_earnings_date
        if next_earnings_quarter is not None:
            self.next_earnings_quarter = next_earnings_quarter
        if next_earnings_fiscal_year is not None:
            self.next_earnings_fiscal_year = next_earnings_fiscal_year
        if preliminary_earnings_date is not None:
            self.preliminary_earnings_date = preliminary_earnings_date
        if security is not None:
            self.security = security

    @property
    def quarter(self):
        """Gets the quarter of this EarningsRecord.  # noqa: E501

        The letter “Q” followed by the quarter number the earnings information applies to  # noqa: E501

        :return: The quarter of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._quarter
        
    @property
    def quarter_dict(self):
        """Gets the quarter of this EarningsRecord.  # noqa: E501

        The letter “Q” followed by the quarter number the earnings information applies to as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The quarter of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.quarter
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'quarter': value }

        
        return result
        

    @quarter.setter
    def quarter(self, quarter):
        """Sets the quarter of this EarningsRecord.

        The letter “Q” followed by the quarter number the earnings information applies to  # noqa: E501

        :param quarter: The quarter of this EarningsRecord.  # noqa: E501
        :type: str
        """

        self._quarter = quarter

    @property
    def time_of_day(self):
        """Gets the time_of_day of this EarningsRecord.  # noqa: E501

        Indicates the time of the announcement  # noqa: E501

        :return: The time_of_day of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._time_of_day
        
    @property
    def time_of_day_dict(self):
        """Gets the time_of_day of this EarningsRecord.  # noqa: E501

        Indicates the time of the announcement as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The time_of_day of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.time_of_day
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'time_of_day': value }

        
        return result
        

    @time_of_day.setter
    def time_of_day(self, time_of_day):
        """Sets the time_of_day of this EarningsRecord.

        Indicates the time of the announcement  # noqa: E501

        :param time_of_day: The time_of_day of this EarningsRecord.  # noqa: E501
        :type: str
        """
        allowed_values = ["Before Market", "During Market", "After Market", "Unspecified"]  # noqa: E501
        if time_of_day not in allowed_values:
            raise ValueError(
                "Invalid value for `time_of_day` ({0}), must be one of {1}"  # noqa: E501
                .format(time_of_day, allowed_values)
            )

        self._time_of_day = time_of_day

    @property
    def broadcast_url(self):
        """Gets the broadcast_url of this EarningsRecord.  # noqa: E501

        Link for Conference Call recording  # noqa: E501

        :return: The broadcast_url of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._broadcast_url
        
    @property
    def broadcast_url_dict(self):
        """Gets the broadcast_url of this EarningsRecord.  # noqa: E501

        Link for Conference Call recording as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The broadcast_url of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.broadcast_url
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'broadcast_url': value }

        
        return result
        

    @broadcast_url.setter
    def broadcast_url(self, broadcast_url):
        """Sets the broadcast_url of this EarningsRecord.

        Link for Conference Call recording  # noqa: E501

        :param broadcast_url: The broadcast_url of this EarningsRecord.  # noqa: E501
        :type: str
        """

        self._broadcast_url = broadcast_url

    @property
    def transcript_url(self):
        """Gets the transcript_url of this EarningsRecord.  # noqa: E501

        Link to the earnings release transcript  # noqa: E501

        :return: The transcript_url of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._transcript_url
        
    @property
    def transcript_url_dict(self):
        """Gets the transcript_url of this EarningsRecord.  # noqa: E501

        Link to the earnings release transcript as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The transcript_url of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.transcript_url
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'transcript_url': value }

        
        return result
        

    @transcript_url.setter
    def transcript_url(self, transcript_url):
        """Sets the transcript_url of this EarningsRecord.

        Link to the earnings release transcript  # noqa: E501

        :param transcript_url: The transcript_url of this EarningsRecord.  # noqa: E501
        :type: str
        """

        self._transcript_url = transcript_url

    @property
    def transcript_quarter(self):
        """Gets the transcript_quarter of this EarningsRecord.  # noqa: E501

        The letter “Q” followed by the quarter number the earnings transcript applies to  # noqa: E501

        :return: The transcript_quarter of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._transcript_quarter
        
    @property
    def transcript_quarter_dict(self):
        """Gets the transcript_quarter of this EarningsRecord.  # noqa: E501

        The letter “Q” followed by the quarter number the earnings transcript applies to as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The transcript_quarter of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.transcript_quarter
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'transcript_quarter': value }

        
        return result
        

    @transcript_quarter.setter
    def transcript_quarter(self, transcript_quarter):
        """Sets the transcript_quarter of this EarningsRecord.

        The letter “Q” followed by the quarter number the earnings transcript applies to  # noqa: E501

        :param transcript_quarter: The transcript_quarter of this EarningsRecord.  # noqa: E501
        :type: str
        """

        self._transcript_quarter = transcript_quarter

    @property
    def transcript_fiscal_year(self):
        """Gets the transcript_fiscal_year of this EarningsRecord.  # noqa: E501

        Fiscal year in YYYY format for the earnings transcript  # noqa: E501

        :return: The transcript_fiscal_year of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._transcript_fiscal_year
        
    @property
    def transcript_fiscal_year_dict(self):
        """Gets the transcript_fiscal_year of this EarningsRecord.  # noqa: E501

        Fiscal year in YYYY format for the earnings transcript as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The transcript_fiscal_year of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.transcript_fiscal_year
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'transcript_fiscal_year': value }

        
        return result
        

    @transcript_fiscal_year.setter
    def transcript_fiscal_year(self, transcript_fiscal_year):
        """Sets the transcript_fiscal_year of this EarningsRecord.

        Fiscal year in YYYY format for the earnings transcript  # noqa: E501

        :param transcript_fiscal_year: The transcript_fiscal_year of this EarningsRecord.  # noqa: E501
        :type: str
        """

        self._transcript_fiscal_year = transcript_fiscal_year

    @property
    def conference_call_date(self):
        """Gets the conference_call_date of this EarningsRecord.  # noqa: E501

        Date of the conference call  # noqa: E501

        :return: The conference_call_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """
        return self._conference_call_date
        
    @property
    def conference_call_date_dict(self):
        """Gets the conference_call_date of this EarningsRecord.  # noqa: E501

        Date of the conference call as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The conference_call_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.conference_call_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'conference_call_date': value }

        
        return result
        

    @conference_call_date.setter
    def conference_call_date(self, conference_call_date):
        """Sets the conference_call_date of this EarningsRecord.

        Date of the conference call  # noqa: E501

        :param conference_call_date: The conference_call_date of this EarningsRecord.  # noqa: E501
        :type: date
        """

        self._conference_call_date = conference_call_date

    @property
    def conference_call_time(self):
        """Gets the conference_call_time of this EarningsRecord.  # noqa: E501

        Published time of the conference call  # noqa: E501

        :return: The conference_call_time of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._conference_call_time
        
    @property
    def conference_call_time_dict(self):
        """Gets the conference_call_time of this EarningsRecord.  # noqa: E501

        Published time of the conference call as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The conference_call_time of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.conference_call_time
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'conference_call_time': value }

        
        return result
        

    @conference_call_time.setter
    def conference_call_time(self, conference_call_time):
        """Sets the conference_call_time of this EarningsRecord.

        Published time of the conference call  # noqa: E501

        :param conference_call_time: The conference_call_time of this EarningsRecord.  # noqa: E501
        :type: str
        """

        self._conference_call_time = conference_call_time

    @property
    def conference_call_phone_number(self):
        """Gets the conference_call_phone_number of this EarningsRecord.  # noqa: E501

        Publicly available phone number for replay conference call  # noqa: E501

        :return: The conference_call_phone_number of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._conference_call_phone_number
        
    @property
    def conference_call_phone_number_dict(self):
        """Gets the conference_call_phone_number of this EarningsRecord.  # noqa: E501

        Publicly available phone number for replay conference call as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The conference_call_phone_number of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.conference_call_phone_number
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'conference_call_phone_number': value }

        
        return result
        

    @conference_call_phone_number.setter
    def conference_call_phone_number(self, conference_call_phone_number):
        """Sets the conference_call_phone_number of this EarningsRecord.

        Publicly available phone number for replay conference call  # noqa: E501

        :param conference_call_phone_number: The conference_call_phone_number of this EarningsRecord.  # noqa: E501
        :type: str
        """

        self._conference_call_phone_number = conference_call_phone_number

    @property
    def conference_call_passcode(self):
        """Gets the conference_call_passcode of this EarningsRecord.  # noqa: E501

        Passcode for replay conference call  # noqa: E501

        :return: The conference_call_passcode of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._conference_call_passcode
        
    @property
    def conference_call_passcode_dict(self):
        """Gets the conference_call_passcode of this EarningsRecord.  # noqa: E501

        Passcode for replay conference call as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The conference_call_passcode of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.conference_call_passcode
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'conference_call_passcode': value }

        
        return result
        

    @conference_call_passcode.setter
    def conference_call_passcode(self, conference_call_passcode):
        """Sets the conference_call_passcode of this EarningsRecord.

        Passcode for replay conference call  # noqa: E501

        :param conference_call_passcode: The conference_call_passcode of this EarningsRecord.  # noqa: E501
        :type: str
        """

        self._conference_call_passcode = conference_call_passcode

    @property
    def last_confirmation_date(self):
        """Gets the last_confirmation_date of this EarningsRecord.  # noqa: E501

        Date of last earnings date update by a WSH analyst  # noqa: E501

        :return: The last_confirmation_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """
        return self._last_confirmation_date
        
    @property
    def last_confirmation_date_dict(self):
        """Gets the last_confirmation_date of this EarningsRecord.  # noqa: E501

        Date of last earnings date update by a WSH analyst as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The last_confirmation_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.last_confirmation_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'last_confirmation_date': value }

        
        return result
        

    @last_confirmation_date.setter
    def last_confirmation_date(self, last_confirmation_date):
        """Sets the last_confirmation_date of this EarningsRecord.

        Date of last earnings date update by a WSH analyst  # noqa: E501

        :param last_confirmation_date: The last_confirmation_date of this EarningsRecord.  # noqa: E501
        :type: date
        """

        self._last_confirmation_date = last_confirmation_date

    @property
    def board_of_directors_meeting_date(self):
        """Gets the board_of_directors_meeting_date of this EarningsRecord.  # noqa: E501

        Date of Board/Shareholder Meeting  # noqa: E501

        :return: The board_of_directors_meeting_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """
        return self._board_of_directors_meeting_date
        
    @property
    def board_of_directors_meeting_date_dict(self):
        """Gets the board_of_directors_meeting_date of this EarningsRecord.  # noqa: E501

        Date of Board/Shareholder Meeting as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The board_of_directors_meeting_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.board_of_directors_meeting_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'board_of_directors_meeting_date': value }

        
        return result
        

    @board_of_directors_meeting_date.setter
    def board_of_directors_meeting_date(self, board_of_directors_meeting_date):
        """Sets the board_of_directors_meeting_date of this EarningsRecord.

        Date of Board/Shareholder Meeting  # noqa: E501

        :param board_of_directors_meeting_date: The board_of_directors_meeting_date of this EarningsRecord.  # noqa: E501
        :type: date
        """

        self._board_of_directors_meeting_date = board_of_directors_meeting_date

    @property
    def board_of_directors_meeting_type(self):
        """Gets the board_of_directors_meeting_type of this EarningsRecord.  # noqa: E501

        The type of meeting - \"B\" indicates a Board of Directors meeting and \"S\" indicates a Shareholder meeting  # noqa: E501

        :return: The board_of_directors_meeting_type of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._board_of_directors_meeting_type
        
    @property
    def board_of_directors_meeting_type_dict(self):
        """Gets the board_of_directors_meeting_type of this EarningsRecord.  # noqa: E501

        The type of meeting - \"B\" indicates a Board of Directors meeting and \"S\" indicates a Shareholder meeting as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The board_of_directors_meeting_type of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.board_of_directors_meeting_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'board_of_directors_meeting_type': value }

        
        return result
        

    @board_of_directors_meeting_type.setter
    def board_of_directors_meeting_type(self, board_of_directors_meeting_type):
        """Sets the board_of_directors_meeting_type of this EarningsRecord.

        The type of meeting - \"B\" indicates a Board of Directors meeting and \"S\" indicates a Shareholder meeting  # noqa: E501

        :param board_of_directors_meeting_type: The board_of_directors_meeting_type of this EarningsRecord.  # noqa: E501
        :type: str
        """
        allowed_values = ["B", "S"]  # noqa: E501
        if board_of_directors_meeting_type not in allowed_values:
            raise ValueError(
                "Invalid value for `board_of_directors_meeting_type` ({0}), must be one of {1}"  # noqa: E501
                .format(board_of_directors_meeting_type, allowed_values)
            )

        self._board_of_directors_meeting_type = board_of_directors_meeting_type

    @property
    def company_website(self):
        """Gets the company_website of this EarningsRecord.  # noqa: E501

        Website link for the company  # noqa: E501

        :return: The company_website of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._company_website
        
    @property
    def company_website_dict(self):
        """Gets the company_website of this EarningsRecord.  # noqa: E501

        Website link for the company as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The company_website of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.company_website
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'company_website': value }

        
        return result
        

    @company_website.setter
    def company_website(self, company_website):
        """Sets the company_website of this EarningsRecord.

        Website link for the company  # noqa: E501

        :param company_website: The company_website of this EarningsRecord.  # noqa: E501
        :type: str
        """

        self._company_website = company_website

    @property
    def q1_date(self):
        """Gets the q1_date of this EarningsRecord.  # noqa: E501

        Earnings Date for 1st quarter  # noqa: E501

        :return: The q1_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """
        return self._q1_date
        
    @property
    def q1_date_dict(self):
        """Gets the q1_date of this EarningsRecord.  # noqa: E501

        Earnings Date for 1st quarter as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The q1_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.q1_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'q1_date': value }

        
        return result
        

    @q1_date.setter
    def q1_date(self, q1_date):
        """Sets the q1_date of this EarningsRecord.

        Earnings Date for 1st quarter  # noqa: E501

        :param q1_date: The q1_date of this EarningsRecord.  # noqa: E501
        :type: date
        """

        self._q1_date = q1_date

    @property
    def q2_date(self):
        """Gets the q2_date of this EarningsRecord.  # noqa: E501

        Earnings Date for 2nd quarter  # noqa: E501

        :return: The q2_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """
        return self._q2_date
        
    @property
    def q2_date_dict(self):
        """Gets the q2_date of this EarningsRecord.  # noqa: E501

        Earnings Date for 2nd quarter as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The q2_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.q2_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'q2_date': value }

        
        return result
        

    @q2_date.setter
    def q2_date(self, q2_date):
        """Sets the q2_date of this EarningsRecord.

        Earnings Date for 2nd quarter  # noqa: E501

        :param q2_date: The q2_date of this EarningsRecord.  # noqa: E501
        :type: date
        """

        self._q2_date = q2_date

    @property
    def q3_date(self):
        """Gets the q3_date of this EarningsRecord.  # noqa: E501

        Earnings Date for 3rd quarter  # noqa: E501

        :return: The q3_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """
        return self._q3_date
        
    @property
    def q3_date_dict(self):
        """Gets the q3_date of this EarningsRecord.  # noqa: E501

        Earnings Date for 3rd quarter as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The q3_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.q3_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'q3_date': value }

        
        return result
        

    @q3_date.setter
    def q3_date(self, q3_date):
        """Sets the q3_date of this EarningsRecord.

        Earnings Date for 3rd quarter  # noqa: E501

        :param q3_date: The q3_date of this EarningsRecord.  # noqa: E501
        :type: date
        """

        self._q3_date = q3_date

    @property
    def q4_date(self):
        """Gets the q4_date of this EarningsRecord.  # noqa: E501

        Earnings Date for 4th quarter  # noqa: E501

        :return: The q4_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """
        return self._q4_date
        
    @property
    def q4_date_dict(self):
        """Gets the q4_date of this EarningsRecord.  # noqa: E501

        Earnings Date for 4th quarter as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The q4_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.q4_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'q4_date': value }

        
        return result
        

    @q4_date.setter
    def q4_date(self, q4_date):
        """Sets the q4_date of this EarningsRecord.

        Earnings Date for 4th quarter  # noqa: E501

        :param q4_date: The q4_date of this EarningsRecord.  # noqa: E501
        :type: date
        """

        self._q4_date = q4_date

    @property
    def type(self):
        """Gets the type of this EarningsRecord.  # noqa: E501

        The nature of the next reported earnings date - \"V\" indicates a Verified date, \"T\" indicates that the date was gathered from the company, but is still considered Tentative, and \"I\" indicates that the date is forecased or Inferred  # noqa: E501

        :return: The type of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._type
        
    @property
    def type_dict(self):
        """Gets the type of this EarningsRecord.  # noqa: E501

        The nature of the next reported earnings date - \"V\" indicates a Verified date, \"T\" indicates that the date was gathered from the company, but is still considered Tentative, and \"I\" indicates that the date is forecased or Inferred as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The type of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'type': value }

        
        return result
        

    @type.setter
    def type(self, type):
        """Sets the type of this EarningsRecord.

        The nature of the next reported earnings date - \"V\" indicates a Verified date, \"T\" indicates that the date was gathered from the company, but is still considered Tentative, and \"I\" indicates that the date is forecased or Inferred  # noqa: E501

        :param type: The type of this EarningsRecord.  # noqa: E501
        :type: str
        """
        allowed_values = ["V", "T", "I"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def next_earnings_date(self):
        """Gets the next_earnings_date of this EarningsRecord.  # noqa: E501

        Next earnings date  # noqa: E501

        :return: The next_earnings_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """
        return self._next_earnings_date
        
    @property
    def next_earnings_date_dict(self):
        """Gets the next_earnings_date of this EarningsRecord.  # noqa: E501

        Next earnings date as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The next_earnings_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.next_earnings_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'next_earnings_date': value }

        
        return result
        

    @next_earnings_date.setter
    def next_earnings_date(self, next_earnings_date):
        """Sets the next_earnings_date of this EarningsRecord.

        Next earnings date  # noqa: E501

        :param next_earnings_date: The next_earnings_date of this EarningsRecord.  # noqa: E501
        :type: date
        """

        self._next_earnings_date = next_earnings_date

    @property
    def next_earnings_quarter(self):
        """Gets the next_earnings_quarter of this EarningsRecord.  # noqa: E501

        The quarter of the next earnings release  # noqa: E501

        :return: The next_earnings_quarter of this EarningsRecord.  # noqa: E501
        :rtype: str
        """
        return self._next_earnings_quarter
        
    @property
    def next_earnings_quarter_dict(self):
        """Gets the next_earnings_quarter of this EarningsRecord.  # noqa: E501

        The quarter of the next earnings release as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The next_earnings_quarter of this EarningsRecord.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.next_earnings_quarter
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'next_earnings_quarter': value }

        
        return result
        

    @next_earnings_quarter.setter
    def next_earnings_quarter(self, next_earnings_quarter):
        """Sets the next_earnings_quarter of this EarningsRecord.

        The quarter of the next earnings release  # noqa: E501

        :param next_earnings_quarter: The next_earnings_quarter of this EarningsRecord.  # noqa: E501
        :type: str
        """

        self._next_earnings_quarter = next_earnings_quarter

    @property
    def next_earnings_fiscal_year(self):
        """Gets the next_earnings_fiscal_year of this EarningsRecord.  # noqa: E501

        The fiscal year associated with next earnings date and next earnings quarter  # noqa: E501

        :return: The next_earnings_fiscal_year of this EarningsRecord.  # noqa: E501
        :rtype: int
        """
        return self._next_earnings_fiscal_year
        
    @property
    def next_earnings_fiscal_year_dict(self):
        """Gets the next_earnings_fiscal_year of this EarningsRecord.  # noqa: E501

        The fiscal year associated with next earnings date and next earnings quarter as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The next_earnings_fiscal_year of this EarningsRecord.  # noqa: E501
        :rtype: int
        """

        result = None

        value = self.next_earnings_fiscal_year
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'next_earnings_fiscal_year': value }

        
        return result
        

    @next_earnings_fiscal_year.setter
    def next_earnings_fiscal_year(self, next_earnings_fiscal_year):
        """Sets the next_earnings_fiscal_year of this EarningsRecord.

        The fiscal year associated with next earnings date and next earnings quarter  # noqa: E501

        :param next_earnings_fiscal_year: The next_earnings_fiscal_year of this EarningsRecord.  # noqa: E501
        :type: int
        """

        self._next_earnings_fiscal_year = next_earnings_fiscal_year

    @property
    def preliminary_earnings_date(self):
        """Gets the preliminary_earnings_date of this EarningsRecord.  # noqa: E501

        The release date of a preliminary earnings report  # noqa: E501

        :return: The preliminary_earnings_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """
        return self._preliminary_earnings_date
        
    @property
    def preliminary_earnings_date_dict(self):
        """Gets the preliminary_earnings_date of this EarningsRecord.  # noqa: E501

        The release date of a preliminary earnings report as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The preliminary_earnings_date of this EarningsRecord.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.preliminary_earnings_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'preliminary_earnings_date': value }

        
        return result
        

    @preliminary_earnings_date.setter
    def preliminary_earnings_date(self, preliminary_earnings_date):
        """Sets the preliminary_earnings_date of this EarningsRecord.

        The release date of a preliminary earnings report  # noqa: E501

        :param preliminary_earnings_date: The preliminary_earnings_date of this EarningsRecord.  # noqa: E501
        :type: date
        """

        self._preliminary_earnings_date = preliminary_earnings_date

    @property
    def security(self):
        """Gets the security of this EarningsRecord.  # noqa: E501


        :return: The security of this EarningsRecord.  # noqa: E501
        :rtype: SecuritySummary
        """
        return self._security
        
    @property
    def security_dict(self):
        """Gets the security of this EarningsRecord.  # noqa: E501


        :return: The security of this EarningsRecord.  # noqa: E501
        :rtype: SecuritySummary
        """

        result = None

        value = self.security
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'security': value }

        
        return result
        

    @security.setter
    def security(self, security):
        """Sets the security of this EarningsRecord.


        :param security: The security of this EarningsRecord.  # noqa: E501
        :type: SecuritySummary
        """

        self._security = security

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EarningsRecord):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
