# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://docs.intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.25.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from intrinio_sdk.models.company_summary import CompanySummary  # noqa: F401,E501
from intrinio_sdk.models.security_summary import SecuritySummary  # noqa: F401,E501


class CompanyInitialPublicOffering(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'ticker': 'str',
        'date': 'datetime',
        'status': 'str',
        'exchange': 'str',
        'offer_amount': 'float',
        'share_price': 'float',
        'share_price_lowest': 'float',
        'share_price_highest': 'float',
        'share_count': 'float',
        'share_count_lowest': 'float',
        'share_count_highest': 'float',
        'announcement_url': 'str',
        'sec_report_url': 'str',
        'open_price': 'float',
        'close_price': 'float',
        'volume': 'float',
        'day_change': 'float',
        'week_change': 'float',
        'month_change': 'float',
        'company': 'CompanySummary',
        'security': 'SecuritySummary'
    }

    attribute_map = {
        'id': 'id',
        'ticker': 'ticker',
        'date': 'date',
        'status': 'status',
        'exchange': 'exchange',
        'offer_amount': 'offer_amount',
        'share_price': 'share_price',
        'share_price_lowest': 'share_price_lowest',
        'share_price_highest': 'share_price_highest',
        'share_count': 'share_count',
        'share_count_lowest': 'share_count_lowest',
        'share_count_highest': 'share_count_highest',
        'announcement_url': 'announcement_url',
        'sec_report_url': 'sec_report_url',
        'open_price': 'open_price',
        'close_price': 'close_price',
        'volume': 'volume',
        'day_change': 'day_change',
        'week_change': 'week_change',
        'month_change': 'month_change',
        'company': 'company',
        'security': 'security'
    }

    def __init__(self, id=None, ticker=None, date=None, status=None, exchange=None, offer_amount=None, share_price=None, share_price_lowest=None, share_price_highest=None, share_count=None, share_count_lowest=None, share_count_highest=None, announcement_url=None, sec_report_url=None, open_price=None, close_price=None, volume=None, day_change=None, week_change=None, month_change=None, company=None, security=None):  # noqa: E501
        """CompanyInitialPublicOffering - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._ticker = None
        self._date = None
        self._status = None
        self._exchange = None
        self._offer_amount = None
        self._share_price = None
        self._share_price_lowest = None
        self._share_price_highest = None
        self._share_count = None
        self._share_count_lowest = None
        self._share_count_highest = None
        self._announcement_url = None
        self._sec_report_url = None
        self._open_price = None
        self._close_price = None
        self._volume = None
        self._day_change = None
        self._week_change = None
        self._month_change = None
        self._company = None
        self._security = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if ticker is not None:
            self.ticker = ticker
        if date is not None:
            self.date = date
        if status is not None:
            self.status = status
        if exchange is not None:
            self.exchange = exchange
        if offer_amount is not None:
            self.offer_amount = offer_amount
        if share_price is not None:
            self.share_price = share_price
        if share_price_lowest is not None:
            self.share_price_lowest = share_price_lowest
        if share_price_highest is not None:
            self.share_price_highest = share_price_highest
        if share_count is not None:
            self.share_count = share_count
        if share_count_lowest is not None:
            self.share_count_lowest = share_count_lowest
        if share_count_highest is not None:
            self.share_count_highest = share_count_highest
        if announcement_url is not None:
            self.announcement_url = announcement_url
        if sec_report_url is not None:
            self.sec_report_url = sec_report_url
        if open_price is not None:
            self.open_price = open_price
        if close_price is not None:
            self.close_price = close_price
        if volume is not None:
            self.volume = volume
        if day_change is not None:
            self.day_change = day_change
        if week_change is not None:
            self.week_change = week_change
        if month_change is not None:
            self.month_change = month_change
        if company is not None:
            self.company = company
        if security is not None:
            self.security = security

    @property
    def id(self):
        """Gets the id of this CompanyInitialPublicOffering.  # noqa: E501

        The Intrinio ID for the IPO  # noqa: E501

        :return: The id of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: str
        """
        return self._id
        
    @property
    def id_dict(self):
        """Gets the id of this CompanyInitialPublicOffering.  # noqa: E501

        The Intrinio ID for the IPO as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The id of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.id
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'id': value }

        
        return result
        

    @id.setter
    def id(self, id):
        """Sets the id of this CompanyInitialPublicOffering.

        The Intrinio ID for the IPO  # noqa: E501

        :param id: The id of this CompanyInitialPublicOffering.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def ticker(self):
        """Gets the ticker of this CompanyInitialPublicOffering.  # noqa: E501

        The ticker under which the Company will be traded after the IPO takes place  # noqa: E501

        :return: The ticker of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: str
        """
        return self._ticker
        
    @property
    def ticker_dict(self):
        """Gets the ticker of this CompanyInitialPublicOffering.  # noqa: E501

        The ticker under which the Company will be traded after the IPO takes place as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The ticker of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.ticker
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'ticker': value }

        
        return result
        

    @ticker.setter
    def ticker(self, ticker):
        """Sets the ticker of this CompanyInitialPublicOffering.

        The ticker under which the Company will be traded after the IPO takes place  # noqa: E501

        :param ticker: The ticker of this CompanyInitialPublicOffering.  # noqa: E501
        :type: str
        """

        self._ticker = ticker

    @property
    def date(self):
        """Gets the date of this CompanyInitialPublicOffering.  # noqa: E501

        The date of the IPO, when the stock first trades on a major exchange  # noqa: E501

        :return: The date of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: datetime
        """
        return self._date
        
    @property
    def date_dict(self):
        """Gets the date of this CompanyInitialPublicOffering.  # noqa: E501

        The date of the IPO, when the stock first trades on a major exchange as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The date of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: datetime
        """

        result = None

        value = self.date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'date': value }

        
        return result
        

    @date.setter
    def date(self, date):
        """Sets the date of this CompanyInitialPublicOffering.

        The date of the IPO, when the stock first trades on a major exchange  # noqa: E501

        :param date: The date of this CompanyInitialPublicOffering.  # noqa: E501
        :type: datetime
        """

        self._date = date

    @property
    def status(self):
        """Gets the status of this CompanyInitialPublicOffering.  # noqa: E501

        The status of the IPO. Upcoming IPOs have not taken place yet but are expected to. Priced IPOs have taken place. Withdrawn IPOs were expected to take place, but were subsequently withdrawn and did not take place  # noqa: E501

        :return: The status of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: str
        """
        return self._status
        
    @property
    def status_dict(self):
        """Gets the status of this CompanyInitialPublicOffering.  # noqa: E501

        The status of the IPO. Upcoming IPOs have not taken place yet but are expected to. Priced IPOs have taken place. Withdrawn IPOs were expected to take place, but were subsequently withdrawn and did not take place as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The status of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.status
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'status': value }

        
        return result
        

    @status.setter
    def status(self, status):
        """Sets the status of this CompanyInitialPublicOffering.

        The status of the IPO. Upcoming IPOs have not taken place yet but are expected to. Priced IPOs have taken place. Withdrawn IPOs were expected to take place, but were subsequently withdrawn and did not take place  # noqa: E501

        :param status: The status of this CompanyInitialPublicOffering.  # noqa: E501
        :type: str
        """
        allowed_values = ["upcoming", "priced", "withdrawn"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def exchange(self):
        """Gets the exchange of this CompanyInitialPublicOffering.  # noqa: E501

        The acronym of the stock exchange that the company is going to trade publicly on. Typically NYSE or NASDAQ  # noqa: E501

        :return: The exchange of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: str
        """
        return self._exchange
        
    @property
    def exchange_dict(self):
        """Gets the exchange of this CompanyInitialPublicOffering.  # noqa: E501

        The acronym of the stock exchange that the company is going to trade publicly on. Typically NYSE or NASDAQ as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The exchange of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.exchange
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'exchange': value }

        
        return result
        

    @exchange.setter
    def exchange(self, exchange):
        """Sets the exchange of this CompanyInitialPublicOffering.

        The acronym of the stock exchange that the company is going to trade publicly on. Typically NYSE or NASDAQ  # noqa: E501

        :param exchange: The exchange of this CompanyInitialPublicOffering.  # noqa: E501
        :type: str
        """

        self._exchange = exchange

    @property
    def offer_amount(self):
        """Gets the offer_amount of this CompanyInitialPublicOffering.  # noqa: E501

        The total dollar amount of shares offered in the IPO. Typically this is share price * share count  # noqa: E501

        :return: The offer_amount of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._offer_amount
        
    @property
    def offer_amount_dict(self):
        """Gets the offer_amount of this CompanyInitialPublicOffering.  # noqa: E501

        The total dollar amount of shares offered in the IPO. Typically this is share price * share count as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The offer_amount of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.offer_amount
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'offer_amount': value }

        
        return result
        

    @offer_amount.setter
    def offer_amount(self, offer_amount):
        """Sets the offer_amount of this CompanyInitialPublicOffering.

        The total dollar amount of shares offered in the IPO. Typically this is share price * share count  # noqa: E501

        :param offer_amount: The offer_amount of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._offer_amount = offer_amount

    @property
    def share_price(self):
        """Gets the share_price of this CompanyInitialPublicOffering.  # noqa: E501

        The price per share at which the IPO was offered  # noqa: E501

        :return: The share_price of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._share_price
        
    @property
    def share_price_dict(self):
        """Gets the share_price of this CompanyInitialPublicOffering.  # noqa: E501

        The price per share at which the IPO was offered as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The share_price of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.share_price
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'share_price': value }

        
        return result
        

    @share_price.setter
    def share_price(self, share_price):
        """Sets the share_price of this CompanyInitialPublicOffering.

        The price per share at which the IPO was offered  # noqa: E501

        :param share_price: The share_price of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._share_price = share_price

    @property
    def share_price_lowest(self):
        """Gets the share_price_lowest of this CompanyInitialPublicOffering.  # noqa: E501

        The expected lowest price per share at which the IPO will be offered. Before an IPO is priced, companies typically provide a range of prices per share at which they expect to offer the IPO (typically available for upcoming IPOs)  # noqa: E501

        :return: The share_price_lowest of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._share_price_lowest
        
    @property
    def share_price_lowest_dict(self):
        """Gets the share_price_lowest of this CompanyInitialPublicOffering.  # noqa: E501

        The expected lowest price per share at which the IPO will be offered. Before an IPO is priced, companies typically provide a range of prices per share at which they expect to offer the IPO (typically available for upcoming IPOs) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The share_price_lowest of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.share_price_lowest
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'share_price_lowest': value }

        
        return result
        

    @share_price_lowest.setter
    def share_price_lowest(self, share_price_lowest):
        """Sets the share_price_lowest of this CompanyInitialPublicOffering.

        The expected lowest price per share at which the IPO will be offered. Before an IPO is priced, companies typically provide a range of prices per share at which they expect to offer the IPO (typically available for upcoming IPOs)  # noqa: E501

        :param share_price_lowest: The share_price_lowest of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._share_price_lowest = share_price_lowest

    @property
    def share_price_highest(self):
        """Gets the share_price_highest of this CompanyInitialPublicOffering.  # noqa: E501

        The expected highest price per share at which the IPO will be offered. Before an IPO is priced, companies typically provide a range of prices per share at which they expect to offer the IPO (typically available for upcoming IPOs)  # noqa: E501

        :return: The share_price_highest of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._share_price_highest
        
    @property
    def share_price_highest_dict(self):
        """Gets the share_price_highest of this CompanyInitialPublicOffering.  # noqa: E501

        The expected highest price per share at which the IPO will be offered. Before an IPO is priced, companies typically provide a range of prices per share at which they expect to offer the IPO (typically available for upcoming IPOs) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The share_price_highest of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.share_price_highest
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'share_price_highest': value }

        
        return result
        

    @share_price_highest.setter
    def share_price_highest(self, share_price_highest):
        """Sets the share_price_highest of this CompanyInitialPublicOffering.

        The expected highest price per share at which the IPO will be offered. Before an IPO is priced, companies typically provide a range of prices per share at which they expect to offer the IPO (typically available for upcoming IPOs)  # noqa: E501

        :param share_price_highest: The share_price_highest of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._share_price_highest = share_price_highest

    @property
    def share_count(self):
        """Gets the share_count of this CompanyInitialPublicOffering.  # noqa: E501

        The number of shares offered in the IPO  # noqa: E501

        :return: The share_count of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._share_count
        
    @property
    def share_count_dict(self):
        """Gets the share_count of this CompanyInitialPublicOffering.  # noqa: E501

        The number of shares offered in the IPO as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The share_count of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.share_count
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'share_count': value }

        
        return result
        

    @share_count.setter
    def share_count(self, share_count):
        """Sets the share_count of this CompanyInitialPublicOffering.

        The number of shares offered in the IPO  # noqa: E501

        :param share_count: The share_count of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._share_count = share_count

    @property
    def share_count_lowest(self):
        """Gets the share_count_lowest of this CompanyInitialPublicOffering.  # noqa: E501

        The expected lowest number of shares that will be offered in the IPO. Before an IPO is priced, companies typically provide a range of shares that they expect to offer in the IPO (typically available for upcoming IPOs)  # noqa: E501

        :return: The share_count_lowest of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._share_count_lowest
        
    @property
    def share_count_lowest_dict(self):
        """Gets the share_count_lowest of this CompanyInitialPublicOffering.  # noqa: E501

        The expected lowest number of shares that will be offered in the IPO. Before an IPO is priced, companies typically provide a range of shares that they expect to offer in the IPO (typically available for upcoming IPOs) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The share_count_lowest of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.share_count_lowest
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'share_count_lowest': value }

        
        return result
        

    @share_count_lowest.setter
    def share_count_lowest(self, share_count_lowest):
        """Sets the share_count_lowest of this CompanyInitialPublicOffering.

        The expected lowest number of shares that will be offered in the IPO. Before an IPO is priced, companies typically provide a range of shares that they expect to offer in the IPO (typically available for upcoming IPOs)  # noqa: E501

        :param share_count_lowest: The share_count_lowest of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._share_count_lowest = share_count_lowest

    @property
    def share_count_highest(self):
        """Gets the share_count_highest of this CompanyInitialPublicOffering.  # noqa: E501

        The expected highest number of shares that will be offered in the IPO. Before an IPO is priced, companies typically provide a range of shares that they expect to offer in the IPO (typically available for upcoming IPOs)  # noqa: E501

        :return: The share_count_highest of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._share_count_highest
        
    @property
    def share_count_highest_dict(self):
        """Gets the share_count_highest of this CompanyInitialPublicOffering.  # noqa: E501

        The expected highest number of shares that will be offered in the IPO. Before an IPO is priced, companies typically provide a range of shares that they expect to offer in the IPO (typically available for upcoming IPOs) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The share_count_highest of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.share_count_highest
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'share_count_highest': value }

        
        return result
        

    @share_count_highest.setter
    def share_count_highest(self, share_count_highest):
        """Sets the share_count_highest of this CompanyInitialPublicOffering.

        The expected highest number of shares that will be offered in the IPO. Before an IPO is priced, companies typically provide a range of shares that they expect to offer in the IPO (typically available for upcoming IPOs)  # noqa: E501

        :param share_count_highest: The share_count_highest of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._share_count_highest = share_count_highest

    @property
    def announcement_url(self):
        """Gets the announcement_url of this CompanyInitialPublicOffering.  # noqa: E501

        The URL to the company's announcement of the IPO  # noqa: E501

        :return: The announcement_url of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: str
        """
        return self._announcement_url
        
    @property
    def announcement_url_dict(self):
        """Gets the announcement_url of this CompanyInitialPublicOffering.  # noqa: E501

        The URL to the company's announcement of the IPO as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The announcement_url of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.announcement_url
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'announcement_url': value }

        
        return result
        

    @announcement_url.setter
    def announcement_url(self, announcement_url):
        """Sets the announcement_url of this CompanyInitialPublicOffering.

        The URL to the company's announcement of the IPO  # noqa: E501

        :param announcement_url: The announcement_url of this CompanyInitialPublicOffering.  # noqa: E501
        :type: str
        """

        self._announcement_url = announcement_url

    @property
    def sec_report_url(self):
        """Gets the sec_report_url of this CompanyInitialPublicOffering.  # noqa: E501

        The IRL to the company's S-1, S-1/A, F-1, or F-1/A SEC filing, which is required to be filed before an IPO takes place.  # noqa: E501

        :return: The sec_report_url of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: str
        """
        return self._sec_report_url
        
    @property
    def sec_report_url_dict(self):
        """Gets the sec_report_url of this CompanyInitialPublicOffering.  # noqa: E501

        The IRL to the company's S-1, S-1/A, F-1, or F-1/A SEC filing, which is required to be filed before an IPO takes place. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The sec_report_url of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.sec_report_url
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'sec_report_url': value }

        
        return result
        

    @sec_report_url.setter
    def sec_report_url(self, sec_report_url):
        """Sets the sec_report_url of this CompanyInitialPublicOffering.

        The IRL to the company's S-1, S-1/A, F-1, or F-1/A SEC filing, which is required to be filed before an IPO takes place.  # noqa: E501

        :param sec_report_url: The sec_report_url of this CompanyInitialPublicOffering.  # noqa: E501
        :type: str
        """

        self._sec_report_url = sec_report_url

    @property
    def open_price(self):
        """Gets the open_price of this CompanyInitialPublicOffering.  # noqa: E501

        The opening price at the beginning of the first trading day (only available for priced IPOs)  # noqa: E501

        :return: The open_price of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._open_price
        
    @property
    def open_price_dict(self):
        """Gets the open_price of this CompanyInitialPublicOffering.  # noqa: E501

        The opening price at the beginning of the first trading day (only available for priced IPOs) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The open_price of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.open_price
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'open_price': value }

        
        return result
        

    @open_price.setter
    def open_price(self, open_price):
        """Sets the open_price of this CompanyInitialPublicOffering.

        The opening price at the beginning of the first trading day (only available for priced IPOs)  # noqa: E501

        :param open_price: The open_price of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._open_price = open_price

    @property
    def close_price(self):
        """Gets the close_price of this CompanyInitialPublicOffering.  # noqa: E501

        The closing price at the end of the first trading day (only available for priced IPOs)  # noqa: E501

        :return: The close_price of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._close_price
        
    @property
    def close_price_dict(self):
        """Gets the close_price of this CompanyInitialPublicOffering.  # noqa: E501

        The closing price at the end of the first trading day (only available for priced IPOs) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The close_price of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.close_price
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'close_price': value }

        
        return result
        

    @close_price.setter
    def close_price(self, close_price):
        """Sets the close_price of this CompanyInitialPublicOffering.

        The closing price at the end of the first trading day (only available for priced IPOs)  # noqa: E501

        :param close_price: The close_price of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._close_price = close_price

    @property
    def volume(self):
        """Gets the volume of this CompanyInitialPublicOffering.  # noqa: E501

        The volume at the end of the first trading day (only available for priced IPOs)  # noqa: E501

        :return: The volume of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._volume
        
    @property
    def volume_dict(self):
        """Gets the volume of this CompanyInitialPublicOffering.  # noqa: E501

        The volume at the end of the first trading day (only available for priced IPOs) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The volume of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.volume
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'volume': value }

        
        return result
        

    @volume.setter
    def volume(self, volume):
        """Sets the volume of this CompanyInitialPublicOffering.

        The volume at the end of the first trading day (only available for priced IPOs)  # noqa: E501

        :param volume: The volume of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._volume = volume

    @property
    def day_change(self):
        """Gets the day_change of this CompanyInitialPublicOffering.  # noqa: E501

        The percentage change between the open price and the close price on the first trading day (only available for priced IPOs)  # noqa: E501

        :return: The day_change of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._day_change
        
    @property
    def day_change_dict(self):
        """Gets the day_change of this CompanyInitialPublicOffering.  # noqa: E501

        The percentage change between the open price and the close price on the first trading day (only available for priced IPOs) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The day_change of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.day_change
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'day_change': value }

        
        return result
        

    @day_change.setter
    def day_change(self, day_change):
        """Sets the day_change of this CompanyInitialPublicOffering.

        The percentage change between the open price and the close price on the first trading day (only available for priced IPOs)  # noqa: E501

        :param day_change: The day_change of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._day_change = day_change

    @property
    def week_change(self):
        """Gets the week_change of this CompanyInitialPublicOffering.  # noqa: E501

        The percentage change between the open price on the first trading day and the close price approximately a week after the first trading day (only available for priced IPOs)  # noqa: E501

        :return: The week_change of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._week_change
        
    @property
    def week_change_dict(self):
        """Gets the week_change of this CompanyInitialPublicOffering.  # noqa: E501

        The percentage change between the open price on the first trading day and the close price approximately a week after the first trading day (only available for priced IPOs) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The week_change of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.week_change
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'week_change': value }

        
        return result
        

    @week_change.setter
    def week_change(self, week_change):
        """Sets the week_change of this CompanyInitialPublicOffering.

        The percentage change between the open price on the first trading day and the close price approximately a week after the first trading day (only available for priced IPOs)  # noqa: E501

        :param week_change: The week_change of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._week_change = week_change

    @property
    def month_change(self):
        """Gets the month_change of this CompanyInitialPublicOffering.  # noqa: E501

        The percentage change between the open price on the first trading day and the close price approximately a month after the first trading day (only available for priced IPOs)  # noqa: E501

        :return: The month_change of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """
        return self._month_change
        
    @property
    def month_change_dict(self):
        """Gets the month_change of this CompanyInitialPublicOffering.  # noqa: E501

        The percentage change between the open price on the first trading day and the close price approximately a month after the first trading day (only available for priced IPOs) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The month_change of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.month_change
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'month_change': value }

        
        return result
        

    @month_change.setter
    def month_change(self, month_change):
        """Sets the month_change of this CompanyInitialPublicOffering.

        The percentage change between the open price on the first trading day and the close price approximately a month after the first trading day (only available for priced IPOs)  # noqa: E501

        :param month_change: The month_change of this CompanyInitialPublicOffering.  # noqa: E501
        :type: float
        """

        self._month_change = month_change

    @property
    def company(self):
        """Gets the company of this CompanyInitialPublicOffering.  # noqa: E501

        The Company that is going public via the IPO  # noqa: E501

        :return: The company of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: CompanySummary
        """
        return self._company
        
    @property
    def company_dict(self):
        """Gets the company of this CompanyInitialPublicOffering.  # noqa: E501

        The Company that is going public via the IPO as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The company of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: CompanySummary
        """

        result = None

        value = self.company
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'company': value }

        
        return result
        

    @company.setter
    def company(self, company):
        """Sets the company of this CompanyInitialPublicOffering.

        The Company that is going public via the IPO  # noqa: E501

        :param company: The company of this CompanyInitialPublicOffering.  # noqa: E501
        :type: CompanySummary
        """

        self._company = company

    @property
    def security(self):
        """Gets the security of this CompanyInitialPublicOffering.  # noqa: E501

        The primary Security for the Company that is going public via the IPO  # noqa: E501

        :return: The security of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: SecuritySummary
        """
        return self._security
        
    @property
    def security_dict(self):
        """Gets the security of this CompanyInitialPublicOffering.  # noqa: E501

        The primary Security for the Company that is going public via the IPO as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The security of this CompanyInitialPublicOffering.  # noqa: E501
        :rtype: SecuritySummary
        """

        result = None

        value = self.security
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'security': value }

        
        return result
        

    @security.setter
    def security(self, security):
        """Sets the security of this CompanyInitialPublicOffering.

        The primary Security for the Company that is going public via the IPO  # noqa: E501

        :param security: The security of this CompanyInitialPublicOffering.  # noqa: E501
        :type: SecuritySummary
        """

        self._security = security

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CompanyInitialPublicOffering):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
