# SPDX-FileCopyrightText: 2024-present Marceau <git@marceau-h.fr>
#
# SPDX-License-Identifier: AGPL-3.0-or-later
from camel2karam.converters.base_converter import PartsMapping
from camel2karam.converters.csv2connlu import Csv2Connlu
from camel2karam.converters.csvsent2csvtok import CsvSent2CsvTok
from camel2karam.converters.csvsent2onelettertag import CsvSent2OneLetterTag
from camel2karam.converters.csvtok2csvsent import CsvTok2CsvSent
from camel2karam.converters.jsonl2connlu import Jsonl2Connlu
from camel2karam.converters.jsonl2csv import Jsonl2Csv
from camel2karam.converters.jsonl2xml import Jsonl2Xml
from camel2karam.converters.tagset_convert import TagsetConvert


__all__ = [
    "PartsMapping",
    "Csv2Connlu",
    "CsvSent2CsvTok",
    "CsvSent2OneLetterTag",
    "CsvTok2CsvSent",
    "Jsonl2Connlu",
    "Jsonl2Csv",
    "Jsonl2Xml",
    "TagsetConvert",
]

from importlib import metadata
for dist in metadata.distributions():
    if dist.metadata["Name"] == "webanno_tsv":
        from camel2karam.converters.jsonl2webanno import Jsonl2WebAnno
        __all__.append("Jsonl2WebAnno")

        break
    else:
        print("""\
The `webanno_tsv` package is not installed. The `Jsonl2WebAnno` converter will not be available.
You can install it by running `pip install git+https://github.com/neuged/webanno_tsv.git`.""")
