"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const worker_threads_1 = require("worker_threads");
// https://giuseppegurgone.com/synchronizing-async-functions/
worker_threads_1.parentPort?.addListener('message', async ({ signal, port, args }) => {
    const file = args[args.length - 1];
    console.log(`Class file to use: ${file}`);
    const className = args[args.length - 2];
    // eslint-disable-next-line
    const asyncProcess = require(file);
    console.log(`Class file loaded: ${file}`);
    // This is the async function that we want to run "synchronously"
    const result = await new asyncProcess[className]().runAsync(args.slice(0, args.length - 2));
    // Post the result to the main thread before unlocking "signal"
    port.postMessage({ result });
    port.close();
    // Change the value of signal[0] to 1
    Atomics.store(signal, 0, 1);
    // This will unlock the main thread when we notify it
    Atomics.notify(signal, 0, Infinity);
});
//# sourceMappingURL=data:application/json;base64,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