"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeLambdaFunctionSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const data_utils_1 = require("../../utils/data-utils");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
const aws_service_1 = require("../../domain/aws-service");
/**
 * AutomationStep implemenation for aws:invokeLambdaFunction
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-lamb.html
 */
class InvokeLambdaFunctionSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:invokeLambdaFunction';
        this.invokeLambdaFunctionStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        const inputMap = this.invokeLambdaFunctionStep.formatInputMap();
        const stepInputs = prune_and_transform_record_1.pruneAndTransformRecord(inputMap, x => x.resolve(inputs));
        stepInputs.InvocationType = stepInputs.InvocationType ?? 'RequestResponse';
        stepInputs.LogType = stepInputs.LogType ?? 'Tail';
        if (stepInputs.Payload) {
            stepInputs.Payload = JSON.stringify(stepInputs.Payload);
        }
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'invokeLambda', {
            service: aws_service_1.AwsService.LAMBDA,
            pascalCaseApi: 'Invoke',
            apiParams: stepInputs,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING_MAP,
                    name: 'result',
                    selector: '$',
                }],
        }), this.props).invoke({});
        if (result.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Invoke lambda failed for ${inputMap.FunctionName}: ${result.stackTrace}`);
        }
        return {
            StatusCode: result.outputs?.['invokeLambda.result'].StatusCode,
            FunctionError: result.outputs?.['invokeLambda.result'].FunctionError ?? null,
            LogResult: data_utils_1.decodeBase64String(result.outputs?.['invokeLambda.result'].LogResult),
            Payload: data_utils_1.stripBeginAndEndQuotes(result.outputs?.['invokeLambda.result'].Payload),
        };
    }
}
exports.InvokeLambdaFunctionSimulation = InvokeLambdaFunctionSimulation;
_a = JSII_RTTI_SYMBOL_1;
InvokeLambdaFunctionSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.InvokeLambdaFunctionSimulation", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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