"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BranchSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const non_retriable_exception_1 = require("../../domain/non-retriable-exception");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation of aws:branch
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-branch.html
 */
class BranchSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step) {
        super(step);
        this.action = 'aws:branch';
        this.branchStep = step;
    }
    /**
       * Overrides invoke because control flow of execution is different than standard steps.
       * Will traverse the choices until one evaluated to true; will skip to that choice.
       */
    nextStep(inputs) {
        const matchedChoice = this.branchStep.choices.find(choice => choice.evaluate(inputs));
        if (matchedChoice == undefined) {
            console.log(`Did not find matching choice to branch to. Will proceed to ${this.getFallbackStep().name}`);
            return this.getFallbackStep();
        }
        else {
            console.log(`Identified a branch that matched evaluation. Will proceed to ${matchedChoice.jumpToStepName}`);
            return this.findStep(matchedChoice.jumpToStepName);
        }
    }
    findStep(name) {
        const matchedSteps = this.branchStep.allStepsInExecution?.filter(step => step.name == name);
        if (matchedSteps?.length != 1) {
            throw new non_retriable_exception_1.NonRetriableException('No branchStep found to match branchStep name: ' + name);
        }
        return matchedSteps[0];
    }
    getFallbackStep() {
        const fallbackStep = this.branchStep.defaultStepName ? this.findStep(this.branchStep.defaultStepName) : this.branchStep.nextStep;
        if (fallbackStep == undefined) {
            throw new non_retriable_exception_1.NonRetriableException('No default or next branchStep provided for branch branchStep!');
        }
        return fallbackStep;
    }
    /**
       * noop. The logic performed in the branch branchStep happens in the invoke() function.
       */
    executeStep(_inputs) {
        // unused
        return {};
    }
}
exports.BranchSimulation = BranchSimulation;
_a = JSII_RTTI_SYMBOL_1;
BranchSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.BranchSimulation", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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