"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateStackStep = exports.OnFailureVariable = exports.HardCodedOnFailure = exports.BodyOrUrlType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const string_variable_1 = require("../../interface/variables/string-variable");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
var BodyOrUrlType;
(function (BodyOrUrlType) {
    BodyOrUrlType[BodyOrUrlType["BODY"] = 0] = "BODY";
    BodyOrUrlType[BodyOrUrlType["URL"] = 1] = "URL";
})(BodyOrUrlType = exports.BodyOrUrlType || (exports.BodyOrUrlType = {}));
class HardCodedOnFailure extends string_variable_1.HardCodedString {
    constructor(val) {
        super(val);
    }
}
exports.HardCodedOnFailure = HardCodedOnFailure;
_a = JSII_RTTI_SYMBOL_1;
HardCodedOnFailure[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HardCodedOnFailure", version: "0.0.32" };
HardCodedOnFailure.DO_NOTHING = new HardCodedOnFailure('DO_NOTHING');
HardCodedOnFailure.ROLLBACK = new HardCodedOnFailure('ROLLBACK');
HardCodedOnFailure.DELETE = new HardCodedOnFailure('DELETE');
class OnFailureVariable extends string_variable_1.StringVariable {
    constructor() {
        super(...arguments);
        this.validValues = ['DO_NOTHING', 'ROLLBACK', 'DELETE'];
    }
    assertType(value) {
        string_variable_1.assertString(value);
        if (!this.validValues.includes(value)) {
            throw new Error(`${value} is not a valid enum value`);
        }
    }
}
exports.OnFailureVariable = OnFailureVariable;
_b = JSII_RTTI_SYMBOL_1;
OnFailureVariable[_b] = { fqn: "@cdklabs/cdk-ssm-documents.OnFailureVariable", version: "0.0.32" };
/**
 * AutomationStep implementation for aws:createStack
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-createstack.html
 */
class CreateStackStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:createStack';
        this.stackName = props.stackName;
        this.capabilities = props.capabilities;
        this.clientRequestToken = props.clientRequestToken;
        this.onStackFailure = props.onStackFailure;
        this.notificationARNs = props.notificationARNs;
        this.parameters = props.parameters;
        this.resourceTypes = props.resourceTypes;
        this.roleArn = props.roleArn;
        if (props.stackPolicy?.propType === BodyOrUrlType.BODY) {
            this.stackPolicyBody = props.stackPolicy.value;
        }
        else {
            this.stackPolicyUrl = props.stackPolicy?.value;
        }
        this.tags = props.tags;
        if (props.template.propType === BodyOrUrlType.BODY) {
            this.templateBody = props.template.value;
        }
        else {
            this.templateUrl = props.template.value;
        }
        this.timeoutInMinutes = props.timeoutInMinutes;
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'StackId',
                selector: '$.StackId',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'StackStatus',
                selector: '$.StackStatus',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'StackStatusReason',
                selector: '$.StackStatusReason',
            }];
    }
    listInputs() {
        const inputs = [
            this.stackName,
            this.capabilities,
            this.clientRequestToken,
            this.notificationARNs,
            this.onStackFailure,
            this.parameters,
            this.resourceTypes,
            this.roleArn,
            this.stackPolicyBody,
            this.stackPolicyUrl,
            this.tags,
            this.templateBody,
            this.templateUrl,
            this.timeoutInMinutes,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        return super.prepareSsmEntry(prune_and_transform_record_1.pruneAndTransformRecord({
            StackName: this.stackName,
            Capabilities: this.capabilities,
            ClientRequestToken: this.clientRequestToken,
            NotificationARNs: this.notificationARNs,
            OnFailure: this.onStackFailure,
            Parameters: this.parameters,
            ResourceTypes: this.resourceTypes,
            RoleARN: this.roleArn,
            StackPolicyBody: this.stackPolicyBody,
            StackPolicyURL: this.stackPolicyUrl,
            Tags: this.tags,
            TemplateBody: this.templateBody,
            TemplateURL: this.templateUrl,
            TimeoutInMinutes: this.timeoutInMinutes,
        }, x => x.print()));
    }
}
exports.CreateStackStep = CreateStackStep;
_c = JSII_RTTI_SYMBOL_1;
CreateStackStep[_c] = { fqn: "@cdklabs/cdk-ssm-documents.CreateStackStep", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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