"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BranchStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation of aws:branch
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-branch.html
 */
class BranchStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:branch';
        this.choices = props.choices;
        this.defaultStepName = props.defaultStepName;
    }
    /**
       * There is no output from branch steps.
       * @returns empty list
       */
    listOutputs() {
        return [];
    }
    /**
       * @returns all of the inputsToTest from the choices provided to the constructor
       */
    listInputs() {
        return [...new Set(this.choices
                .flatMap(choice => choice.variable.requiredInputs()))];
    }
    toSsmEntry() {
        const choicesInputs = { Choices: this.choices.map(choice => choice.asSsmEntry()) };
        if (this.defaultStepName) {
            choicesInputs.Default = this.defaultStepName;
        }
        return super.prepareSsmEntry(choicesInputs);
    }
}
exports.BranchStep = BranchStep;
_a = JSII_RTTI_SYMBOL_1;
BranchStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.BranchStep", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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