"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from datetime import date, datetime
from typing import Any, List, Union, Literal
from typing_extensions import TypedDict, NotRequired

from pydantic import Extra, Field, BaseModel

from githubkit.utils import UNSET, Unset


class RootType(TypedDict):
    """Root"""

    current_user_url: str
    current_user_authorizations_html_url: str
    authorizations_url: str
    code_search_url: str
    commit_search_url: str
    emails_url: str
    emojis_url: str
    events_url: str
    feeds_url: str
    followers_url: str
    following_url: str
    gists_url: str
    hub_url: str
    issue_search_url: str
    issues_url: str
    keys_url: str
    label_search_url: str
    notifications_url: str
    organization_url: str
    organization_repositories_url: str
    organization_teams_url: str
    public_gists_url: str
    rate_limit_url: str
    repository_url: str
    repository_search_url: str
    current_user_repositories_url: str
    starred_url: str
    starred_gists_url: str
    topic_search_url: NotRequired[Union[Unset, str]]
    user_url: str
    user_organizations_url: str
    user_repositories_url: str
    user_search_url: str


class SimpleUserType(TypedDict):
    """Simple User

    Simple User
    """

    name: NotRequired[Union[Unset, Union[str, None]]]
    email: NotRequired[Union[Unset, Union[str, None]]]
    login: str
    id: int
    node_id: str
    avatar_url: str
    gravatar_id: Union[str, None]
    url: str
    html_url: str
    followers_url: str
    following_url: str
    gists_url: str
    starred_url: str
    subscriptions_url: str
    organizations_url: str
    repos_url: str
    events_url: str
    received_events_url: str
    type: str
    site_admin: bool
    starred_at: NotRequired[Union[Unset, str]]


class IntegrationType(TypedDict):
    """GitHub app

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    id: int
    slug: NotRequired[Union[Unset, str]]
    node_id: str
    owner: Union[None, SimpleUserType]
    name: str
    description: Union[str, None]
    external_url: str
    html_url: str
    created_at: datetime
    updated_at: datetime
    permissions: IntegrationPropPermissionsType
    events: List[str]
    installations_count: NotRequired[Union[Unset, int]]
    client_id: NotRequired[Union[Unset, str]]
    client_secret: NotRequired[Union[Unset, str]]
    webhook_secret: NotRequired[Union[Unset, Union[str, None]]]
    pem: NotRequired[Union[Unset, str]]


class IntegrationPropPermissionsType(TypedDict):
    """IntegrationPropPermissions

    The set of permissions for the GitHub app

    Examples:
        {'issues': 'read', 'deployments': 'write'}
    """

    issues: NotRequired[Union[Unset, str]]
    checks: NotRequired[Union[Unset, str]]
    metadata: NotRequired[Union[Unset, str]]
    contents: NotRequired[Union[Unset, str]]
    deployments: NotRequired[Union[Unset, str]]


class BasicErrorType(TypedDict):
    """Basic Error

    Basic Error
    """

    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    status: NotRequired[Union[Unset, str]]


class ValidationErrorSimpleType(TypedDict):
    """Validation Error Simple

    Validation Error Simple
    """

    message: str
    documentation_url: str
    errors: NotRequired[Union[Unset, List[str]]]


class WebhookConfigType(TypedDict):
    """Webhook Configuration

    Configuration object of the webhook
    """

    url: NotRequired[Union[Unset, str]]
    content_type: NotRequired[Union[Unset, str]]
    secret: NotRequired[Union[Unset, str]]
    insecure_ssl: NotRequired[Union[Unset, Union[str, float]]]


class HookDeliveryItemType(TypedDict):
    """Simple webhook delivery

    Delivery made by a webhook, without request and response information.
    """

    id: int
    guid: str
    delivered_at: datetime
    redelivery: bool
    duration: float
    status: str
    status_code: int
    event: str
    action: Union[str, None]
    installation_id: Union[int, None]
    repository_id: Union[int, None]


class ScimErrorType(TypedDict):
    """Scim Error

    Scim Error
    """

    message: NotRequired[Union[Unset, Union[str, None]]]
    documentation_url: NotRequired[Union[Unset, Union[str, None]]]
    detail: NotRequired[Union[Unset, Union[str, None]]]
    status: NotRequired[Union[Unset, int]]
    scim_type: NotRequired[Union[Unset, Union[str, None]]]
    schemas: NotRequired[Union[Unset, List[str]]]


class ValidationErrorType(TypedDict):
    """Validation Error

    Validation Error
    """

    message: str
    documentation_url: str
    errors: NotRequired[Union[Unset, List[ValidationErrorPropErrorsItemsType]]]


class ValidationErrorPropErrorsItemsType(TypedDict):
    """ValidationErrorPropErrorsItems"""

    resource: NotRequired[Union[Unset, str]]
    field: NotRequired[Union[Unset, str]]
    message: NotRequired[Union[Unset, str]]
    code: str
    index: NotRequired[Union[Unset, int]]
    value: NotRequired[
        Union[Unset, Union[Union[str, None], Union[int, None], Union[List[str], None]]]
    ]


class HookDeliveryType(TypedDict):
    """Webhook delivery

    Delivery made by a webhook.
    """

    id: int
    guid: str
    delivered_at: datetime
    redelivery: bool
    duration: float
    status: str
    status_code: int
    event: str
    action: Union[str, None]
    installation_id: Union[int, None]
    repository_id: Union[int, None]
    url: NotRequired[Union[Unset, str]]
    request: HookDeliveryPropRequestType
    response: HookDeliveryPropResponseType


class HookDeliveryPropRequestType(TypedDict):
    """HookDeliveryPropRequest"""

    headers: Union[HookDeliveryPropRequestPropHeadersType, None]
    payload: Union[HookDeliveryPropRequestPropPayloadType, None]


class HookDeliveryPropRequestPropHeadersType(TypedDict):
    """HookDeliveryPropRequestPropHeaders

    The request headers sent with the webhook delivery.
    """


class HookDeliveryPropRequestPropPayloadType(TypedDict):
    """HookDeliveryPropRequestPropPayload

    The webhook payload.
    """


class HookDeliveryPropResponseType(TypedDict):
    """HookDeliveryPropResponse"""

    headers: Union[HookDeliveryPropResponsePropHeadersType, None]
    payload: Union[str, None]


class HookDeliveryPropResponsePropHeadersType(TypedDict):
    """HookDeliveryPropResponsePropHeaders

    The response headers received when the delivery was made.
    """


class EnterpriseType(TypedDict):
    """Enterprise

    An enterprise account
    """

    description: NotRequired[Union[Unset, Union[str, None]]]
    html_url: str
    website_url: NotRequired[Union[Unset, Union[str, None]]]
    id: int
    node_id: str
    name: str
    slug: str
    created_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    avatar_url: str


class AppPermissionsType(TypedDict):
    """App Permissions

        The permissions granted to the user-to-server access token.

        Examples:
            {'contents': 'read', 'issues': 'read', 'deployments': 'write', 'single_file':
    'read'}
    """

    actions: NotRequired[Union[Unset, Literal["read", "write"]]]
    administration: NotRequired[Union[Unset, Literal["read", "write"]]]
    checks: NotRequired[Union[Unset, Literal["read", "write"]]]
    contents: NotRequired[Union[Unset, Literal["read", "write"]]]
    deployments: NotRequired[Union[Unset, Literal["read", "write"]]]
    environments: NotRequired[Union[Unset, Literal["read", "write"]]]
    issues: NotRequired[Union[Unset, Literal["read", "write"]]]
    metadata: NotRequired[Union[Unset, Literal["read", "write"]]]
    packages: NotRequired[Union[Unset, Literal["read", "write"]]]
    pages: NotRequired[Union[Unset, Literal["read", "write"]]]
    pull_requests: NotRequired[Union[Unset, Literal["read", "write"]]]
    repository_hooks: NotRequired[Union[Unset, Literal["read", "write"]]]
    repository_projects: NotRequired[Union[Unset, Literal["read", "write", "admin"]]]
    secret_scanning_alerts: NotRequired[Union[Unset, Literal["read", "write"]]]
    secrets: NotRequired[Union[Unset, Literal["read", "write"]]]
    security_events: NotRequired[Union[Unset, Literal["read", "write"]]]
    single_file: NotRequired[Union[Unset, Literal["read", "write"]]]
    statuses: NotRequired[Union[Unset, Literal["read", "write"]]]
    vulnerability_alerts: NotRequired[Union[Unset, Literal["read", "write"]]]
    workflows: NotRequired[Union[Unset, Literal["write"]]]
    members: NotRequired[Union[Unset, Literal["read", "write"]]]
    organization_administration: NotRequired[Union[Unset, Literal["read", "write"]]]
    organization_hooks: NotRequired[Union[Unset, Literal["read", "write"]]]
    organization_plan: NotRequired[Union[Unset, Literal["read"]]]
    organization_projects: NotRequired[Union[Unset, Literal["read", "write", "admin"]]]
    organization_packages: NotRequired[Union[Unset, Literal["read", "write"]]]
    organization_secrets: NotRequired[Union[Unset, Literal["read", "write"]]]
    organization_self_hosted_runners: NotRequired[
        Union[Unset, Literal["read", "write"]]
    ]
    organization_user_blocking: NotRequired[Union[Unset, Literal["read", "write"]]]
    team_discussions: NotRequired[Union[Unset, Literal["read", "write"]]]


class InstallationType(TypedDict):
    """Installation

    Installation
    """

    id: int
    account: Union[None, InstallationPropAccountType, SimpleUserType, EnterpriseType]
    repository_selection: Literal["all", "selected"]
    access_tokens_url: str
    repositories_url: str
    html_url: str
    app_id: int
    target_id: int
    target_type: str
    permissions: AppPermissionsType
    events: List[str]
    created_at: datetime
    updated_at: datetime
    single_file_name: Union[str, None]
    has_multiple_single_files: NotRequired[Union[Unset, bool]]
    single_file_paths: NotRequired[Union[Unset, List[str]]]
    app_slug: str
    suspended_by: Union[None, SimpleUserType]
    suspended_at: Union[datetime, None]
    contact_email: NotRequired[Union[Unset, Union[str, None]]]


class InstallationPropAccountType(TypedDict):
    """InstallationPropAccount"""


class LicenseSimpleType(TypedDict):
    """License Simple

    License Simple
    """

    key: str
    name: str
    url: Union[str, None]
    spdx_id: Union[str, None]
    node_id: str
    html_url: NotRequired[Union[Unset, str]]


class RepositoryType(TypedDict):
    """Repository

    A git repository
    """

    id: int
    node_id: str
    name: str
    full_name: str
    license_: Union[None, LicenseSimpleType]
    organization: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    forks: int
    permissions: NotRequired[Union[Unset, RepositoryPropPermissionsType]]
    owner: SimpleUserType
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    downloads_url: str
    events_url: str
    forks_url: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    notifications_url: str
    pulls_url: str
    releases_url: str
    ssh_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    clone_url: str
    mirror_url: Union[str, None]
    hooks_url: str
    svn_url: str
    homepage: Union[str, None]
    language: Union[str, None]
    forks_count: int
    stargazers_count: int
    watchers_count: int
    size: int
    default_branch: str
    open_issues_count: int
    is_template: NotRequired[Union[Unset, bool]]
    topics: NotRequired[Union[Unset, List[str]]]
    has_issues: bool
    has_projects: bool
    has_wiki: bool
    has_pages: bool
    has_downloads: bool
    archived: bool
    disabled: bool
    visibility: NotRequired[Union[Unset, str]]
    pushed_at: Union[datetime, None]
    created_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    allow_rebase_merge: NotRequired[Union[Unset, bool]]
    template_repository: NotRequired[
        Union[Unset, Union[RepositoryPropTemplateRepositoryType, None]]
    ]
    temp_clone_token: NotRequired[Union[Unset, str]]
    allow_squash_merge: NotRequired[Union[Unset, bool]]
    allow_auto_merge: NotRequired[Union[Unset, bool]]
    delete_branch_on_merge: NotRequired[Union[Unset, bool]]
    allow_update_branch: NotRequired[Union[Unset, bool]]
    use_squash_pr_title_as_default: NotRequired[Union[Unset, bool]]
    allow_merge_commit: NotRequired[Union[Unset, bool]]
    allow_forking: NotRequired[Union[Unset, bool]]
    subscribers_count: NotRequired[Union[Unset, int]]
    network_count: NotRequired[Union[Unset, int]]
    open_issues: int
    watchers: int
    master_branch: NotRequired[Union[Unset, str]]
    starred_at: NotRequired[Union[Unset, str]]


class RepositoryPropPermissionsType(TypedDict):
    """RepositoryPropPermissions"""

    admin: bool
    pull: bool
    triage: NotRequired[Union[Unset, bool]]
    push: bool
    maintain: NotRequired[Union[Unset, bool]]


class RepositoryPropTemplateRepositoryType(TypedDict):
    """RepositoryPropTemplateRepository"""

    id: NotRequired[Union[Unset, int]]
    node_id: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    full_name: NotRequired[Union[Unset, str]]
    owner: NotRequired[Union[Unset, RepositoryPropTemplateRepositoryPropOwnerType]]
    private: NotRequired[Union[Unset, bool]]
    html_url: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, str]]
    fork: NotRequired[Union[Unset, bool]]
    url: NotRequired[Union[Unset, str]]
    archive_url: NotRequired[Union[Unset, str]]
    assignees_url: NotRequired[Union[Unset, str]]
    blobs_url: NotRequired[Union[Unset, str]]
    branches_url: NotRequired[Union[Unset, str]]
    collaborators_url: NotRequired[Union[Unset, str]]
    comments_url: NotRequired[Union[Unset, str]]
    commits_url: NotRequired[Union[Unset, str]]
    compare_url: NotRequired[Union[Unset, str]]
    contents_url: NotRequired[Union[Unset, str]]
    contributors_url: NotRequired[Union[Unset, str]]
    deployments_url: NotRequired[Union[Unset, str]]
    downloads_url: NotRequired[Union[Unset, str]]
    events_url: NotRequired[Union[Unset, str]]
    forks_url: NotRequired[Union[Unset, str]]
    git_commits_url: NotRequired[Union[Unset, str]]
    git_refs_url: NotRequired[Union[Unset, str]]
    git_tags_url: NotRequired[Union[Unset, str]]
    git_url: NotRequired[Union[Unset, str]]
    issue_comment_url: NotRequired[Union[Unset, str]]
    issue_events_url: NotRequired[Union[Unset, str]]
    issues_url: NotRequired[Union[Unset, str]]
    keys_url: NotRequired[Union[Unset, str]]
    labels_url: NotRequired[Union[Unset, str]]
    languages_url: NotRequired[Union[Unset, str]]
    merges_url: NotRequired[Union[Unset, str]]
    milestones_url: NotRequired[Union[Unset, str]]
    notifications_url: NotRequired[Union[Unset, str]]
    pulls_url: NotRequired[Union[Unset, str]]
    releases_url: NotRequired[Union[Unset, str]]
    ssh_url: NotRequired[Union[Unset, str]]
    stargazers_url: NotRequired[Union[Unset, str]]
    statuses_url: NotRequired[Union[Unset, str]]
    subscribers_url: NotRequired[Union[Unset, str]]
    subscription_url: NotRequired[Union[Unset, str]]
    tags_url: NotRequired[Union[Unset, str]]
    teams_url: NotRequired[Union[Unset, str]]
    trees_url: NotRequired[Union[Unset, str]]
    clone_url: NotRequired[Union[Unset, str]]
    mirror_url: NotRequired[Union[Unset, str]]
    hooks_url: NotRequired[Union[Unset, str]]
    svn_url: NotRequired[Union[Unset, str]]
    homepage: NotRequired[Union[Unset, str]]
    language: NotRequired[Union[Unset, str]]
    forks_count: NotRequired[Union[Unset, int]]
    stargazers_count: NotRequired[Union[Unset, int]]
    watchers_count: NotRequired[Union[Unset, int]]
    size: NotRequired[Union[Unset, int]]
    default_branch: NotRequired[Union[Unset, str]]
    open_issues_count: NotRequired[Union[Unset, int]]
    is_template: NotRequired[Union[Unset, bool]]
    topics: NotRequired[Union[Unset, List[str]]]
    has_issues: NotRequired[Union[Unset, bool]]
    has_projects: NotRequired[Union[Unset, bool]]
    has_wiki: NotRequired[Union[Unset, bool]]
    has_pages: NotRequired[Union[Unset, bool]]
    has_downloads: NotRequired[Union[Unset, bool]]
    archived: NotRequired[Union[Unset, bool]]
    disabled: NotRequired[Union[Unset, bool]]
    visibility: NotRequired[Union[Unset, str]]
    pushed_at: NotRequired[Union[Unset, str]]
    created_at: NotRequired[Union[Unset, str]]
    updated_at: NotRequired[Union[Unset, str]]
    permissions: NotRequired[
        Union[Unset, RepositoryPropTemplateRepositoryPropPermissionsType]
    ]
    allow_rebase_merge: NotRequired[Union[Unset, bool]]
    temp_clone_token: NotRequired[Union[Unset, str]]
    allow_squash_merge: NotRequired[Union[Unset, bool]]
    allow_auto_merge: NotRequired[Union[Unset, bool]]
    delete_branch_on_merge: NotRequired[Union[Unset, bool]]
    allow_update_branch: NotRequired[Union[Unset, bool]]
    use_squash_pr_title_as_default: NotRequired[Union[Unset, bool]]
    allow_merge_commit: NotRequired[Union[Unset, bool]]
    subscribers_count: NotRequired[Union[Unset, int]]
    network_count: NotRequired[Union[Unset, int]]


class RepositoryPropTemplateRepositoryPropOwnerType(TypedDict):
    """RepositoryPropTemplateRepositoryPropOwner"""

    login: NotRequired[Union[Unset, str]]
    id: NotRequired[Union[Unset, int]]
    node_id: NotRequired[Union[Unset, str]]
    avatar_url: NotRequired[Union[Unset, str]]
    gravatar_id: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    followers_url: NotRequired[Union[Unset, str]]
    following_url: NotRequired[Union[Unset, str]]
    gists_url: NotRequired[Union[Unset, str]]
    starred_url: NotRequired[Union[Unset, str]]
    subscriptions_url: NotRequired[Union[Unset, str]]
    organizations_url: NotRequired[Union[Unset, str]]
    repos_url: NotRequired[Union[Unset, str]]
    events_url: NotRequired[Union[Unset, str]]
    received_events_url: NotRequired[Union[Unset, str]]
    type: NotRequired[Union[Unset, str]]
    site_admin: NotRequired[Union[Unset, bool]]


class RepositoryPropTemplateRepositoryPropPermissionsType(TypedDict):
    """RepositoryPropTemplateRepositoryPropPermissions"""

    admin: NotRequired[Union[Unset, bool]]
    maintain: NotRequired[Union[Unset, bool]]
    push: NotRequired[Union[Unset, bool]]
    triage: NotRequired[Union[Unset, bool]]
    pull: NotRequired[Union[Unset, bool]]


class InstallationTokenType(TypedDict):
    """Installation Token

    Authentication token for a GitHub App installed on a user or org.
    """

    token: str
    expires_at: str
    permissions: NotRequired[Union[Unset, AppPermissionsType]]
    repository_selection: NotRequired[Union[Unset, Literal["all", "selected"]]]
    repositories: NotRequired[Union[Unset, List[RepositoryType]]]
    single_file: NotRequired[Union[Unset, str]]
    has_multiple_single_files: NotRequired[Union[Unset, bool]]
    single_file_paths: NotRequired[Union[Unset, List[str]]]


class ApplicationGrantType(TypedDict):
    """Application Grant

    The authorization associated with an OAuth Access.
    """

    id: int
    url: str
    app: ApplicationGrantPropAppType
    created_at: datetime
    updated_at: datetime
    scopes: List[str]
    user: NotRequired[Union[Unset, Union[None, SimpleUserType]]]


class ApplicationGrantPropAppType(TypedDict):
    """ApplicationGrantPropApp"""

    client_id: str
    name: str
    url: str


class ScopedInstallationType(TypedDict):
    """Scoped Installation"""

    permissions: AppPermissionsType
    repository_selection: Literal["all", "selected"]
    single_file_name: Union[str, None]
    has_multiple_single_files: NotRequired[Union[Unset, bool]]
    single_file_paths: NotRequired[Union[Unset, List[str]]]
    repositories_url: str
    account: SimpleUserType


class AuthorizationType(TypedDict):
    """Authorization

    The authorization for an OAuth app, GitHub App, or a Personal Access Token.
    """

    id: int
    url: str
    scopes: Union[List[str], None]
    token: str
    token_last_eight: Union[str, None]
    hashed_token: Union[str, None]
    app: AuthorizationPropAppType
    note: Union[str, None]
    note_url: Union[str, None]
    updated_at: datetime
    created_at: datetime
    fingerprint: Union[str, None]
    user: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    installation: NotRequired[Union[Unset, Union[None, ScopedInstallationType]]]
    expires_at: Union[datetime, None]


class AuthorizationPropAppType(TypedDict):
    """AuthorizationPropApp"""

    client_id: str
    name: str
    url: str


class CodeOfConductType(TypedDict):
    """Code Of Conduct

    Code Of Conduct
    """

    key: str
    name: str
    url: str
    body: NotRequired[Union[Unset, str]]
    html_url: Union[str, None]


class ActionsCacheUsageOrgEnterpriseType(TypedDict):
    """ActionsCacheUsageOrgEnterprise"""

    total_active_caches_count: int
    total_active_caches_size_in_bytes: int


class ActionsOidcCustomIssuerPolicyForEnterpriseType(TypedDict):
    """ActionsOidcCustomIssuerPolicyForEnterprise"""

    include_enterprise_slug: NotRequired[Union[Unset, bool]]


class ActionsEnterprisePermissionsType(TypedDict):
    """ActionsEnterprisePermissions"""

    enabled_organizations: Literal["all", "none", "selected"]
    selected_organizations_url: NotRequired[Union[Unset, str]]
    allowed_actions: NotRequired[Union[Unset, Literal["all", "local_only", "selected"]]]
    selected_actions_url: NotRequired[Union[Unset, str]]


class OrganizationSimpleType(TypedDict):
    """Organization Simple

    Organization Simple
    """

    login: str
    id: int
    node_id: str
    url: str
    repos_url: str
    events_url: str
    hooks_url: str
    issues_url: str
    members_url: str
    public_members_url: str
    avatar_url: str
    description: Union[str, None]


class SelectedActionsType(TypedDict):
    """SelectedActions"""

    github_owned_allowed: NotRequired[Union[Unset, bool]]
    verified_allowed: NotRequired[Union[Unset, bool]]
    patterns_allowed: NotRequired[Union[Unset, List[str]]]


class ActionsGetDefaultWorkflowPermissionsType(TypedDict):
    """ActionsGetDefaultWorkflowPermissions"""

    default_workflow_permissions: Literal["read", "write"]
    can_approve_pull_request_reviews: bool


class ActionsSetDefaultWorkflowPermissionsType(TypedDict):
    """ActionsSetDefaultWorkflowPermissions"""

    default_workflow_permissions: NotRequired[Union[Unset, Literal["read", "write"]]]
    can_approve_pull_request_reviews: NotRequired[Union[Unset, bool]]


class RunnerGroupsEnterpriseType(TypedDict):
    """RunnerGroupsEnterprise"""

    id: float
    name: str
    visibility: str
    default: bool
    selected_organizations_url: NotRequired[Union[Unset, str]]
    runners_url: str
    allows_public_repositories: bool
    workflow_restrictions_read_only: NotRequired[Union[Unset, bool]]
    restricted_to_workflows: NotRequired[Union[Unset, bool]]
    selected_workflows: NotRequired[Union[Unset, List[str]]]


class RunnerLabelType(TypedDict):
    """Self hosted runner label

    A label for a self hosted runner
    """

    id: NotRequired[Union[Unset, int]]
    name: str
    type: NotRequired[Union[Unset, Literal["read-only", "custom"]]]


class RunnerType(TypedDict):
    """Self hosted runners

    A self hosted runner
    """

    id: int
    name: str
    os: str
    status: str
    busy: bool
    labels: List[RunnerLabelType]


class RunnerApplicationType(TypedDict):
    """Runner Application

    Runner Application
    """

    os: str
    architecture: str
    download_url: str
    filename: str
    temp_download_token: NotRequired[Union[Unset, str]]
    sha256_checksum: NotRequired[Union[Unset, str]]


class AuthenticationTokenType(TypedDict):
    """Authentication Token

    Authentication Token
    """

    token: str
    expires_at: datetime
    permissions: NotRequired[Union[Unset, AuthenticationTokenPropPermissionsType]]
    repositories: NotRequired[Union[Unset, List[RepositoryType]]]
    single_file: NotRequired[Union[Unset, Union[str, None]]]
    repository_selection: NotRequired[Union[Unset, Literal["all", "selected"]]]


class AuthenticationTokenPropPermissionsType(TypedDict):
    """AuthenticationTokenPropPermissions

    Examples:
        {'issues': 'read', 'deployments': 'write'}
    """


class AuditLogEventType(TypedDict):
    """AuditLogEvent"""

    timestamp: NotRequired[Union[Unset, int]]
    action: NotRequired[Union[Unset, str]]
    active: NotRequired[Union[Unset, bool]]
    active_was: NotRequired[Union[Unset, bool]]
    actor: NotRequired[Union[Unset, str]]
    actor_id: NotRequired[Union[Unset, int]]
    actor_location: NotRequired[Union[Unset, AuditLogEventPropActorLocationType]]
    data: NotRequired[Union[Unset, AuditLogEventPropDataType]]
    org_id: NotRequired[Union[Unset, int]]
    blocked_user: NotRequired[Union[Unset, str]]
    business: NotRequired[Union[Unset, str]]
    config: NotRequired[Union[Unset, List[AuditLogEventPropConfigItemsType]]]
    config_was: NotRequired[Union[Unset, List[AuditLogEventPropConfigWasItemsType]]]
    content_type: NotRequired[Union[Unset, str]]
    created_at: NotRequired[Union[Unset, int]]
    deploy_key_fingerprint: NotRequired[Union[Unset, str]]
    document_id: NotRequired[Union[Unset, str]]
    emoji: NotRequired[Union[Unset, str]]
    events: NotRequired[Union[Unset, List[AuditLogEventPropEventsItemsType]]]
    events_were: NotRequired[Union[Unset, List[AuditLogEventPropEventsWereItemsType]]]
    explanation: NotRequired[Union[Unset, str]]
    fingerprint: NotRequired[Union[Unset, str]]
    hook_id: NotRequired[Union[Unset, int]]
    limited_availability: NotRequired[Union[Unset, bool]]
    message: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    old_user: NotRequired[Union[Unset, str]]
    openssh_public_key: NotRequired[Union[Unset, str]]
    org: NotRequired[Union[Unset, str]]
    previous_visibility: NotRequired[Union[Unset, str]]
    read_only: NotRequired[Union[Unset, bool]]
    repo: NotRequired[Union[Unset, str]]
    repository: NotRequired[Union[Unset, str]]
    repository_public: NotRequired[Union[Unset, bool]]
    target_login: NotRequired[Union[Unset, str]]
    team: NotRequired[Union[Unset, str]]
    transport_protocol: NotRequired[Union[Unset, int]]
    transport_protocol_name: NotRequired[Union[Unset, str]]
    user: NotRequired[Union[Unset, str]]
    visibility: NotRequired[Union[Unset, str]]


class AuditLogEventPropActorLocationType(TypedDict):
    """AuditLogEventPropActorLocation"""

    country_name: NotRequired[Union[Unset, str]]


class AuditLogEventPropDataType(TypedDict):
    """AuditLogEventPropData"""


class AuditLogEventPropConfigItemsType(TypedDict):
    """AuditLogEventPropConfigItems"""


class AuditLogEventPropConfigWasItemsType(TypedDict):
    """AuditLogEventPropConfigWasItems"""


class AuditLogEventPropEventsItemsType(TypedDict):
    """AuditLogEventPropEventsItems"""


class AuditLogEventPropEventsWereItemsType(TypedDict):
    """AuditLogEventPropEventsWereItems"""


class CodeScanningAlertRuleType(TypedDict):
    """CodeScanningAlertRule"""

    id: NotRequired[Union[Unset, Union[str, None]]]
    name: NotRequired[Union[Unset, str]]
    severity: NotRequired[
        Union[Unset, Literal["none", "note", "warning", "error", None]]
    ]
    security_severity_level: NotRequired[
        Union[Unset, Literal["low", "medium", "high", "critical", None]]
    ]
    description: NotRequired[Union[Unset, str]]
    full_description: NotRequired[Union[Unset, str]]
    tags: NotRequired[Union[Unset, Union[List[str], None]]]
    help_: NotRequired[Union[Unset, Union[str, None]]]


class CodeScanningAnalysisToolType(TypedDict):
    """CodeScanningAnalysisTool"""

    name: NotRequired[Union[Unset, str]]
    version: NotRequired[Union[Unset, Union[str, None]]]
    guid: NotRequired[Union[Unset, Union[str, None]]]


class CodeScanningAlertLocationType(TypedDict):
    """CodeScanningAlertLocation

    Describe a region within a file for the alert.
    """

    path: NotRequired[Union[Unset, str]]
    start_line: NotRequired[Union[Unset, int]]
    end_line: NotRequired[Union[Unset, int]]
    start_column: NotRequired[Union[Unset, int]]
    end_column: NotRequired[Union[Unset, int]]


class CodeScanningAlertInstanceType(TypedDict):
    """CodeScanningAlertInstance"""

    ref: NotRequired[Union[Unset, str]]
    analysis_key: NotRequired[Union[Unset, str]]
    environment: NotRequired[Union[Unset, str]]
    category: NotRequired[Union[Unset, str]]
    state: NotRequired[Union[Unset, Literal["open", "closed", "dismissed", "fixed"]]]
    commit_sha: NotRequired[Union[Unset, str]]
    message: NotRequired[Union[Unset, CodeScanningAlertInstancePropMessageType]]
    location: NotRequired[Union[Unset, CodeScanningAlertLocationType]]
    html_url: NotRequired[Union[Unset, str]]
    classifications: NotRequired[
        Union[Unset, List[Literal["source", "generated", "test", "library", None]]]
    ]


class CodeScanningAlertInstancePropMessageType(TypedDict):
    """CodeScanningAlertInstancePropMessage"""

    text: NotRequired[Union[Unset, str]]


class SimpleRepositoryType(TypedDict):
    """Simple Repository

    Simple Repository
    """

    id: int
    node_id: str
    name: str
    full_name: str
    owner: SimpleUserType
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    downloads_url: str
    events_url: str
    forks_url: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    notifications_url: str
    pulls_url: str
    releases_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    hooks_url: str


class CodeScanningOrganizationAlertItemsType(TypedDict):
    """CodeScanningOrganizationAlertItems"""

    number: int
    created_at: datetime
    updated_at: NotRequired[Union[Unset, datetime]]
    url: str
    html_url: str
    instances_url: str
    state: Literal["open", "closed", "dismissed", "fixed"]
    fixed_at: NotRequired[Union[Unset, Union[datetime, None]]]
    dismissed_by: Union[None, SimpleUserType]
    dismissed_at: Union[datetime, None]
    dismissed_reason: Literal[None, "false positive", "won't fix", "used in tests"]
    dismissed_comment: NotRequired[Union[Unset, Union[str, None]]]
    rule: CodeScanningAlertRuleType
    tool: CodeScanningAnalysisToolType
    most_recent_instance: CodeScanningAlertInstanceType
    repository: SimpleRepositoryType


class OrganizationSecretScanningAlertType(TypedDict):
    """OrganizationSecretScanningAlert"""

    number: NotRequired[Union[Unset, int]]
    created_at: NotRequired[Union[Unset, datetime]]
    updated_at: NotRequired[Union[Unset, Union[None, datetime]]]
    url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    locations_url: NotRequired[Union[Unset, str]]
    state: NotRequired[Union[Unset, Literal["open", "resolved"]]]
    resolution: NotRequired[
        Union[
            Unset,
            Literal[None, "false_positive", "wont_fix", "revoked", "used_in_tests"],
        ]
    ]
    resolved_at: NotRequired[Union[Unset, Union[datetime, None]]]
    resolved_by: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    secret_type: NotRequired[Union[Unset, str]]
    secret_type_display_name: NotRequired[Union[Unset, str]]
    secret: NotRequired[Union[Unset, str]]
    repository: NotRequired[Union[Unset, SimpleRepositoryType]]
    push_protection_bypassed: NotRequired[Union[Unset, Union[bool, None]]]
    push_protection_bypassed_by: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    push_protection_bypassed_at: NotRequired[Union[Unset, Union[datetime, None]]]


class ActionsBillingUsageType(TypedDict):
    """ActionsBillingUsage"""

    total_minutes_used: int
    total_paid_minutes_used: int
    included_minutes: int
    minutes_used_breakdown: ActionsBillingUsagePropMinutesUsedBreakdownType


class ActionsBillingUsagePropMinutesUsedBreakdownType(TypedDict):
    """ActionsBillingUsagePropMinutesUsedBreakdown"""

    ubuntu: NotRequired[Union[Unset, int]]
    macos: NotRequired[Union[Unset, int]]
    windows: NotRequired[Union[Unset, int]]
    ubuntu_4_core: NotRequired[Union[Unset, int]]
    ubuntu_8_core: NotRequired[Union[Unset, int]]
    ubuntu_16_core: NotRequired[Union[Unset, int]]
    ubuntu_32_core: NotRequired[Union[Unset, int]]
    ubuntu_64_core: NotRequired[Union[Unset, int]]
    windows_4_core: NotRequired[Union[Unset, int]]
    windows_8_core: NotRequired[Union[Unset, int]]
    windows_16_core: NotRequired[Union[Unset, int]]
    windows_32_core: NotRequired[Union[Unset, int]]
    windows_64_core: NotRequired[Union[Unset, int]]
    total: NotRequired[Union[Unset, int]]


class AdvancedSecurityActiveCommittersUserType(TypedDict):
    """AdvancedSecurityActiveCommittersUser"""

    user_login: str
    last_pushed_date: str


class AdvancedSecurityActiveCommittersRepositoryType(TypedDict):
    """AdvancedSecurityActiveCommittersRepository"""

    name: str
    advanced_security_committers: int
    advanced_security_committers_breakdown: List[
        AdvancedSecurityActiveCommittersUserType
    ]


class AdvancedSecurityActiveCommittersType(TypedDict):
    """AdvancedSecurityActiveCommitters"""

    total_advanced_security_committers: NotRequired[Union[Unset, int]]
    total_count: NotRequired[Union[Unset, int]]
    repositories: List[AdvancedSecurityActiveCommittersRepositoryType]


class PackagesBillingUsageType(TypedDict):
    """PackagesBillingUsage"""

    total_gigabytes_bandwidth_used: int
    total_paid_gigabytes_bandwidth_used: int
    included_gigabytes_bandwidth: int


class CombinedBillingUsageType(TypedDict):
    """CombinedBillingUsage"""

    days_left_in_billing_cycle: int
    estimated_paid_storage_for_month: int
    estimated_storage_for_month: int


class ActorType(TypedDict):
    """Actor

    Actor
    """

    id: int
    login: str
    display_login: NotRequired[Union[Unset, str]]
    gravatar_id: Union[str, None]
    url: str
    avatar_url: str


class MilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    url: str
    html_url: str
    labels_url: str
    id: int
    node_id: str
    number: int
    state: Literal["open", "closed"]
    title: str
    description: Union[str, None]
    creator: Union[None, SimpleUserType]
    open_issues: int
    closed_issues: int
    created_at: datetime
    updated_at: datetime
    closed_at: Union[datetime, None]
    due_on: Union[datetime, None]


class ReactionRollupType(TypedDict):
    """Reaction Rollup"""

    url: str
    total_count: int
    plus_one: int
    minus_one: int
    laugh: int
    confused: int
    heart: int
    hooray: int
    eyes: int
    rocket: int


class IssueType(TypedDict):
    """Issue

    Issues are a great way to keep track of tasks, enhancements, and bugs for your
    projects.
    """

    id: int
    node_id: str
    url: str
    repository_url: str
    labels_url: str
    comments_url: str
    events_url: str
    html_url: str
    number: int
    state: str
    state_reason: NotRequired[Union[Unset, Union[str, None]]]
    title: str
    body: NotRequired[Union[Unset, Union[str, None]]]
    user: Union[None, SimpleUserType]
    labels: List[Union[str, IssuePropLabelsItemsOneof1Type]]
    assignee: Union[None, SimpleUserType]
    assignees: NotRequired[Union[Unset, Union[List[SimpleUserType], None]]]
    milestone: Union[None, MilestoneType]
    locked: bool
    active_lock_reason: NotRequired[Union[Unset, Union[str, None]]]
    comments: int
    pull_request: NotRequired[Union[Unset, IssuePropPullRequestType]]
    closed_at: Union[datetime, None]
    created_at: datetime
    updated_at: datetime
    draft: NotRequired[Union[Unset, bool]]
    closed_by: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    body_html: NotRequired[Union[Unset, str]]
    body_text: NotRequired[Union[Unset, str]]
    timeline_url: NotRequired[Union[Unset, str]]
    repository: NotRequired[Union[Unset, RepositoryType]]
    performed_via_github_app: NotRequired[Union[Unset, Union[None, IntegrationType]]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    reactions: NotRequired[Union[Unset, ReactionRollupType]]


class IssuePropLabelsItemsOneof1Type(TypedDict):
    """IssuePropLabelsItemsOneof1"""

    id: NotRequired[Union[Unset, int]]
    node_id: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, Union[str, None]]]
    color: NotRequired[Union[Unset, Union[str, None]]]
    default: NotRequired[Union[Unset, bool]]


class IssuePropPullRequestType(TypedDict):
    """IssuePropPullRequest"""

    merged_at: NotRequired[Union[Unset, Union[datetime, None]]]
    diff_url: Union[str, None]
    html_url: Union[str, None]
    patch_url: Union[str, None]
    url: Union[str, None]


class IssueCommentType(TypedDict):
    """Issue Comment

    Comments provide a way for people to collaborate on an issue.
    """

    id: int
    node_id: str
    url: str
    body: NotRequired[Union[Unset, str]]
    body_text: NotRequired[Union[Unset, str]]
    body_html: NotRequired[Union[Unset, str]]
    html_url: str
    user: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime
    issue_url: str
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    performed_via_github_app: NotRequired[Union[Unset, Union[None, IntegrationType]]]
    reactions: NotRequired[Union[Unset, ReactionRollupType]]


class EventType(TypedDict):
    """Event

    Event
    """

    id: str
    type: Union[str, None]
    actor: ActorType
    repo: EventPropRepoType
    org: NotRequired[Union[Unset, ActorType]]
    payload: EventPropPayloadType
    public: bool
    created_at: Union[datetime, None]


class EventPropRepoType(TypedDict):
    """EventPropRepo"""

    id: int
    name: str
    url: str


class EventPropPayloadType(TypedDict):
    """EventPropPayload"""

    action: NotRequired[Union[Unset, str]]
    issue: NotRequired[Union[Unset, IssueType]]
    comment: NotRequired[Union[Unset, IssueCommentType]]
    pages: NotRequired[Union[Unset, List[EventPropPayloadPropPagesItemsType]]]


class EventPropPayloadPropPagesItemsType(TypedDict):
    """EventPropPayloadPropPagesItems"""

    page_name: NotRequired[Union[Unset, str]]
    title: NotRequired[Union[Unset, str]]
    summary: NotRequired[Union[Unset, Union[str, None]]]
    action: NotRequired[Union[Unset, str]]
    sha: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]


class LinkWithTypeType(TypedDict):
    """Link With Type

    Hypermedia Link with Type
    """

    href: str
    type: str


class FeedType(TypedDict):
    """Feed

    Feed
    """

    timeline_url: str
    user_url: str
    current_user_public_url: NotRequired[Union[Unset, str]]
    current_user_url: NotRequired[Union[Unset, str]]
    current_user_actor_url: NotRequired[Union[Unset, str]]
    current_user_organization_url: NotRequired[Union[Unset, str]]
    current_user_organization_urls: NotRequired[Union[Unset, List[str]]]
    security_advisories_url: NotRequired[Union[Unset, str]]
    links: FeedPropLinksType


class FeedPropLinksType(TypedDict):
    """FeedPropLinks"""

    timeline: LinkWithTypeType
    user: LinkWithTypeType
    security_advisories: NotRequired[Union[Unset, LinkWithTypeType]]
    current_user: NotRequired[Union[Unset, LinkWithTypeType]]
    current_user_public: NotRequired[Union[Unset, LinkWithTypeType]]
    current_user_actor: NotRequired[Union[Unset, LinkWithTypeType]]
    current_user_organization: NotRequired[Union[Unset, LinkWithTypeType]]
    current_user_organizations: NotRequired[Union[Unset, List[LinkWithTypeType]]]


class BaseGistType(TypedDict):
    """Base Gist

    Base Gist
    """

    url: str
    forks_url: str
    commits_url: str
    id: str
    node_id: str
    git_pull_url: str
    git_push_url: str
    html_url: str
    files: BaseGistPropFilesType
    public: bool
    created_at: datetime
    updated_at: datetime
    description: Union[str, None]
    comments: int
    user: Union[None, SimpleUserType]
    comments_url: str
    owner: NotRequired[Union[Unset, SimpleUserType]]
    truncated: NotRequired[Union[Unset, bool]]
    forks: NotRequired[Union[Unset, List[Any]]]
    history: NotRequired[Union[Unset, List[Any]]]


class BaseGistPropFilesType(TypedDict):
    """BaseGistPropFiles"""


class PublicUserType(TypedDict):
    """Public User

    Public User
    """

    login: str
    id: int
    node_id: str
    avatar_url: str
    gravatar_id: Union[str, None]
    url: str
    html_url: str
    followers_url: str
    following_url: str
    gists_url: str
    starred_url: str
    subscriptions_url: str
    organizations_url: str
    repos_url: str
    events_url: str
    received_events_url: str
    type: str
    site_admin: bool
    name: Union[str, None]
    company: Union[str, None]
    blog: Union[str, None]
    location: Union[str, None]
    email: Union[str, None]
    hireable: Union[bool, None]
    bio: Union[str, None]
    twitter_username: NotRequired[Union[Unset, Union[str, None]]]
    public_repos: int
    public_gists: int
    followers: int
    following: int
    created_at: datetime
    updated_at: datetime
    plan: NotRequired[Union[Unset, PublicUserPropPlanType]]
    suspended_at: NotRequired[Union[Unset, Union[datetime, None]]]
    private_gists: NotRequired[Union[Unset, int]]
    total_private_repos: NotRequired[Union[Unset, int]]
    owned_private_repos: NotRequired[Union[Unset, int]]
    disk_usage: NotRequired[Union[Unset, int]]
    collaborators: NotRequired[Union[Unset, int]]


class PublicUserPropPlanType(TypedDict):
    """PublicUserPropPlan"""

    collaborators: int
    name: str
    space: int
    private_repos: int


class GistHistoryType(TypedDict):
    """Gist History

    Gist History
    """

    user: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    version: NotRequired[Union[Unset, str]]
    committed_at: NotRequired[Union[Unset, datetime]]
    change_status: NotRequired[Union[Unset, GistHistoryPropChangeStatusType]]
    url: NotRequired[Union[Unset, str]]


class GistHistoryPropChangeStatusType(TypedDict):
    """GistHistoryPropChangeStatus"""

    total: NotRequired[Union[Unset, int]]
    additions: NotRequired[Union[Unset, int]]
    deletions: NotRequired[Union[Unset, int]]


class GistSimpleType(TypedDict):
    """Gist Simple

    Gist Simple
    """

    forks: NotRequired[Union[Unset, Union[List[GistSimplePropForksItemsType], None]]]
    history: NotRequired[Union[Unset, Union[List[GistHistoryType], None]]]
    fork_of: NotRequired[Union[Unset, Union[GistSimplePropForkOfType, None]]]
    url: NotRequired[Union[Unset, str]]
    forks_url: NotRequired[Union[Unset, str]]
    commits_url: NotRequired[Union[Unset, str]]
    id: NotRequired[Union[Unset, str]]
    node_id: NotRequired[Union[Unset, str]]
    git_pull_url: NotRequired[Union[Unset, str]]
    git_push_url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    files: NotRequired[Union[Unset, GistSimplePropFilesType]]
    public: NotRequired[Union[Unset, bool]]
    created_at: NotRequired[Union[Unset, str]]
    updated_at: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, Union[str, None]]]
    comments: NotRequired[Union[Unset, int]]
    user: NotRequired[Union[Unset, Union[str, None]]]
    comments_url: NotRequired[Union[Unset, str]]
    owner: NotRequired[Union[Unset, SimpleUserType]]
    truncated: NotRequired[Union[Unset, bool]]


class GistSimplePropForksItemsType(TypedDict):
    """GistSimplePropForksItems"""

    id: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    user: NotRequired[Union[Unset, PublicUserType]]
    created_at: NotRequired[Union[Unset, datetime]]
    updated_at: NotRequired[Union[Unset, datetime]]


class GistSimplePropForkOfType(TypedDict):
    """Gist

    Gist
    """

    url: str
    forks_url: str
    commits_url: str
    id: str
    node_id: str
    git_pull_url: str
    git_push_url: str
    html_url: str
    files: GistSimplePropForkOfPropFilesType
    public: bool
    created_at: datetime
    updated_at: datetime
    description: Union[str, None]
    comments: int
    user: Union[None, SimpleUserType]
    comments_url: str
    owner: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    truncated: NotRequired[Union[Unset, bool]]
    forks: NotRequired[Union[Unset, List[Any]]]
    history: NotRequired[Union[Unset, List[Any]]]


class GistSimplePropForkOfPropFilesType(TypedDict):
    """GistSimplePropForkOfPropFiles"""


class GistSimplePropFilesType(TypedDict):
    """GistSimplePropFiles"""


class GistCommentType(TypedDict):
    """Gist Comment

    A comment made to a gist.
    """

    id: int
    node_id: str
    url: str
    body: str
    user: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]


class GistCommitType(TypedDict):
    """Gist Commit

    Gist Commit
    """

    url: str
    version: str
    user: Union[None, SimpleUserType]
    change_status: GistCommitPropChangeStatusType
    committed_at: datetime


class GistCommitPropChangeStatusType(TypedDict):
    """GistCommitPropChangeStatus"""

    total: NotRequired[Union[Unset, int]]
    additions: NotRequired[Union[Unset, int]]
    deletions: NotRequired[Union[Unset, int]]


class GitignoreTemplateType(TypedDict):
    """Gitignore Template

    Gitignore Template
    """

    name: str
    source: str


class LicenseType(TypedDict):
    """License

    License
    """

    key: str
    name: str
    spdx_id: Union[str, None]
    url: Union[str, None]
    node_id: str
    html_url: str
    description: str
    implementation: str
    permissions: List[str]
    conditions: List[str]
    limitations: List[str]
    body: str
    featured: bool


class MarketplaceListingPlanType(TypedDict):
    """Marketplace Listing Plan

    Marketplace Listing Plan
    """

    url: str
    accounts_url: str
    id: int
    number: int
    name: str
    description: str
    monthly_price_in_cents: int
    yearly_price_in_cents: int
    price_model: str
    has_free_trial: bool
    unit_name: Union[str, None]
    state: str
    bullets: List[str]


class MarketplacePurchaseType(TypedDict):
    """Marketplace Purchase

    Marketplace Purchase
    """

    url: str
    type: str
    id: int
    login: str
    organization_billing_email: NotRequired[Union[Unset, str]]
    email: NotRequired[Union[Unset, Union[str, None]]]
    marketplace_pending_change: NotRequired[
        Union[Unset, Union[MarketplacePurchasePropMarketplacePendingChangeType, None]]
    ]
    marketplace_purchase: MarketplacePurchasePropMarketplacePurchaseType


class MarketplacePurchasePropMarketplacePendingChangeType(TypedDict):
    """MarketplacePurchasePropMarketplacePendingChange"""

    is_installed: NotRequired[Union[Unset, bool]]
    effective_date: NotRequired[Union[Unset, str]]
    unit_count: NotRequired[Union[Unset, Union[int, None]]]
    id: NotRequired[Union[Unset, int]]
    plan: NotRequired[Union[Unset, MarketplaceListingPlanType]]


class MarketplacePurchasePropMarketplacePurchaseType(TypedDict):
    """MarketplacePurchasePropMarketplacePurchase"""

    billing_cycle: NotRequired[Union[Unset, str]]
    next_billing_date: NotRequired[Union[Unset, Union[str, None]]]
    is_installed: NotRequired[Union[Unset, bool]]
    unit_count: NotRequired[Union[Unset, Union[int, None]]]
    on_free_trial: NotRequired[Union[Unset, bool]]
    free_trial_ends_on: NotRequired[Union[Unset, Union[str, None]]]
    updated_at: NotRequired[Union[Unset, str]]
    plan: NotRequired[Union[Unset, MarketplaceListingPlanType]]


class ApiOverviewType(TypedDict):
    """Api Overview

    Api Overview
    """

    verifiable_password_authentication: bool
    ssh_key_fingerprints: NotRequired[
        Union[Unset, ApiOverviewPropSshKeyFingerprintsType]
    ]
    ssh_keys: NotRequired[Union[Unset, List[str]]]
    hooks: NotRequired[Union[Unset, List[str]]]
    web: NotRequired[Union[Unset, List[str]]]
    api: NotRequired[Union[Unset, List[str]]]
    git: NotRequired[Union[Unset, List[str]]]
    packages: NotRequired[Union[Unset, List[str]]]
    pages: NotRequired[Union[Unset, List[str]]]
    importer: NotRequired[Union[Unset, List[str]]]
    actions: NotRequired[Union[Unset, List[str]]]
    dependabot: NotRequired[Union[Unset, List[str]]]


class ApiOverviewPropSshKeyFingerprintsType(TypedDict):
    """ApiOverviewPropSshKeyFingerprints"""

    sha256_rsa: NotRequired[Union[Unset, str]]
    sha256_dsa: NotRequired[Union[Unset, str]]
    sha256_ecdsa: NotRequired[Union[Unset, str]]
    sha256_ed25519: NotRequired[Union[Unset, str]]


class MinimalRepositoryType(TypedDict):
    """Minimal Repository

    Minimal Repository
    """

    id: int
    node_id: str
    name: str
    full_name: str
    owner: SimpleUserType
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    downloads_url: str
    events_url: str
    forks_url: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: NotRequired[Union[Unset, str]]
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    notifications_url: str
    pulls_url: str
    releases_url: str
    ssh_url: NotRequired[Union[Unset, str]]
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    clone_url: NotRequired[Union[Unset, str]]
    mirror_url: NotRequired[Union[Unset, Union[str, None]]]
    hooks_url: str
    svn_url: NotRequired[Union[Unset, str]]
    homepage: NotRequired[Union[Unset, Union[str, None]]]
    language: NotRequired[Union[Unset, Union[str, None]]]
    forks_count: NotRequired[Union[Unset, int]]
    stargazers_count: NotRequired[Union[Unset, int]]
    watchers_count: NotRequired[Union[Unset, int]]
    size: NotRequired[Union[Unset, int]]
    default_branch: NotRequired[Union[Unset, str]]
    open_issues_count: NotRequired[Union[Unset, int]]
    is_template: NotRequired[Union[Unset, bool]]
    topics: NotRequired[Union[Unset, List[str]]]
    has_issues: NotRequired[Union[Unset, bool]]
    has_projects: NotRequired[Union[Unset, bool]]
    has_wiki: NotRequired[Union[Unset, bool]]
    has_pages: NotRequired[Union[Unset, bool]]
    has_downloads: NotRequired[Union[Unset, bool]]
    archived: NotRequired[Union[Unset, bool]]
    disabled: NotRequired[Union[Unset, bool]]
    visibility: NotRequired[Union[Unset, str]]
    pushed_at: NotRequired[Union[Unset, Union[datetime, None]]]
    created_at: NotRequired[Union[Unset, Union[datetime, None]]]
    updated_at: NotRequired[Union[Unset, Union[datetime, None]]]
    permissions: NotRequired[Union[Unset, MinimalRepositoryPropPermissionsType]]
    role_name: NotRequired[Union[Unset, str]]
    template_repository: NotRequired[Union[Unset, Union[None, RepositoryType]]]
    temp_clone_token: NotRequired[Union[Unset, str]]
    delete_branch_on_merge: NotRequired[Union[Unset, bool]]
    subscribers_count: NotRequired[Union[Unset, int]]
    network_count: NotRequired[Union[Unset, int]]
    code_of_conduct: NotRequired[Union[Unset, CodeOfConductType]]
    license_: NotRequired[Union[Unset, Union[MinimalRepositoryPropLicenseType, None]]]
    forks: NotRequired[Union[Unset, int]]
    open_issues: NotRequired[Union[Unset, int]]
    watchers: NotRequired[Union[Unset, int]]
    allow_forking: NotRequired[Union[Unset, bool]]


class MinimalRepositoryPropPermissionsType(TypedDict):
    """MinimalRepositoryPropPermissions"""

    admin: NotRequired[Union[Unset, bool]]
    maintain: NotRequired[Union[Unset, bool]]
    push: NotRequired[Union[Unset, bool]]
    triage: NotRequired[Union[Unset, bool]]
    pull: NotRequired[Union[Unset, bool]]


class MinimalRepositoryPropLicenseType(TypedDict):
    """MinimalRepositoryPropLicense"""

    key: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    spdx_id: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    node_id: NotRequired[Union[Unset, str]]


class ThreadType(TypedDict):
    """Thread

    Thread
    """

    id: str
    repository: MinimalRepositoryType
    subject: ThreadPropSubjectType
    reason: str
    unread: bool
    updated_at: str
    last_read_at: Union[str, None]
    url: str
    subscription_url: str


class ThreadPropSubjectType(TypedDict):
    """ThreadPropSubject"""

    title: str
    url: str
    latest_comment_url: str
    type: str


class ThreadSubscriptionType(TypedDict):
    """Thread Subscription

    Thread Subscription
    """

    subscribed: bool
    ignored: bool
    reason: Union[str, None]
    created_at: Union[datetime, None]
    url: str
    thread_url: NotRequired[Union[Unset, str]]
    repository_url: NotRequired[Union[Unset, str]]


class OrganizationCustomRepositoryRoleType(TypedDict):
    """Organization Custom Repository Role

    Custom repository roles created by organization administrators
    """

    id: int
    name: str


class OrganizationFullType(TypedDict):
    """Organization Full

    Organization Full
    """

    login: str
    id: int
    node_id: str
    url: str
    repos_url: str
    events_url: str
    hooks_url: str
    issues_url: str
    members_url: str
    public_members_url: str
    avatar_url: str
    description: Union[str, None]
    name: NotRequired[Union[Unset, str]]
    company: NotRequired[Union[Unset, str]]
    blog: NotRequired[Union[Unset, str]]
    location: NotRequired[Union[Unset, str]]
    email: NotRequired[Union[Unset, str]]
    twitter_username: NotRequired[Union[Unset, Union[str, None]]]
    is_verified: NotRequired[Union[Unset, bool]]
    has_organization_projects: bool
    has_repository_projects: bool
    public_repos: int
    public_gists: int
    followers: int
    following: int
    html_url: str
    created_at: datetime
    type: str
    total_private_repos: NotRequired[Union[Unset, int]]
    owned_private_repos: NotRequired[Union[Unset, int]]
    private_gists: NotRequired[Union[Unset, Union[int, None]]]
    disk_usage: NotRequired[Union[Unset, Union[int, None]]]
    collaborators: NotRequired[Union[Unset, Union[int, None]]]
    billing_email: NotRequired[Union[Unset, Union[str, None]]]
    plan: NotRequired[Union[Unset, OrganizationFullPropPlanType]]
    default_repository_permission: NotRequired[Union[Unset, Union[str, None]]]
    members_can_create_repositories: NotRequired[Union[Unset, Union[bool, None]]]
    two_factor_requirement_enabled: NotRequired[Union[Unset, Union[bool, None]]]
    members_allowed_repository_creation_type: NotRequired[Union[Unset, str]]
    members_can_create_public_repositories: NotRequired[Union[Unset, bool]]
    members_can_create_private_repositories: NotRequired[Union[Unset, bool]]
    members_can_create_internal_repositories: NotRequired[Union[Unset, bool]]
    members_can_create_pages: NotRequired[Union[Unset, bool]]
    members_can_create_public_pages: NotRequired[Union[Unset, bool]]
    members_can_create_private_pages: NotRequired[Union[Unset, bool]]
    members_can_fork_private_repositories: NotRequired[Union[Unset, Union[bool, None]]]
    updated_at: datetime


class OrganizationFullPropPlanType(TypedDict):
    """OrganizationFullPropPlan"""

    name: str
    space: int
    private_repos: int
    filled_seats: NotRequired[Union[Unset, int]]
    seats: NotRequired[Union[Unset, int]]


class ActionsCacheUsageByRepositoryType(TypedDict):
    """Actions Cache Usage by repository

    GitHub Actions Cache Usage by repository.
    """

    full_name: str
    active_caches_size_in_bytes: int
    active_caches_count: int


class OidcCustomSubType(TypedDict):
    """Actions OIDC Subject customization

    Actions OIDC Subject customization
    """

    include_claim_keys: List[str]


class EmptyObjectType(TypedDict):
    """Empty Object

    An object without any properties.
    """


class ActionsOrganizationPermissionsType(TypedDict):
    """ActionsOrganizationPermissions"""

    enabled_repositories: Literal["all", "none", "selected"]
    selected_repositories_url: NotRequired[Union[Unset, str]]
    allowed_actions: NotRequired[Union[Unset, Literal["all", "local_only", "selected"]]]
    selected_actions_url: NotRequired[Union[Unset, str]]


class RunnerGroupsOrgType(TypedDict):
    """RunnerGroupsOrg"""

    id: float
    name: str
    visibility: str
    default: bool
    selected_repositories_url: NotRequired[Union[Unset, str]]
    runners_url: str
    inherited: bool
    inherited_allows_public_repositories: NotRequired[Union[Unset, bool]]
    allows_public_repositories: bool
    workflow_restrictions_read_only: NotRequired[Union[Unset, bool]]
    restricted_to_workflows: NotRequired[Union[Unset, bool]]
    selected_workflows: NotRequired[Union[Unset, List[str]]]


class OrganizationActionsSecretType(TypedDict):
    """Actions Secret for an Organization

    Secrets for GitHub Actions for an organization.
    """

    name: str
    created_at: datetime
    updated_at: datetime
    visibility: Literal["all", "private", "selected"]
    selected_repositories_url: NotRequired[Union[Unset, str]]


class ActionsPublicKeyType(TypedDict):
    """ActionsPublicKey

    The public key used for setting Actions Secrets.
    """

    key_id: str
    key: str
    id: NotRequired[Union[Unset, int]]
    url: NotRequired[Union[Unset, str]]
    title: NotRequired[Union[Unset, str]]
    created_at: NotRequired[Union[Unset, str]]


class CodespaceMachineType(TypedDict):
    """Codespace machine

    A description of the machine powering a codespace.
    """

    name: str
    display_name: str
    operating_system: str
    storage_in_bytes: int
    memory_in_bytes: int
    cpus: int
    prebuild_availability: Literal["none", "ready", "in_progress", None]


class CodespaceType(TypedDict):
    """Codespace

    A codespace.
    """

    id: int
    name: str
    display_name: NotRequired[Union[Unset, Union[str, None]]]
    environment_id: Union[str, None]
    owner: SimpleUserType
    billable_owner: SimpleUserType
    repository: MinimalRepositoryType
    machine: Union[None, CodespaceMachineType]
    devcontainer_path: NotRequired[Union[Unset, Union[str, None]]]
    prebuild: Union[bool, None]
    created_at: datetime
    updated_at: datetime
    last_used_at: datetime
    state: Literal[
        "Unknown",
        "Created",
        "Queued",
        "Provisioning",
        "Available",
        "Awaiting",
        "Unavailable",
        "Deleted",
        "Moved",
        "Shutdown",
        "Archived",
        "Starting",
        "ShuttingDown",
        "Failed",
        "Exporting",
        "Updating",
        "Rebuilding",
    ]
    url: str
    git_status: CodespacePropGitStatusType
    location: Literal["EastUs", "SouthEastAsia", "WestEurope", "WestUs2"]
    idle_timeout_minutes: Union[int, None]
    web_url: str
    machines_url: str
    start_url: str
    stop_url: str
    pulls_url: Union[str, None]
    recent_folders: List[str]
    runtime_constraints: NotRequired[Union[Unset, CodespacePropRuntimeConstraintsType]]
    pending_operation: NotRequired[Union[Unset, Union[bool, None]]]
    pending_operation_disabled_reason: NotRequired[Union[Unset, Union[str, None]]]
    idle_timeout_notice: NotRequired[Union[Unset, Union[str, None]]]


class CodespacePropGitStatusType(TypedDict):
    """CodespacePropGitStatus

    Details about the codespace's git repository.
    """

    ahead: NotRequired[Union[Unset, int]]
    behind: NotRequired[Union[Unset, int]]
    has_unpushed_changes: NotRequired[Union[Unset, bool]]
    has_uncommitted_changes: NotRequired[Union[Unset, bool]]
    ref: NotRequired[Union[Unset, str]]


class CodespacePropRuntimeConstraintsType(TypedDict):
    """CodespacePropRuntimeConstraints"""

    allowed_port_privacy_settings: NotRequired[Union[Unset, Union[List[str], None]]]


class CredentialAuthorizationType(TypedDict):
    """Credential Authorization

    Credential Authorization
    """

    login: str
    credential_id: int
    credential_type: str
    token_last_eight: NotRequired[Union[Unset, str]]
    credential_authorized_at: datetime
    scopes: NotRequired[Union[Unset, List[str]]]
    fingerprint: NotRequired[Union[Unset, str]]
    credential_accessed_at: Union[datetime, None]
    authorized_credential_id: Union[int, None]
    authorized_credential_title: NotRequired[Union[Unset, Union[str, None]]]
    authorized_credential_note: NotRequired[Union[Unset, Union[str, None]]]
    authorized_credential_expires_at: NotRequired[Union[Unset, Union[datetime, None]]]


class OrganizationDependabotSecretType(TypedDict):
    """Dependabot Secret for an Organization

    Secrets for GitHub Dependabot for an organization.
    """

    name: str
    created_at: datetime
    updated_at: datetime
    visibility: Literal["all", "private", "selected"]
    selected_repositories_url: NotRequired[Union[Unset, str]]


class DependabotPublicKeyType(TypedDict):
    """DependabotPublicKey

    The public key used for setting Dependabot Secrets.
    """

    key_id: str
    key: str


class ExternalGroupType(TypedDict):
    """ExternalGroup

    Information about an external group's usage and its members
    """

    group_id: int
    group_name: str
    updated_at: NotRequired[Union[Unset, str]]
    teams: List[ExternalGroupPropTeamsItemsType]
    members: List[ExternalGroupPropMembersItemsType]


class ExternalGroupPropTeamsItemsType(TypedDict):
    """ExternalGroupPropTeamsItems"""

    team_id: int
    team_name: str


class ExternalGroupPropMembersItemsType(TypedDict):
    """ExternalGroupPropMembersItems"""

    member_id: int
    member_login: str
    member_name: str
    member_email: str


class ExternalGroupsType(TypedDict):
    """ExternalGroups

    A list of external groups available to be connected to a team
    """

    groups: NotRequired[Union[Unset, List[ExternalGroupsPropGroupsItemsType]]]


class ExternalGroupsPropGroupsItemsType(TypedDict):
    """ExternalGroupsPropGroupsItems"""

    group_id: int
    group_name: str
    updated_at: str


class OrganizationInvitationType(TypedDict):
    """Organization Invitation

    Organization Invitation
    """

    id: int
    login: Union[str, None]
    email: Union[str, None]
    role: str
    created_at: str
    failed_at: NotRequired[Union[Unset, Union[str, None]]]
    failed_reason: NotRequired[Union[Unset, Union[str, None]]]
    inviter: SimpleUserType
    team_count: int
    node_id: str
    invitation_teams_url: str


class OrgHookType(TypedDict):
    """Org Hook

    Org Hook
    """

    id: int
    url: str
    ping_url: str
    deliveries_url: NotRequired[Union[Unset, str]]
    name: str
    events: List[str]
    active: bool
    config: OrgHookPropConfigType
    updated_at: datetime
    created_at: datetime
    type: str


class OrgHookPropConfigType(TypedDict):
    """OrgHookPropConfig"""

    url: NotRequired[Union[Unset, str]]
    insecure_ssl: NotRequired[Union[Unset, str]]
    content_type: NotRequired[Union[Unset, str]]
    secret: NotRequired[Union[Unset, str]]


class InteractionLimitResponseType(TypedDict):
    """Interaction Limits

    Interaction limit settings.
    """

    limit: Literal["existing_users", "contributors_only", "collaborators_only"]
    origin: str
    expires_at: datetime


class InteractionLimitType(TypedDict):
    """Interaction Restrictions

    Limit interactions to a specific type of user for a specified duration
    """

    limit: Literal["existing_users", "contributors_only", "collaborators_only"]
    expiry: NotRequired[
        Union[
            Unset,
            Literal["one_day", "three_days", "one_week", "one_month", "six_months"],
        ]
    ]


class TeamSimpleType(TypedDict):
    """Team Simple

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int
    node_id: str
    url: str
    members_url: str
    name: str
    description: Union[str, None]
    permission: str
    privacy: NotRequired[Union[Unset, str]]
    html_url: str
    repositories_url: str
    slug: str
    ldap_dn: NotRequired[Union[Unset, str]]


class TeamType(TypedDict):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int
    node_id: str
    name: str
    slug: str
    description: Union[str, None]
    privacy: NotRequired[Union[Unset, str]]
    permission: str
    permissions: NotRequired[Union[Unset, TeamPropPermissionsType]]
    url: str
    html_url: str
    members_url: str
    repositories_url: str
    parent: Union[None, TeamSimpleType]


class TeamPropPermissionsType(TypedDict):
    """TeamPropPermissions"""

    pull: bool
    triage: bool
    push: bool
    maintain: bool
    admin: bool


class OrgMembershipType(TypedDict):
    """Org Membership

    Org Membership
    """

    url: str
    state: Literal["active", "pending"]
    role: Literal["admin", "member", "billing_manager"]
    organization_url: str
    organization: OrganizationSimpleType
    user: Union[None, SimpleUserType]
    permissions: NotRequired[Union[Unset, OrgMembershipPropPermissionsType]]


class OrgMembershipPropPermissionsType(TypedDict):
    """OrgMembershipPropPermissions"""

    can_create_repository: bool


class MigrationType(TypedDict):
    """Migration

    A migration.
    """

    id: int
    owner: Union[None, SimpleUserType]
    guid: str
    state: str
    lock_repositories: bool
    exclude_metadata: bool
    exclude_git_data: bool
    exclude_attachments: bool
    exclude_releases: bool
    exclude_owner_projects: bool
    org_metadata_only: bool
    repositories: List[RepositoryType]
    url: str
    created_at: datetime
    updated_at: datetime
    node_id: str
    archive_url: NotRequired[Union[Unset, str]]
    exclude: NotRequired[Union[Unset, List[Any]]]


class PackageType(TypedDict):
    """Package

    A software package
    """

    id: int
    name: str
    package_type: Literal["npm", "maven", "rubygems", "docker", "nuget", "container"]
    url: str
    html_url: str
    version_count: int
    visibility: Literal["private", "public"]
    owner: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    repository: NotRequired[Union[Unset, Union[None, MinimalRepositoryType]]]
    created_at: datetime
    updated_at: datetime


class PackageVersionType(TypedDict):
    """Package Version

    A version of a software package
    """

    id: int
    name: str
    url: str
    package_html_url: str
    html_url: NotRequired[Union[Unset, str]]
    license_: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, str]]
    created_at: datetime
    updated_at: datetime
    deleted_at: NotRequired[Union[Unset, datetime]]
    metadata: NotRequired[Union[Unset, PackageVersionPropMetadataType]]


class PackageVersionPropMetadataType(TypedDict):
    """Package Version Metadata"""

    package_type: Literal["npm", "maven", "rubygems", "docker", "nuget", "container"]
    container: NotRequired[Union[Unset, PackageVersionPropMetadataPropContainerType]]
    docker: NotRequired[Union[Unset, PackageVersionPropMetadataPropDockerType]]


class PackageVersionPropMetadataPropContainerType(TypedDict):
    """Container Metadata"""

    tags: List[str]


class PackageVersionPropMetadataPropDockerType(TypedDict):
    """Docker Metadata"""

    tag: NotRequired[Union[Unset, List[str]]]


class ProjectType(TypedDict):
    """Project

    Projects are a way to organize columns and cards of work.
    """

    owner_url: str
    url: str
    html_url: str
    columns_url: str
    id: int
    node_id: str
    name: str
    body: Union[str, None]
    number: int
    state: str
    creator: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime
    organization_permission: NotRequired[
        Union[Unset, Literal["read", "write", "admin", "none"]]
    ]
    private: NotRequired[Union[Unset, bool]]


class GroupMappingType(TypedDict):
    """GroupMapping

    External Groups to be mapped to a team for membership
    """

    groups: NotRequired[Union[Unset, List[GroupMappingPropGroupsItemsType]]]


class GroupMappingPropGroupsItemsType(TypedDict):
    """GroupMappingPropGroupsItems"""

    group_id: str
    group_name: str
    group_description: str
    status: NotRequired[Union[Unset, str]]
    synced_at: NotRequired[Union[Unset, Union[str, None]]]


class TeamFullType(TypedDict):
    """Full Team

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int
    node_id: str
    url: str
    html_url: str
    name: str
    slug: str
    description: Union[str, None]
    privacy: NotRequired[Union[Unset, Literal["closed", "secret"]]]
    permission: str
    members_url: str
    repositories_url: str
    parent: NotRequired[Union[Unset, Union[None, TeamSimpleType]]]
    members_count: int
    repos_count: int
    created_at: datetime
    updated_at: datetime
    organization: OrganizationFullType
    ldap_dn: NotRequired[Union[Unset, str]]


class TeamDiscussionType(TypedDict):
    """Team Discussion

    A team discussion is a persistent record of a free-form conversation within a
    team.
    """

    author: Union[None, SimpleUserType]
    body: str
    body_html: str
    body_version: str
    comments_count: int
    comments_url: str
    created_at: datetime
    last_edited_at: Union[datetime, None]
    html_url: str
    node_id: str
    number: int
    pinned: bool
    private: bool
    team_url: str
    title: str
    updated_at: datetime
    url: str
    reactions: NotRequired[Union[Unset, ReactionRollupType]]


class TeamDiscussionCommentType(TypedDict):
    """Team Discussion Comment

    A reply to a discussion within a team.
    """

    author: Union[None, SimpleUserType]
    body: str
    body_html: str
    body_version: str
    created_at: datetime
    last_edited_at: Union[datetime, None]
    discussion_url: str
    html_url: str
    node_id: str
    number: int
    updated_at: datetime
    url: str
    reactions: NotRequired[Union[Unset, ReactionRollupType]]


class ReactionType(TypedDict):
    """Reaction

    Reactions to conversations provide a way to help people express their feelings
    more simply and effectively.
    """

    id: int
    node_id: str
    user: Union[None, SimpleUserType]
    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ]
    created_at: datetime


class TeamMembershipType(TypedDict):
    """Team Membership

    Team Membership
    """

    url: str
    role: Literal["member", "maintainer"]
    state: Literal["active", "pending"]


class TeamProjectType(TypedDict):
    """Team Project

    A team's access to a project.
    """

    owner_url: str
    url: str
    html_url: str
    columns_url: str
    id: int
    node_id: str
    name: str
    body: Union[str, None]
    number: int
    state: str
    creator: SimpleUserType
    created_at: str
    updated_at: str
    organization_permission: NotRequired[Union[Unset, str]]
    private: NotRequired[Union[Unset, bool]]
    permissions: TeamProjectPropPermissionsType


class TeamProjectPropPermissionsType(TypedDict):
    """TeamProjectPropPermissions"""

    read: bool
    write: bool
    admin: bool


class TeamRepositoryType(TypedDict):
    """Team Repository

    A team's access to a repository.
    """

    id: int
    node_id: str
    name: str
    full_name: str
    license_: Union[None, LicenseSimpleType]
    forks: int
    permissions: NotRequired[Union[Unset, TeamRepositoryPropPermissionsType]]
    role_name: NotRequired[Union[Unset, str]]
    owner: Union[None, SimpleUserType]
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    downloads_url: str
    events_url: str
    forks_url: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    notifications_url: str
    pulls_url: str
    releases_url: str
    ssh_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    clone_url: str
    mirror_url: Union[str, None]
    hooks_url: str
    svn_url: str
    homepage: Union[str, None]
    language: Union[str, None]
    forks_count: int
    stargazers_count: int
    watchers_count: int
    size: int
    default_branch: str
    open_issues_count: int
    is_template: NotRequired[Union[Unset, bool]]
    topics: NotRequired[Union[Unset, List[str]]]
    has_issues: bool
    has_projects: bool
    has_wiki: bool
    has_pages: bool
    has_downloads: bool
    archived: bool
    disabled: bool
    visibility: NotRequired[Union[Unset, str]]
    pushed_at: Union[datetime, None]
    created_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    allow_rebase_merge: NotRequired[Union[Unset, bool]]
    template_repository: NotRequired[Union[Unset, Union[None, RepositoryType]]]
    temp_clone_token: NotRequired[Union[Unset, str]]
    allow_squash_merge: NotRequired[Union[Unset, bool]]
    allow_auto_merge: NotRequired[Union[Unset, bool]]
    delete_branch_on_merge: NotRequired[Union[Unset, bool]]
    allow_merge_commit: NotRequired[Union[Unset, bool]]
    allow_forking: NotRequired[Union[Unset, bool]]
    subscribers_count: NotRequired[Union[Unset, int]]
    network_count: NotRequired[Union[Unset, int]]
    open_issues: int
    watchers: int
    master_branch: NotRequired[Union[Unset, str]]


class TeamRepositoryPropPermissionsType(TypedDict):
    """TeamRepositoryPropPermissions"""

    admin: bool
    pull: bool
    triage: NotRequired[Union[Unset, bool]]
    push: bool
    maintain: NotRequired[Union[Unset, bool]]


class ProjectCardType(TypedDict):
    """Project Card

    Project cards represent a scope of work.
    """

    url: str
    id: int
    node_id: str
    note: Union[str, None]
    creator: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime
    archived: NotRequired[Union[Unset, bool]]
    column_name: NotRequired[Union[Unset, str]]
    project_id: NotRequired[Union[Unset, str]]
    column_url: str
    content_url: NotRequired[Union[Unset, str]]
    project_url: str


class ProjectColumnType(TypedDict):
    """Project Column

    Project columns contain cards of work.
    """

    url: str
    project_url: str
    cards_url: str
    id: int
    node_id: str
    name: str
    created_at: datetime
    updated_at: datetime


class ProjectCollaboratorPermissionType(TypedDict):
    """Project Collaborator Permission

    Project Collaborator Permission
    """

    permission: str
    user: Union[None, SimpleUserType]


class RateLimitType(TypedDict):
    """Rate Limit"""

    limit: int
    remaining: int
    reset: int
    used: int


class RateLimitOverviewType(TypedDict):
    """Rate Limit Overview

    Rate Limit Overview
    """

    resources: RateLimitOverviewPropResourcesType
    rate: RateLimitType


class RateLimitOverviewPropResourcesType(TypedDict):
    """RateLimitOverviewPropResources"""

    core: RateLimitType
    graphql: NotRequired[Union[Unset, RateLimitType]]
    search: RateLimitType
    source_import: NotRequired[Union[Unset, RateLimitType]]
    integration_manifest: NotRequired[Union[Unset, RateLimitType]]
    code_scanning_upload: NotRequired[Union[Unset, RateLimitType]]
    actions_runner_registration: NotRequired[Union[Unset, RateLimitType]]
    scim: NotRequired[Union[Unset, RateLimitType]]
    dependency_snapshots: NotRequired[Union[Unset, RateLimitType]]


class CodeOfConductSimpleType(TypedDict):
    """Code Of Conduct Simple

    Code of Conduct Simple
    """

    url: str
    key: str
    name: str
    html_url: Union[str, None]


class SecurityAndAnalysisType(TypedDict):
    """SecurityAndAnalysis"""

    advanced_security: NotRequired[
        Union[Unset, SecurityAndAnalysisPropAdvancedSecurityType]
    ]
    secret_scanning: NotRequired[
        Union[Unset, SecurityAndAnalysisPropSecretScanningType]
    ]
    secret_scanning_push_protection: NotRequired[
        Union[Unset, SecurityAndAnalysisPropSecretScanningPushProtectionType]
    ]


class SecurityAndAnalysisPropAdvancedSecurityType(TypedDict):
    """SecurityAndAnalysisPropAdvancedSecurity"""

    status: NotRequired[Union[Unset, Literal["enabled", "disabled"]]]


class SecurityAndAnalysisPropSecretScanningType(TypedDict):
    """SecurityAndAnalysisPropSecretScanning"""

    status: NotRequired[Union[Unset, Literal["enabled", "disabled"]]]


class SecurityAndAnalysisPropSecretScanningPushProtectionType(TypedDict):
    """SecurityAndAnalysisPropSecretScanningPushProtection"""

    status: NotRequired[Union[Unset, Literal["enabled", "disabled"]]]


class FullRepositoryType(TypedDict):
    """Full Repository

    Full Repository
    """

    id: int
    node_id: str
    name: str
    full_name: str
    owner: SimpleUserType
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    downloads_url: str
    events_url: str
    forks_url: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    notifications_url: str
    pulls_url: str
    releases_url: str
    ssh_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    clone_url: str
    mirror_url: Union[str, None]
    hooks_url: str
    svn_url: str
    homepage: Union[str, None]
    language: Union[str, None]
    forks_count: int
    stargazers_count: int
    watchers_count: int
    size: int
    default_branch: str
    open_issues_count: int
    is_template: NotRequired[Union[Unset, bool]]
    topics: NotRequired[Union[Unset, List[str]]]
    has_issues: bool
    has_projects: bool
    has_wiki: bool
    has_pages: bool
    has_downloads: bool
    archived: bool
    disabled: bool
    visibility: NotRequired[Union[Unset, str]]
    pushed_at: datetime
    created_at: datetime
    updated_at: datetime
    permissions: NotRequired[Union[Unset, FullRepositoryPropPermissionsType]]
    allow_rebase_merge: NotRequired[Union[Unset, bool]]
    template_repository: NotRequired[Union[Unset, Union[None, RepositoryType]]]
    temp_clone_token: NotRequired[Union[Unset, Union[str, None]]]
    allow_squash_merge: NotRequired[Union[Unset, bool]]
    allow_auto_merge: NotRequired[Union[Unset, bool]]
    delete_branch_on_merge: NotRequired[Union[Unset, bool]]
    allow_merge_commit: NotRequired[Union[Unset, bool]]
    allow_update_branch: NotRequired[Union[Unset, bool]]
    use_squash_pr_title_as_default: NotRequired[Union[Unset, bool]]
    allow_forking: NotRequired[Union[Unset, bool]]
    subscribers_count: int
    network_count: int
    license_: Union[None, LicenseSimpleType]
    organization: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    parent: NotRequired[Union[Unset, RepositoryType]]
    source: NotRequired[Union[Unset, RepositoryType]]
    forks: int
    master_branch: NotRequired[Union[Unset, str]]
    open_issues: int
    watchers: int
    anonymous_access_enabled: NotRequired[Union[Unset, bool]]
    code_of_conduct: NotRequired[Union[Unset, CodeOfConductSimpleType]]
    security_and_analysis: NotRequired[Union[Unset, SecurityAndAnalysisType]]


class FullRepositoryPropPermissionsType(TypedDict):
    """FullRepositoryPropPermissions"""

    admin: bool
    maintain: NotRequired[Union[Unset, bool]]
    push: bool
    triage: NotRequired[Union[Unset, bool]]
    pull: bool


class ArtifactType(TypedDict):
    """Artifact

    An artifact
    """

    id: int
    node_id: str
    name: str
    size_in_bytes: int
    url: str
    archive_download_url: str
    expired: bool
    created_at: Union[datetime, None]
    expires_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    workflow_run: NotRequired[Union[Unset, Union[ArtifactPropWorkflowRunType, None]]]


class ArtifactPropWorkflowRunType(TypedDict):
    """ArtifactPropWorkflowRun"""

    id: NotRequired[Union[Unset, int]]
    repository_id: NotRequired[Union[Unset, int]]
    head_repository_id: NotRequired[Union[Unset, int]]
    head_branch: NotRequired[Union[Unset, str]]
    head_sha: NotRequired[Union[Unset, str]]


class ActionsCacheListType(TypedDict):
    """Repository actions caches

    Repository actions caches
    """

    total_count: int
    actions_caches: List[ActionsCacheListPropActionsCachesItemsType]


class ActionsCacheListPropActionsCachesItemsType(TypedDict):
    """ActionsCacheListPropActionsCachesItems"""

    id: NotRequired[Union[Unset, int]]
    ref: NotRequired[Union[Unset, str]]
    key: NotRequired[Union[Unset, str]]
    version: NotRequired[Union[Unset, str]]
    last_accessed_at: NotRequired[Union[Unset, datetime]]
    created_at: NotRequired[Union[Unset, datetime]]
    size_in_bytes: NotRequired[Union[Unset, int]]


class JobType(TypedDict):
    """Job

    Information of a job execution in a workflow run
    """

    id: int
    run_id: int
    run_url: str
    run_attempt: NotRequired[Union[Unset, int]]
    node_id: str
    head_sha: str
    url: str
    html_url: Union[str, None]
    status: Literal["queued", "in_progress", "completed"]
    conclusion: Union[str, None]
    started_at: datetime
    completed_at: Union[datetime, None]
    name: str
    steps: NotRequired[Union[Unset, List[JobPropStepsItemsType]]]
    check_run_url: str
    labels: List[str]
    runner_id: Union[int, None]
    runner_name: Union[str, None]
    runner_group_id: Union[int, None]
    runner_group_name: Union[str, None]


class JobPropStepsItemsType(TypedDict):
    """JobPropStepsItems"""

    status: Literal["queued", "in_progress", "completed"]
    conclusion: Union[str, None]
    name: str
    number: int
    started_at: NotRequired[Union[Unset, Union[datetime, None]]]
    completed_at: NotRequired[Union[Unset, Union[datetime, None]]]


class OptOutOidcCustomSubType(TypedDict):
    """The json payload enables/disables the use of sub claim customization

    OIDC Customer Subject
    """

    use_default: bool


class ActionsRepositoryPermissionsType(TypedDict):
    """ActionsRepositoryPermissions"""

    enabled: bool
    allowed_actions: NotRequired[Union[Unset, Literal["all", "local_only", "selected"]]]
    selected_actions_url: NotRequired[Union[Unset, str]]


class ActionsWorkflowAccessToRepositoryType(TypedDict):
    """ActionsWorkflowAccessToRepository"""

    access_level: Literal["none", "organization", "enterprise"]


class ReferencedWorkflowType(TypedDict):
    """Referenced workflow

    A workflow referenced/reused by the initial caller workflow
    """

    path: str
    sha: str
    ref: NotRequired[Union[Unset, str]]


class PullRequestMinimalType(TypedDict):
    """Pull Request Minimal"""

    id: int
    number: int
    url: str
    head: PullRequestMinimalPropHeadType
    base: PullRequestMinimalPropBaseType


class PullRequestMinimalPropHeadType(TypedDict):
    """PullRequestMinimalPropHead"""

    ref: str
    sha: str
    repo: PullRequestMinimalPropHeadPropRepoType


class PullRequestMinimalPropHeadPropRepoType(TypedDict):
    """PullRequestMinimalPropHeadPropRepo"""

    id: int
    url: str
    name: str


class PullRequestMinimalPropBaseType(TypedDict):
    """PullRequestMinimalPropBase"""

    ref: str
    sha: str
    repo: PullRequestMinimalPropBasePropRepoType


class PullRequestMinimalPropBasePropRepoType(TypedDict):
    """PullRequestMinimalPropBasePropRepo"""

    id: int
    url: str
    name: str


class SimpleCommitType(TypedDict):
    """Simple Commit

    Simple Commit
    """

    id: str
    tree_id: str
    message: str
    timestamp: datetime
    author: Union[SimpleCommitPropAuthorType, None]
    committer: Union[SimpleCommitPropCommitterType, None]


class SimpleCommitPropAuthorType(TypedDict):
    """SimpleCommitPropAuthor"""

    name: str
    email: str


class SimpleCommitPropCommitterType(TypedDict):
    """SimpleCommitPropCommitter"""

    name: str
    email: str


class WorkflowRunType(TypedDict):
    """Workflow Run

    An invocation of a workflow
    """

    id: int
    name: NotRequired[Union[Unset, Union[str, None]]]
    node_id: str
    check_suite_id: NotRequired[Union[Unset, int]]
    check_suite_node_id: NotRequired[Union[Unset, str]]
    head_branch: Union[str, None]
    head_sha: str
    path: str
    run_number: int
    run_attempt: NotRequired[Union[Unset, int]]
    referenced_workflows: NotRequired[
        Union[Unset, Union[List[ReferencedWorkflowType], None]]
    ]
    event: str
    status: Union[str, None]
    conclusion: Union[str, None]
    workflow_id: int
    url: str
    html_url: str
    pull_requests: Union[List[PullRequestMinimalType], None]
    created_at: datetime
    updated_at: datetime
    actor: NotRequired[Union[Unset, SimpleUserType]]
    triggering_actor: NotRequired[Union[Unset, SimpleUserType]]
    run_started_at: NotRequired[Union[Unset, datetime]]
    jobs_url: str
    logs_url: str
    check_suite_url: str
    artifacts_url: str
    cancel_url: str
    rerun_url: str
    previous_attempt_url: NotRequired[Union[Unset, Union[str, None]]]
    workflow_url: str
    head_commit: Union[None, SimpleCommitType]
    repository: MinimalRepositoryType
    head_repository: MinimalRepositoryType
    head_repository_id: NotRequired[Union[Unset, int]]


class EnvironmentApprovalsType(TypedDict):
    """Environment Approval

    An entry in the reviews log for environment deployments
    """

    environments: List[EnvironmentApprovalsPropEnvironmentsItemsType]
    state: Literal["approved", "rejected"]
    user: SimpleUserType
    comment: str


class EnvironmentApprovalsPropEnvironmentsItemsType(TypedDict):
    """EnvironmentApprovalsPropEnvironmentsItems"""

    id: NotRequired[Union[Unset, int]]
    node_id: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    created_at: NotRequired[Union[Unset, datetime]]
    updated_at: NotRequired[Union[Unset, datetime]]


class PendingDeploymentType(TypedDict):
    """Pending Deployment

    Details of a deployment that is waiting for protection rules to pass
    """

    environment: PendingDeploymentPropEnvironmentType
    wait_timer: int
    wait_timer_started_at: Union[datetime, None]
    current_user_can_approve: bool
    reviewers: List[PendingDeploymentPropReviewersItemsType]


class PendingDeploymentPropEnvironmentType(TypedDict):
    """PendingDeploymentPropEnvironment"""

    id: NotRequired[Union[Unset, int]]
    node_id: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]


class PendingDeploymentPropReviewersItemsType(TypedDict):
    """PendingDeploymentPropReviewersItems"""

    type: NotRequired[Union[Unset, Literal["User", "Team"]]]
    reviewer: NotRequired[Union[Unset, Union[SimpleUserType, TeamType]]]


class DeploymentType(TypedDict):
    """Deployment

    A request for a specific ref(branch,sha,tag) to be deployed
    """

    url: str
    id: int
    node_id: str
    sha: str
    ref: str
    task: str
    payload: Union[DeploymentPropPayloadOneof0Type, str]
    original_environment: NotRequired[Union[Unset, str]]
    environment: str
    description: Union[str, None]
    creator: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime
    statuses_url: str
    repository_url: str
    transient_environment: NotRequired[Union[Unset, bool]]
    production_environment: NotRequired[Union[Unset, bool]]
    performed_via_github_app: NotRequired[Union[Unset, Union[None, IntegrationType]]]


class DeploymentPropPayloadOneof0Type(TypedDict):
    """DeploymentPropPayloadOneof0"""


class WorkflowRunUsageType(TypedDict):
    """Workflow Run Usage

    Workflow Run Usage
    """

    billable: WorkflowRunUsagePropBillableType
    run_duration_ms: NotRequired[Union[Unset, int]]


class WorkflowRunUsagePropBillableType(TypedDict):
    """WorkflowRunUsagePropBillable"""

    ubuntu: NotRequired[Union[Unset, WorkflowRunUsagePropBillablePropUbuntuType]]
    macos: NotRequired[Union[Unset, WorkflowRunUsagePropBillablePropMacosType]]
    windows: NotRequired[Union[Unset, WorkflowRunUsagePropBillablePropWindowsType]]


class WorkflowRunUsagePropBillablePropUbuntuType(TypedDict):
    """WorkflowRunUsagePropBillablePropUbuntu"""

    total_ms: int
    jobs: int
    job_runs: NotRequired[
        Union[Unset, List[WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItemsType]]
    ]


class WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItemsType(TypedDict):
    """WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems"""

    job_id: int
    duration_ms: int


class WorkflowRunUsagePropBillablePropMacosType(TypedDict):
    """WorkflowRunUsagePropBillablePropMacos"""

    total_ms: int
    jobs: int
    job_runs: NotRequired[
        Union[Unset, List[WorkflowRunUsagePropBillablePropMacosPropJobRunsItemsType]]
    ]


class WorkflowRunUsagePropBillablePropMacosPropJobRunsItemsType(TypedDict):
    """WorkflowRunUsagePropBillablePropMacosPropJobRunsItems"""

    job_id: int
    duration_ms: int


class WorkflowRunUsagePropBillablePropWindowsType(TypedDict):
    """WorkflowRunUsagePropBillablePropWindows"""

    total_ms: int
    jobs: int
    job_runs: NotRequired[
        Union[Unset, List[WorkflowRunUsagePropBillablePropWindowsPropJobRunsItemsType]]
    ]


class WorkflowRunUsagePropBillablePropWindowsPropJobRunsItemsType(TypedDict):
    """WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems"""

    job_id: int
    duration_ms: int


class ActionsSecretType(TypedDict):
    """Actions Secret

    Set secrets for GitHub Actions.
    """

    name: str
    created_at: datetime
    updated_at: datetime


class WorkflowType(TypedDict):
    """Workflow

    A GitHub Actions workflow
    """

    id: int
    node_id: str
    name: str
    path: str
    state: Literal[
        "active", "deleted", "disabled_fork", "disabled_inactivity", "disabled_manually"
    ]
    created_at: datetime
    updated_at: datetime
    url: str
    html_url: str
    badge_url: str
    deleted_at: NotRequired[Union[Unset, datetime]]


class WorkflowUsageType(TypedDict):
    """Workflow Usage

    Workflow Usage
    """

    billable: WorkflowUsagePropBillableType


class WorkflowUsagePropBillableType(TypedDict):
    """WorkflowUsagePropBillable"""

    ubuntu: NotRequired[Union[Unset, WorkflowUsagePropBillablePropUbuntuType]]
    macos: NotRequired[Union[Unset, WorkflowUsagePropBillablePropMacosType]]
    windows: NotRequired[Union[Unset, WorkflowUsagePropBillablePropWindowsType]]


class WorkflowUsagePropBillablePropUbuntuType(TypedDict):
    """WorkflowUsagePropBillablePropUbuntu"""

    total_ms: NotRequired[Union[Unset, int]]


class WorkflowUsagePropBillablePropMacosType(TypedDict):
    """WorkflowUsagePropBillablePropMacos"""

    total_ms: NotRequired[Union[Unset, int]]


class WorkflowUsagePropBillablePropWindowsType(TypedDict):
    """WorkflowUsagePropBillablePropWindows"""

    total_ms: NotRequired[Union[Unset, int]]


class AutolinkType(TypedDict):
    """Autolink reference

    An autolink reference.
    """

    id: int
    key_prefix: str
    url_template: str
    is_alphanumeric: NotRequired[Union[Unset, bool]]


class ProtectedBranchRequiredStatusCheckType(TypedDict):
    """Protected Branch Required Status Check

    Protected Branch Required Status Check
    """

    url: NotRequired[Union[Unset, str]]
    enforcement_level: NotRequired[Union[Unset, str]]
    contexts: List[str]
    checks: List[ProtectedBranchRequiredStatusCheckPropChecksItemsType]
    contexts_url: NotRequired[Union[Unset, str]]
    strict: NotRequired[Union[Unset, bool]]


class ProtectedBranchRequiredStatusCheckPropChecksItemsType(TypedDict):
    """ProtectedBranchRequiredStatusCheckPropChecksItems"""

    context: str
    app_id: Union[int, None]


class ProtectedBranchAdminEnforcedType(TypedDict):
    """Protected Branch Admin Enforced

    Protected Branch Admin Enforced
    """

    url: str
    enabled: bool


class ProtectedBranchPullRequestReviewType(TypedDict):
    """Protected Branch Pull Request Review

    Protected Branch Pull Request Review
    """

    url: NotRequired[Union[Unset, str]]
    dismissal_restrictions: NotRequired[
        Union[Unset, ProtectedBranchPullRequestReviewPropDismissalRestrictionsType]
    ]
    bypass_pull_request_allowances: NotRequired[
        Union[
            Unset, ProtectedBranchPullRequestReviewPropBypassPullRequestAllowancesType
        ]
    ]
    dismiss_stale_reviews: bool
    require_code_owner_reviews: bool
    required_approving_review_count: NotRequired[Union[Unset, int]]


class ProtectedBranchPullRequestReviewPropDismissalRestrictionsType(TypedDict):
    """ProtectedBranchPullRequestReviewPropDismissalRestrictions"""

    users: NotRequired[Union[Unset, List[SimpleUserType]]]
    teams: NotRequired[Union[Unset, List[TeamType]]]
    apps: NotRequired[Union[Unset, List[IntegrationType]]]
    url: NotRequired[Union[Unset, str]]
    users_url: NotRequired[Union[Unset, str]]
    teams_url: NotRequired[Union[Unset, str]]


class ProtectedBranchPullRequestReviewPropBypassPullRequestAllowancesType(TypedDict):
    """ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances

    Allow specific users, teams, or apps to bypass pull request requirements.
    """

    users: NotRequired[Union[Unset, List[SimpleUserType]]]
    teams: NotRequired[Union[Unset, List[TeamType]]]
    apps: NotRequired[Union[Unset, List[IntegrationType]]]


class BranchRestrictionPolicyType(TypedDict):
    """Branch Restriction Policy

    Branch Restriction Policy
    """

    url: str
    users_url: str
    teams_url: str
    apps_url: str
    users: List[BranchRestrictionPolicyPropUsersItemsType]
    teams: List[BranchRestrictionPolicyPropTeamsItemsType]
    apps: List[BranchRestrictionPolicyPropAppsItemsType]


class BranchRestrictionPolicyPropUsersItemsType(TypedDict):
    """BranchRestrictionPolicyPropUsersItems"""

    login: NotRequired[Union[Unset, str]]
    id: NotRequired[Union[Unset, int]]
    node_id: NotRequired[Union[Unset, str]]
    avatar_url: NotRequired[Union[Unset, str]]
    gravatar_id: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    followers_url: NotRequired[Union[Unset, str]]
    following_url: NotRequired[Union[Unset, str]]
    gists_url: NotRequired[Union[Unset, str]]
    starred_url: NotRequired[Union[Unset, str]]
    subscriptions_url: NotRequired[Union[Unset, str]]
    organizations_url: NotRequired[Union[Unset, str]]
    repos_url: NotRequired[Union[Unset, str]]
    events_url: NotRequired[Union[Unset, str]]
    received_events_url: NotRequired[Union[Unset, str]]
    type: NotRequired[Union[Unset, str]]
    site_admin: NotRequired[Union[Unset, bool]]


class BranchRestrictionPolicyPropTeamsItemsType(TypedDict):
    """BranchRestrictionPolicyPropTeamsItems"""

    id: NotRequired[Union[Unset, int]]
    node_id: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    slug: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, Union[str, None]]]
    privacy: NotRequired[Union[Unset, str]]
    permission: NotRequired[Union[Unset, str]]
    members_url: NotRequired[Union[Unset, str]]
    repositories_url: NotRequired[Union[Unset, str]]
    parent: NotRequired[Union[Unset, Union[str, None]]]


class BranchRestrictionPolicyPropAppsItemsType(TypedDict):
    """BranchRestrictionPolicyPropAppsItems"""

    id: NotRequired[Union[Unset, int]]
    slug: NotRequired[Union[Unset, str]]
    node_id: NotRequired[Union[Unset, str]]
    owner: NotRequired[Union[Unset, BranchRestrictionPolicyPropAppsItemsPropOwnerType]]
    name: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, str]]
    external_url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    created_at: NotRequired[Union[Unset, str]]
    updated_at: NotRequired[Union[Unset, str]]
    permissions: NotRequired[
        Union[Unset, BranchRestrictionPolicyPropAppsItemsPropPermissionsType]
    ]
    events: NotRequired[Union[Unset, List[str]]]


class BranchRestrictionPolicyPropAppsItemsPropOwnerType(TypedDict):
    """BranchRestrictionPolicyPropAppsItemsPropOwner"""

    login: NotRequired[Union[Unset, str]]
    id: NotRequired[Union[Unset, int]]
    node_id: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    repos_url: NotRequired[Union[Unset, str]]
    events_url: NotRequired[Union[Unset, str]]
    hooks_url: NotRequired[Union[Unset, str]]
    issues_url: NotRequired[Union[Unset, str]]
    members_url: NotRequired[Union[Unset, str]]
    public_members_url: NotRequired[Union[Unset, str]]
    avatar_url: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, str]]
    gravatar_id: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    followers_url: NotRequired[Union[Unset, str]]
    following_url: NotRequired[Union[Unset, str]]
    gists_url: NotRequired[Union[Unset, str]]
    starred_url: NotRequired[Union[Unset, str]]
    subscriptions_url: NotRequired[Union[Unset, str]]
    organizations_url: NotRequired[Union[Unset, str]]
    received_events_url: NotRequired[Union[Unset, str]]
    type: NotRequired[Union[Unset, str]]
    site_admin: NotRequired[Union[Unset, bool]]


class BranchRestrictionPolicyPropAppsItemsPropPermissionsType(TypedDict):
    """BranchRestrictionPolicyPropAppsItemsPropPermissions"""

    metadata: NotRequired[Union[Unset, str]]
    contents: NotRequired[Union[Unset, str]]
    issues: NotRequired[Union[Unset, str]]
    single_file: NotRequired[Union[Unset, str]]


class BranchProtectionType(TypedDict):
    """Branch Protection

    Branch Protection
    """

    url: NotRequired[Union[Unset, str]]
    enabled: NotRequired[Union[Unset, bool]]
    required_status_checks: NotRequired[
        Union[Unset, ProtectedBranchRequiredStatusCheckType]
    ]
    enforce_admins: NotRequired[Union[Unset, ProtectedBranchAdminEnforcedType]]
    required_pull_request_reviews: NotRequired[
        Union[Unset, ProtectedBranchPullRequestReviewType]
    ]
    restrictions: NotRequired[Union[Unset, BranchRestrictionPolicyType]]
    required_linear_history: NotRequired[
        Union[Unset, BranchProtectionPropRequiredLinearHistoryType]
    ]
    allow_force_pushes: NotRequired[
        Union[Unset, BranchProtectionPropAllowForcePushesType]
    ]
    allow_deletions: NotRequired[Union[Unset, BranchProtectionPropAllowDeletionsType]]
    block_creations: NotRequired[Union[Unset, BranchProtectionPropBlockCreationsType]]
    required_conversation_resolution: NotRequired[
        Union[Unset, BranchProtectionPropRequiredConversationResolutionType]
    ]
    name: NotRequired[Union[Unset, str]]
    protection_url: NotRequired[Union[Unset, str]]
    required_signatures: NotRequired[
        Union[Unset, BranchProtectionPropRequiredSignaturesType]
    ]


class BranchProtectionPropRequiredLinearHistoryType(TypedDict):
    """BranchProtectionPropRequiredLinearHistory"""

    enabled: NotRequired[Union[Unset, bool]]


class BranchProtectionPropAllowForcePushesType(TypedDict):
    """BranchProtectionPropAllowForcePushes"""

    enabled: NotRequired[Union[Unset, bool]]


class BranchProtectionPropAllowDeletionsType(TypedDict):
    """BranchProtectionPropAllowDeletions"""

    enabled: NotRequired[Union[Unset, bool]]


class BranchProtectionPropBlockCreationsType(TypedDict):
    """BranchProtectionPropBlockCreations"""

    enabled: NotRequired[Union[Unset, bool]]


class BranchProtectionPropRequiredConversationResolutionType(TypedDict):
    """BranchProtectionPropRequiredConversationResolution"""

    enabled: NotRequired[Union[Unset, bool]]


class BranchProtectionPropRequiredSignaturesType(TypedDict):
    """BranchProtectionPropRequiredSignatures"""

    url: str
    enabled: bool


class ShortBranchType(TypedDict):
    """Short Branch

    Short Branch
    """

    name: str
    commit: ShortBranchPropCommitType
    protected: bool
    protection: NotRequired[Union[Unset, BranchProtectionType]]
    protection_url: NotRequired[Union[Unset, str]]


class ShortBranchPropCommitType(TypedDict):
    """ShortBranchPropCommit"""

    sha: str
    url: str


class GitUserType(TypedDict):
    """Git User

    Metaproperties for Git author/committer information.
    """

    name: NotRequired[Union[Unset, str]]
    email: NotRequired[Union[Unset, str]]
    date: NotRequired[Union[Unset, str]]


class VerificationType(TypedDict):
    """Verification"""

    verified: bool
    reason: str
    payload: Union[str, None]
    signature: Union[str, None]


class DiffEntryType(TypedDict):
    """Diff Entry

    Diff Entry
    """

    sha: str
    filename: str
    status: Literal[
        "added", "removed", "modified", "renamed", "copied", "changed", "unchanged"
    ]
    additions: int
    deletions: int
    changes: int
    blob_url: str
    raw_url: str
    contents_url: str
    patch: NotRequired[Union[Unset, str]]
    previous_filename: NotRequired[Union[Unset, str]]


class CommitType(TypedDict):
    """Commit

    Commit
    """

    url: str
    sha: str
    node_id: str
    html_url: str
    comments_url: str
    commit: CommitPropCommitType
    author: Union[None, SimpleUserType]
    committer: Union[None, SimpleUserType]
    parents: List[CommitPropParentsItemsType]
    stats: NotRequired[Union[Unset, CommitPropStatsType]]
    files: NotRequired[Union[Unset, List[DiffEntryType]]]


class CommitPropCommitType(TypedDict):
    """CommitPropCommit"""

    url: str
    author: Union[None, GitUserType]
    committer: Union[None, GitUserType]
    message: str
    comment_count: int
    tree: CommitPropCommitPropTreeType
    verification: NotRequired[Union[Unset, VerificationType]]


class CommitPropCommitPropTreeType(TypedDict):
    """CommitPropCommitPropTree"""

    sha: str
    url: str


class CommitPropParentsItemsType(TypedDict):
    """CommitPropParentsItems"""

    sha: str
    url: str
    html_url: NotRequired[Union[Unset, str]]


class CommitPropStatsType(TypedDict):
    """CommitPropStats"""

    additions: NotRequired[Union[Unset, int]]
    deletions: NotRequired[Union[Unset, int]]
    total: NotRequired[Union[Unset, int]]


class BranchWithProtectionType(TypedDict):
    """Branch With Protection

    Branch With Protection
    """

    name: str
    commit: CommitType
    links: BranchWithProtectionPropLinksType
    protected: bool
    protection: BranchProtectionType
    protection_url: str
    pattern: NotRequired[Union[Unset, str]]
    required_approving_review_count: NotRequired[Union[Unset, int]]


class BranchWithProtectionPropLinksType(TypedDict):
    """BranchWithProtectionPropLinks"""

    html: str
    self_: str


class StatusCheckPolicyType(TypedDict):
    """Status Check Policy

    Status Check Policy
    """

    url: str
    strict: bool
    contexts: List[str]
    checks: List[StatusCheckPolicyPropChecksItemsType]
    contexts_url: str


class StatusCheckPolicyPropChecksItemsType(TypedDict):
    """StatusCheckPolicyPropChecksItems"""

    context: str
    app_id: Union[int, None]


class ProtectedBranchType(TypedDict):
    """Protected Branch

    Branch protections protect branches
    """

    url: str
    required_status_checks: NotRequired[Union[Unset, StatusCheckPolicyType]]
    required_pull_request_reviews: NotRequired[
        Union[Unset, ProtectedBranchPropRequiredPullRequestReviewsType]
    ]
    required_signatures: NotRequired[
        Union[Unset, ProtectedBranchPropRequiredSignaturesType]
    ]
    enforce_admins: NotRequired[Union[Unset, ProtectedBranchPropEnforceAdminsType]]
    required_linear_history: NotRequired[
        Union[Unset, ProtectedBranchPropRequiredLinearHistoryType]
    ]
    allow_force_pushes: NotRequired[
        Union[Unset, ProtectedBranchPropAllowForcePushesType]
    ]
    allow_deletions: NotRequired[Union[Unset, ProtectedBranchPropAllowDeletionsType]]
    restrictions: NotRequired[Union[Unset, BranchRestrictionPolicyType]]
    required_conversation_resolution: NotRequired[
        Union[Unset, ProtectedBranchPropRequiredConversationResolutionType]
    ]
    block_creations: NotRequired[Union[Unset, ProtectedBranchPropBlockCreationsType]]


class ProtectedBranchPropRequiredPullRequestReviewsType(TypedDict):
    """ProtectedBranchPropRequiredPullRequestReviews"""

    url: str
    dismiss_stale_reviews: NotRequired[Union[Unset, bool]]
    require_code_owner_reviews: NotRequired[Union[Unset, bool]]
    required_approving_review_count: NotRequired[Union[Unset, int]]
    dismissal_restrictions: NotRequired[
        Union[
            Unset,
            ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictionsType,
        ]
    ]
    bypass_pull_request_allowances: NotRequired[
        Union[
            Unset,
            ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowancesType,
        ]
    ]


class ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictionsType(
    TypedDict
):
    """ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions"""

    url: str
    users_url: str
    teams_url: str
    users: List[SimpleUserType]
    teams: List[TeamType]
    apps: NotRequired[Union[Unset, List[IntegrationType]]]


class ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowancesType(
    TypedDict
):
    """ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances"""

    users: List[SimpleUserType]
    teams: List[TeamType]
    apps: NotRequired[Union[Unset, List[IntegrationType]]]


class ProtectedBranchPropRequiredSignaturesType(TypedDict):
    """ProtectedBranchPropRequiredSignatures"""

    url: str
    enabled: bool


class ProtectedBranchPropEnforceAdminsType(TypedDict):
    """ProtectedBranchPropEnforceAdmins"""

    url: str
    enabled: bool


class ProtectedBranchPropRequiredLinearHistoryType(TypedDict):
    """ProtectedBranchPropRequiredLinearHistory"""

    enabled: bool


class ProtectedBranchPropAllowForcePushesType(TypedDict):
    """ProtectedBranchPropAllowForcePushes"""

    enabled: bool


class ProtectedBranchPropAllowDeletionsType(TypedDict):
    """ProtectedBranchPropAllowDeletions"""

    enabled: bool


class ProtectedBranchPropRequiredConversationResolutionType(TypedDict):
    """ProtectedBranchPropRequiredConversationResolution"""

    enabled: NotRequired[Union[Unset, bool]]


class ProtectedBranchPropBlockCreationsType(TypedDict):
    """ProtectedBranchPropBlockCreations"""

    enabled: bool


class DeploymentSimpleType(TypedDict):
    """Deployment

    A deployment created as the result of an Actions check run from a workflow that
    references an environment
    """

    url: str
    id: int
    node_id: str
    task: str
    original_environment: NotRequired[Union[Unset, str]]
    environment: str
    description: Union[str, None]
    created_at: datetime
    updated_at: datetime
    statuses_url: str
    repository_url: str
    transient_environment: NotRequired[Union[Unset, bool]]
    production_environment: NotRequired[Union[Unset, bool]]
    performed_via_github_app: NotRequired[Union[Unset, Union[None, IntegrationType]]]


class CheckRunType(TypedDict):
    """CheckRun

    A check performed on the code of a given code change
    """

    id: int
    head_sha: str
    node_id: str
    external_id: Union[str, None]
    url: str
    html_url: Union[str, None]
    details_url: Union[str, None]
    status: Literal["queued", "in_progress", "completed"]
    conclusion: Literal[
        "success",
        "failure",
        "neutral",
        "cancelled",
        "skipped",
        "timed_out",
        "action_required",
        None,
    ]
    started_at: Union[datetime, None]
    completed_at: Union[datetime, None]
    output: CheckRunPropOutputType
    name: str
    check_suite: Union[CheckRunPropCheckSuiteType, None]
    app: Union[None, IntegrationType]
    pull_requests: List[PullRequestMinimalType]
    deployment: NotRequired[Union[Unset, DeploymentSimpleType]]


class CheckRunPropOutputType(TypedDict):
    """CheckRunPropOutput"""

    title: Union[str, None]
    summary: Union[str, None]
    text: Union[str, None]
    annotations_count: int
    annotations_url: str


class CheckRunPropCheckSuiteType(TypedDict):
    """CheckRunPropCheckSuite"""

    id: int


class CheckAnnotationType(TypedDict):
    """Check Annotation

    Check Annotation
    """

    path: str
    start_line: int
    end_line: int
    start_column: Union[int, None]
    end_column: Union[int, None]
    annotation_level: Union[str, None]
    title: Union[str, None]
    message: Union[str, None]
    raw_details: Union[str, None]
    blob_href: str


class CheckSuiteType(TypedDict):
    """CheckSuite

    A suite of checks performed on the code of a given code change
    """

    id: int
    node_id: str
    head_branch: Union[str, None]
    head_sha: str
    status: Literal["queued", "in_progress", "completed", None]
    conclusion: Literal[
        "success",
        "failure",
        "neutral",
        "cancelled",
        "skipped",
        "timed_out",
        "action_required",
        None,
    ]
    url: Union[str, None]
    before: Union[str, None]
    after: Union[str, None]
    pull_requests: Union[List[PullRequestMinimalType], None]
    app: Union[None, IntegrationType]
    repository: MinimalRepositoryType
    created_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    head_commit: SimpleCommitType
    latest_check_runs_count: int
    check_runs_url: str
    rerequestable: NotRequired[Union[Unset, bool]]
    runs_rerequestable: NotRequired[Union[Unset, bool]]


class CheckSuitePreferenceType(TypedDict):
    """Check Suite Preference

    Check suite configuration preferences for a repository.
    """

    preferences: CheckSuitePreferencePropPreferencesType
    repository: MinimalRepositoryType


class CheckSuitePreferencePropPreferencesType(TypedDict):
    """CheckSuitePreferencePropPreferences"""

    auto_trigger_checks: NotRequired[
        Union[
            Unset,
            List[CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItemsType],
        ]
    ]


class CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItemsType(TypedDict):
    """CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems"""

    app_id: int
    setting: bool


class CodeScanningAlertRuleSummaryType(TypedDict):
    """CodeScanningAlertRuleSummary"""

    id: NotRequired[Union[Unset, Union[str, None]]]
    name: NotRequired[Union[Unset, str]]
    tags: NotRequired[Union[Unset, Union[List[str], None]]]
    severity: NotRequired[
        Union[Unset, Literal["none", "note", "warning", "error", None]]
    ]
    description: NotRequired[Union[Unset, str]]


class CodeScanningAlertItemsType(TypedDict):
    """CodeScanningAlertItems"""

    number: int
    created_at: datetime
    updated_at: NotRequired[Union[Unset, datetime]]
    url: str
    html_url: str
    instances_url: str
    state: Literal["open", "closed", "dismissed", "fixed"]
    fixed_at: NotRequired[Union[Unset, Union[datetime, None]]]
    dismissed_by: Union[None, SimpleUserType]
    dismissed_at: Union[datetime, None]
    dismissed_reason: Literal[None, "false positive", "won't fix", "used in tests"]
    dismissed_comment: NotRequired[Union[Unset, Union[str, None]]]
    rule: CodeScanningAlertRuleSummaryType
    tool: CodeScanningAnalysisToolType
    most_recent_instance: CodeScanningAlertInstanceType


class CodeScanningAlertType(TypedDict):
    """CodeScanningAlert"""

    number: int
    created_at: datetime
    updated_at: NotRequired[Union[Unset, datetime]]
    url: str
    html_url: str
    instances_url: str
    state: Literal["open", "closed", "dismissed", "fixed"]
    fixed_at: NotRequired[Union[Unset, Union[datetime, None]]]
    dismissed_by: Union[None, SimpleUserType]
    dismissed_at: Union[datetime, None]
    dismissed_reason: Literal[None, "false positive", "won't fix", "used in tests"]
    dismissed_comment: NotRequired[Union[Unset, Union[str, None]]]
    rule: CodeScanningAlertRuleType
    tool: CodeScanningAnalysisToolType
    most_recent_instance: CodeScanningAlertInstanceType


class CodeScanningAnalysisType(TypedDict):
    """CodeScanningAnalysis"""

    ref: str
    commit_sha: str
    analysis_key: str
    environment: str
    category: NotRequired[Union[Unset, str]]
    error: str
    created_at: datetime
    results_count: int
    rules_count: int
    id: int
    url: str
    sarif_id: str
    tool: CodeScanningAnalysisToolType
    deletable: bool
    warning: str


class CodeScanningAnalysisDeletionType(TypedDict):
    """Analysis deletion

    Successful deletion of a code scanning analysis
    """

    next_analysis_url: Union[str, None]
    confirm_delete_url: Union[str, None]


class CodeScanningSarifsReceiptType(TypedDict):
    """CodeScanningSarifsReceipt"""

    id: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]


class CodeScanningSarifsStatusType(TypedDict):
    """CodeScanningSarifsStatus"""

    processing_status: NotRequired[
        Union[Unset, Literal["pending", "complete", "failed"]]
    ]
    analyses_url: NotRequired[Union[Unset, Union[str, None]]]
    errors: NotRequired[Union[Unset, Union[List[str], None]]]


class CodeownersErrorsType(TypedDict):
    """CODEOWNERS errors

    A list of errors found in a repo's CODEOWNERS file
    """

    errors: List[CodeownersErrorsPropErrorsItemsType]


class CodeownersErrorsPropErrorsItemsType(TypedDict):
    """CodeownersErrorsPropErrorsItems"""

    line: int
    column: int
    source: NotRequired[Union[Unset, str]]
    kind: str
    suggestion: NotRequired[Union[Unset, Union[str, None]]]
    message: str
    path: str


class RepoCodespacesSecretType(TypedDict):
    """Codespaces Secret

    Set repository secrets for GitHub Codespaces.
    """

    name: str
    created_at: datetime
    updated_at: datetime


class CodespacesPublicKeyType(TypedDict):
    """CodespacesPublicKey

    The public key used for setting Codespaces secrets.
    """

    key_id: str
    key: str
    id: NotRequired[Union[Unset, int]]
    url: NotRequired[Union[Unset, str]]
    title: NotRequired[Union[Unset, str]]
    created_at: NotRequired[Union[Unset, str]]


class CollaboratorType(TypedDict):
    """Collaborator

    Collaborator
    """

    login: str
    id: int
    email: NotRequired[Union[Unset, Union[str, None]]]
    name: NotRequired[Union[Unset, Union[str, None]]]
    node_id: str
    avatar_url: str
    gravatar_id: Union[str, None]
    url: str
    html_url: str
    followers_url: str
    following_url: str
    gists_url: str
    starred_url: str
    subscriptions_url: str
    organizations_url: str
    repos_url: str
    events_url: str
    received_events_url: str
    type: str
    site_admin: bool
    permissions: NotRequired[Union[Unset, CollaboratorPropPermissionsType]]
    role_name: str


class CollaboratorPropPermissionsType(TypedDict):
    """CollaboratorPropPermissions"""

    pull: bool
    triage: NotRequired[Union[Unset, bool]]
    push: bool
    maintain: NotRequired[Union[Unset, bool]]
    admin: bool


class RepositoryInvitationType(TypedDict):
    """Repository Invitation

    Repository invitations let you manage who you collaborate with.
    """

    id: int
    repository: MinimalRepositoryType
    invitee: Union[None, SimpleUserType]
    inviter: Union[None, SimpleUserType]
    permissions: Literal["read", "write", "admin", "triage", "maintain"]
    created_at: datetime
    expired: NotRequired[Union[Unset, bool]]
    url: str
    html_url: str
    node_id: str


class RepositoryCollaboratorPermissionType(TypedDict):
    """Repository Collaborator Permission

    Repository Collaborator Permission
    """

    permission: str
    role_name: str
    user: Union[None, CollaboratorType]


class CommitCommentType(TypedDict):
    """Commit Comment

    Commit Comment
    """

    html_url: str
    url: str
    id: int
    node_id: str
    body: str
    path: Union[str, None]
    position: Union[int, None]
    line: Union[int, None]
    commit_id: str
    user: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    reactions: NotRequired[Union[Unset, ReactionRollupType]]


class BranchShortType(TypedDict):
    """Branch Short

    Branch Short
    """

    name: str
    commit: BranchShortPropCommitType
    protected: bool


class BranchShortPropCommitType(TypedDict):
    """BranchShortPropCommit"""

    sha: str
    url: str


class LinkType(TypedDict):
    """Link

    Hypermedia Link
    """

    href: str


class AutoMergeType(TypedDict):
    """Auto merge

    The status of auto merging a pull request.
    """

    enabled_by: SimpleUserType
    merge_method: Literal["merge", "squash", "rebase"]
    commit_title: str
    commit_message: str


class PullRequestSimpleType(TypedDict):
    """Pull Request Simple

    Pull Request Simple
    """

    url: str
    id: int
    node_id: str
    html_url: str
    diff_url: str
    patch_url: str
    issue_url: str
    commits_url: str
    review_comments_url: str
    review_comment_url: str
    comments_url: str
    statuses_url: str
    number: int
    state: str
    locked: bool
    title: str
    user: Union[None, SimpleUserType]
    body: Union[str, None]
    labels: List[PullRequestSimplePropLabelsItemsType]
    milestone: Union[None, MilestoneType]
    active_lock_reason: NotRequired[Union[Unset, Union[str, None]]]
    created_at: datetime
    updated_at: datetime
    closed_at: Union[datetime, None]
    merged_at: Union[datetime, None]
    merge_commit_sha: Union[str, None]
    assignee: Union[None, SimpleUserType]
    assignees: NotRequired[Union[Unset, Union[List[SimpleUserType], None]]]
    requested_reviewers: NotRequired[Union[Unset, Union[List[SimpleUserType], None]]]
    requested_teams: NotRequired[Union[Unset, Union[List[TeamType], None]]]
    head: PullRequestSimplePropHeadType
    base: PullRequestSimplePropBaseType
    links: PullRequestSimplePropLinksType
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    auto_merge: AutoMergeType
    draft: NotRequired[Union[Unset, bool]]


class PullRequestSimplePropLabelsItemsType(TypedDict):
    """PullRequestSimplePropLabelsItems"""

    id: int
    node_id: str
    url: str
    name: str
    description: str
    color: str
    default: bool


class PullRequestSimplePropHeadType(TypedDict):
    """PullRequestSimplePropHead"""

    label: str
    ref: str
    repo: RepositoryType
    sha: str
    user: Union[None, SimpleUserType]


class PullRequestSimplePropBaseType(TypedDict):
    """PullRequestSimplePropBase"""

    label: str
    ref: str
    repo: RepositoryType
    sha: str
    user: Union[None, SimpleUserType]


class PullRequestSimplePropLinksType(TypedDict):
    """PullRequestSimplePropLinks"""

    comments: LinkType
    commits: LinkType
    statuses: LinkType
    html: LinkType
    issue: LinkType
    review_comments: LinkType
    review_comment: LinkType
    self_: LinkType


class SimpleCommitStatusType(TypedDict):
    """Simple Commit Status"""

    description: Union[str, None]
    id: int
    node_id: str
    state: str
    context: str
    target_url: Union[str, None]
    required: NotRequired[Union[Unset, Union[bool, None]]]
    avatar_url: Union[str, None]
    url: str
    created_at: datetime
    updated_at: datetime


class CombinedCommitStatusType(TypedDict):
    """Combined Commit Status

    Combined Commit Status
    """

    state: str
    statuses: List[SimpleCommitStatusType]
    sha: str
    total_count: int
    repository: MinimalRepositoryType
    commit_url: str
    url: str


class StatusType(TypedDict):
    """Status

    The status of a commit.
    """

    url: str
    avatar_url: Union[str, None]
    id: int
    node_id: str
    state: str
    description: Union[str, None]
    target_url: Union[str, None]
    context: str
    created_at: str
    updated_at: str
    creator: Union[None, SimpleUserType]


class CommunityHealthFileType(TypedDict):
    """Community Health File"""

    url: str
    html_url: str


class CommunityProfileType(TypedDict):
    """Community Profile

    Community Profile
    """

    health_percentage: int
    description: Union[str, None]
    documentation: Union[str, None]
    files: CommunityProfilePropFilesType
    updated_at: Union[datetime, None]
    content_reports_enabled: NotRequired[Union[Unset, bool]]


class CommunityProfilePropFilesType(TypedDict):
    """CommunityProfilePropFiles"""

    code_of_conduct: Union[None, CodeOfConductSimpleType]
    code_of_conduct_file: Union[None, CommunityHealthFileType]
    license_: Union[None, LicenseSimpleType]
    contributing: Union[None, CommunityHealthFileType]
    readme: Union[None, CommunityHealthFileType]
    issue_template: Union[None, CommunityHealthFileType]
    pull_request_template: Union[None, CommunityHealthFileType]


class CommitComparisonType(TypedDict):
    """Commit Comparison

    Commit Comparison
    """

    url: str
    html_url: str
    permalink_url: str
    diff_url: str
    patch_url: str
    base_commit: CommitType
    merge_base_commit: CommitType
    status: Literal["diverged", "ahead", "behind", "identical"]
    ahead_by: int
    behind_by: int
    total_commits: int
    commits: List[CommitType]
    files: NotRequired[Union[Unset, List[DiffEntryType]]]


class ContentTreeType(TypedDict):
    """Content Tree

    Content Tree
    """

    type: str
    size: int
    name: str
    path: str
    sha: str
    url: str
    git_url: Union[str, None]
    html_url: Union[str, None]
    download_url: Union[str, None]
    entries: NotRequired[Union[Unset, List[ContentTreePropEntriesItemsType]]]
    links: ContentTreePropLinksType


class ContentTreePropEntriesItemsType(TypedDict):
    """ContentTreePropEntriesItems"""

    type: str
    size: int
    name: str
    path: str
    content: NotRequired[Union[Unset, str]]
    sha: str
    url: str
    git_url: Union[str, None]
    html_url: Union[str, None]
    download_url: Union[str, None]
    links: ContentTreePropEntriesItemsPropLinksType


class ContentTreePropEntriesItemsPropLinksType(TypedDict):
    """ContentTreePropEntriesItemsPropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class ContentTreePropLinksType(TypedDict):
    """ContentTreePropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class ContentDirectoryItemsType(TypedDict):
    """ContentDirectoryItems"""

    type: str
    size: int
    name: str
    path: str
    content: NotRequired[Union[Unset, str]]
    sha: str
    url: str
    git_url: Union[str, None]
    html_url: Union[str, None]
    download_url: Union[str, None]
    links: ContentDirectoryItemsPropLinksType


class ContentDirectoryItemsPropLinksType(TypedDict):
    """ContentDirectoryItemsPropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class ContentFileType(TypedDict):
    """Content File

    Content File
    """

    type: str
    encoding: str
    size: int
    name: str
    path: str
    content: str
    sha: str
    url: str
    git_url: Union[str, None]
    html_url: Union[str, None]
    download_url: Union[str, None]
    links: ContentFilePropLinksType
    target: NotRequired[Union[Unset, str]]
    submodule_git_url: NotRequired[Union[Unset, str]]


class ContentFilePropLinksType(TypedDict):
    """ContentFilePropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class ContentSymlinkType(TypedDict):
    """Symlink Content

    An object describing a symlink
    """

    type: str
    target: str
    size: int
    name: str
    path: str
    sha: str
    url: str
    git_url: Union[str, None]
    html_url: Union[str, None]
    download_url: Union[str, None]
    links: ContentSymlinkPropLinksType


class ContentSymlinkPropLinksType(TypedDict):
    """ContentSymlinkPropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class ContentSubmoduleType(TypedDict):
    """Symlink Content

    An object describing a symlink
    """

    type: str
    submodule_git_url: str
    size: int
    name: str
    path: str
    sha: str
    url: str
    git_url: Union[str, None]
    html_url: Union[str, None]
    download_url: Union[str, None]
    links: ContentSubmodulePropLinksType


class ContentSubmodulePropLinksType(TypedDict):
    """ContentSubmodulePropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class FileCommitType(TypedDict):
    """File Commit

    File Commit
    """

    content: Union[FileCommitPropContentType, None]
    commit: FileCommitPropCommitType


class FileCommitPropContentType(TypedDict):
    """FileCommitPropContent"""

    name: NotRequired[Union[Unset, str]]
    path: NotRequired[Union[Unset, str]]
    sha: NotRequired[Union[Unset, str]]
    size: NotRequired[Union[Unset, int]]
    url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    git_url: NotRequired[Union[Unset, str]]
    download_url: NotRequired[Union[Unset, str]]
    type: NotRequired[Union[Unset, str]]
    links: NotRequired[Union[Unset, FileCommitPropContentPropLinksType]]


class FileCommitPropContentPropLinksType(TypedDict):
    """FileCommitPropContentPropLinks"""

    self_: NotRequired[Union[Unset, str]]
    git: NotRequired[Union[Unset, str]]
    html: NotRequired[Union[Unset, str]]


class FileCommitPropCommitType(TypedDict):
    """FileCommitPropCommit"""

    sha: NotRequired[Union[Unset, str]]
    node_id: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    author: NotRequired[Union[Unset, FileCommitPropCommitPropAuthorType]]
    committer: NotRequired[Union[Unset, FileCommitPropCommitPropCommitterType]]
    message: NotRequired[Union[Unset, str]]
    tree: NotRequired[Union[Unset, FileCommitPropCommitPropTreeType]]
    parents: NotRequired[Union[Unset, List[FileCommitPropCommitPropParentsItemsType]]]
    verification: NotRequired[Union[Unset, FileCommitPropCommitPropVerificationType]]


class FileCommitPropCommitPropAuthorType(TypedDict):
    """FileCommitPropCommitPropAuthor"""

    date: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    email: NotRequired[Union[Unset, str]]


class FileCommitPropCommitPropCommitterType(TypedDict):
    """FileCommitPropCommitPropCommitter"""

    date: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    email: NotRequired[Union[Unset, str]]


class FileCommitPropCommitPropTreeType(TypedDict):
    """FileCommitPropCommitPropTree"""

    url: NotRequired[Union[Unset, str]]
    sha: NotRequired[Union[Unset, str]]


class FileCommitPropCommitPropParentsItemsType(TypedDict):
    """FileCommitPropCommitPropParentsItems"""

    url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    sha: NotRequired[Union[Unset, str]]


class FileCommitPropCommitPropVerificationType(TypedDict):
    """FileCommitPropCommitPropVerification"""

    verified: NotRequired[Union[Unset, bool]]
    reason: NotRequired[Union[Unset, str]]
    signature: NotRequired[Union[Unset, Union[str, None]]]
    payload: NotRequired[Union[Unset, Union[str, None]]]


class ContributorType(TypedDict):
    """Contributor

    Contributor
    """

    login: NotRequired[Union[Unset, str]]
    id: NotRequired[Union[Unset, int]]
    node_id: NotRequired[Union[Unset, str]]
    avatar_url: NotRequired[Union[Unset, str]]
    gravatar_id: NotRequired[Union[Unset, Union[str, None]]]
    url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    followers_url: NotRequired[Union[Unset, str]]
    following_url: NotRequired[Union[Unset, str]]
    gists_url: NotRequired[Union[Unset, str]]
    starred_url: NotRequired[Union[Unset, str]]
    subscriptions_url: NotRequired[Union[Unset, str]]
    organizations_url: NotRequired[Union[Unset, str]]
    repos_url: NotRequired[Union[Unset, str]]
    events_url: NotRequired[Union[Unset, str]]
    received_events_url: NotRequired[Union[Unset, str]]
    type: str
    site_admin: NotRequired[Union[Unset, bool]]
    contributions: int
    email: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]


class DependabotSecretType(TypedDict):
    """Dependabot Secret

    Set secrets for Dependabot.
    """

    name: str
    created_at: datetime
    updated_at: datetime


class DependencyGraphDiffItemsType(TypedDict):
    """DependencyGraphDiffItems"""

    change_type: Literal["added", "removed"]
    manifest: str
    ecosystem: str
    name: str
    version: str
    package_url: Union[str, None]
    license_: Union[str, None]
    source_repository_url: Union[str, None]
    vulnerabilities: List[DependencyGraphDiffItemsPropVulnerabilitiesItemsType]


class DependencyGraphDiffItemsPropVulnerabilitiesItemsType(TypedDict):
    """DependencyGraphDiffItemsPropVulnerabilitiesItems"""

    severity: str
    advisory_ghsa_id: str
    advisory_summary: str
    advisory_url: str


class MetadataType(TypedDict):
    """metadata

    User-defined metadata to store domain-specific information limited to 8 keys
    with scalar values.
    """


class DependencyType(TypedDict):
    """Dependency

    A single package dependency.
    """

    package_url: NotRequired[Union[Unset, str]]
    metadata: NotRequired[Union[Unset, MetadataType]]
    relationship: NotRequired[Union[Unset, Literal["direct", "indirect"]]]
    scope: NotRequired[Union[Unset, Literal["runtime", "development"]]]
    dependencies: NotRequired[Union[Unset, List[str]]]


class ManifestType(TypedDict):
    """manifest

    A collection of related dependencies declared in a file or representing a
    logical group of dependencies.
    """

    name: str
    file: NotRequired[Union[Unset, ManifestPropFileType]]
    metadata: NotRequired[Union[Unset, MetadataType]]
    resolved: NotRequired[Union[Unset, Any]]


class ManifestPropFileType(TypedDict):
    """ManifestPropFile"""

    source_location: NotRequired[Union[Unset, str]]


class SnapshotType(TypedDict):
    """snapshot

    Create a new snapshot of a repository's dependencies.
    """

    version: int
    job: SnapshotPropJobType
    sha: str
    ref: str
    detector: SnapshotPropDetectorType
    metadata: NotRequired[Union[Unset, MetadataType]]
    manifests: NotRequired[Union[Unset, SnapshotPropManifestsType]]
    scanned: datetime


class SnapshotPropJobType(TypedDict):
    """SnapshotPropJob"""

    id: str
    correlator: str
    html_url: NotRequired[Union[Unset, str]]


class SnapshotPropDetectorType(TypedDict):
    """SnapshotPropDetector

    A description of the detector used.
    """

    name: str
    version: str
    url: str


class SnapshotPropManifestsType(TypedDict):
    """SnapshotPropManifests

    A collection of package manifests
    """


class DeploymentStatusType(TypedDict):
    """Deployment Status

    The status of a deployment.
    """

    url: str
    id: int
    node_id: str
    state: Literal[
        "error", "failure", "inactive", "pending", "success", "queued", "in_progress"
    ]
    creator: Union[None, SimpleUserType]
    description: str
    environment: NotRequired[Union[Unset, str]]
    target_url: str
    created_at: datetime
    updated_at: datetime
    deployment_url: str
    repository_url: str
    environment_url: NotRequired[Union[Unset, str]]
    log_url: NotRequired[Union[Unset, str]]
    performed_via_github_app: NotRequired[Union[Unset, Union[None, IntegrationType]]]


class DeploymentBranchPolicyType(TypedDict):
    """DeploymentBranchPolicy

    The type of deployment branch policy for this environment. To allow all branches
    to deploy, set to `null`.
    """

    protected_branches: bool
    custom_branch_policies: bool


class EnvironmentType(TypedDict):
    """Environment

    Details of a deployment environment
    """

    id: int
    node_id: str
    name: str
    url: str
    html_url: str
    created_at: datetime
    updated_at: datetime
    protection_rules: NotRequired[
        Union[
            Unset,
            List[
                Union[
                    EnvironmentPropProtectionRulesItemsAnyof0Type,
                    EnvironmentPropProtectionRulesItemsAnyof1Type,
                    EnvironmentPropProtectionRulesItemsAnyof2Type,
                ]
            ],
        ]
    ]
    deployment_branch_policy: NotRequired[Union[Unset, DeploymentBranchPolicyType]]


class EnvironmentPropProtectionRulesItemsAnyof0Type(TypedDict):
    """EnvironmentPropProtectionRulesItemsAnyof0"""

    id: int
    node_id: str
    type: str
    wait_timer: NotRequired[Union[Unset, int]]


class EnvironmentPropProtectionRulesItemsAnyof1Type(TypedDict):
    """EnvironmentPropProtectionRulesItemsAnyof1"""

    id: int
    node_id: str
    type: str
    reviewers: NotRequired[
        Union[
            Unset, List[EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItemsType]
        ]
    ]


class EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItemsType(TypedDict):
    """EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems"""

    type: NotRequired[Union[Unset, Literal["User", "Team"]]]
    reviewer: NotRequired[Union[Unset, Union[SimpleUserType, TeamType]]]


class EnvironmentPropProtectionRulesItemsAnyof2Type(TypedDict):
    """EnvironmentPropProtectionRulesItemsAnyof2"""

    id: int
    node_id: str
    type: str


class ShortBlobType(TypedDict):
    """Short Blob

    Short Blob
    """

    url: str
    sha: str


class BlobType(TypedDict):
    """Blob

    Blob
    """

    content: str
    encoding: str
    url: str
    sha: str
    size: Union[int, None]
    node_id: str
    highlighted_content: NotRequired[Union[Unset, str]]


class GitCommitType(TypedDict):
    """Git Commit

    Low-level Git commit operations within a repository
    """

    sha: str
    node_id: str
    url: str
    author: GitCommitPropAuthorType
    committer: GitCommitPropCommitterType
    message: str
    tree: GitCommitPropTreeType
    parents: List[GitCommitPropParentsItemsType]
    verification: GitCommitPropVerificationType
    html_url: str


class GitCommitPropAuthorType(TypedDict):
    """GitCommitPropAuthor

    Identifying information for the git-user
    """

    date: datetime
    email: str
    name: str


class GitCommitPropCommitterType(TypedDict):
    """GitCommitPropCommitter

    Identifying information for the git-user
    """

    date: datetime
    email: str
    name: str


class GitCommitPropTreeType(TypedDict):
    """GitCommitPropTree"""

    sha: str
    url: str


class GitCommitPropParentsItemsType(TypedDict):
    """GitCommitPropParentsItems"""

    sha: str
    url: str
    html_url: str


class GitCommitPropVerificationType(TypedDict):
    """GitCommitPropVerification"""

    verified: bool
    reason: str
    signature: Union[str, None]
    payload: Union[str, None]


class GitRefType(TypedDict):
    """Git Reference

    Git references within a repository
    """

    ref: str
    node_id: str
    url: str
    object_: GitRefPropObjectType


class GitRefPropObjectType(TypedDict):
    """GitRefPropObject"""

    type: str
    sha: str
    url: str


class GitTagType(TypedDict):
    """Git Tag

    Metadata for a Git tag
    """

    node_id: str
    tag: str
    sha: str
    url: str
    message: str
    tagger: GitTagPropTaggerType
    object_: GitTagPropObjectType
    verification: NotRequired[Union[Unset, VerificationType]]


class GitTagPropTaggerType(TypedDict):
    """GitTagPropTagger"""

    date: str
    email: str
    name: str


class GitTagPropObjectType(TypedDict):
    """GitTagPropObject"""

    sha: str
    type: str
    url: str


class GitTreeType(TypedDict):
    """Git Tree

    The hierarchy between files in a Git repository.
    """

    sha: str
    url: str
    truncated: bool
    tree: List[GitTreePropTreeItemsType]


class GitTreePropTreeItemsType(TypedDict):
    """GitTreePropTreeItems"""

    path: NotRequired[Union[Unset, str]]
    mode: NotRequired[Union[Unset, str]]
    type: NotRequired[Union[Unset, str]]
    sha: NotRequired[Union[Unset, str]]
    size: NotRequired[Union[Unset, int]]
    url: NotRequired[Union[Unset, str]]


class HookResponseType(TypedDict):
    """Hook Response"""

    code: Union[int, None]
    status: Union[str, None]
    message: Union[str, None]


class HookType(TypedDict):
    """Webhook

    Webhooks for repositories.
    """

    type: str
    id: int
    name: str
    active: bool
    events: List[str]
    config: HookPropConfigType
    updated_at: datetime
    created_at: datetime
    url: str
    test_url: str
    ping_url: str
    deliveries_url: NotRequired[Union[Unset, str]]
    last_response: HookResponseType


class HookPropConfigType(TypedDict):
    """HookPropConfig"""

    email: NotRequired[Union[Unset, str]]
    password: NotRequired[Union[Unset, str]]
    room: NotRequired[Union[Unset, str]]
    subdomain: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    insecure_ssl: NotRequired[Union[Unset, Union[str, float]]]
    content_type: NotRequired[Union[Unset, str]]
    digest: NotRequired[Union[Unset, str]]
    secret: NotRequired[Union[Unset, str]]
    token: NotRequired[Union[Unset, str]]


class ImportType(TypedDict):
    """Import

    A repository import from an external source.
    """

    vcs: Union[str, None]
    use_lfs: NotRequired[Union[Unset, bool]]
    vcs_url: str
    svc_root: NotRequired[Union[Unset, str]]
    tfvc_project: NotRequired[Union[Unset, str]]
    status: Literal[
        "auth",
        "error",
        "none",
        "detecting",
        "choose",
        "auth_failed",
        "importing",
        "mapping",
        "waiting_to_push",
        "pushing",
        "complete",
        "setup",
        "unknown",
        "detection_found_multiple",
        "detection_found_nothing",
        "detection_needs_auth",
    ]
    status_text: NotRequired[Union[Unset, Union[str, None]]]
    failed_step: NotRequired[Union[Unset, Union[str, None]]]
    error_message: NotRequired[Union[Unset, Union[str, None]]]
    import_percent: NotRequired[Union[Unset, Union[int, None]]]
    commit_count: NotRequired[Union[Unset, Union[int, None]]]
    push_percent: NotRequired[Union[Unset, Union[int, None]]]
    has_large_files: NotRequired[Union[Unset, bool]]
    large_files_size: NotRequired[Union[Unset, int]]
    large_files_count: NotRequired[Union[Unset, int]]
    project_choices: NotRequired[Union[Unset, List[ImportPropProjectChoicesItemsType]]]
    message: NotRequired[Union[Unset, str]]
    authors_count: NotRequired[Union[Unset, Union[int, None]]]
    url: str
    html_url: str
    authors_url: str
    repository_url: str
    svn_root: NotRequired[Union[Unset, str]]


class ImportPropProjectChoicesItemsType(TypedDict):
    """ImportPropProjectChoicesItems"""

    vcs: NotRequired[Union[Unset, str]]
    tfvc_project: NotRequired[Union[Unset, str]]
    human_name: NotRequired[Union[Unset, str]]


class PorterAuthorType(TypedDict):
    """Porter Author

    Porter Author
    """

    id: int
    remote_id: str
    remote_name: str
    email: str
    name: str
    url: str
    import_url: str


class PorterLargeFileType(TypedDict):
    """Porter Large File

    Porter Large File
    """

    ref_name: str
    path: str
    oid: str
    size: int


class IssueEventLabelType(TypedDict):
    """Issue Event Label

    Issue Event Label
    """

    name: Union[str, None]
    color: Union[str, None]


class IssueEventDismissedReviewType(TypedDict):
    """Issue Event Dismissed Review"""

    state: str
    review_id: int
    dismissal_message: Union[str, None]
    dismissal_commit_id: NotRequired[Union[Unset, Union[str, None]]]


class IssueEventMilestoneType(TypedDict):
    """Issue Event Milestone

    Issue Event Milestone
    """

    title: str


class IssueEventProjectCardType(TypedDict):
    """Issue Event Project Card

    Issue Event Project Card
    """

    url: str
    id: int
    project_url: str
    project_id: int
    column_name: str
    previous_column_name: NotRequired[Union[Unset, str]]


class IssueEventRenameType(TypedDict):
    """Issue Event Rename

    Issue Event Rename
    """

    from_: str
    to: str


class IssueEventType(TypedDict):
    """Issue Event

    Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: Union[None, SimpleUserType]
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: datetime
    issue: NotRequired[Union[Unset, Union[None, IssueType]]]
    label: NotRequired[Union[Unset, IssueEventLabelType]]
    assignee: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    assigner: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    review_requester: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    requested_reviewer: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    requested_team: NotRequired[Union[Unset, TeamType]]
    dismissed_review: NotRequired[Union[Unset, IssueEventDismissedReviewType]]
    milestone: NotRequired[Union[Unset, IssueEventMilestoneType]]
    project_card: NotRequired[Union[Unset, IssueEventProjectCardType]]
    rename: NotRequired[Union[Unset, IssueEventRenameType]]
    author_association: NotRequired[
        Union[
            Unset,
            Literal[
                "COLLABORATOR",
                "CONTRIBUTOR",
                "FIRST_TIMER",
                "FIRST_TIME_CONTRIBUTOR",
                "MANNEQUIN",
                "MEMBER",
                "NONE",
                "OWNER",
            ],
        ]
    ]
    lock_reason: NotRequired[Union[Unset, Union[str, None]]]
    performed_via_github_app: NotRequired[Union[Unset, Union[None, IntegrationType]]]


class LabeledIssueEventType(TypedDict):
    """Labeled Issue Event

    Labeled Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    label: LabeledIssueEventPropLabelType


class LabeledIssueEventPropLabelType(TypedDict):
    """LabeledIssueEventPropLabel"""

    name: str
    color: str


class UnlabeledIssueEventType(TypedDict):
    """Unlabeled Issue Event

    Unlabeled Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    label: UnlabeledIssueEventPropLabelType


class UnlabeledIssueEventPropLabelType(TypedDict):
    """UnlabeledIssueEventPropLabel"""

    name: str
    color: str


class AssignedIssueEventType(TypedDict):
    """Assigned Issue Event

    Assigned Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: IntegrationType
    assignee: SimpleUserType
    assigner: SimpleUserType


class UnassignedIssueEventType(TypedDict):
    """Unassigned Issue Event

    Unassigned Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    assignee: SimpleUserType
    assigner: SimpleUserType


class MilestonedIssueEventType(TypedDict):
    """Milestoned Issue Event

    Milestoned Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    milestone: MilestonedIssueEventPropMilestoneType


class MilestonedIssueEventPropMilestoneType(TypedDict):
    """MilestonedIssueEventPropMilestone"""

    title: str


class DemilestonedIssueEventType(TypedDict):
    """Demilestoned Issue Event

    Demilestoned Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    milestone: DemilestonedIssueEventPropMilestoneType


class DemilestonedIssueEventPropMilestoneType(TypedDict):
    """DemilestonedIssueEventPropMilestone"""

    title: str


class RenamedIssueEventType(TypedDict):
    """Renamed Issue Event

    Renamed Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    rename: RenamedIssueEventPropRenameType


class RenamedIssueEventPropRenameType(TypedDict):
    """RenamedIssueEventPropRename"""

    from_: str
    to: str


class ReviewRequestedIssueEventType(TypedDict):
    """Review Requested Issue Event

    Review Requested Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    review_requester: SimpleUserType
    requested_team: NotRequired[Union[Unset, TeamType]]
    requested_reviewer: NotRequired[Union[Unset, SimpleUserType]]


class ReviewRequestRemovedIssueEventType(TypedDict):
    """Review Request Removed Issue Event

    Review Request Removed Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    review_requester: SimpleUserType
    requested_team: NotRequired[Union[Unset, TeamType]]
    requested_reviewer: NotRequired[Union[Unset, SimpleUserType]]


class ReviewDismissedIssueEventType(TypedDict):
    """Review Dismissed Issue Event

    Review Dismissed Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    dismissed_review: ReviewDismissedIssueEventPropDismissedReviewType


class ReviewDismissedIssueEventPropDismissedReviewType(TypedDict):
    """ReviewDismissedIssueEventPropDismissedReview"""

    state: str
    review_id: int
    dismissal_message: Union[str, None]
    dismissal_commit_id: NotRequired[Union[Unset, str]]


class LockedIssueEventType(TypedDict):
    """Locked Issue Event

    Locked Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    lock_reason: Union[str, None]


class AddedToProjectIssueEventType(TypedDict):
    """Added to Project Issue Event

    Added to Project Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    project_card: NotRequired[Union[Unset, AddedToProjectIssueEventPropProjectCardType]]


class AddedToProjectIssueEventPropProjectCardType(TypedDict):
    """AddedToProjectIssueEventPropProjectCard"""

    id: int
    url: str
    project_id: int
    project_url: str
    column_name: str
    previous_column_name: NotRequired[Union[Unset, str]]


class MovedColumnInProjectIssueEventType(TypedDict):
    """Moved Column in Project Issue Event

    Moved Column in Project Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    project_card: NotRequired[
        Union[Unset, MovedColumnInProjectIssueEventPropProjectCardType]
    ]


class MovedColumnInProjectIssueEventPropProjectCardType(TypedDict):
    """MovedColumnInProjectIssueEventPropProjectCard"""

    id: int
    url: str
    project_id: int
    project_url: str
    column_name: str
    previous_column_name: NotRequired[Union[Unset, str]]


class RemovedFromProjectIssueEventType(TypedDict):
    """Removed from Project Issue Event

    Removed from Project Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    project_card: NotRequired[
        Union[Unset, RemovedFromProjectIssueEventPropProjectCardType]
    ]


class RemovedFromProjectIssueEventPropProjectCardType(TypedDict):
    """RemovedFromProjectIssueEventPropProjectCard"""

    id: int
    url: str
    project_id: int
    project_url: str
    column_name: str
    previous_column_name: NotRequired[Union[Unset, str]]


class ConvertedNoteToIssueIssueEventType(TypedDict):
    """Converted Note to Issue Issue Event

    Converted Note to Issue Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: IntegrationType
    project_card: NotRequired[
        Union[Unset, ConvertedNoteToIssueIssueEventPropProjectCardType]
    ]


class ConvertedNoteToIssueIssueEventPropProjectCardType(TypedDict):
    """ConvertedNoteToIssueIssueEventPropProjectCard"""

    id: int
    url: str
    project_id: int
    project_url: str
    column_name: str
    previous_column_name: NotRequired[Union[Unset, str]]


class LabelType(TypedDict):
    """Label

    Color-coded labels help you categorize and filter your issues (just like labels
    in Gmail).
    """

    id: int
    node_id: str
    url: str
    name: str
    description: Union[str, None]
    color: str
    default: bool


class TimelineCommentEventType(TypedDict):
    """Timeline Comment Event

    Timeline Comment Event
    """

    event: str
    actor: SimpleUserType
    id: int
    node_id: str
    url: str
    body: NotRequired[Union[Unset, str]]
    body_text: NotRequired[Union[Unset, str]]
    body_html: NotRequired[Union[Unset, str]]
    html_url: str
    user: SimpleUserType
    created_at: datetime
    updated_at: datetime
    issue_url: str
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    performed_via_github_app: NotRequired[Union[Unset, Union[None, IntegrationType]]]
    reactions: NotRequired[Union[Unset, ReactionRollupType]]


class TimelineCrossReferencedEventType(TypedDict):
    """Timeline Cross Referenced Event

    Timeline Cross Referenced Event
    """

    event: str
    actor: NotRequired[Union[Unset, SimpleUserType]]
    created_at: datetime
    updated_at: datetime
    source: TimelineCrossReferencedEventPropSourceType


class TimelineCrossReferencedEventPropSourceType(TypedDict):
    """TimelineCrossReferencedEventPropSource"""

    type: NotRequired[Union[Unset, str]]
    issue: NotRequired[Union[Unset, IssueType]]


class TimelineCommittedEventType(TypedDict):
    """Timeline Committed Event

    Timeline Committed Event
    """

    event: NotRequired[Union[Unset, str]]
    sha: str
    node_id: str
    url: str
    author: TimelineCommittedEventPropAuthorType
    committer: TimelineCommittedEventPropCommitterType
    message: str
    tree: TimelineCommittedEventPropTreeType
    parents: List[TimelineCommittedEventPropParentsItemsType]
    verification: TimelineCommittedEventPropVerificationType
    html_url: str


class TimelineCommittedEventPropAuthorType(TypedDict):
    """TimelineCommittedEventPropAuthor

    Identifying information for the git-user
    """

    date: datetime
    email: str
    name: str


class TimelineCommittedEventPropCommitterType(TypedDict):
    """TimelineCommittedEventPropCommitter

    Identifying information for the git-user
    """

    date: datetime
    email: str
    name: str


class TimelineCommittedEventPropTreeType(TypedDict):
    """TimelineCommittedEventPropTree"""

    sha: str
    url: str


class TimelineCommittedEventPropParentsItemsType(TypedDict):
    """TimelineCommittedEventPropParentsItems"""

    sha: str
    url: str
    html_url: str


class TimelineCommittedEventPropVerificationType(TypedDict):
    """TimelineCommittedEventPropVerification"""

    verified: bool
    reason: str
    signature: Union[str, None]
    payload: Union[str, None]


class TimelineReviewedEventType(TypedDict):
    """Timeline Reviewed Event

    Timeline Reviewed Event
    """

    event: str
    id: int
    node_id: str
    user: SimpleUserType
    body: Union[str, None]
    state: str
    html_url: str
    pull_request_url: str
    links: TimelineReviewedEventPropLinksType
    submitted_at: NotRequired[Union[Unset, datetime]]
    commit_id: str
    body_html: NotRequired[Union[Unset, str]]
    body_text: NotRequired[Union[Unset, str]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]


class TimelineReviewedEventPropLinksType(TypedDict):
    """TimelineReviewedEventPropLinks"""

    html: TimelineReviewedEventPropLinksPropHtmlType
    pull_request: TimelineReviewedEventPropLinksPropPullRequestType


class TimelineReviewedEventPropLinksPropHtmlType(TypedDict):
    """TimelineReviewedEventPropLinksPropHtml"""

    href: str


class TimelineReviewedEventPropLinksPropPullRequestType(TypedDict):
    """TimelineReviewedEventPropLinksPropPullRequest"""

    href: str


class PullRequestReviewCommentType(TypedDict):
    """Pull Request Review Comment

    Pull Request Review Comments are comments on a portion of the Pull Request's
    diff.
    """

    url: str
    pull_request_review_id: Union[int, None]
    id: int
    node_id: str
    diff_hunk: str
    path: str
    position: int
    original_position: int
    commit_id: str
    original_commit_id: str
    in_reply_to_id: NotRequired[Union[Unset, int]]
    user: SimpleUserType
    body: str
    created_at: datetime
    updated_at: datetime
    html_url: str
    pull_request_url: str
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    links: PullRequestReviewCommentPropLinksType
    start_line: NotRequired[Union[Unset, Union[int, None]]]
    original_start_line: NotRequired[Union[Unset, Union[int, None]]]
    start_side: NotRequired[Union[Unset, Literal["LEFT", "RIGHT", None]]]
    line: NotRequired[Union[Unset, int]]
    original_line: NotRequired[Union[Unset, int]]
    side: NotRequired[Union[Unset, Literal["LEFT", "RIGHT"]]]
    reactions: NotRequired[Union[Unset, ReactionRollupType]]
    body_html: NotRequired[Union[Unset, str]]
    body_text: NotRequired[Union[Unset, str]]


class PullRequestReviewCommentPropLinksType(TypedDict):
    """PullRequestReviewCommentPropLinks"""

    self_: PullRequestReviewCommentPropLinksPropSelfType
    html: PullRequestReviewCommentPropLinksPropHtmlType
    pull_request: PullRequestReviewCommentPropLinksPropPullRequestType


class PullRequestReviewCommentPropLinksPropSelfType(TypedDict):
    """PullRequestReviewCommentPropLinksPropSelf"""

    href: str


class PullRequestReviewCommentPropLinksPropHtmlType(TypedDict):
    """PullRequestReviewCommentPropLinksPropHtml"""

    href: str


class PullRequestReviewCommentPropLinksPropPullRequestType(TypedDict):
    """PullRequestReviewCommentPropLinksPropPullRequest"""

    href: str


class TimelineLineCommentedEventType(TypedDict):
    """Timeline Line Commented Event

    Timeline Line Commented Event
    """

    event: NotRequired[Union[Unset, str]]
    node_id: NotRequired[Union[Unset, str]]
    comments: NotRequired[Union[Unset, List[PullRequestReviewCommentType]]]


class TimelineCommitCommentedEventType(TypedDict):
    """Timeline Commit Commented Event

    Timeline Commit Commented Event
    """

    event: NotRequired[Union[Unset, str]]
    node_id: NotRequired[Union[Unset, str]]
    commit_id: NotRequired[Union[Unset, str]]
    comments: NotRequired[Union[Unset, List[CommitCommentType]]]


class TimelineAssignedIssueEventType(TypedDict):
    """Timeline Assigned Issue Event

    Timeline Assigned Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    assignee: SimpleUserType


class TimelineUnassignedIssueEventType(TypedDict):
    """Timeline Unassigned Issue Event

    Timeline Unassigned Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    assignee: SimpleUserType


class StateChangeIssueEventType(TypedDict):
    """State Change Issue Event

    State Change Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    state_reason: NotRequired[Union[Unset, Union[str, None]]]


class DeployKeyType(TypedDict):
    """Deploy Key

    An SSH key granting access to a single repository.
    """

    id: int
    key: str
    url: str
    title: str
    verified: bool
    created_at: str
    read_only: bool


class LanguageType(TypedDict):
    """Language

    Language
    """


class LicenseContentType(TypedDict):
    """License Content

    License Content
    """

    name: str
    path: str
    sha: str
    size: int
    url: str
    html_url: Union[str, None]
    git_url: Union[str, None]
    download_url: Union[str, None]
    type: str
    content: str
    encoding: str
    links: LicenseContentPropLinksType
    license_: Union[None, LicenseSimpleType]


class LicenseContentPropLinksType(TypedDict):
    """LicenseContentPropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class MergedUpstreamType(TypedDict):
    """Merged upstream

    Results of a successful merge upstream request
    """

    message: NotRequired[Union[Unset, str]]
    merge_type: NotRequired[Union[Unset, Literal["merge", "fast-forward", "none"]]]
    base_branch: NotRequired[Union[Unset, str]]


class PagesSourceHashType(TypedDict):
    """Pages Source Hash"""

    branch: str
    path: str


class PagesHttpsCertificateType(TypedDict):
    """Pages Https Certificate"""

    state: Literal[
        "new",
        "authorization_created",
        "authorization_pending",
        "authorized",
        "authorization_revoked",
        "issued",
        "uploaded",
        "approved",
        "errored",
        "bad_authz",
        "destroy_pending",
        "dns_changed",
    ]
    description: str
    domains: List[str]
    expires_at: NotRequired[Union[Unset, date]]


class PageType(TypedDict):
    """GitHub Pages

    The configuration for GitHub Pages for a repository.
    """

    url: str
    status: Literal["built", "building", "errored", None]
    cname: Union[str, None]
    protected_domain_state: NotRequired[
        Union[Unset, Literal["pending", "verified", "unverified", None]]
    ]
    pending_domain_unverified_at: NotRequired[Union[Unset, Union[datetime, None]]]
    custom_404: bool
    html_url: NotRequired[Union[Unset, str]]
    build_type: NotRequired[Union[Unset, Literal["legacy", "workflow", None]]]
    source: NotRequired[Union[Unset, PagesSourceHashType]]
    public: bool
    https_certificate: NotRequired[Union[Unset, PagesHttpsCertificateType]]
    https_enforced: NotRequired[Union[Unset, bool]]


class PageBuildType(TypedDict):
    """Page Build

    Page Build
    """

    url: str
    status: str
    error: PageBuildPropErrorType
    pusher: Union[None, SimpleUserType]
    commit: str
    duration: int
    created_at: datetime
    updated_at: datetime


class PageBuildPropErrorType(TypedDict):
    """PageBuildPropError"""

    message: Union[str, None]


class PageBuildStatusType(TypedDict):
    """Page Build Status

    Page Build Status
    """

    url: str
    status: str


class PagesHealthCheckType(TypedDict):
    """Pages Health Check Status

    Pages Health Check Status
    """

    domain: NotRequired[Union[Unset, PagesHealthCheckPropDomainType]]
    alt_domain: NotRequired[
        Union[Unset, Union[PagesHealthCheckPropAltDomainType, None]]
    ]


class PagesHealthCheckPropDomainType(TypedDict):
    """PagesHealthCheckPropDomain"""

    host: NotRequired[Union[Unset, str]]
    uri: NotRequired[Union[Unset, str]]
    nameservers: NotRequired[Union[Unset, str]]
    dns_resolves: NotRequired[Union[Unset, bool]]
    is_proxied: NotRequired[Union[Unset, Union[bool, None]]]
    is_cloudflare_ip: NotRequired[Union[Unset, Union[bool, None]]]
    is_fastly_ip: NotRequired[Union[Unset, Union[bool, None]]]
    is_old_ip_address: NotRequired[Union[Unset, Union[bool, None]]]
    is_a_record: NotRequired[Union[Unset, Union[bool, None]]]
    has_cname_record: NotRequired[Union[Unset, Union[bool, None]]]
    has_mx_records_present: NotRequired[Union[Unset, Union[bool, None]]]
    is_valid_domain: NotRequired[Union[Unset, bool]]
    is_apex_domain: NotRequired[Union[Unset, bool]]
    should_be_a_record: NotRequired[Union[Unset, Union[bool, None]]]
    is_cname_to_github_user_domain: NotRequired[Union[Unset, Union[bool, None]]]
    is_cname_to_pages_dot_github_dot_com: NotRequired[Union[Unset, Union[bool, None]]]
    is_cname_to_fastly: NotRequired[Union[Unset, Union[bool, None]]]
    is_pointed_to_github_pages_ip: NotRequired[Union[Unset, Union[bool, None]]]
    is_non_github_pages_ip_present: NotRequired[Union[Unset, Union[bool, None]]]
    is_pages_domain: NotRequired[Union[Unset, bool]]
    is_served_by_pages: NotRequired[Union[Unset, Union[bool, None]]]
    is_valid: NotRequired[Union[Unset, bool]]
    reason: NotRequired[Union[Unset, Union[str, None]]]
    responds_to_https: NotRequired[Union[Unset, bool]]
    enforces_https: NotRequired[Union[Unset, bool]]
    https_error: NotRequired[Union[Unset, Union[str, None]]]
    is_https_eligible: NotRequired[Union[Unset, Union[bool, None]]]
    caa_error: NotRequired[Union[Unset, Union[str, None]]]


class PagesHealthCheckPropAltDomainType(TypedDict):
    """PagesHealthCheckPropAltDomain"""

    host: NotRequired[Union[Unset, str]]
    uri: NotRequired[Union[Unset, str]]
    nameservers: NotRequired[Union[Unset, str]]
    dns_resolves: NotRequired[Union[Unset, bool]]
    is_proxied: NotRequired[Union[Unset, Union[bool, None]]]
    is_cloudflare_ip: NotRequired[Union[Unset, Union[bool, None]]]
    is_fastly_ip: NotRequired[Union[Unset, Union[bool, None]]]
    is_old_ip_address: NotRequired[Union[Unset, Union[bool, None]]]
    is_a_record: NotRequired[Union[Unset, Union[bool, None]]]
    has_cname_record: NotRequired[Union[Unset, Union[bool, None]]]
    has_mx_records_present: NotRequired[Union[Unset, Union[bool, None]]]
    is_valid_domain: NotRequired[Union[Unset, bool]]
    is_apex_domain: NotRequired[Union[Unset, bool]]
    should_be_a_record: NotRequired[Union[Unset, Union[bool, None]]]
    is_cname_to_github_user_domain: NotRequired[Union[Unset, Union[bool, None]]]
    is_cname_to_pages_dot_github_dot_com: NotRequired[Union[Unset, Union[bool, None]]]
    is_cname_to_fastly: NotRequired[Union[Unset, Union[bool, None]]]
    is_pointed_to_github_pages_ip: NotRequired[Union[Unset, Union[bool, None]]]
    is_non_github_pages_ip_present: NotRequired[Union[Unset, Union[bool, None]]]
    is_pages_domain: NotRequired[Union[Unset, bool]]
    is_served_by_pages: NotRequired[Union[Unset, Union[bool, None]]]
    is_valid: NotRequired[Union[Unset, bool]]
    reason: NotRequired[Union[Unset, Union[str, None]]]
    responds_to_https: NotRequired[Union[Unset, bool]]
    enforces_https: NotRequired[Union[Unset, bool]]
    https_error: NotRequired[Union[Unset, Union[str, None]]]
    is_https_eligible: NotRequired[Union[Unset, Union[bool, None]]]
    caa_error: NotRequired[Union[Unset, Union[str, None]]]


class PullRequestType(TypedDict):
    """Pull Request

    Pull requests let you tell others about changes you've pushed to a repository on
    GitHub. Once a pull request is sent, interested parties can review the set of
    changes, discuss potential modifications, and even push follow-up commits if
    necessary.
    """

    url: str
    id: int
    node_id: str
    html_url: str
    diff_url: str
    patch_url: str
    issue_url: str
    commits_url: str
    review_comments_url: str
    review_comment_url: str
    comments_url: str
    statuses_url: str
    number: int
    state: Literal["open", "closed"]
    locked: bool
    title: str
    user: Union[None, SimpleUserType]
    body: Union[str, None]
    labels: List[PullRequestPropLabelsItemsType]
    milestone: Union[None, MilestoneType]
    active_lock_reason: NotRequired[Union[Unset, Union[str, None]]]
    created_at: datetime
    updated_at: datetime
    closed_at: Union[datetime, None]
    merged_at: Union[datetime, None]
    merge_commit_sha: Union[str, None]
    assignee: Union[None, SimpleUserType]
    assignees: NotRequired[Union[Unset, Union[List[SimpleUserType], None]]]
    requested_reviewers: NotRequired[Union[Unset, Union[List[SimpleUserType], None]]]
    requested_teams: NotRequired[Union[Unset, Union[List[TeamSimpleType], None]]]
    head: PullRequestPropHeadType
    base: PullRequestPropBaseType
    links: PullRequestPropLinksType
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    auto_merge: AutoMergeType
    draft: NotRequired[Union[Unset, bool]]
    merged: bool
    mergeable: Union[bool, None]
    rebaseable: NotRequired[Union[Unset, Union[bool, None]]]
    mergeable_state: str
    merged_by: Union[None, SimpleUserType]
    comments: int
    review_comments: int
    maintainer_can_modify: bool
    commits: int
    additions: int
    deletions: int
    changed_files: int


class PullRequestPropLabelsItemsType(TypedDict):
    """PullRequestPropLabelsItems"""

    id: int
    node_id: str
    url: str
    name: str
    description: Union[str, None]
    color: str
    default: bool


class PullRequestPropHeadType(TypedDict):
    """PullRequestPropHead"""

    label: str
    ref: str
    repo: Union[PullRequestPropHeadPropRepoType, None]
    sha: str
    user: PullRequestPropHeadPropUserType


class PullRequestPropHeadPropRepoType(TypedDict):
    """PullRequestPropHeadPropRepo"""

    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    description: Union[str, None]
    downloads_url: str
    events_url: str
    fork: bool
    forks_url: str
    full_name: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    hooks_url: str
    html_url: str
    id: int
    node_id: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    name: str
    notifications_url: str
    owner: PullRequestPropHeadPropRepoPropOwnerType
    private: bool
    pulls_url: str
    releases_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    url: str
    clone_url: str
    default_branch: str
    forks: int
    forks_count: int
    git_url: str
    has_downloads: bool
    has_issues: bool
    has_projects: bool
    has_wiki: bool
    has_pages: bool
    homepage: Union[str, None]
    language: Union[str, None]
    master_branch: NotRequired[Union[Unset, str]]
    archived: bool
    disabled: bool
    visibility: NotRequired[Union[Unset, str]]
    mirror_url: Union[str, None]
    open_issues: int
    open_issues_count: int
    permissions: NotRequired[
        Union[Unset, PullRequestPropHeadPropRepoPropPermissionsType]
    ]
    temp_clone_token: NotRequired[Union[Unset, str]]
    allow_merge_commit: NotRequired[Union[Unset, bool]]
    allow_squash_merge: NotRequired[Union[Unset, bool]]
    allow_rebase_merge: NotRequired[Union[Unset, bool]]
    license_: Union[PullRequestPropHeadPropRepoPropLicenseType, None]
    pushed_at: datetime
    size: int
    ssh_url: str
    stargazers_count: int
    svn_url: str
    topics: NotRequired[Union[Unset, List[str]]]
    watchers: int
    watchers_count: int
    created_at: datetime
    updated_at: datetime
    allow_forking: NotRequired[Union[Unset, bool]]
    is_template: NotRequired[Union[Unset, bool]]


class PullRequestPropHeadPropRepoPropOwnerType(TypedDict):
    """PullRequestPropHeadPropRepoPropOwner"""

    avatar_url: str
    events_url: str
    followers_url: str
    following_url: str
    gists_url: str
    gravatar_id: Union[str, None]
    html_url: str
    id: int
    node_id: str
    login: str
    organizations_url: str
    received_events_url: str
    repos_url: str
    site_admin: bool
    starred_url: str
    subscriptions_url: str
    type: str
    url: str


class PullRequestPropHeadPropRepoPropPermissionsType(TypedDict):
    """PullRequestPropHeadPropRepoPropPermissions"""

    admin: bool
    maintain: NotRequired[Union[Unset, bool]]
    push: bool
    triage: NotRequired[Union[Unset, bool]]
    pull: bool


class PullRequestPropHeadPropRepoPropLicenseType(TypedDict):
    """PullRequestPropHeadPropRepoPropLicense"""

    key: str
    name: str
    url: Union[str, None]
    spdx_id: Union[str, None]
    node_id: str


class PullRequestPropHeadPropUserType(TypedDict):
    """PullRequestPropHeadPropUser"""

    avatar_url: str
    events_url: str
    followers_url: str
    following_url: str
    gists_url: str
    gravatar_id: Union[str, None]
    html_url: str
    id: int
    node_id: str
    login: str
    organizations_url: str
    received_events_url: str
    repos_url: str
    site_admin: bool
    starred_url: str
    subscriptions_url: str
    type: str
    url: str


class PullRequestPropBaseType(TypedDict):
    """PullRequestPropBase"""

    label: str
    ref: str
    repo: PullRequestPropBasePropRepoType
    sha: str
    user: PullRequestPropBasePropUserType


class PullRequestPropBasePropRepoType(TypedDict):
    """PullRequestPropBasePropRepo"""

    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    description: Union[str, None]
    downloads_url: str
    events_url: str
    fork: bool
    forks_url: str
    full_name: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    hooks_url: str
    html_url: str
    id: int
    is_template: NotRequired[Union[Unset, bool]]
    node_id: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    name: str
    notifications_url: str
    owner: PullRequestPropBasePropRepoPropOwnerType
    private: bool
    pulls_url: str
    releases_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    url: str
    clone_url: str
    default_branch: str
    forks: int
    forks_count: int
    git_url: str
    has_downloads: bool
    has_issues: bool
    has_projects: bool
    has_wiki: bool
    has_pages: bool
    homepage: Union[str, None]
    language: Union[str, None]
    master_branch: NotRequired[Union[Unset, str]]
    archived: bool
    disabled: bool
    visibility: NotRequired[Union[Unset, str]]
    mirror_url: Union[str, None]
    open_issues: int
    open_issues_count: int
    permissions: NotRequired[
        Union[Unset, PullRequestPropBasePropRepoPropPermissionsType]
    ]
    temp_clone_token: NotRequired[Union[Unset, str]]
    allow_merge_commit: NotRequired[Union[Unset, bool]]
    allow_squash_merge: NotRequired[Union[Unset, bool]]
    allow_rebase_merge: NotRequired[Union[Unset, bool]]
    license_: Union[None, LicenseSimpleType]
    pushed_at: datetime
    size: int
    ssh_url: str
    stargazers_count: int
    svn_url: str
    topics: NotRequired[Union[Unset, List[str]]]
    watchers: int
    watchers_count: int
    created_at: datetime
    updated_at: datetime
    allow_forking: NotRequired[Union[Unset, bool]]


class PullRequestPropBasePropRepoPropOwnerType(TypedDict):
    """PullRequestPropBasePropRepoPropOwner"""

    avatar_url: str
    events_url: str
    followers_url: str
    following_url: str
    gists_url: str
    gravatar_id: Union[str, None]
    html_url: str
    id: int
    node_id: str
    login: str
    organizations_url: str
    received_events_url: str
    repos_url: str
    site_admin: bool
    starred_url: str
    subscriptions_url: str
    type: str
    url: str


class PullRequestPropBasePropRepoPropPermissionsType(TypedDict):
    """PullRequestPropBasePropRepoPropPermissions"""

    admin: bool
    maintain: NotRequired[Union[Unset, bool]]
    push: bool
    triage: NotRequired[Union[Unset, bool]]
    pull: bool


class PullRequestPropBasePropUserType(TypedDict):
    """PullRequestPropBasePropUser"""

    avatar_url: str
    events_url: str
    followers_url: str
    following_url: str
    gists_url: str
    gravatar_id: Union[str, None]
    html_url: str
    id: int
    node_id: str
    login: str
    organizations_url: str
    received_events_url: str
    repos_url: str
    site_admin: bool
    starred_url: str
    subscriptions_url: str
    type: str
    url: str


class PullRequestPropLinksType(TypedDict):
    """PullRequestPropLinks"""

    comments: LinkType
    commits: LinkType
    statuses: LinkType
    html: LinkType
    issue: LinkType
    review_comments: LinkType
    review_comment: LinkType
    self_: LinkType


class PullRequestMergeResultType(TypedDict):
    """Pull Request Merge Result

    Pull Request Merge Result
    """

    sha: str
    merged: bool
    message: str


class PullRequestReviewRequestType(TypedDict):
    """Pull Request Review Request

    Pull Request Review Request
    """

    users: List[SimpleUserType]
    teams: List[TeamType]


class PullRequestReviewType(TypedDict):
    """Pull Request Review

    Pull Request Reviews are reviews on pull requests.
    """

    id: int
    node_id: str
    user: Union[None, SimpleUserType]
    body: str
    state: str
    html_url: str
    pull_request_url: str
    links: PullRequestReviewPropLinksType
    submitted_at: NotRequired[Union[Unset, datetime]]
    commit_id: str
    body_html: NotRequired[Union[Unset, str]]
    body_text: NotRequired[Union[Unset, str]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]


class PullRequestReviewPropLinksType(TypedDict):
    """PullRequestReviewPropLinks"""

    html: PullRequestReviewPropLinksPropHtmlType
    pull_request: PullRequestReviewPropLinksPropPullRequestType


class PullRequestReviewPropLinksPropHtmlType(TypedDict):
    """PullRequestReviewPropLinksPropHtml"""

    href: str


class PullRequestReviewPropLinksPropPullRequestType(TypedDict):
    """PullRequestReviewPropLinksPropPullRequest"""

    href: str


class ReviewCommentType(TypedDict):
    """Legacy Review Comment

    Legacy Review Comment
    """

    url: str
    pull_request_review_id: Union[int, None]
    id: int
    node_id: str
    diff_hunk: str
    path: str
    position: Union[int, None]
    original_position: int
    commit_id: str
    original_commit_id: str
    in_reply_to_id: NotRequired[Union[Unset, int]]
    user: Union[None, SimpleUserType]
    body: str
    created_at: datetime
    updated_at: datetime
    html_url: str
    pull_request_url: str
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    links: ReviewCommentPropLinksType
    body_text: NotRequired[Union[Unset, str]]
    body_html: NotRequired[Union[Unset, str]]
    reactions: NotRequired[Union[Unset, ReactionRollupType]]
    side: NotRequired[Union[Unset, Literal["LEFT", "RIGHT"]]]
    start_side: NotRequired[Union[Unset, Literal["LEFT", "RIGHT", None]]]
    line: NotRequired[Union[Unset, int]]
    original_line: NotRequired[Union[Unset, int]]
    start_line: NotRequired[Union[Unset, Union[int, None]]]
    original_start_line: NotRequired[Union[Unset, Union[int, None]]]


class ReviewCommentPropLinksType(TypedDict):
    """ReviewCommentPropLinks"""

    self_: LinkType
    html: LinkType
    pull_request: LinkType


class ReleaseAssetType(TypedDict):
    """Release Asset

    Data related to a release.
    """

    url: str
    browser_download_url: str
    id: int
    node_id: str
    name: str
    label: Union[str, None]
    state: Literal["uploaded", "open"]
    content_type: str
    size: int
    download_count: int
    created_at: datetime
    updated_at: datetime
    uploader: Union[None, SimpleUserType]


class ReleaseType(TypedDict):
    """Release

    A release.
    """

    url: str
    html_url: str
    assets_url: str
    upload_url: str
    tarball_url: Union[str, None]
    zipball_url: Union[str, None]
    id: int
    node_id: str
    tag_name: str
    target_commitish: str
    name: Union[str, None]
    body: NotRequired[Union[Unset, Union[str, None]]]
    draft: bool
    prerelease: bool
    created_at: datetime
    published_at: Union[datetime, None]
    author: SimpleUserType
    assets: List[ReleaseAssetType]
    body_html: NotRequired[Union[Unset, str]]
    body_text: NotRequired[Union[Unset, str]]
    mentions_count: NotRequired[Union[Unset, int]]
    discussion_url: NotRequired[Union[Unset, str]]
    reactions: NotRequired[Union[Unset, ReactionRollupType]]


class ReleaseNotesContentType(TypedDict):
    """Generated Release Notes Content

    Generated name and body describing a release
    """

    name: str
    body: str


class SecretScanningAlertType(TypedDict):
    """SecretScanningAlert"""

    number: NotRequired[Union[Unset, int]]
    created_at: NotRequired[Union[Unset, datetime]]
    updated_at: NotRequired[Union[Unset, datetime]]
    url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    locations_url: NotRequired[Union[Unset, str]]
    state: NotRequired[Union[Unset, Literal["open", "resolved"]]]
    resolution: NotRequired[
        Union[
            Unset,
            Literal[None, "false_positive", "wont_fix", "revoked", "used_in_tests"],
        ]
    ]
    resolved_at: NotRequired[Union[Unset, Union[datetime, None]]]
    resolved_by: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    secret_type: NotRequired[Union[Unset, str]]
    secret_type_display_name: NotRequired[Union[Unset, str]]
    secret: NotRequired[Union[Unset, str]]
    push_protection_bypassed: NotRequired[Union[Unset, Union[bool, None]]]
    push_protection_bypassed_by: NotRequired[Union[Unset, Union[None, SimpleUserType]]]
    push_protection_bypassed_at: NotRequired[Union[Unset, Union[datetime, None]]]


class SecretScanningLocationCommitType(TypedDict):
    """SecretScanningLocationCommit

    Represents a 'commit' secret scanning location type. This location type shows
    that a secret was detected inside a commit to a repository.
    """

    path: str
    start_line: float
    end_line: float
    start_column: float
    end_column: float
    blob_sha: str
    blob_url: str
    commit_sha: str
    commit_url: str


class SecretScanningLocationType(TypedDict):
    """SecretScanningLocation"""

    type: Literal["commit"]
    details: SecretScanningLocationCommitType


class StargazerType(TypedDict):
    """Stargazer

    Stargazer
    """

    starred_at: datetime
    user: Union[None, SimpleUserType]


class CommitActivityType(TypedDict):
    """Commit Activity

    Commit Activity
    """

    days: List[int]
    total: int
    week: int


class ContributorActivityType(TypedDict):
    """Contributor Activity

    Contributor Activity
    """

    author: Union[None, SimpleUserType]
    total: int
    weeks: List[ContributorActivityPropWeeksItemsType]


class ContributorActivityPropWeeksItemsType(TypedDict):
    """ContributorActivityPropWeeksItems"""

    w: NotRequired[Union[Unset, int]]
    a: NotRequired[Union[Unset, int]]
    d: NotRequired[Union[Unset, int]]
    c: NotRequired[Union[Unset, int]]


class ParticipationStatsType(TypedDict):
    """Participation Stats"""

    all_: List[int]
    owner: List[int]


class RepositorySubscriptionType(TypedDict):
    """Repository Invitation

    Repository invitations let you manage who you collaborate with.
    """

    subscribed: bool
    ignored: bool
    reason: Union[str, None]
    created_at: datetime
    url: str
    repository_url: str


class TagType(TypedDict):
    """Tag

    Tag
    """

    name: str
    commit: TagPropCommitType
    zipball_url: str
    tarball_url: str
    node_id: str


class TagPropCommitType(TypedDict):
    """TagPropCommit"""

    sha: str
    url: str


class TagProtectionType(TypedDict):
    """Tag protection

    Tag protection
    """

    id: NotRequired[Union[Unset, int]]
    created_at: NotRequired[Union[Unset, str]]
    updated_at: NotRequired[Union[Unset, str]]
    enabled: NotRequired[Union[Unset, bool]]
    pattern: str


class TopicType(TypedDict):
    """Topic

    A topic aggregates entities that are related to a subject.
    """

    names: List[str]


class TrafficType(TypedDict):
    """Traffic"""

    timestamp: datetime
    uniques: int
    count: int


class CloneTrafficType(TypedDict):
    """Clone Traffic

    Clone Traffic
    """

    count: int
    uniques: int
    clones: List[TrafficType]


class ContentTrafficType(TypedDict):
    """Content Traffic

    Content Traffic
    """

    path: str
    title: str
    count: int
    uniques: int


class ReferrerTrafficType(TypedDict):
    """Referrer Traffic

    Referrer Traffic
    """

    referrer: str
    count: int
    uniques: int


class ViewTrafficType(TypedDict):
    """View Traffic

    View Traffic
    """

    count: int
    uniques: int
    views: List[TrafficType]


class ScimGroupListEnterpriseType(TypedDict):
    """ScimGroupListEnterprise"""

    schemas: List[str]
    total_results: float
    items_per_page: float
    start_index: float
    resources: List[ScimGroupListEnterprisePropResourcesItemsType]


class ScimGroupListEnterprisePropResourcesItemsType(TypedDict):
    """ScimGroupListEnterprisePropResourcesItems"""

    schemas: List[str]
    id: str
    external_id: NotRequired[Union[Unset, Union[str, None]]]
    display_name: NotRequired[Union[Unset, str]]
    members: NotRequired[
        Union[
            Unset, List[ScimGroupListEnterprisePropResourcesItemsPropMembersItemsType]
        ]
    ]
    meta: NotRequired[
        Union[Unset, ScimGroupListEnterprisePropResourcesItemsPropMetaType]
    ]


class ScimGroupListEnterprisePropResourcesItemsPropMembersItemsType(TypedDict):
    """ScimGroupListEnterprisePropResourcesItemsPropMembersItems"""

    value: NotRequired[Union[Unset, str]]
    ref: NotRequired[Union[Unset, str]]
    display: NotRequired[Union[Unset, str]]


class ScimGroupListEnterprisePropResourcesItemsPropMetaType(TypedDict):
    """ScimGroupListEnterprisePropResourcesItemsPropMeta"""

    resource_type: NotRequired[Union[Unset, str]]
    created: NotRequired[Union[Unset, str]]
    last_modified: NotRequired[Union[Unset, str]]
    location: NotRequired[Union[Unset, str]]


class ScimEnterpriseGroupType(TypedDict):
    """ScimEnterpriseGroup"""

    schemas: List[str]
    id: str
    external_id: NotRequired[Union[Unset, Union[str, None]]]
    display_name: NotRequired[Union[Unset, str]]
    members: NotRequired[Union[Unset, List[ScimEnterpriseGroupPropMembersItemsType]]]
    meta: NotRequired[Union[Unset, ScimEnterpriseGroupPropMetaType]]


class ScimEnterpriseGroupPropMembersItemsType(TypedDict):
    """ScimEnterpriseGroupPropMembersItems"""

    value: NotRequired[Union[Unset, str]]
    ref: NotRequired[Union[Unset, str]]
    display: NotRequired[Union[Unset, str]]


class ScimEnterpriseGroupPropMetaType(TypedDict):
    """ScimEnterpriseGroupPropMeta"""

    resource_type: NotRequired[Union[Unset, str]]
    created: NotRequired[Union[Unset, str]]
    last_modified: NotRequired[Union[Unset, str]]
    location: NotRequired[Union[Unset, str]]


class ScimUserListEnterpriseType(TypedDict):
    """ScimUserListEnterprise"""

    schemas: List[str]
    total_results: float
    items_per_page: float
    start_index: float
    resources: List[ScimUserListEnterprisePropResourcesItemsType]


class ScimUserListEnterprisePropResourcesItemsType(TypedDict):
    """ScimUserListEnterprisePropResourcesItems"""

    schemas: List[str]
    id: str
    external_id: NotRequired[Union[Unset, str]]
    user_name: NotRequired[Union[Unset, str]]
    name: NotRequired[
        Union[Unset, ScimUserListEnterprisePropResourcesItemsPropNameType]
    ]
    emails: NotRequired[
        Union[Unset, List[ScimUserListEnterprisePropResourcesItemsPropEmailsItemsType]]
    ]
    groups: NotRequired[
        Union[Unset, List[ScimUserListEnterprisePropResourcesItemsPropGroupsItemsType]]
    ]
    active: NotRequired[Union[Unset, bool]]
    meta: NotRequired[
        Union[Unset, ScimUserListEnterprisePropResourcesItemsPropMetaType]
    ]


class ScimUserListEnterprisePropResourcesItemsPropNameType(TypedDict):
    """ScimUserListEnterprisePropResourcesItemsPropName"""

    given_name: NotRequired[Union[Unset, str]]
    family_name: NotRequired[Union[Unset, str]]


class ScimUserListEnterprisePropResourcesItemsPropEmailsItemsType(TypedDict):
    """ScimUserListEnterprisePropResourcesItemsPropEmailsItems"""

    value: NotRequired[Union[Unset, str]]
    primary: NotRequired[Union[Unset, bool]]
    type: NotRequired[Union[Unset, str]]


class ScimUserListEnterprisePropResourcesItemsPropGroupsItemsType(TypedDict):
    """ScimUserListEnterprisePropResourcesItemsPropGroupsItems"""

    value: NotRequired[Union[Unset, str]]


class ScimUserListEnterprisePropResourcesItemsPropMetaType(TypedDict):
    """ScimUserListEnterprisePropResourcesItemsPropMeta"""

    resource_type: NotRequired[Union[Unset, str]]
    created: NotRequired[Union[Unset, str]]
    last_modified: NotRequired[Union[Unset, str]]
    location: NotRequired[Union[Unset, str]]


class ScimEnterpriseUserType(TypedDict):
    """ScimEnterpriseUser"""

    schemas: List[str]
    id: str
    external_id: NotRequired[Union[Unset, str]]
    user_name: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, ScimEnterpriseUserPropNameType]]
    emails: NotRequired[Union[Unset, List[ScimEnterpriseUserPropEmailsItemsType]]]
    groups: NotRequired[Union[Unset, List[ScimEnterpriseUserPropGroupsItemsType]]]
    active: NotRequired[Union[Unset, bool]]
    meta: NotRequired[Union[Unset, ScimEnterpriseUserPropMetaType]]


class ScimEnterpriseUserPropNameType(TypedDict):
    """ScimEnterpriseUserPropName"""

    given_name: NotRequired[Union[Unset, str]]
    family_name: NotRequired[Union[Unset, str]]


class ScimEnterpriseUserPropEmailsItemsType(TypedDict):
    """ScimEnterpriseUserPropEmailsItems"""

    value: NotRequired[Union[Unset, str]]
    type: NotRequired[Union[Unset, str]]
    primary: NotRequired[Union[Unset, bool]]


class ScimEnterpriseUserPropGroupsItemsType(TypedDict):
    """ScimEnterpriseUserPropGroupsItems"""

    value: NotRequired[Union[Unset, str]]


class ScimEnterpriseUserPropMetaType(TypedDict):
    """ScimEnterpriseUserPropMeta"""

    resource_type: NotRequired[Union[Unset, str]]
    created: NotRequired[Union[Unset, str]]
    last_modified: NotRequired[Union[Unset, str]]
    location: NotRequired[Union[Unset, str]]


class ScimUserType(TypedDict):
    """SCIM /Users

    SCIM /Users provisioning endpoints
    """

    schemas: List[str]
    id: str
    external_id: Union[str, None]
    user_name: Union[str, None]
    display_name: NotRequired[Union[Unset, Union[str, None]]]
    name: ScimUserPropNameType
    emails: List[ScimUserPropEmailsItemsType]
    active: bool
    meta: ScimUserPropMetaType
    organization_id: NotRequired[Union[Unset, int]]
    operations: NotRequired[Union[Unset, List[ScimUserPropOperationsItemsType]]]
    groups: NotRequired[Union[Unset, List[Any]]]


class ScimUserPropNameType(TypedDict):
    """ScimUserPropName

    Examples:
        {'givenName': 'Jane', 'familyName': 'User'}
    """

    given_name: Union[str, None]
    family_name: Union[str, None]
    formatted: NotRequired[Union[Unset, Union[str, None]]]


class ScimUserPropEmailsItemsType(TypedDict):
    """ScimUserPropEmailsItems"""

    value: str
    primary: NotRequired[Union[Unset, bool]]


class ScimUserPropMetaType(TypedDict):
    """ScimUserPropMeta"""

    resource_type: NotRequired[Union[Unset, str]]
    created: NotRequired[Union[Unset, datetime]]
    last_modified: NotRequired[Union[Unset, datetime]]
    location: NotRequired[Union[Unset, str]]


class ScimUserPropOperationsItemsType(TypedDict):
    """ScimUserPropOperationsItems"""

    op: Literal["add", "remove", "replace"]
    path: NotRequired[Union[Unset, str]]
    value: NotRequired[
        Union[
            Unset, Union[str, ScimUserPropOperationsItemsPropValueOneof1Type, List[Any]]
        ]
    ]


class ScimUserPropOperationsItemsPropValueOneof1Type(TypedDict):
    """ScimUserPropOperationsItemsPropValueOneof1"""


class ScimUserListType(TypedDict):
    """SCIM User List

    SCIM User List
    """

    schemas: List[str]
    total_results: int
    items_per_page: int
    start_index: int
    resources: List[ScimUserType]


class SearchResultTextMatchesItemsType(TypedDict):
    """SearchResultTextMatchesItems"""

    object_url: NotRequired[Union[Unset, str]]
    object_type: NotRequired[Union[Unset, Union[str, None]]]
    property_: NotRequired[Union[Unset, str]]
    fragment: NotRequired[Union[Unset, str]]
    matches: NotRequired[
        Union[Unset, List[SearchResultTextMatchesItemsPropMatchesItemsType]]
    ]


class SearchResultTextMatchesItemsPropMatchesItemsType(TypedDict):
    """SearchResultTextMatchesItemsPropMatchesItems"""

    text: NotRequired[Union[Unset, str]]
    indices: NotRequired[Union[Unset, List[int]]]


class CodeSearchResultItemType(TypedDict):
    """Code Search Result Item

    Code Search Result Item
    """

    name: str
    path: str
    sha: str
    url: str
    git_url: str
    html_url: str
    repository: MinimalRepositoryType
    score: float
    file_size: NotRequired[Union[Unset, int]]
    language: NotRequired[Union[Unset, Union[str, None]]]
    last_modified_at: NotRequired[Union[Unset, datetime]]
    line_numbers: NotRequired[Union[Unset, List[str]]]
    text_matches: NotRequired[Union[Unset, List[SearchResultTextMatchesItemsType]]]


class CommitSearchResultItemType(TypedDict):
    """Commit Search Result Item

    Commit Search Result Item
    """

    url: str
    sha: str
    html_url: str
    comments_url: str
    commit: CommitSearchResultItemPropCommitType
    author: Union[None, SimpleUserType]
    committer: Union[None, GitUserType]
    parents: List[CommitSearchResultItemPropParentsItemsType]
    repository: MinimalRepositoryType
    score: float
    node_id: str
    text_matches: NotRequired[Union[Unset, List[SearchResultTextMatchesItemsType]]]


class CommitSearchResultItemPropCommitType(TypedDict):
    """CommitSearchResultItemPropCommit"""

    author: CommitSearchResultItemPropCommitPropAuthorType
    committer: Union[None, GitUserType]
    comment_count: int
    message: str
    tree: CommitSearchResultItemPropCommitPropTreeType
    url: str
    verification: NotRequired[Union[Unset, VerificationType]]


class CommitSearchResultItemPropCommitPropAuthorType(TypedDict):
    """CommitSearchResultItemPropCommitPropAuthor"""

    name: str
    email: str
    date: datetime


class CommitSearchResultItemPropCommitPropTreeType(TypedDict):
    """CommitSearchResultItemPropCommitPropTree"""

    sha: str
    url: str


class CommitSearchResultItemPropParentsItemsType(TypedDict):
    """CommitSearchResultItemPropParentsItems"""

    url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, str]]
    sha: NotRequired[Union[Unset, str]]


class IssueSearchResultItemType(TypedDict):
    """Issue Search Result Item

    Issue Search Result Item
    """

    url: str
    repository_url: str
    labels_url: str
    comments_url: str
    events_url: str
    html_url: str
    id: int
    node_id: str
    number: int
    title: str
    locked: bool
    active_lock_reason: NotRequired[Union[Unset, Union[str, None]]]
    assignees: NotRequired[Union[Unset, Union[List[SimpleUserType], None]]]
    user: Union[None, SimpleUserType]
    labels: List[IssueSearchResultItemPropLabelsItemsType]
    state: str
    state_reason: NotRequired[Union[Unset, Union[str, None]]]
    assignee: Union[None, SimpleUserType]
    milestone: Union[None, MilestoneType]
    comments: int
    created_at: datetime
    updated_at: datetime
    closed_at: Union[datetime, None]
    text_matches: NotRequired[Union[Unset, List[SearchResultTextMatchesItemsType]]]
    pull_request: NotRequired[Union[Unset, IssueSearchResultItemPropPullRequestType]]
    body: NotRequired[Union[Unset, str]]
    score: float
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    draft: NotRequired[Union[Unset, bool]]
    repository: NotRequired[Union[Unset, RepositoryType]]
    body_html: NotRequired[Union[Unset, str]]
    body_text: NotRequired[Union[Unset, str]]
    timeline_url: NotRequired[Union[Unset, str]]
    performed_via_github_app: NotRequired[Union[Unset, Union[None, IntegrationType]]]
    reactions: NotRequired[Union[Unset, ReactionRollupType]]


class IssueSearchResultItemPropLabelsItemsType(TypedDict):
    """IssueSearchResultItemPropLabelsItems"""

    id: NotRequired[Union[Unset, int]]
    node_id: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    color: NotRequired[Union[Unset, str]]
    default: NotRequired[Union[Unset, bool]]
    description: NotRequired[Union[Unset, Union[str, None]]]


class IssueSearchResultItemPropPullRequestType(TypedDict):
    """IssueSearchResultItemPropPullRequest"""

    merged_at: NotRequired[Union[Unset, Union[datetime, None]]]
    diff_url: Union[str, None]
    html_url: Union[str, None]
    patch_url: Union[str, None]
    url: Union[str, None]


class LabelSearchResultItemType(TypedDict):
    """Label Search Result Item

    Label Search Result Item
    """

    id: int
    node_id: str
    url: str
    name: str
    color: str
    default: bool
    description: Union[str, None]
    score: float
    text_matches: NotRequired[Union[Unset, List[SearchResultTextMatchesItemsType]]]


class RepoSearchResultItemType(TypedDict):
    """Repo Search Result Item

    Repo Search Result Item
    """

    id: int
    node_id: str
    name: str
    full_name: str
    owner: Union[None, SimpleUserType]
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    created_at: datetime
    updated_at: datetime
    pushed_at: datetime
    homepage: Union[str, None]
    size: int
    stargazers_count: int
    watchers_count: int
    language: Union[str, None]
    forks_count: int
    open_issues_count: int
    master_branch: NotRequired[Union[Unset, str]]
    default_branch: str
    score: float
    forks_url: str
    keys_url: str
    collaborators_url: str
    teams_url: str
    hooks_url: str
    issue_events_url: str
    events_url: str
    assignees_url: str
    branches_url: str
    tags_url: str
    blobs_url: str
    git_tags_url: str
    git_refs_url: str
    trees_url: str
    statuses_url: str
    languages_url: str
    stargazers_url: str
    contributors_url: str
    subscribers_url: str
    subscription_url: str
    commits_url: str
    git_commits_url: str
    comments_url: str
    issue_comment_url: str
    contents_url: str
    compare_url: str
    merges_url: str
    archive_url: str
    downloads_url: str
    issues_url: str
    pulls_url: str
    milestones_url: str
    notifications_url: str
    labels_url: str
    releases_url: str
    deployments_url: str
    git_url: str
    ssh_url: str
    clone_url: str
    svn_url: str
    forks: int
    open_issues: int
    watchers: int
    topics: NotRequired[Union[Unset, List[str]]]
    mirror_url: Union[str, None]
    has_issues: bool
    has_projects: bool
    has_pages: bool
    has_wiki: bool
    has_downloads: bool
    archived: bool
    disabled: bool
    visibility: NotRequired[Union[Unset, str]]
    license_: Union[None, LicenseSimpleType]
    permissions: NotRequired[Union[Unset, RepoSearchResultItemPropPermissionsType]]
    text_matches: NotRequired[Union[Unset, List[SearchResultTextMatchesItemsType]]]
    temp_clone_token: NotRequired[Union[Unset, str]]
    allow_merge_commit: NotRequired[Union[Unset, bool]]
    allow_squash_merge: NotRequired[Union[Unset, bool]]
    allow_rebase_merge: NotRequired[Union[Unset, bool]]
    allow_auto_merge: NotRequired[Union[Unset, bool]]
    delete_branch_on_merge: NotRequired[Union[Unset, bool]]
    allow_forking: NotRequired[Union[Unset, bool]]
    is_template: NotRequired[Union[Unset, bool]]


class RepoSearchResultItemPropPermissionsType(TypedDict):
    """RepoSearchResultItemPropPermissions"""

    admin: bool
    maintain: NotRequired[Union[Unset, bool]]
    push: bool
    triage: NotRequired[Union[Unset, bool]]
    pull: bool


class TopicSearchResultItemType(TypedDict):
    """Topic Search Result Item

    Topic Search Result Item
    """

    name: str
    display_name: Union[str, None]
    short_description: Union[str, None]
    description: Union[str, None]
    created_by: Union[str, None]
    released: Union[str, None]
    created_at: datetime
    updated_at: datetime
    featured: bool
    curated: bool
    score: float
    repository_count: NotRequired[Union[Unset, Union[int, None]]]
    logo_url: NotRequired[Union[Unset, Union[str, None]]]
    text_matches: NotRequired[Union[Unset, List[SearchResultTextMatchesItemsType]]]
    related: NotRequired[
        Union[Unset, Union[List[TopicSearchResultItemPropRelatedItemsType], None]]
    ]
    aliases: NotRequired[
        Union[Unset, Union[List[TopicSearchResultItemPropAliasesItemsType], None]]
    ]


class TopicSearchResultItemPropRelatedItemsType(TypedDict):
    """TopicSearchResultItemPropRelatedItems"""

    topic_relation: NotRequired[
        Union[Unset, TopicSearchResultItemPropRelatedItemsPropTopicRelationType]
    ]


class TopicSearchResultItemPropRelatedItemsPropTopicRelationType(TypedDict):
    """TopicSearchResultItemPropRelatedItemsPropTopicRelation"""

    id: NotRequired[Union[Unset, int]]
    name: NotRequired[Union[Unset, str]]
    topic_id: NotRequired[Union[Unset, int]]
    relation_type: NotRequired[Union[Unset, str]]


class TopicSearchResultItemPropAliasesItemsType(TypedDict):
    """TopicSearchResultItemPropAliasesItems"""

    topic_relation: NotRequired[
        Union[Unset, TopicSearchResultItemPropAliasesItemsPropTopicRelationType]
    ]


class TopicSearchResultItemPropAliasesItemsPropTopicRelationType(TypedDict):
    """TopicSearchResultItemPropAliasesItemsPropTopicRelation"""

    id: NotRequired[Union[Unset, int]]
    name: NotRequired[Union[Unset, str]]
    topic_id: NotRequired[Union[Unset, int]]
    relation_type: NotRequired[Union[Unset, str]]


class UserSearchResultItemType(TypedDict):
    """User Search Result Item

    User Search Result Item
    """

    login: str
    id: int
    node_id: str
    avatar_url: str
    gravatar_id: Union[str, None]
    url: str
    html_url: str
    followers_url: str
    subscriptions_url: str
    organizations_url: str
    repos_url: str
    received_events_url: str
    type: str
    score: float
    following_url: str
    gists_url: str
    starred_url: str
    events_url: str
    public_repos: NotRequired[Union[Unset, int]]
    public_gists: NotRequired[Union[Unset, int]]
    followers: NotRequired[Union[Unset, int]]
    following: NotRequired[Union[Unset, int]]
    created_at: NotRequired[Union[Unset, datetime]]
    updated_at: NotRequired[Union[Unset, datetime]]
    name: NotRequired[Union[Unset, Union[str, None]]]
    bio: NotRequired[Union[Unset, Union[str, None]]]
    email: NotRequired[Union[Unset, Union[str, None]]]
    location: NotRequired[Union[Unset, Union[str, None]]]
    site_admin: bool
    hireable: NotRequired[Union[Unset, Union[bool, None]]]
    text_matches: NotRequired[Union[Unset, List[SearchResultTextMatchesItemsType]]]
    blog: NotRequired[Union[Unset, Union[str, None]]]
    company: NotRequired[Union[Unset, Union[str, None]]]
    suspended_at: NotRequired[Union[Unset, Union[datetime, None]]]


class PrivateUserType(TypedDict):
    """Private User

    Private User
    """

    login: str
    id: int
    node_id: str
    avatar_url: str
    gravatar_id: Union[str, None]
    url: str
    html_url: str
    followers_url: str
    following_url: str
    gists_url: str
    starred_url: str
    subscriptions_url: str
    organizations_url: str
    repos_url: str
    events_url: str
    received_events_url: str
    type: str
    site_admin: bool
    name: Union[str, None]
    company: Union[str, None]
    blog: Union[str, None]
    location: Union[str, None]
    email: Union[str, None]
    hireable: Union[bool, None]
    bio: Union[str, None]
    twitter_username: NotRequired[Union[Unset, Union[str, None]]]
    public_repos: int
    public_gists: int
    followers: int
    following: int
    created_at: datetime
    updated_at: datetime
    private_gists: int
    total_private_repos: int
    owned_private_repos: int
    disk_usage: int
    collaborators: int
    two_factor_authentication: bool
    plan: NotRequired[Union[Unset, PrivateUserPropPlanType]]
    suspended_at: NotRequired[Union[Unset, Union[datetime, None]]]
    business_plus: NotRequired[Union[Unset, bool]]
    ldap_dn: NotRequired[Union[Unset, str]]


class PrivateUserPropPlanType(TypedDict):
    """PrivateUserPropPlan"""

    collaborators: int
    name: str
    space: int
    private_repos: int


class CodespacesSecretType(TypedDict):
    """Codespaces Secret

    Secrets for a GitHub Codespace.
    """

    name: str
    created_at: datetime
    updated_at: datetime
    visibility: Literal["all", "private", "selected"]
    selected_repositories_url: str


class CodespacesUserPublicKeyType(TypedDict):
    """CodespacesUserPublicKey

    The public key used for setting user Codespaces' Secrets.
    """

    key_id: str
    key: str


class CodespaceExportDetailsType(TypedDict):
    """Fetches information about an export of a codespace.

    An export of a codespace. Also, latest export details for a codespace can be
    fetched with id = latest
    """

    state: NotRequired[Union[Unset, Union[str, None]]]
    completed_at: NotRequired[Union[Unset, Union[datetime, None]]]
    branch: NotRequired[Union[Unset, Union[str, None]]]
    sha: NotRequired[Union[Unset, Union[str, None]]]
    id: NotRequired[Union[Unset, str]]
    export_url: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, Union[str, None]]]


class EmailType(TypedDict):
    """Email

    Email
    """

    email: str
    primary: bool
    verified: bool
    visibility: Union[str, None]


class GpgKeyType(TypedDict):
    """GPG Key

    A unique encryption key
    """

    id: int
    name: NotRequired[Union[Unset, Union[str, None]]]
    primary_key_id: Union[int, None]
    key_id: str
    public_key: str
    emails: List[GpgKeyPropEmailsItemsType]
    subkeys: List[GpgKeyPropSubkeysItemsType]
    can_sign: bool
    can_encrypt_comms: bool
    can_encrypt_storage: bool
    can_certify: bool
    created_at: datetime
    expires_at: Union[datetime, None]
    revoked: bool
    raw_key: Union[str, None]


class GpgKeyPropEmailsItemsType(TypedDict):
    """GpgKeyPropEmailsItems"""

    email: NotRequired[Union[Unset, str]]
    verified: NotRequired[Union[Unset, bool]]


class GpgKeyPropSubkeysItemsType(TypedDict):
    """GpgKeyPropSubkeysItems"""

    id: NotRequired[Union[Unset, int]]
    primary_key_id: NotRequired[Union[Unset, int]]
    key_id: NotRequired[Union[Unset, str]]
    public_key: NotRequired[Union[Unset, str]]
    emails: NotRequired[Union[Unset, List[Any]]]
    subkeys: NotRequired[Union[Unset, List[Any]]]
    can_sign: NotRequired[Union[Unset, bool]]
    can_encrypt_comms: NotRequired[Union[Unset, bool]]
    can_encrypt_storage: NotRequired[Union[Unset, bool]]
    can_certify: NotRequired[Union[Unset, bool]]
    created_at: NotRequired[Union[Unset, str]]
    expires_at: NotRequired[Union[Unset, Union[str, None]]]
    raw_key: NotRequired[Union[Unset, Union[str, None]]]
    revoked: NotRequired[Union[Unset, bool]]


class KeyType(TypedDict):
    """Key

    Key
    """

    key: str
    id: int
    url: str
    title: str
    created_at: datetime
    verified: bool
    read_only: bool


class MarketplaceAccountType(TypedDict):
    """Marketplace Account"""

    url: str
    id: int
    type: str
    node_id: NotRequired[Union[Unset, str]]
    login: str
    email: NotRequired[Union[Unset, Union[str, None]]]
    organization_billing_email: NotRequired[Union[Unset, Union[str, None]]]


class UserMarketplacePurchaseType(TypedDict):
    """User Marketplace Purchase

    User Marketplace Purchase
    """

    billing_cycle: str
    next_billing_date: Union[datetime, None]
    unit_count: Union[int, None]
    on_free_trial: bool
    free_trial_ends_on: Union[datetime, None]
    updated_at: Union[datetime, None]
    account: MarketplaceAccountType
    plan: MarketplaceListingPlanType


class StarredRepositoryType(TypedDict):
    """Starred Repository

    Starred Repository
    """

    starred_at: datetime
    repo: RepositoryType


class HovercardType(TypedDict):
    """Hovercard

    Hovercard
    """

    contexts: List[HovercardPropContextsItemsType]


class HovercardPropContextsItemsType(TypedDict):
    """HovercardPropContextsItems"""

    message: str
    octicon: str


class KeySimpleType(TypedDict):
    """Key Simple

    Key Simple
    """

    id: int
    key: str


class AppManifestsCodeConversionsPostResponse201Type(TypedDict):
    """AppManifestsCodeConversionsPostResponse201"""

    id: int
    slug: NotRequired[Union[Unset, str]]
    node_id: str
    owner: Union[None, SimpleUserType]
    name: str
    description: Union[str, None]
    external_url: str
    html_url: str
    created_at: datetime
    updated_at: datetime
    permissions: IntegrationPropPermissionsType
    events: List[str]
    installations_count: NotRequired[Union[Unset, int]]
    client_id: str
    client_secret: str
    webhook_secret: Union[str, None]
    pem: str


class AppManifestsCodeConversionsPostResponse201Allof1Type(TypedDict):
    """AppManifestsCodeConversionsPostResponse201Allof1"""

    client_id: str
    client_secret: str
    webhook_secret: Union[str, None]
    pem: str


class AppHookConfigPatchBodyType(TypedDict):
    """AppHookConfigPatchBody"""

    url: NotRequired[Union[Unset, str]]
    content_type: NotRequired[Union[Unset, str]]
    secret: NotRequired[Union[Unset, str]]
    insecure_ssl: NotRequired[Union[Unset, Union[str, float]]]


class AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type(TypedDict):
    """AppHookDeliveriesDeliveryIdAttemptsPostResponse202"""


class AppInstallationsInstallationIdAccessTokensPostBodyType(TypedDict):
    """AppInstallationsInstallationIdAccessTokensPostBody"""

    repositories: NotRequired[Union[Unset, List[str]]]
    repository_ids: NotRequired[Union[Unset, List[int]]]
    permissions: NotRequired[Union[Unset, AppPermissionsType]]


class ApplicationsClientIdGrantDeleteBodyType(TypedDict):
    """ApplicationsClientIdGrantDeleteBody"""

    access_token: str


class ApplicationsClientIdTokenPostBodyType(TypedDict):
    """ApplicationsClientIdTokenPostBody"""

    access_token: str


class ApplicationsClientIdTokenDeleteBodyType(TypedDict):
    """ApplicationsClientIdTokenDeleteBody"""

    access_token: str


class ApplicationsClientIdTokenPatchBodyType(TypedDict):
    """ApplicationsClientIdTokenPatchBody"""

    access_token: str


class ApplicationsClientIdTokenScopedPostBodyType(TypedDict):
    """ApplicationsClientIdTokenScopedPostBody"""

    access_token: str
    target: NotRequired[Union[Unset, str]]
    target_id: NotRequired[Union[Unset, int]]
    repositories: NotRequired[Union[Unset, List[str]]]
    repository_ids: NotRequired[Union[Unset, List[int]]]
    permissions: NotRequired[Union[Unset, AppPermissionsType]]


class AuthorizationsPostBodyType(TypedDict):
    """AuthorizationsPostBody"""

    scopes: NotRequired[Union[Unset, Union[List[str], None]]]
    note: NotRequired[Union[Unset, str]]
    note_url: NotRequired[Union[Unset, str]]
    client_id: NotRequired[Union[Unset, str]]
    client_secret: NotRequired[Union[Unset, str]]
    fingerprint: NotRequired[Union[Unset, str]]


class AuthorizationsClientsClientIdPutBodyType(TypedDict):
    """AuthorizationsClientsClientIdPutBody"""

    client_secret: str
    scopes: NotRequired[Union[Unset, Union[List[str], None]]]
    note: NotRequired[Union[Unset, str]]
    note_url: NotRequired[Union[Unset, str]]
    fingerprint: NotRequired[Union[Unset, str]]


class AuthorizationsClientsClientIdFingerprintPutBodyType(TypedDict):
    """AuthorizationsClientsClientIdFingerprintPutBody"""

    client_secret: str
    scopes: NotRequired[Union[Unset, Union[List[str], None]]]
    note: NotRequired[Union[Unset, str]]
    note_url: NotRequired[Union[Unset, str]]


class AuthorizationsAuthorizationIdPatchBodyType(TypedDict):
    """AuthorizationsAuthorizationIdPatchBody"""

    scopes: NotRequired[Union[Unset, Union[List[str], None]]]
    add_scopes: NotRequired[Union[Unset, List[str]]]
    remove_scopes: NotRequired[Union[Unset, List[str]]]
    note: NotRequired[Union[Unset, str]]
    note_url: NotRequired[Union[Unset, str]]
    fingerprint: NotRequired[Union[Unset, str]]


class EmojisGetResponse200Type(TypedDict):
    """EmojisGetResponse200"""


class EnterprisesEnterpriseActionsPermissionsPutBodyType(TypedDict):
    """EnterprisesEnterpriseActionsPermissionsPutBody"""

    enabled_organizations: Literal["all", "none", "selected"]
    allowed_actions: NotRequired[Union[Unset, Literal["all", "local_only", "selected"]]]


class EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200Type(TypedDict):
    """EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200"""

    total_count: float
    organizations: List[OrganizationSimpleType]


class EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType(TypedDict):
    """EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody"""

    selected_organization_ids: List[int]


class EnterprisesEnterpriseActionsRunnerGroupsGetResponse200Type(TypedDict):
    """EnterprisesEnterpriseActionsRunnerGroupsGetResponse200"""

    total_count: float
    runner_groups: List[RunnerGroupsEnterpriseType]


class EnterprisesEnterpriseActionsRunnerGroupsPostBodyType(TypedDict):
    """EnterprisesEnterpriseActionsRunnerGroupsPostBody"""

    name: str
    visibility: NotRequired[Union[Unset, Literal["selected", "all"]]]
    selected_organization_ids: NotRequired[Union[Unset, List[int]]]
    runners: NotRequired[Union[Unset, List[int]]]
    allows_public_repositories: NotRequired[Union[Unset, bool]]
    restricted_to_workflows: NotRequired[Union[Unset, bool]]
    selected_workflows: NotRequired[Union[Unset, List[str]]]


class EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType(TypedDict):
    """EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody"""

    name: NotRequired[Union[Unset, str]]
    visibility: NotRequired[Union[Unset, Literal["selected", "all"]]]
    allows_public_repositories: NotRequired[Union[Unset, bool]]
    restricted_to_workflows: NotRequired[Union[Unset, bool]]
    selected_workflows: NotRequired[Union[Unset, List[str]]]


class EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200Type(
    TypedDict
):
    """EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200"""

    total_count: float
    organizations: List[OrganizationSimpleType]


class EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType(
    TypedDict
):
    """EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody"""

    selected_organization_ids: List[int]


class EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type(
    TypedDict
):
    """EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200"""

    total_count: float
    runners: List[RunnerType]


class EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType(
    TypedDict
):
    """EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody"""

    runners: List[int]


class EnterprisesEnterpriseActionsRunnersGetResponse200Type(TypedDict):
    """EnterprisesEnterpriseActionsRunnersGetResponse200"""

    total_count: NotRequired[Union[Unset, float]]
    runners: NotRequired[Union[Unset, List[RunnerType]]]


class EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type(TypedDict):
    """EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200"""

    total_count: int
    labels: List[RunnerLabelType]


class EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType(TypedDict):
    """EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody"""

    labels: List[str]


class EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType(TypedDict):
    """EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody"""

    labels: List[str]


class EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type(TypedDict):
    """EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200"""

    total_count: int
    labels: List[RunnerLabelType]


class EnterprisesEnterpriseCodeScanningAlertsGetResponse503Type(TypedDict):
    """EnterprisesEnterpriseCodeScanningAlertsGetResponse503"""

    code: NotRequired[Union[Unset, str]]
    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]


class GistsPostBodyType(TypedDict):
    """GistsPostBody"""

    description: NotRequired[Union[Unset, str]]
    files: GistsPostBodyPropFilesType
    public: NotRequired[Union[Unset, Union[bool, Literal["true", "false"]]]]


class GistsPostBodyPropFilesType(TypedDict):
    """GistsPostBodyPropFiles

    Names and content for the files that make up the gist

    Examples:
        {'hello.rb': {'content': 'puts "Hello, World!"'}}
    """


class GistsGistIdGetResponse403Type(TypedDict):
    """GistsGistIdGetResponse403"""

    block: NotRequired[Union[Unset, GistsGistIdGetResponse403PropBlockType]]
    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]


class GistsGistIdGetResponse403PropBlockType(TypedDict):
    """GistsGistIdGetResponse403PropBlock"""

    reason: NotRequired[Union[Unset, str]]
    created_at: NotRequired[Union[Unset, str]]
    html_url: NotRequired[Union[Unset, Union[str, None]]]


class GistsGistIdPatchBodyType(TypedDict):
    """GistsGistIdPatchBody"""

    description: NotRequired[Union[Unset, str]]
    files: NotRequired[Union[Unset, GistsGistIdPatchBodyPropFilesType]]


class GistsGistIdPatchBodyPropFilesType(TypedDict):
    """GistsGistIdPatchBodyPropFiles

    Names of files to be updated

    Examples:
        {'hello.rb': {'content': 'blah', 'filename': 'goodbye.rb'}}
    """


class GistsGistIdCommentsPostBodyType(TypedDict):
    """GistsGistIdCommentsPostBody"""

    body: str


class GistsGistIdCommentsCommentIdPatchBodyType(TypedDict):
    """GistsGistIdCommentsCommentIdPatchBody"""

    body: str


class GistsGistIdStarGetResponse404Type(TypedDict):
    """GistsGistIdStarGetResponse404"""


class InstallationRepositoriesGetResponse200Type(TypedDict):
    """InstallationRepositoriesGetResponse200"""

    total_count: int
    repositories: List[RepositoryType]
    repository_selection: NotRequired[Union[Unset, str]]


class MarkdownPostBodyType(TypedDict):
    """MarkdownPostBody"""

    text: str
    mode: NotRequired[Union[Unset, Literal["markdown", "gfm"]]]
    context: NotRequired[Union[Unset, str]]


class NotificationsPutBodyType(TypedDict):
    """NotificationsPutBody"""

    last_read_at: NotRequired[Union[Unset, datetime]]
    read: NotRequired[Union[Unset, bool]]


class NotificationsPutResponse202Type(TypedDict):
    """NotificationsPutResponse202"""

    message: NotRequired[Union[Unset, str]]


class NotificationsThreadsThreadIdSubscriptionPutBodyType(TypedDict):
    """NotificationsThreadsThreadIdSubscriptionPutBody"""

    ignored: NotRequired[Union[Unset, bool]]


class OrganizationsOrganizationIdCustomRolesGetResponse200Type(TypedDict):
    """OrganizationsOrganizationIdCustomRolesGetResponse200"""

    total_count: NotRequired[Union[Unset, int]]
    custom_roles: NotRequired[Union[Unset, List[OrganizationCustomRepositoryRoleType]]]


class OrgsOrgPatchBodyType(TypedDict):
    """OrgsOrgPatchBody"""

    billing_email: NotRequired[Union[Unset, str]]
    company: NotRequired[Union[Unset, str]]
    email: NotRequired[Union[Unset, str]]
    twitter_username: NotRequired[Union[Unset, str]]
    location: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, str]]
    has_organization_projects: NotRequired[Union[Unset, bool]]
    has_repository_projects: NotRequired[Union[Unset, bool]]
    default_repository_permission: NotRequired[
        Union[Unset, Literal["read", "write", "admin", "none"]]
    ]
    members_can_create_repositories: NotRequired[Union[Unset, bool]]
    members_can_create_internal_repositories: NotRequired[Union[Unset, bool]]
    members_can_create_private_repositories: NotRequired[Union[Unset, bool]]
    members_can_create_public_repositories: NotRequired[Union[Unset, bool]]
    members_allowed_repository_creation_type: NotRequired[
        Union[Unset, Literal["all", "private", "none"]]
    ]
    members_can_create_pages: NotRequired[Union[Unset, bool]]
    members_can_create_public_pages: NotRequired[Union[Unset, bool]]
    members_can_create_private_pages: NotRequired[Union[Unset, bool]]
    members_can_fork_private_repositories: NotRequired[Union[Unset, bool]]
    blog: NotRequired[Union[Unset, str]]


class OrgsOrgActionsCacheUsageByRepositoryGetResponse200Type(TypedDict):
    """OrgsOrgActionsCacheUsageByRepositoryGetResponse200"""

    total_count: int
    repository_cache_usages: List[ActionsCacheUsageByRepositoryType]


class OrgsOrgActionsPermissionsPutBodyType(TypedDict):
    """OrgsOrgActionsPermissionsPutBody"""

    enabled_repositories: Literal["all", "none", "selected"]
    allowed_actions: NotRequired[Union[Unset, Literal["all", "local_only", "selected"]]]


class OrgsOrgActionsPermissionsRepositoriesGetResponse200Type(TypedDict):
    """OrgsOrgActionsPermissionsRepositoriesGetResponse200"""

    total_count: float
    repositories: List[RepositoryType]


class OrgsOrgActionsPermissionsRepositoriesPutBodyType(TypedDict):
    """OrgsOrgActionsPermissionsRepositoriesPutBody"""

    selected_repository_ids: List[int]


class OrgsOrgActionsRunnerGroupsGetResponse200Type(TypedDict):
    """OrgsOrgActionsRunnerGroupsGetResponse200"""

    total_count: float
    runner_groups: List[RunnerGroupsOrgType]


class OrgsOrgActionsRunnerGroupsPostBodyType(TypedDict):
    """OrgsOrgActionsRunnerGroupsPostBody"""

    name: str
    visibility: NotRequired[Union[Unset, Literal["selected", "all", "private"]]]
    selected_repository_ids: NotRequired[Union[Unset, List[int]]]
    runners: NotRequired[Union[Unset, List[int]]]
    allows_public_repositories: NotRequired[Union[Unset, bool]]
    restricted_to_workflows: NotRequired[Union[Unset, bool]]
    selected_workflows: NotRequired[Union[Unset, List[str]]]


class OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType(TypedDict):
    """OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBody"""

    name: str
    visibility: NotRequired[Union[Unset, Literal["selected", "all", "private"]]]
    allows_public_repositories: NotRequired[Union[Unset, bool]]
    restricted_to_workflows: NotRequired[Union[Unset, bool]]
    selected_workflows: NotRequired[Union[Unset, List[str]]]


class OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200Type(TypedDict):
    """OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200"""

    total_count: float
    repositories: List[MinimalRepositoryType]


class OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType(TypedDict):
    """OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBody"""

    selected_repository_ids: List[int]


class OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type(TypedDict):
    """OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200"""

    total_count: float
    runners: List[RunnerType]


class OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType(TypedDict):
    """OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBody"""

    runners: List[int]


class OrgsOrgActionsRunnersGetResponse200Type(TypedDict):
    """OrgsOrgActionsRunnersGetResponse200"""

    total_count: int
    runners: List[RunnerType]


class OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType(TypedDict):
    """OrgsOrgActionsRunnersRunnerIdLabelsPutBody"""

    labels: List[str]


class OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType(TypedDict):
    """OrgsOrgActionsRunnersRunnerIdLabelsPostBody"""

    labels: List[str]


class OrgsOrgActionsSecretsGetResponse200Type(TypedDict):
    """OrgsOrgActionsSecretsGetResponse200"""

    total_count: int
    secrets: List[OrganizationActionsSecretType]


class OrgsOrgActionsSecretsSecretNamePutBodyType(TypedDict):
    """OrgsOrgActionsSecretsSecretNamePutBody"""

    encrypted_value: NotRequired[Union[Unset, str]]
    key_id: NotRequired[Union[Unset, str]]
    visibility: Literal["all", "private", "selected"]
    selected_repository_ids: NotRequired[Union[Unset, List[int]]]


class OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200Type(TypedDict):
    """OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200"""

    total_count: int
    repositories: List[MinimalRepositoryType]


class OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType(TypedDict):
    """OrgsOrgActionsSecretsSecretNameRepositoriesPutBody"""

    selected_repository_ids: List[int]


class OrgsOrgCodespacesGetResponse200Type(TypedDict):
    """OrgsOrgCodespacesGetResponse200"""

    total_count: int
    codespaces: List[CodespaceType]


class OrgsOrgDependabotSecretsGetResponse200Type(TypedDict):
    """OrgsOrgDependabotSecretsGetResponse200"""

    total_count: int
    secrets: List[OrganizationDependabotSecretType]


class OrgsOrgDependabotSecretsSecretNamePutBodyType(TypedDict):
    """OrgsOrgDependabotSecretsSecretNamePutBody"""

    encrypted_value: NotRequired[Union[Unset, str]]
    key_id: NotRequired[Union[Unset, str]]
    visibility: Literal["all", "private", "selected"]
    selected_repository_ids: NotRequired[Union[Unset, List[str]]]


class OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200Type(TypedDict):
    """OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200"""

    total_count: int
    repositories: List[MinimalRepositoryType]


class OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType(TypedDict):
    """OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody"""

    selected_repository_ids: List[int]


class OrgsOrgHooksPostBodyType(TypedDict):
    """OrgsOrgHooksPostBody"""

    name: str
    config: OrgsOrgHooksPostBodyPropConfigType
    events: NotRequired[Union[Unset, List[str]]]
    active: NotRequired[Union[Unset, bool]]


class OrgsOrgHooksPostBodyPropConfigType(TypedDict):
    """OrgsOrgHooksPostBodyPropConfig

    Key/value pairs to provide settings for this webhook. [These are defined
    below](https://docs.github.com/rest/reference/orgs#create-hook-config-params).
    """

    url: str
    content_type: NotRequired[Union[Unset, str]]
    secret: NotRequired[Union[Unset, str]]
    insecure_ssl: NotRequired[Union[Unset, Union[str, float]]]
    username: NotRequired[Union[Unset, str]]
    password: NotRequired[Union[Unset, str]]


class OrgsOrgHooksHookIdPatchBodyType(TypedDict):
    """OrgsOrgHooksHookIdPatchBody"""

    config: NotRequired[Union[Unset, OrgsOrgHooksHookIdPatchBodyPropConfigType]]
    events: NotRequired[Union[Unset, List[str]]]
    active: NotRequired[Union[Unset, bool]]
    name: NotRequired[Union[Unset, str]]


class OrgsOrgHooksHookIdPatchBodyPropConfigType(TypedDict):
    """OrgsOrgHooksHookIdPatchBodyPropConfig

    Key/value pairs to provide settings for this webhook. [These are defined
    below](https://docs.github.com/rest/reference/orgs#update-hook-config-params).
    """

    url: str
    content_type: NotRequired[Union[Unset, str]]
    secret: NotRequired[Union[Unset, str]]
    insecure_ssl: NotRequired[Union[Unset, Union[str, float]]]


class OrgsOrgHooksHookIdConfigPatchBodyType(TypedDict):
    """OrgsOrgHooksHookIdConfigPatchBody"""

    url: NotRequired[Union[Unset, str]]
    content_type: NotRequired[Union[Unset, str]]
    secret: NotRequired[Union[Unset, str]]
    insecure_ssl: NotRequired[Union[Unset, Union[str, float]]]


class OrgsOrgInstallationsGetResponse200Type(TypedDict):
    """OrgsOrgInstallationsGetResponse200"""

    total_count: int
    installations: List[InstallationType]


class OrgsOrgInteractionLimitsGetResponse200Anyof1Type(TypedDict):
    """OrgsOrgInteractionLimitsGetResponse200Anyof1"""


class OrgsOrgInvitationsPostBodyType(TypedDict):
    """OrgsOrgInvitationsPostBody"""

    invitee_id: NotRequired[Union[Unset, int]]
    email: NotRequired[Union[Unset, str]]
    role: NotRequired[
        Union[Unset, Literal["admin", "direct_member", "billing_manager"]]
    ]
    team_ids: NotRequired[Union[Unset, List[int]]]


class OrgsOrgMembershipsUsernamePutBodyType(TypedDict):
    """OrgsOrgMembershipsUsernamePutBody"""

    role: NotRequired[Union[Unset, Literal["admin", "member"]]]


class OrgsOrgMigrationsPostBodyType(TypedDict):
    """OrgsOrgMigrationsPostBody"""

    repositories: List[str]
    lock_repositories: NotRequired[Union[Unset, bool]]
    exclude_metadata: NotRequired[Union[Unset, bool]]
    exclude_git_data: NotRequired[Union[Unset, bool]]
    exclude_attachments: NotRequired[Union[Unset, bool]]
    exclude_releases: NotRequired[Union[Unset, bool]]
    exclude_owner_projects: NotRequired[Union[Unset, bool]]
    org_metadata_only: NotRequired[Union[Unset, bool]]
    exclude: NotRequired[Union[Unset, List[Literal["repositories"]]]]


class OrgsOrgOutsideCollaboratorsUsernamePutBodyType(TypedDict):
    """OrgsOrgOutsideCollaboratorsUsernamePutBody"""

    async_: NotRequired[Union[Unset, bool]]


class OrgsOrgOutsideCollaboratorsUsernamePutResponse202Type(TypedDict):
    """OrgsOrgOutsideCollaboratorsUsernamePutResponse202"""


class OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422Type(TypedDict):
    """OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422"""

    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]


class OrgsOrgProjectsPostBodyType(TypedDict):
    """OrgsOrgProjectsPostBody"""

    name: str
    body: NotRequired[Union[Unset, str]]


class OrgsOrgReposPostBodyType(TypedDict):
    """OrgsOrgReposPostBody"""

    name: str
    description: NotRequired[Union[Unset, str]]
    homepage: NotRequired[Union[Unset, str]]
    private: NotRequired[Union[Unset, bool]]
    visibility: NotRequired[Union[Unset, Literal["public", "private", "internal"]]]
    has_issues: NotRequired[Union[Unset, bool]]
    has_projects: NotRequired[Union[Unset, bool]]
    has_wiki: NotRequired[Union[Unset, bool]]
    is_template: NotRequired[Union[Unset, bool]]
    team_id: NotRequired[Union[Unset, int]]
    auto_init: NotRequired[Union[Unset, bool]]
    gitignore_template: NotRequired[Union[Unset, str]]
    license_template: NotRequired[Union[Unset, str]]
    allow_squash_merge: NotRequired[Union[Unset, bool]]
    allow_merge_commit: NotRequired[Union[Unset, bool]]
    allow_rebase_merge: NotRequired[Union[Unset, bool]]
    allow_auto_merge: NotRequired[Union[Unset, bool]]
    delete_branch_on_merge: NotRequired[Union[Unset, bool]]
    use_squash_pr_title_as_default: NotRequired[Union[Unset, bool]]


class OrgsOrgTeamsPostBodyType(TypedDict):
    """OrgsOrgTeamsPostBody"""

    name: str
    description: NotRequired[Union[Unset, str]]
    maintainers: NotRequired[Union[Unset, List[str]]]
    repo_names: NotRequired[Union[Unset, List[str]]]
    privacy: NotRequired[Union[Unset, Literal["secret", "closed"]]]
    permission: NotRequired[Union[Unset, Literal["pull", "push"]]]
    parent_team_id: NotRequired[Union[Unset, int]]


class OrgsOrgTeamsTeamSlugPatchBodyType(TypedDict):
    """OrgsOrgTeamsTeamSlugPatchBody"""

    name: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, str]]
    privacy: NotRequired[Union[Unset, Literal["secret", "closed"]]]
    permission: NotRequired[Union[Unset, Literal["pull", "push", "admin"]]]
    parent_team_id: NotRequired[Union[Unset, Union[int, None]]]


class OrgsOrgTeamsTeamSlugDiscussionsPostBodyType(TypedDict):
    """OrgsOrgTeamsTeamSlugDiscussionsPostBody"""

    title: str
    body: str
    private: NotRequired[Union[Unset, bool]]


class OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType(TypedDict):
    """OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody"""

    title: NotRequired[Union[Unset, str]]
    body: NotRequired[Union[Unset, str]]


class OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType(TypedDict):
    """OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody"""

    body: str


class OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType(
    TypedDict
):
    """OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody"""

    body: str


class OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType(
    TypedDict
):
    """OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPos
    tBody
    """

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ]


class OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType(TypedDict):
    """OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ]


class OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType(TypedDict):
    """OrgsOrgTeamsTeamSlugExternalGroupsPatchBody"""

    group_id: int


class OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType(TypedDict):
    """OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody"""

    role: NotRequired[Union[Unset, Literal["member", "maintainer"]]]


class OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType(TypedDict):
    """OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody"""

    permission: NotRequired[Union[Unset, Literal["read", "write", "admin"]]]


class OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403Type(TypedDict):
    """OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403"""

    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]


class OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType(TypedDict):
    """OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody"""

    permission: NotRequired[
        Union[Unset, Literal["pull", "push", "admin", "maintain", "triage"]]
    ]


class OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType(TypedDict):
    """OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBody"""

    groups: NotRequired[
        Union[
            Unset,
            List[OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItemsType],
        ]
    ]


class OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItemsType(TypedDict):
    """OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItems"""

    group_id: str
    group_name: str
    group_description: str


class ProjectsColumnsCardsCardIdDeleteResponse403Type(TypedDict):
    """ProjectsColumnsCardsCardIdDeleteResponse403"""

    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]
    errors: NotRequired[Union[Unset, List[str]]]


class ProjectsColumnsCardsCardIdPatchBodyType(TypedDict):
    """ProjectsColumnsCardsCardIdPatchBody"""

    note: NotRequired[Union[Unset, Union[str, None]]]
    archived: NotRequired[Union[Unset, bool]]


class ProjectsColumnsCardsCardIdMovesPostBodyType(TypedDict):
    """ProjectsColumnsCardsCardIdMovesPostBody"""

    position: str
    column_id: NotRequired[Union[Unset, int]]


class ProjectsColumnsCardsCardIdMovesPostResponse201Type(TypedDict):
    """ProjectsColumnsCardsCardIdMovesPostResponse201"""


class ProjectsColumnsCardsCardIdMovesPostResponse403Type(TypedDict):
    """ProjectsColumnsCardsCardIdMovesPostResponse403"""

    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]
    errors: NotRequired[
        Union[
            Unset,
            List[ProjectsColumnsCardsCardIdMovesPostResponse403PropErrorsItemsType],
        ]
    ]


class ProjectsColumnsCardsCardIdMovesPostResponse403PropErrorsItemsType(TypedDict):
    """ProjectsColumnsCardsCardIdMovesPostResponse403PropErrorsItems"""

    code: NotRequired[Union[Unset, str]]
    message: NotRequired[Union[Unset, str]]
    resource: NotRequired[Union[Unset, str]]
    field: NotRequired[Union[Unset, str]]


class ProjectsColumnsCardsCardIdMovesPostResponse503Type(TypedDict):
    """ProjectsColumnsCardsCardIdMovesPostResponse503"""

    code: NotRequired[Union[Unset, str]]
    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]
    errors: NotRequired[
        Union[
            Unset,
            List[ProjectsColumnsCardsCardIdMovesPostResponse503PropErrorsItemsType],
        ]
    ]


class ProjectsColumnsCardsCardIdMovesPostResponse503PropErrorsItemsType(TypedDict):
    """ProjectsColumnsCardsCardIdMovesPostResponse503PropErrorsItems"""

    code: NotRequired[Union[Unset, str]]
    message: NotRequired[Union[Unset, str]]


class ProjectsColumnsColumnIdPatchBodyType(TypedDict):
    """ProjectsColumnsColumnIdPatchBody"""

    name: str


class ProjectsColumnsColumnIdCardsPostBodyOneof0Type(TypedDict):
    """ProjectsColumnsColumnIdCardsPostBodyOneof0"""

    note: Union[str, None]


class ProjectsColumnsColumnIdCardsPostBodyOneof1Type(TypedDict):
    """ProjectsColumnsColumnIdCardsPostBodyOneof1"""

    content_id: int
    content_type: str


class ProjectsColumnsColumnIdCardsPostResponse503Type(TypedDict):
    """ProjectsColumnsColumnIdCardsPostResponse503"""

    code: NotRequired[Union[Unset, str]]
    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]
    errors: NotRequired[
        Union[
            Unset, List[ProjectsColumnsColumnIdCardsPostResponse503PropErrorsItemsType]
        ]
    ]


class ProjectsColumnsColumnIdCardsPostResponse503PropErrorsItemsType(TypedDict):
    """ProjectsColumnsColumnIdCardsPostResponse503PropErrorsItems"""

    code: NotRequired[Union[Unset, str]]
    message: NotRequired[Union[Unset, str]]


class ProjectsColumnsColumnIdMovesPostBodyType(TypedDict):
    """ProjectsColumnsColumnIdMovesPostBody"""

    position: str


class ProjectsColumnsColumnIdMovesPostResponse201Type(TypedDict):
    """ProjectsColumnsColumnIdMovesPostResponse201"""


class ProjectsProjectIdDeleteResponse403Type(TypedDict):
    """ProjectsProjectIdDeleteResponse403"""

    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]
    errors: NotRequired[Union[Unset, List[str]]]


class ProjectsProjectIdPatchBodyType(TypedDict):
    """ProjectsProjectIdPatchBody"""

    name: NotRequired[Union[Unset, str]]
    body: NotRequired[Union[Unset, Union[str, None]]]
    state: NotRequired[Union[Unset, str]]
    organization_permission: NotRequired[
        Union[Unset, Literal["read", "write", "admin", "none"]]
    ]
    private: NotRequired[Union[Unset, bool]]


class ProjectsProjectIdPatchResponse403Type(TypedDict):
    """ProjectsProjectIdPatchResponse403"""

    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]
    errors: NotRequired[Union[Unset, List[str]]]


class ProjectsProjectIdCollaboratorsUsernamePutBodyType(TypedDict):
    """ProjectsProjectIdCollaboratorsUsernamePutBody"""

    permission: NotRequired[Union[Unset, Literal["read", "write", "admin"]]]


class ProjectsProjectIdColumnsPostBodyType(TypedDict):
    """ProjectsProjectIdColumnsPostBody"""

    name: str


class ReposOwnerRepoDeleteResponse403Type(TypedDict):
    """ReposOwnerRepoDeleteResponse403"""

    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]


class ReposOwnerRepoPatchBodyType(TypedDict):
    """ReposOwnerRepoPatchBody"""

    name: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, str]]
    homepage: NotRequired[Union[Unset, str]]
    private: NotRequired[Union[Unset, bool]]
    visibility: NotRequired[Union[Unset, Literal["public", "private", "internal"]]]
    security_and_analysis: NotRequired[
        Union[Unset, Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]]
    ]
    has_issues: NotRequired[Union[Unset, bool]]
    has_projects: NotRequired[Union[Unset, bool]]
    has_wiki: NotRequired[Union[Unset, bool]]
    is_template: NotRequired[Union[Unset, bool]]
    default_branch: NotRequired[Union[Unset, str]]
    allow_squash_merge: NotRequired[Union[Unset, bool]]
    allow_merge_commit: NotRequired[Union[Unset, bool]]
    allow_rebase_merge: NotRequired[Union[Unset, bool]]
    allow_auto_merge: NotRequired[Union[Unset, bool]]
    delete_branch_on_merge: NotRequired[Union[Unset, bool]]
    allow_update_branch: NotRequired[Union[Unset, bool]]
    use_squash_pr_title_as_default: NotRequired[Union[Unset, bool]]
    archived: NotRequired[Union[Unset, bool]]
    allow_forking: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType(TypedDict):
    """ReposOwnerRepoPatchBodyPropSecurityAndAnalysis

    Specify which security and analysis features to enable or disable. For example,
    to enable GitHub Advanced Security, use this data in the body of the PATCH
    request: `{"security_and_analysis": {"advanced_security": {"status":
    "enabled"}}}`. If you have admin permissions for a private repository covered by
    an Advanced Security license, you can check which security and analysis features
    are currently enabled by using a `GET /repos/{owner}/{repo}` request.
    """

    advanced_security: NotRequired[
        Union[
            Unset,
            ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropAdvancedSecurityType,
        ]
    ]
    secret_scanning: NotRequired[
        Union[
            Unset, ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanningType
        ]
    ]
    secret_scanning_push_protection: NotRequired[
        Union[
            Unset,
            ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanningPushProtectionType,
        ]
    ]


class ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropAdvancedSecurityType(TypedDict):
    """ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropAdvancedSecurity

    Use the `status` property to enable or disable GitHub Advanced Security for this
    repository. For more information, see "[About GitHub Advanced
    Security](/github/getting-started-with-github/learning-about-github/about-
    github-advanced-security)."
    """

    status: NotRequired[Union[Unset, str]]


class ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanningType(TypedDict):
    """ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanning

    Use the `status` property to enable or disable secret scanning for this
    repository. For more information, see "[About secret scanning](/code-
    security/secret-security/about-secret-scanning)."
    """

    status: NotRequired[Union[Unset, str]]


class ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanningPushProtectionType(
    TypedDict
):
    """ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanningPushProtection

    Use the `status` property to enable or disable secret scanning push protection
    for this repository. For more information, see "[Protecting pushes with secret
    scanning](/code-security/secret-scanning/protecting-pushes-with-secret-
    scanning)."
    """

    status: NotRequired[Union[Unset, str]]


class ReposOwnerRepoActionsArtifactsGetResponse200Type(TypedDict):
    """ReposOwnerRepoActionsArtifactsGetResponse200"""

    total_count: int
    artifacts: List[ArtifactType]


class ReposOwnerRepoActionsJobsJobIdRerunPostBodyType(TypedDict):
    """ReposOwnerRepoActionsJobsJobIdRerunPostBody"""

    enable_debug_logging: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoActionsPermissionsPutBodyType(TypedDict):
    """ReposOwnerRepoActionsPermissionsPutBody"""

    enabled: bool
    allowed_actions: NotRequired[Union[Unset, Literal["all", "local_only", "selected"]]]


class ReposOwnerRepoActionsRunnersGetResponse200Type(TypedDict):
    """ReposOwnerRepoActionsRunnersGetResponse200"""

    total_count: int
    runners: List[RunnerType]


class ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType(TypedDict):
    """ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody"""

    labels: List[str]


class ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType(TypedDict):
    """ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody"""

    labels: List[str]


class ReposOwnerRepoActionsRunsGetResponse200Type(TypedDict):
    """ReposOwnerRepoActionsRunsGetResponse200"""

    total_count: int
    workflow_runs: List[WorkflowRunType]


class ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200Type(TypedDict):
    """ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200"""

    total_count: int
    artifacts: List[ArtifactType]


class ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200Type(
    TypedDict
):
    """ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200"""

    total_count: int
    jobs: List[JobType]


class ReposOwnerRepoActionsRunsRunIdCancelPostResponse202Type(TypedDict):
    """ReposOwnerRepoActionsRunsRunIdCancelPostResponse202"""


class ReposOwnerRepoActionsRunsRunIdJobsGetResponse200Type(TypedDict):
    """ReposOwnerRepoActionsRunsRunIdJobsGetResponse200"""

    total_count: int
    jobs: List[JobType]


class ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType(TypedDict):
    """ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody"""

    environment_ids: List[int]
    state: Literal["approved", "rejected"]
    comment: str


class ReposOwnerRepoActionsRunsRunIdRerunPostBodyType(TypedDict):
    """ReposOwnerRepoActionsRunsRunIdRerunPostBody"""

    enable_debug_logging: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoActionsRunsRunIdRerunPostResponse201Type(TypedDict):
    """ReposOwnerRepoActionsRunsRunIdRerunPostResponse201"""


class ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType(TypedDict):
    """ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody"""

    enable_debug_logging: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoActionsSecretsGetResponse200Type(TypedDict):
    """ReposOwnerRepoActionsSecretsGetResponse200"""

    total_count: int
    secrets: List[ActionsSecretType]


class ReposOwnerRepoActionsSecretsSecretNamePutBodyType(TypedDict):
    """ReposOwnerRepoActionsSecretsSecretNamePutBody"""

    encrypted_value: NotRequired[Union[Unset, str]]
    key_id: NotRequired[Union[Unset, str]]


class ReposOwnerRepoActionsSecretsSecretNamePutResponse201Type(TypedDict):
    """ReposOwnerRepoActionsSecretsSecretNamePutResponse201"""


class ReposOwnerRepoActionsWorkflowsGetResponse200Type(TypedDict):
    """ReposOwnerRepoActionsWorkflowsGetResponse200"""

    total_count: int
    workflows: List[WorkflowType]


class ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType(TypedDict):
    """ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody"""

    ref: str
    inputs: NotRequired[
        Union[
            Unset,
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType,
        ]
    ]


class ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType(
    TypedDict
):
    """ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputs

    Input keys and values configured in the workflow file. The maximum number of
    properties is 10. Any default properties configured in the workflow file will be
    used when `inputs` are omitted.
    """


class ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200Type(TypedDict):
    """ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200"""

    total_count: int
    workflow_runs: List[WorkflowRunType]


class ReposOwnerRepoAutolinksPostBodyType(TypedDict):
    """ReposOwnerRepoAutolinksPostBody"""

    key_prefix: str
    url_template: str


class ReposOwnerRepoBranchesBranchProtectionPutBodyType(TypedDict):
    """ReposOwnerRepoBranchesBranchProtectionPutBody"""

    required_status_checks: Union[
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType, None
    ]
    enforce_admins: Union[bool, None]
    required_pull_request_reviews: Union[
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
        None,
    ]
    restrictions: Union[
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
    ]
    required_linear_history: NotRequired[Union[Unset, bool]]
    allow_force_pushes: NotRequired[Union[Unset, Union[bool, None]]]
    allow_deletions: NotRequired[Union[Unset, bool]]
    block_creations: NotRequired[Union[Unset, bool]]
    required_conversation_resolution: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecks

    Require status checks to pass before merging. Set to `null` to disable.
    """

    strict: bool
    contexts: List[str]
    checks: NotRequired[
        Union[
            Unset,
            List[
                ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksPropChecksItemsType
            ],
        ]
    ]


class ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksPropChecksItemsType(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksPropChecksI
    tems
    """

    context: str
    app_id: NotRequired[Union[Unset, int]]


class ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviews

    Require at least one approving review on a pull request, before merging. Set to
    `null` to disable.
    """

    dismissal_restrictions: NotRequired[
        Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropDismissalRestrictionsType,
        ]
    ]
    dismiss_stale_reviews: NotRequired[Union[Unset, bool]]
    require_code_owner_reviews: NotRequired[Union[Unset, bool]]
    required_approving_review_count: NotRequired[Union[Unset, int]]
    bypass_pull_request_allowances: NotRequired[
        Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropBypassPullRequestAllowancesType,
        ]
    ]


class ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropDismissalRestrictionsType(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropD
    ismissalRestrictions

        Specify which users, teams, and apps can dismiss pull request reviews. Pass an
        empty `dismissal_restrictions` object to disable. User and team
        `dismissal_restrictions` are only available for organization-owned repositories.
        Omit this parameter for personal repositories.
    """

    users: NotRequired[Union[Unset, List[str]]]
    teams: NotRequired[Union[Unset, List[str]]]
    apps: NotRequired[Union[Unset, List[str]]]


class ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropBypassPullRequestAllowancesType(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropB
    ypassPullRequestAllowances

        Allow specific users, teams, or apps to bypass pull request requirements.
    """

    users: NotRequired[Union[Unset, List[str]]]
    teams: NotRequired[Union[Unset, List[str]]]
    apps: NotRequired[Union[Unset, List[str]]]


class ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType(TypedDict):
    """ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictions

    Restrict who can push to the protected branch. User, app, and team
    `restrictions` are only available for organization-owned repositories. Set to
    `null` to disable.
    """

    users: List[str]
    teams: List[str]
    apps: NotRequired[Union[Unset, List[str]]]


class ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody"""

    dismissal_restrictions: NotRequired[
        Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType,
        ]
    ]
    dismiss_stale_reviews: NotRequired[Union[Unset, bool]]
    require_code_owner_reviews: NotRequired[Union[Unset, bool]]
    required_approving_review_count: NotRequired[Union[Unset, int]]
    bypass_pull_request_allowances: NotRequired[
        Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType,
        ]
    ]


class ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDis
    missalRestrictions

        Specify which users, teams, and apps can dismiss pull request reviews. Pass an
        empty `dismissal_restrictions` object to disable. User and team
        `dismissal_restrictions` are only available for organization-owned repositories.
        Omit this parameter for personal repositories.
    """

    users: NotRequired[Union[Unset, List[str]]]
    teams: NotRequired[Union[Unset, List[str]]]
    apps: NotRequired[Union[Unset, List[str]]]


class ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropByp
    assPullRequestAllowances

        Allow specific users, teams, or apps to bypass pull request requirements.
    """

    users: NotRequired[Union[Unset, List[str]]]
    teams: NotRequired[Union[Unset, List[str]]]
    apps: NotRequired[Union[Unset, List[str]]]


class ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody"""

    strict: NotRequired[Union[Unset, bool]]
    contexts: NotRequired[Union[Unset, List[str]]]
    checks: NotRequired[
        Union[
            Unset,
            List[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ],
        ]
    ]


class ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksIte
    ms
    """

    context: str
    app_id: NotRequired[Union[Unset, int]]


class ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0

    Examples:
        {'contexts': ['contexts']}
    """

    contexts: List[str]


class ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0

    Examples:
        {'contexts': ['contexts']}
    """

    contexts: List[str]


class ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneo
    f0

        Examples:
            {'contexts': ['contexts']}
    """

    contexts: List[str]


class ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0

    Examples:
        {'apps': ['my-app']}
    """

    apps: List[str]


class ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0

    Examples:
        {'apps': ['my-app']}
    """

    apps: List[str]


class ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0

    Examples:
        {'apps': ['my-app']}
    """

    apps: List[str]


class ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0

    Examples:
        {'teams': ['my-team']}
    """

    teams: List[str]


class ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0

    Examples:
        {'teams': ['my-team']}
    """

    teams: List[str]


class ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0

    Examples:
        {'teams': ['my-team']}
    """

    teams: List[str]


class ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0

    Examples:
        {'users': ['mona']}
    """

    users: List[str]


class ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0

    Examples:
        {'users': ['mona']}
    """

    users: List[str]


class ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type(
    TypedDict
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0

    Examples:
        {'users': ['mona']}
    """

    users: List[str]


class ReposOwnerRepoBranchesBranchRenamePostBodyType(TypedDict):
    """ReposOwnerRepoBranchesBranchRenamePostBody"""

    new_name: str


class ReposOwnerRepoCheckRunsCheckRunIdRerequestPostResponse201Type(TypedDict):
    """ReposOwnerRepoCheckRunsCheckRunIdRerequestPostResponse201"""


class ReposOwnerRepoCheckSuitesPostBodyType(TypedDict):
    """ReposOwnerRepoCheckSuitesPostBody"""

    head_sha: str


class ReposOwnerRepoCheckSuitesPreferencesPatchBodyType(TypedDict):
    """ReposOwnerRepoCheckSuitesPreferencesPatchBody"""

    auto_trigger_checks: NotRequired[
        Union[
            Unset,
            List[
                ReposOwnerRepoCheckSuitesPreferencesPatchBodyPropAutoTriggerChecksItemsType
            ],
        ]
    ]


class ReposOwnerRepoCheckSuitesPreferencesPatchBodyPropAutoTriggerChecksItemsType(
    TypedDict
):
    """ReposOwnerRepoCheckSuitesPreferencesPatchBodyPropAutoTriggerChecksItems"""

    app_id: int
    setting: bool


class ReposOwnerRepoCheckSuitesCheckSuiteIdCheckRunsGetResponse200Type(TypedDict):
    """ReposOwnerRepoCheckSuitesCheckSuiteIdCheckRunsGetResponse200"""

    total_count: int
    check_runs: List[CheckRunType]


class ReposOwnerRepoCheckSuitesCheckSuiteIdRerequestPostResponse201Type(TypedDict):
    """ReposOwnerRepoCheckSuitesCheckSuiteIdRerequestPostResponse201"""


class ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBodyType(TypedDict):
    """ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBody"""

    state: Literal["open", "dismissed"]
    dismissed_reason: NotRequired[
        Union[Unset, Literal[None, "false positive", "won't fix", "used in tests"]]
    ]
    dismissed_comment: NotRequired[Union[Unset, Union[str, None]]]


class ReposOwnerRepoCodeScanningSarifsPostBodyType(TypedDict):
    """ReposOwnerRepoCodeScanningSarifsPostBody"""

    commit_sha: str
    ref: str
    sarif: str
    checkout_uri: NotRequired[Union[Unset, str]]
    started_at: NotRequired[Union[Unset, datetime]]
    tool_name: NotRequired[Union[Unset, str]]


class ReposOwnerRepoCodespacesGetResponse200Type(TypedDict):
    """ReposOwnerRepoCodespacesGetResponse200"""

    total_count: int
    codespaces: List[CodespaceType]


class ReposOwnerRepoCodespacesPostBodyType(TypedDict):
    """ReposOwnerRepoCodespacesPostBody"""

    ref: NotRequired[Union[Unset, str]]
    location: NotRequired[Union[Unset, str]]
    client_ip: NotRequired[Union[Unset, str]]
    machine: NotRequired[Union[Unset, str]]
    devcontainer_path: NotRequired[Union[Unset, str]]
    multi_repo_permissions_opt_out: NotRequired[Union[Unset, bool]]
    working_directory: NotRequired[Union[Unset, str]]
    idle_timeout_minutes: NotRequired[Union[Unset, int]]
    display_name: NotRequired[Union[Unset, str]]
    retention_period_minutes: NotRequired[Union[Unset, int]]


class ReposOwnerRepoCodespacesDevcontainersGetResponse200Type(TypedDict):
    """ReposOwnerRepoCodespacesDevcontainersGetResponse200"""

    total_count: int
    devcontainers: List[
        ReposOwnerRepoCodespacesDevcontainersGetResponse200PropDevcontainersItemsType
    ]


class ReposOwnerRepoCodespacesDevcontainersGetResponse200PropDevcontainersItemsType(
    TypedDict
):
    """ReposOwnerRepoCodespacesDevcontainersGetResponse200PropDevcontainersItems"""

    path: str
    name: NotRequired[Union[Unset, str]]


class ReposOwnerRepoCodespacesMachinesGetResponse200Type(TypedDict):
    """ReposOwnerRepoCodespacesMachinesGetResponse200"""

    total_count: int
    machines: List[CodespaceMachineType]


class ReposOwnerRepoCodespacesNewGetResponse200Type(TypedDict):
    """ReposOwnerRepoCodespacesNewGetResponse200"""

    billable_owner: NotRequired[Union[Unset, SimpleUserType]]
    defaults: NotRequired[
        Union[Unset, ReposOwnerRepoCodespacesNewGetResponse200PropDefaultsType]
    ]


class ReposOwnerRepoCodespacesNewGetResponse200PropDefaultsType(TypedDict):
    """ReposOwnerRepoCodespacesNewGetResponse200PropDefaults"""

    location: str
    devcontainer_path: Union[str, None]


class ReposOwnerRepoCodespacesSecretsGetResponse200Type(TypedDict):
    """ReposOwnerRepoCodespacesSecretsGetResponse200"""

    total_count: int
    secrets: List[RepoCodespacesSecretType]


class ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType(TypedDict):
    """ReposOwnerRepoCodespacesSecretsSecretNamePutBody"""

    encrypted_value: NotRequired[Union[Unset, str]]
    key_id: NotRequired[Union[Unset, str]]


class ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201Type(TypedDict):
    """ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201"""


class ReposOwnerRepoCollaboratorsUsernamePutBodyType(TypedDict):
    """ReposOwnerRepoCollaboratorsUsernamePutBody"""

    permission: NotRequired[
        Union[Unset, Literal["pull", "push", "admin", "maintain", "triage"]]
    ]


class ReposOwnerRepoCommentsCommentIdPatchBodyType(TypedDict):
    """ReposOwnerRepoCommentsCommentIdPatchBody"""

    body: str


class ReposOwnerRepoCommentsCommentIdReactionsPostBodyType(TypedDict):
    """ReposOwnerRepoCommentsCommentIdReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ]


class ReposOwnerRepoCommitsCommitShaCommentsPostBodyType(TypedDict):
    """ReposOwnerRepoCommitsCommitShaCommentsPostBody"""

    body: str
    path: NotRequired[Union[Unset, str]]
    position: NotRequired[Union[Unset, int]]
    line: NotRequired[Union[Unset, int]]


class ReposOwnerRepoCommitsRefCheckRunsGetResponse200Type(TypedDict):
    """ReposOwnerRepoCommitsRefCheckRunsGetResponse200"""

    total_count: int
    check_runs: List[CheckRunType]


class ReposOwnerRepoCommitsRefCheckSuitesGetResponse200Type(TypedDict):
    """ReposOwnerRepoCommitsRefCheckSuitesGetResponse200"""

    total_count: int
    check_suites: List[CheckSuiteType]


class ReposOwnerRepoContentsPathPutBodyType(TypedDict):
    """ReposOwnerRepoContentsPathPutBody"""

    message: str
    content: str
    sha: NotRequired[Union[Unset, str]]
    branch: NotRequired[Union[Unset, str]]
    committer: NotRequired[
        Union[Unset, ReposOwnerRepoContentsPathPutBodyPropCommitterType]
    ]
    author: NotRequired[Union[Unset, ReposOwnerRepoContentsPathPutBodyPropAuthorType]]


class ReposOwnerRepoContentsPathPutBodyPropCommitterType(TypedDict):
    """ReposOwnerRepoContentsPathPutBodyPropCommitter

    The person that committed the file. Default: the authenticated user.
    """

    name: str
    email: str
    date: NotRequired[Union[Unset, str]]


class ReposOwnerRepoContentsPathPutBodyPropAuthorType(TypedDict):
    """ReposOwnerRepoContentsPathPutBodyPropAuthor

    The author of the file. Default: The `committer` or the authenticated user if
    you omit `committer`.
    """

    name: str
    email: str
    date: NotRequired[Union[Unset, str]]


class ReposOwnerRepoContentsPathDeleteBodyType(TypedDict):
    """ReposOwnerRepoContentsPathDeleteBody"""

    message: str
    sha: str
    branch: NotRequired[Union[Unset, str]]
    committer: NotRequired[
        Union[Unset, ReposOwnerRepoContentsPathDeleteBodyPropCommitterType]
    ]
    author: NotRequired[
        Union[Unset, ReposOwnerRepoContentsPathDeleteBodyPropAuthorType]
    ]


class ReposOwnerRepoContentsPathDeleteBodyPropCommitterType(TypedDict):
    """ReposOwnerRepoContentsPathDeleteBodyPropCommitter

    object containing information about the committer.
    """

    name: NotRequired[Union[Unset, str]]
    email: NotRequired[Union[Unset, str]]


class ReposOwnerRepoContentsPathDeleteBodyPropAuthorType(TypedDict):
    """ReposOwnerRepoContentsPathDeleteBodyPropAuthor

    object containing information about the author.
    """

    name: NotRequired[Union[Unset, str]]
    email: NotRequired[Union[Unset, str]]


class ReposOwnerRepoDependabotSecretsGetResponse200Type(TypedDict):
    """ReposOwnerRepoDependabotSecretsGetResponse200"""

    total_count: int
    secrets: List[DependabotSecretType]


class ReposOwnerRepoDependabotSecretsSecretNamePutBodyType(TypedDict):
    """ReposOwnerRepoDependabotSecretsSecretNamePutBody"""

    encrypted_value: NotRequired[Union[Unset, str]]
    key_id: NotRequired[Union[Unset, str]]


class ReposOwnerRepoDependencyGraphSnapshotsPostResponse201Type(TypedDict):
    """ReposOwnerRepoDependencyGraphSnapshotsPostResponse201"""

    id: int
    created_at: str
    result: str
    message: str


class ReposOwnerRepoDeploymentsPostBodyType(TypedDict):
    """ReposOwnerRepoDeploymentsPostBody"""

    ref: str
    task: NotRequired[Union[Unset, str]]
    auto_merge: NotRequired[Union[Unset, bool]]
    required_contexts: NotRequired[Union[Unset, List[str]]]
    payload: NotRequired[
        Union[Unset, Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]]
    ]
    environment: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, Union[str, None]]]
    transient_environment: NotRequired[Union[Unset, bool]]
    production_environment: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type(TypedDict):
    """ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0"""


class ReposOwnerRepoDeploymentsPostResponse202Type(TypedDict):
    """ReposOwnerRepoDeploymentsPostResponse202"""

    message: NotRequired[Union[Unset, str]]


class ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType(TypedDict):
    """ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody"""

    state: Literal[
        "error", "failure", "inactive", "in_progress", "queued", "pending", "success"
    ]
    target_url: NotRequired[Union[Unset, str]]
    log_url: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, str]]
    environment: NotRequired[Union[Unset, Literal["production", "staging", "qa"]]]
    environment_url: NotRequired[Union[Unset, str]]
    auto_inactive: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoDispatchesPostBodyType(TypedDict):
    """ReposOwnerRepoDispatchesPostBody"""

    event_type: str
    client_payload: NotRequired[
        Union[Unset, ReposOwnerRepoDispatchesPostBodyPropClientPayloadType]
    ]


class ReposOwnerRepoDispatchesPostBodyPropClientPayloadType(TypedDict):
    """ReposOwnerRepoDispatchesPostBodyPropClientPayload

    JSON payload with extra information about the webhook event that your action or
    workflow may use.
    """


class ReposOwnerRepoEnvironmentsGetResponse200Type(TypedDict):
    """ReposOwnerRepoEnvironmentsGetResponse200"""

    total_count: NotRequired[Union[Unset, int]]
    environments: NotRequired[Union[Unset, List[EnvironmentType]]]


class ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType(TypedDict):
    """ReposOwnerRepoEnvironmentsEnvironmentNamePutBody"""

    wait_timer: NotRequired[Union[Unset, int]]
    reviewers: NotRequired[
        Union[
            Unset,
            Union[
                List[
                    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType
                ],
                None,
            ],
        ]
    ]
    deployment_branch_policy: NotRequired[Union[Unset, DeploymentBranchPolicyType]]


class ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType(TypedDict):
    """ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItems"""

    type: NotRequired[Union[Unset, Literal["User", "Team"]]]
    id: NotRequired[Union[Unset, int]]


class ReposOwnerRepoForksPostBodyType(TypedDict):
    """ReposOwnerRepoForksPostBody"""

    organization: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]


class ReposOwnerRepoGitBlobsPostBodyType(TypedDict):
    """ReposOwnerRepoGitBlobsPostBody"""

    content: str
    encoding: NotRequired[Union[Unset, str]]


class ReposOwnerRepoGitCommitsPostBodyType(TypedDict):
    """ReposOwnerRepoGitCommitsPostBody"""

    message: str
    tree: str
    parents: NotRequired[Union[Unset, List[str]]]
    author: NotRequired[Union[Unset, ReposOwnerRepoGitCommitsPostBodyPropAuthorType]]
    committer: NotRequired[
        Union[Unset, ReposOwnerRepoGitCommitsPostBodyPropCommitterType]
    ]
    signature: NotRequired[Union[Unset, str]]


class ReposOwnerRepoGitCommitsPostBodyPropAuthorType(TypedDict):
    """ReposOwnerRepoGitCommitsPostBodyPropAuthor

    Information about the author of the commit. By default, the `author` will be the
    authenticated user and the current date. See the `author` and `committer` object
    below for details.
    """

    name: str
    email: str
    date: NotRequired[Union[Unset, datetime]]


class ReposOwnerRepoGitCommitsPostBodyPropCommitterType(TypedDict):
    """ReposOwnerRepoGitCommitsPostBodyPropCommitter

    Information about the person who is making the commit. By default, `committer`
    will use the information set in `author`. See the `author` and `committer`
    object below for details.
    """

    name: NotRequired[Union[Unset, str]]
    email: NotRequired[Union[Unset, str]]
    date: NotRequired[Union[Unset, datetime]]


class ReposOwnerRepoGitRefsPostBodyType(TypedDict):
    """ReposOwnerRepoGitRefsPostBody"""

    ref: str
    sha: str
    key: NotRequired[Union[Unset, str]]


class ReposOwnerRepoGitRefsRefPatchBodyType(TypedDict):
    """ReposOwnerRepoGitRefsRefPatchBody"""

    sha: str
    force: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoGitTagsPostBodyType(TypedDict):
    """ReposOwnerRepoGitTagsPostBody"""

    tag: str
    message: str
    object_: str
    type: Literal["commit", "tree", "blob"]
    tagger: NotRequired[Union[Unset, ReposOwnerRepoGitTagsPostBodyPropTaggerType]]


class ReposOwnerRepoGitTagsPostBodyPropTaggerType(TypedDict):
    """ReposOwnerRepoGitTagsPostBodyPropTagger

    An object with information about the individual creating the tag.
    """

    name: str
    email: str
    date: NotRequired[Union[Unset, datetime]]


class ReposOwnerRepoGitTreesPostBodyType(TypedDict):
    """ReposOwnerRepoGitTreesPostBody"""

    tree: List[ReposOwnerRepoGitTreesPostBodyPropTreeItemsType]
    base_tree: NotRequired[Union[Unset, str]]


class ReposOwnerRepoGitTreesPostBodyPropTreeItemsType(TypedDict):
    """ReposOwnerRepoGitTreesPostBodyPropTreeItems"""

    path: NotRequired[Union[Unset, str]]
    mode: NotRequired[
        Union[Unset, Literal["100644", "100755", "040000", "160000", "120000"]]
    ]
    type: NotRequired[Union[Unset, Literal["blob", "tree", "commit"]]]
    sha: NotRequired[Union[Unset, Union[str, None]]]
    content: NotRequired[Union[Unset, str]]


class ReposOwnerRepoHooksPostBodyType(TypedDict):
    """ReposOwnerRepoHooksPostBody"""

    name: NotRequired[Union[Unset, str]]
    config: NotRequired[Union[Unset, ReposOwnerRepoHooksPostBodyPropConfigType]]
    events: NotRequired[Union[Unset, List[str]]]
    active: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoHooksPostBodyPropConfigType(TypedDict):
    """ReposOwnerRepoHooksPostBodyPropConfig

    Key/value pairs to provide settings for this webhook. [These are defined
    below](https://docs.github.com/rest/reference/repos#create-hook-config-params).
    """

    url: NotRequired[Union[Unset, str]]
    content_type: NotRequired[Union[Unset, str]]
    secret: NotRequired[Union[Unset, str]]
    insecure_ssl: NotRequired[Union[Unset, Union[str, float]]]
    token: NotRequired[Union[Unset, str]]
    digest: NotRequired[Union[Unset, str]]


class ReposOwnerRepoHooksHookIdPatchBodyType(TypedDict):
    """ReposOwnerRepoHooksHookIdPatchBody"""

    config: NotRequired[Union[Unset, ReposOwnerRepoHooksHookIdPatchBodyPropConfigType]]
    events: NotRequired[Union[Unset, List[str]]]
    add_events: NotRequired[Union[Unset, List[str]]]
    remove_events: NotRequired[Union[Unset, List[str]]]
    active: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoHooksHookIdPatchBodyPropConfigType(TypedDict):
    """ReposOwnerRepoHooksHookIdPatchBodyPropConfig

    Key/value pairs to provide settings for this webhook. [These are defined
    below](https://docs.github.com/rest/reference/repos#create-hook-config-params).
    """

    url: str
    content_type: NotRequired[Union[Unset, str]]
    secret: NotRequired[Union[Unset, str]]
    insecure_ssl: NotRequired[Union[Unset, Union[str, float]]]
    address: NotRequired[Union[Unset, str]]
    room: NotRequired[Union[Unset, str]]


class ReposOwnerRepoHooksHookIdConfigPatchBodyType(TypedDict):
    """ReposOwnerRepoHooksHookIdConfigPatchBody

        Examples:
            {'content_type': 'json', 'insecure_ssl': '0', 'secret': '********', 'url':
    'https://example.com/webhook'}
    """

    url: NotRequired[Union[Unset, str]]
    content_type: NotRequired[Union[Unset, str]]
    secret: NotRequired[Union[Unset, str]]
    insecure_ssl: NotRequired[Union[Unset, Union[str, float]]]


class ReposOwnerRepoImportPutBodyType(TypedDict):
    """ReposOwnerRepoImportPutBody"""

    vcs_url: str
    vcs: NotRequired[Union[Unset, Literal["subversion", "git", "mercurial", "tfvc"]]]
    vcs_username: NotRequired[Union[Unset, str]]
    vcs_password: NotRequired[Union[Unset, str]]
    tfvc_project: NotRequired[Union[Unset, str]]


class ReposOwnerRepoImportPatchBodyType(TypedDict):
    """ReposOwnerRepoImportPatchBody"""

    vcs_username: NotRequired[Union[Unset, str]]
    vcs_password: NotRequired[Union[Unset, str]]
    vcs: NotRequired[Union[Unset, Literal["subversion", "tfvc", "git", "mercurial"]]]
    tfvc_project: NotRequired[Union[Unset, str]]


class ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType(TypedDict):
    """ReposOwnerRepoImportAuthorsAuthorIdPatchBody"""

    email: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]


class ReposOwnerRepoImportLfsPatchBodyType(TypedDict):
    """ReposOwnerRepoImportLfsPatchBody"""

    use_lfs: Literal["opt_in", "opt_out"]


class ReposOwnerRepoInteractionLimitsGetResponse200Anyof1Type(TypedDict):
    """ReposOwnerRepoInteractionLimitsGetResponse200Anyof1"""


class ReposOwnerRepoInvitationsInvitationIdPatchBodyType(TypedDict):
    """ReposOwnerRepoInvitationsInvitationIdPatchBody"""

    permissions: NotRequired[
        Union[Unset, Literal["read", "write", "maintain", "triage", "admin"]]
    ]


class ReposOwnerRepoIssuesPostBodyType(TypedDict):
    """ReposOwnerRepoIssuesPostBody"""

    title: Union[str, int]
    body: NotRequired[Union[Unset, str]]
    assignee: NotRequired[Union[Unset, Union[str, None]]]
    milestone: NotRequired[Union[Unset, Union[None, str, int, str, int]]]
    labels: NotRequired[
        Union[
            Unset,
            List[Union[str, ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1Type]],
        ]
    ]
    assignees: NotRequired[Union[Unset, List[str]]]


class ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1Type(TypedDict):
    """ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1"""

    id: NotRequired[Union[Unset, int]]
    name: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, Union[str, None]]]
    color: NotRequired[Union[Unset, Union[str, None]]]


class ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType(TypedDict):
    """ReposOwnerRepoIssuesCommentsCommentIdPatchBody"""

    body: str


class ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType(TypedDict):
    """ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ]


class ReposOwnerRepoIssuesIssueNumberPatchBodyType(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberPatchBody"""

    title: NotRequired[Union[Unset, Union[None, str, int, str, int]]]
    body: NotRequired[Union[Unset, Union[str, None]]]
    assignee: NotRequired[Union[Unset, Union[str, None]]]
    state: NotRequired[Union[Unset, Literal["open", "closed"]]]
    milestone: NotRequired[Union[Unset, Union[None, str, int, str, int]]]
    labels: NotRequired[
        Union[
            Unset,
            List[
                Union[
                    str,
                    ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1Type,
                ]
            ],
        ]
    ]
    assignees: NotRequired[Union[Unset, List[str]]]


class ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1Type(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1"""

    id: NotRequired[Union[Unset, int]]
    name: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, Union[str, None]]]
    color: NotRequired[Union[Unset, Union[str, None]]]


class ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberAssigneesPostBody"""

    assignees: NotRequired[Union[Unset, List[str]]]


class ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody"""

    assignees: NotRequired[Union[Unset, List[str]]]


class ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberCommentsPostBody"""

    body: str


class ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0"""

    labels: NotRequired[Union[Unset, List[str]]]


class ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2"""

    labels: NotRequired[
        Union[
            Unset,
            List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItemsType],
        ]
    ]


class ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItemsType(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItems"""

    name: str


class ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items"""

    name: str


class ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0"""

    labels: NotRequired[Union[Unset, List[str]]]


class ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2"""

    labels: NotRequired[
        Union[
            Unset,
            List[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItemsType
            ],
        ]
    ]


class ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItemsType(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItems"""

    name: str


class ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items"""

    name: str


class ReposOwnerRepoIssuesIssueNumberLockPutBodyType(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberLockPutBody"""

    lock_reason: NotRequired[
        Union[Unset, Literal["off-topic", "too heated", "resolved", "spam"]]
    ]


class ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType(TypedDict):
    """ReposOwnerRepoIssuesIssueNumberReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ]


class ReposOwnerRepoKeysPostBodyType(TypedDict):
    """ReposOwnerRepoKeysPostBody"""

    title: NotRequired[Union[Unset, str]]
    key: str
    read_only: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoLabelsPostBodyType(TypedDict):
    """ReposOwnerRepoLabelsPostBody"""

    name: str
    color: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, str]]


class ReposOwnerRepoLabelsNamePatchBodyType(TypedDict):
    """ReposOwnerRepoLabelsNamePatchBody"""

    new_name: NotRequired[Union[Unset, str]]
    color: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, str]]


class ReposOwnerRepoMergeUpstreamPostBodyType(TypedDict):
    """ReposOwnerRepoMergeUpstreamPostBody"""

    branch: str


class ReposOwnerRepoMergesPostBodyType(TypedDict):
    """ReposOwnerRepoMergesPostBody"""

    base: str
    head: str
    commit_message: NotRequired[Union[Unset, str]]


class ReposOwnerRepoMilestonesPostBodyType(TypedDict):
    """ReposOwnerRepoMilestonesPostBody"""

    title: str
    state: NotRequired[Union[Unset, Literal["open", "closed"]]]
    description: NotRequired[Union[Unset, str]]
    due_on: NotRequired[Union[Unset, datetime]]


class ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType(TypedDict):
    """ReposOwnerRepoMilestonesMilestoneNumberPatchBody"""

    title: NotRequired[Union[Unset, str]]
    state: NotRequired[Union[Unset, Literal["open", "closed"]]]
    description: NotRequired[Union[Unset, str]]
    due_on: NotRequired[Union[Unset, datetime]]


class ReposOwnerRepoNotificationsPutBodyType(TypedDict):
    """ReposOwnerRepoNotificationsPutBody"""

    last_read_at: NotRequired[Union[Unset, datetime]]


class ReposOwnerRepoNotificationsPutResponse202Type(TypedDict):
    """ReposOwnerRepoNotificationsPutResponse202"""

    message: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]


class ReposOwnerRepoPagesPostBodyType(TypedDict):
    """ReposOwnerRepoPagesPostBody

    The source branch and directory used to publish your Pages site.
    """

    source: NotRequired[Union[Unset, ReposOwnerRepoPagesPostBodyPropSourceType]]


class ReposOwnerRepoPagesPostBodyPropSourceType(TypedDict):
    """ReposOwnerRepoPagesPostBodyPropSource

    The source branch and directory used to publish your Pages site.
    """

    branch: str
    path: NotRequired[Union[Unset, Literal["/", "/docs"]]]


class ReposOwnerRepoProjectsPostBodyType(TypedDict):
    """ReposOwnerRepoProjectsPostBody"""

    name: str
    body: NotRequired[Union[Unset, str]]


class ReposOwnerRepoPullsPostBodyType(TypedDict):
    """ReposOwnerRepoPullsPostBody"""

    title: NotRequired[Union[Unset, str]]
    head: str
    base: str
    body: NotRequired[Union[Unset, str]]
    maintainer_can_modify: NotRequired[Union[Unset, bool]]
    draft: NotRequired[Union[Unset, bool]]
    issue: NotRequired[Union[Unset, int]]


class ReposOwnerRepoPullsCommentsCommentIdPatchBodyType(TypedDict):
    """ReposOwnerRepoPullsCommentsCommentIdPatchBody"""

    body: str


class ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType(TypedDict):
    """ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ]


class ReposOwnerRepoPullsPullNumberPatchBodyType(TypedDict):
    """ReposOwnerRepoPullsPullNumberPatchBody"""

    title: NotRequired[Union[Unset, str]]
    body: NotRequired[Union[Unset, str]]
    state: NotRequired[Union[Unset, Literal["open", "closed"]]]
    base: NotRequired[Union[Unset, str]]
    maintainer_can_modify: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoPullsPullNumberCodespacesPostBodyType(TypedDict):
    """ReposOwnerRepoPullsPullNumberCodespacesPostBody"""

    location: NotRequired[Union[Unset, str]]
    client_ip: NotRequired[Union[Unset, str]]
    machine: NotRequired[Union[Unset, str]]
    devcontainer_path: NotRequired[Union[Unset, str]]
    multi_repo_permissions_opt_out: NotRequired[Union[Unset, bool]]
    working_directory: NotRequired[Union[Unset, str]]
    idle_timeout_minutes: NotRequired[Union[Unset, int]]
    display_name: NotRequired[Union[Unset, str]]
    retention_period_minutes: NotRequired[Union[Unset, int]]


class ReposOwnerRepoPullsPullNumberCommentsPostBodyType(TypedDict):
    """ReposOwnerRepoPullsPullNumberCommentsPostBody"""

    body: str
    commit_id: NotRequired[Union[Unset, str]]
    path: NotRequired[Union[Unset, str]]
    position: NotRequired[Union[Unset, int]]
    side: NotRequired[Union[Unset, Literal["LEFT", "RIGHT"]]]
    line: NotRequired[Union[Unset, int]]
    start_line: NotRequired[Union[Unset, int]]
    start_side: NotRequired[Union[Unset, Literal["LEFT", "RIGHT", "side"]]]
    in_reply_to: NotRequired[Union[Unset, int]]


class ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType(TypedDict):
    """ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody"""

    body: str


class ReposOwnerRepoPullsPullNumberMergePutBodyType(TypedDict):
    """ReposOwnerRepoPullsPullNumberMergePutBody"""

    commit_title: NotRequired[Union[Unset, str]]
    commit_message: NotRequired[Union[Unset, str]]
    sha: NotRequired[Union[Unset, str]]
    merge_method: NotRequired[Union[Unset, Literal["merge", "squash", "rebase"]]]


class ReposOwnerRepoPullsPullNumberMergePutResponse405Type(TypedDict):
    """ReposOwnerRepoPullsPullNumberMergePutResponse405"""

    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]


class ReposOwnerRepoPullsPullNumberMergePutResponse409Type(TypedDict):
    """ReposOwnerRepoPullsPullNumberMergePutResponse409"""

    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]


class ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType(TypedDict):
    """ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody"""

    reviewers: List[str]
    team_reviewers: NotRequired[Union[Unset, List[str]]]


class ReposOwnerRepoPullsPullNumberReviewsPostBodyType(TypedDict):
    """ReposOwnerRepoPullsPullNumberReviewsPostBody"""

    commit_id: NotRequired[Union[Unset, str]]
    body: NotRequired[Union[Unset, str]]
    event: NotRequired[Union[Unset, Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]]]
    comments: NotRequired[
        Union[
            Unset,
            List[ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType],
        ]
    ]


class ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType(TypedDict):
    """ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItems"""

    path: str
    position: NotRequired[Union[Unset, int]]
    body: str
    line: NotRequired[Union[Unset, int]]
    side: NotRequired[Union[Unset, str]]
    start_line: NotRequired[Union[Unset, int]]
    start_side: NotRequired[Union[Unset, str]]


class ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType(TypedDict):
    """ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody"""

    body: str


class ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType(TypedDict):
    """ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody"""

    message: str
    event: NotRequired[Union[Unset, Literal["DISMISS"]]]


class ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType(TypedDict):
    """ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody"""

    body: NotRequired[Union[Unset, str]]
    event: Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]


class ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType(TypedDict):
    """ReposOwnerRepoPullsPullNumberUpdateBranchPutBody"""

    expected_head_sha: NotRequired[Union[Unset, str]]


class ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type(TypedDict):
    """ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202"""

    message: NotRequired[Union[Unset, str]]
    url: NotRequired[Union[Unset, str]]


class ReposOwnerRepoReleasesPostBodyType(TypedDict):
    """ReposOwnerRepoReleasesPostBody"""

    tag_name: str
    target_commitish: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    body: NotRequired[Union[Unset, str]]
    draft: NotRequired[Union[Unset, bool]]
    prerelease: NotRequired[Union[Unset, bool]]
    discussion_category_name: NotRequired[Union[Unset, str]]
    generate_release_notes: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType(TypedDict):
    """ReposOwnerRepoReleasesAssetsAssetIdPatchBody"""

    name: NotRequired[Union[Unset, str]]
    label: NotRequired[Union[Unset, str]]
    state: NotRequired[Union[Unset, str]]


class ReposOwnerRepoReleasesGenerateNotesPostBodyType(TypedDict):
    """ReposOwnerRepoReleasesGenerateNotesPostBody"""

    tag_name: str
    target_commitish: NotRequired[Union[Unset, str]]
    previous_tag_name: NotRequired[Union[Unset, str]]
    configuration_file_path: NotRequired[Union[Unset, str]]


class ReposOwnerRepoReleasesReleaseIdPatchBodyType(TypedDict):
    """ReposOwnerRepoReleasesReleaseIdPatchBody"""

    tag_name: NotRequired[Union[Unset, str]]
    target_commitish: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    body: NotRequired[Union[Unset, str]]
    draft: NotRequired[Union[Unset, bool]]
    prerelease: NotRequired[Union[Unset, bool]]
    discussion_category_name: NotRequired[Union[Unset, str]]


class ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType(TypedDict):
    """ReposOwnerRepoReleasesReleaseIdReactionsPostBody"""

    content: Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"]


class ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyType(TypedDict):
    """ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBody"""

    state: Literal["open", "resolved"]
    resolution: NotRequired[
        Union[
            Unset,
            Literal[None, "false_positive", "wont_fix", "revoked", "used_in_tests"],
        ]
    ]


class ReposOwnerRepoStatusesShaPostBodyType(TypedDict):
    """ReposOwnerRepoStatusesShaPostBody"""

    state: Literal["error", "failure", "pending", "success"]
    target_url: NotRequired[Union[Unset, Union[str, None]]]
    description: NotRequired[Union[Unset, Union[str, None]]]
    context: NotRequired[Union[Unset, str]]


class ReposOwnerRepoSubscriptionPutBodyType(TypedDict):
    """ReposOwnerRepoSubscriptionPutBody"""

    subscribed: NotRequired[Union[Unset, bool]]
    ignored: NotRequired[Union[Unset, bool]]


class ReposOwnerRepoTagsProtectionPostBodyType(TypedDict):
    """ReposOwnerRepoTagsProtectionPostBody"""

    pattern: str


class ReposOwnerRepoTopicsPutBodyType(TypedDict):
    """ReposOwnerRepoTopicsPutBody"""

    names: List[str]


class ReposOwnerRepoTransferPostBodyType(TypedDict):
    """ReposOwnerRepoTransferPostBody"""

    new_owner: str
    team_ids: NotRequired[Union[Unset, List[int]]]


class ReposTemplateOwnerTemplateRepoGeneratePostBodyType(TypedDict):
    """ReposTemplateOwnerTemplateRepoGeneratePostBody"""

    owner: NotRequired[Union[Unset, str]]
    name: str
    description: NotRequired[Union[Unset, str]]
    include_all_branches: NotRequired[Union[Unset, bool]]
    private: NotRequired[Union[Unset, bool]]


class RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200Type(
    TypedDict
):
    """RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200"""

    total_count: int
    secrets: List[ActionsSecretType]


class RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType(
    TypedDict
):
    """RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody"""

    encrypted_value: str
    key_id: str


class ScimV2EnterprisesEnterpriseGroupsPostBodyType(TypedDict):
    """ScimV2EnterprisesEnterpriseGroupsPostBody"""

    schemas: List[str]
    display_name: str
    members: NotRequired[
        Union[
            Unset, List[ScimV2EnterprisesEnterpriseGroupsPostBodyPropMembersItemsType]
        ]
    ]


class ScimV2EnterprisesEnterpriseGroupsPostBodyPropMembersItemsType(TypedDict):
    """ScimV2EnterprisesEnterpriseGroupsPostBodyPropMembersItems"""

    value: str


class ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyType(TypedDict):
    """ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBody"""

    schemas: List[str]
    display_name: str
    members: NotRequired[
        Union[
            Unset,
            List[
                ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyPropMembersItemsType
            ],
        ]
    ]


class ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyPropMembersItemsType(
    TypedDict
):
    """ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyPropMembersItems"""

    value: str


class ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyType(TypedDict):
    """ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBody"""

    schemas: List[str]
    operations: List[
        ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyPropOperationsItemsType
    ]


class ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyPropOperationsItemsType(
    TypedDict
):
    """ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyPropOperationsItems"""

    op: Literal["add", "Add", "remove", "Remove", "replace", "Replace"]
    path: NotRequired[Union[Unset, str]]
    value: NotRequired[Union[Unset, Any]]


class ScimV2EnterprisesEnterpriseUsersPostBodyType(TypedDict):
    """ScimV2EnterprisesEnterpriseUsersPostBody"""

    schemas: List[str]
    user_name: str
    name: ScimV2EnterprisesEnterpriseUsersPostBodyPropNameType
    emails: List[ScimV2EnterprisesEnterpriseUsersPostBodyPropEmailsItemsType]
    groups: NotRequired[
        Union[Unset, List[ScimV2EnterprisesEnterpriseUsersPostBodyPropGroupsItemsType]]
    ]


class ScimV2EnterprisesEnterpriseUsersPostBodyPropNameType(TypedDict):
    """ScimV2EnterprisesEnterpriseUsersPostBodyPropName"""

    given_name: str
    family_name: str


class ScimV2EnterprisesEnterpriseUsersPostBodyPropEmailsItemsType(TypedDict):
    """ScimV2EnterprisesEnterpriseUsersPostBodyPropEmailsItems"""

    value: str
    type: str
    primary: bool


class ScimV2EnterprisesEnterpriseUsersPostBodyPropGroupsItemsType(TypedDict):
    """ScimV2EnterprisesEnterpriseUsersPostBodyPropGroupsItems"""

    value: NotRequired[Union[Unset, str]]


class ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyType(TypedDict):
    """ScimV2EnterprisesEnterpriseUsersScimUserIdPutBody"""

    schemas: List[str]
    user_name: str
    name: ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropNameType
    emails: List[ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropEmailsItemsType]
    groups: NotRequired[
        Union[
            Unset,
            List[ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropGroupsItemsType],
        ]
    ]


class ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropNameType(TypedDict):
    """ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropName"""

    given_name: str
    family_name: str


class ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropEmailsItemsType(TypedDict):
    """ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropEmailsItems"""

    value: str
    type: str
    primary: bool


class ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropGroupsItemsType(TypedDict):
    """ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropGroupsItems"""

    value: NotRequired[Union[Unset, str]]


class ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyType(TypedDict):
    """ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBody"""

    schemas: List[str]
    operations: List[
        ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyPropOperationsItemsType
    ]


class ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyPropOperationsItemsType(
    TypedDict
):
    """ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyPropOperationsItems"""


class ScimV2OrganizationsOrgUsersPostBodyType(TypedDict):
    """ScimV2OrganizationsOrgUsersPostBody"""

    user_name: str
    display_name: NotRequired[Union[Unset, str]]
    name: ScimV2OrganizationsOrgUsersPostBodyPropNameType
    emails: List[ScimV2OrganizationsOrgUsersPostBodyPropEmailsItemsType]
    schemas: NotRequired[Union[Unset, List[str]]]
    external_id: NotRequired[Union[Unset, str]]
    groups: NotRequired[Union[Unset, List[str]]]
    active: NotRequired[Union[Unset, bool]]


class ScimV2OrganizationsOrgUsersPostBodyPropNameType(TypedDict):
    """ScimV2OrganizationsOrgUsersPostBodyPropName

    Examples:
        {'givenName': 'Jane', 'familyName': 'User'}
    """

    given_name: str
    family_name: str
    formatted: NotRequired[Union[Unset, str]]


class ScimV2OrganizationsOrgUsersPostBodyPropEmailsItemsType(TypedDict):
    """ScimV2OrganizationsOrgUsersPostBodyPropEmailsItems"""

    value: str
    primary: NotRequired[Union[Unset, bool]]
    type: NotRequired[Union[Unset, str]]


class ScimV2OrganizationsOrgUsersScimUserIdPutBodyType(TypedDict):
    """ScimV2OrganizationsOrgUsersScimUserIdPutBody"""

    schemas: NotRequired[Union[Unset, List[str]]]
    display_name: NotRequired[Union[Unset, str]]
    external_id: NotRequired[Union[Unset, str]]
    groups: NotRequired[Union[Unset, List[str]]]
    active: NotRequired[Union[Unset, bool]]
    user_name: str
    name: ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropNameType
    emails: List[ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropEmailsItemsType]


class ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropNameType(TypedDict):
    """ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropName

    Examples:
        {'givenName': 'Jane', 'familyName': 'User'}
    """

    given_name: str
    family_name: str
    formatted: NotRequired[Union[Unset, str]]


class ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropEmailsItemsType(TypedDict):
    """ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropEmailsItems"""

    type: NotRequired[Union[Unset, str]]
    value: str
    primary: NotRequired[Union[Unset, bool]]


class ScimV2OrganizationsOrgUsersScimUserIdPatchBodyType(TypedDict):
    """ScimV2OrganizationsOrgUsersScimUserIdPatchBody"""

    schemas: NotRequired[Union[Unset, List[str]]]
    operations: List[
        ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsType
    ]


class ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsType(TypedDict):
    """ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItems"""

    op: Literal["add", "remove", "replace"]
    path: NotRequired[Union[Unset, str]]
    value: NotRequired[
        Union[
            Unset,
            Union[
                ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsPropValueOneof0Type,
                List[
                    ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsPropValueOneof1ItemsType
                ],
                str,
            ],
        ]
    ]


class ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsPropValueOneof0Type(
    TypedDict
):
    """ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsPropValueOneof0"""

    active: NotRequired[Union[Unset, Union[bool, None]]]
    user_name: NotRequired[Union[Unset, Union[str, None]]]
    external_id: NotRequired[Union[Unset, Union[str, None]]]
    given_name: NotRequired[Union[Unset, Union[str, None]]]
    family_name: NotRequired[Union[Unset, Union[str, None]]]


class ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsPropValueOneof1ItemsType(
    TypedDict
):
    """ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsPropValueOneof1
    Items
    """

    value: NotRequired[Union[Unset, str]]
    primary: NotRequired[Union[Unset, bool]]


class SearchCodeGetResponse200Type(TypedDict):
    """SearchCodeGetResponse200"""

    total_count: int
    incomplete_results: bool
    items: List[CodeSearchResultItemType]


class SearchCommitsGetResponse200Type(TypedDict):
    """SearchCommitsGetResponse200"""

    total_count: int
    incomplete_results: bool
    items: List[CommitSearchResultItemType]


class SearchIssuesGetResponse200Type(TypedDict):
    """SearchIssuesGetResponse200"""

    total_count: int
    incomplete_results: bool
    items: List[IssueSearchResultItemType]


class SearchLabelsGetResponse200Type(TypedDict):
    """SearchLabelsGetResponse200"""

    total_count: int
    incomplete_results: bool
    items: List[LabelSearchResultItemType]


class SearchRepositoriesGetResponse200Type(TypedDict):
    """SearchRepositoriesGetResponse200"""

    total_count: int
    incomplete_results: bool
    items: List[RepoSearchResultItemType]


class SearchTopicsGetResponse200Type(TypedDict):
    """SearchTopicsGetResponse200"""

    total_count: int
    incomplete_results: bool
    items: List[TopicSearchResultItemType]


class SearchUsersGetResponse200Type(TypedDict):
    """SearchUsersGetResponse200"""

    total_count: int
    incomplete_results: bool
    items: List[UserSearchResultItemType]


class TeamsTeamIdPatchBodyType(TypedDict):
    """TeamsTeamIdPatchBody"""

    name: str
    description: NotRequired[Union[Unset, str]]
    privacy: NotRequired[Union[Unset, Literal["secret", "closed"]]]
    permission: NotRequired[Union[Unset, Literal["pull", "push", "admin"]]]
    parent_team_id: NotRequired[Union[Unset, Union[int, None]]]


class TeamsTeamIdDiscussionsPostBodyType(TypedDict):
    """TeamsTeamIdDiscussionsPostBody"""

    title: str
    body: str
    private: NotRequired[Union[Unset, bool]]


class TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType(TypedDict):
    """TeamsTeamIdDiscussionsDiscussionNumberPatchBody"""

    title: NotRequired[Union[Unset, str]]
    body: NotRequired[Union[Unset, str]]


class TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType(TypedDict):
    """TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody"""

    body: str


class TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType(
    TypedDict
):
    """TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody"""

    body: str


class TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType(
    TypedDict
):
    """TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ]


class TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType(TypedDict):
    """TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ]


class TeamsTeamIdMembershipsUsernamePutBodyType(TypedDict):
    """TeamsTeamIdMembershipsUsernamePutBody"""

    role: NotRequired[Union[Unset, Literal["member", "maintainer"]]]


class TeamsTeamIdProjectsProjectIdPutBodyType(TypedDict):
    """TeamsTeamIdProjectsProjectIdPutBody"""

    permission: NotRequired[Union[Unset, Literal["read", "write", "admin"]]]


class TeamsTeamIdProjectsProjectIdPutResponse403Type(TypedDict):
    """TeamsTeamIdProjectsProjectIdPutResponse403"""

    message: NotRequired[Union[Unset, str]]
    documentation_url: NotRequired[Union[Unset, str]]


class TeamsTeamIdReposOwnerRepoPutBodyType(TypedDict):
    """TeamsTeamIdReposOwnerRepoPutBody"""

    permission: NotRequired[Union[Unset, Literal["pull", "push", "admin"]]]


class TeamsTeamIdTeamSyncGroupMappingsPatchBodyType(TypedDict):
    """TeamsTeamIdTeamSyncGroupMappingsPatchBody"""

    groups: List[TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItemsType]
    synced_at: NotRequired[Union[Unset, str]]


class TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItemsType(TypedDict):
    """TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItems"""

    group_id: str
    group_name: str
    group_description: str
    id: NotRequired[Union[Unset, str]]
    name: NotRequired[Union[Unset, str]]
    description: NotRequired[Union[Unset, str]]


class UserPatchBodyType(TypedDict):
    """UserPatchBody"""

    name: NotRequired[Union[Unset, str]]
    email: NotRequired[Union[Unset, str]]
    blog: NotRequired[Union[Unset, str]]
    twitter_username: NotRequired[Union[Unset, Union[str, None]]]
    company: NotRequired[Union[Unset, str]]
    location: NotRequired[Union[Unset, str]]
    hireable: NotRequired[Union[Unset, bool]]
    bio: NotRequired[Union[Unset, str]]


class UserCodespacesGetResponse200Type(TypedDict):
    """UserCodespacesGetResponse200"""

    total_count: int
    codespaces: List[CodespaceType]


class UserCodespacesPostBodyOneof0Type(TypedDict):
    """UserCodespacesPostBodyOneof0"""

    repository_id: int
    ref: NotRequired[Union[Unset, str]]
    location: NotRequired[Union[Unset, str]]
    client_ip: NotRequired[Union[Unset, str]]
    machine: NotRequired[Union[Unset, str]]
    devcontainer_path: NotRequired[Union[Unset, str]]
    multi_repo_permissions_opt_out: NotRequired[Union[Unset, bool]]
    working_directory: NotRequired[Union[Unset, str]]
    idle_timeout_minutes: NotRequired[Union[Unset, int]]
    display_name: NotRequired[Union[Unset, str]]
    retention_period_minutes: NotRequired[Union[Unset, int]]


class UserCodespacesPostBodyOneof1Type(TypedDict):
    """UserCodespacesPostBodyOneof1"""

    pull_request: UserCodespacesPostBodyOneof1PropPullRequestType
    location: NotRequired[Union[Unset, str]]
    machine: NotRequired[Union[Unset, str]]
    devcontainer_path: NotRequired[Union[Unset, str]]
    working_directory: NotRequired[Union[Unset, str]]
    idle_timeout_minutes: NotRequired[Union[Unset, int]]


class UserCodespacesPostBodyOneof1PropPullRequestType(TypedDict):
    """UserCodespacesPostBodyOneof1PropPullRequest

    Pull request number for this codespace
    """

    pull_request_number: int
    repository_id: int


class UserCodespacesSecretsGetResponse200Type(TypedDict):
    """UserCodespacesSecretsGetResponse200"""

    total_count: int
    secrets: List[CodespacesSecretType]


class UserCodespacesSecretsSecretNamePutBodyType(TypedDict):
    """UserCodespacesSecretsSecretNamePutBody"""

    encrypted_value: NotRequired[Union[Unset, str]]
    key_id: str
    selected_repository_ids: NotRequired[Union[Unset, List[str]]]


class UserCodespacesSecretsSecretNamePutResponse201Type(TypedDict):
    """UserCodespacesSecretsSecretNamePutResponse201"""


class UserCodespacesSecretsSecretNameRepositoriesGetResponse200Type(TypedDict):
    """UserCodespacesSecretsSecretNameRepositoriesGetResponse200"""

    total_count: int
    repositories: List[MinimalRepositoryType]


class UserCodespacesSecretsSecretNameRepositoriesPutBodyType(TypedDict):
    """UserCodespacesSecretsSecretNameRepositoriesPutBody"""

    selected_repository_ids: List[int]


class UserCodespacesCodespaceNamePatchBodyType(TypedDict):
    """UserCodespacesCodespaceNamePatchBody"""

    machine: NotRequired[Union[Unset, str]]
    display_name: NotRequired[Union[Unset, str]]
    recent_folders: NotRequired[Union[Unset, List[str]]]


class UserCodespacesCodespaceNameMachinesGetResponse200Type(TypedDict):
    """UserCodespacesCodespaceNameMachinesGetResponse200"""

    total_count: int
    machines: List[CodespaceMachineType]


class UserEmailVisibilityPatchBodyType(TypedDict):
    """UserEmailVisibilityPatchBody"""

    visibility: Literal["public", "private"]


class UserEmailsPostBodyOneof0Type(TypedDict):
    """UserEmailsPostBodyOneof0

    Examples:
        {'emails': ['octocat@github.com', 'mona@github.com']}
    """

    emails: List[str]


class UserEmailsDeleteBodyOneof0Type(TypedDict):
    """UserEmailsDeleteBodyOneof0

    Deletes one or more email addresses from your GitHub account. Must contain at
    least one email address. **Note:** Alternatively, you can pass a single email
    address or an `array` of emails addresses directly, but we recommend that you
    pass an object using the `emails` key.

    Examples:
        {'emails': ['octocat@github.com', 'mona@github.com']}
    """

    emails: List[str]


class UserGpgKeysPostBodyType(TypedDict):
    """UserGpgKeysPostBody"""

    name: NotRequired[Union[Unset, str]]
    armored_public_key: str


class UserInstallationsGetResponse200Type(TypedDict):
    """UserInstallationsGetResponse200"""

    total_count: int
    installations: List[InstallationType]


class UserInstallationsInstallationIdRepositoriesGetResponse200Type(TypedDict):
    """UserInstallationsInstallationIdRepositoriesGetResponse200"""

    total_count: int
    repository_selection: NotRequired[Union[Unset, str]]
    repositories: List[RepositoryType]


class UserInteractionLimitsGetResponse200Anyof1Type(TypedDict):
    """UserInteractionLimitsGetResponse200Anyof1"""


class UserKeysPostBodyType(TypedDict):
    """UserKeysPostBody"""

    title: NotRequired[Union[Unset, str]]
    key: str


class UserMembershipsOrgsOrgPatchBodyType(TypedDict):
    """UserMembershipsOrgsOrgPatchBody"""

    state: Literal["active"]


class UserMigrationsPostBodyType(TypedDict):
    """UserMigrationsPostBody"""

    lock_repositories: NotRequired[Union[Unset, bool]]
    exclude_metadata: NotRequired[Union[Unset, bool]]
    exclude_git_data: NotRequired[Union[Unset, bool]]
    exclude_attachments: NotRequired[Union[Unset, bool]]
    exclude_releases: NotRequired[Union[Unset, bool]]
    exclude_owner_projects: NotRequired[Union[Unset, bool]]
    org_metadata_only: NotRequired[Union[Unset, bool]]
    exclude: NotRequired[Union[Unset, List[Literal["repositories"]]]]
    repositories: List[str]


class UserProjectsPostBodyType(TypedDict):
    """UserProjectsPostBody"""

    name: str
    body: NotRequired[Union[Unset, Union[str, None]]]


class UserReposPostBodyType(TypedDict):
    """UserReposPostBody"""

    name: str
    description: NotRequired[Union[Unset, str]]
    homepage: NotRequired[Union[Unset, str]]
    private: NotRequired[Union[Unset, bool]]
    has_issues: NotRequired[Union[Unset, bool]]
    has_projects: NotRequired[Union[Unset, bool]]
    has_wiki: NotRequired[Union[Unset, bool]]
    team_id: NotRequired[Union[Unset, int]]
    auto_init: NotRequired[Union[Unset, bool]]
    gitignore_template: NotRequired[Union[Unset, str]]
    license_template: NotRequired[Union[Unset, str]]
    allow_squash_merge: NotRequired[Union[Unset, bool]]
    allow_merge_commit: NotRequired[Union[Unset, bool]]
    allow_rebase_merge: NotRequired[Union[Unset, bool]]
    allow_auto_merge: NotRequired[Union[Unset, bool]]
    delete_branch_on_merge: NotRequired[Union[Unset, bool]]
    has_downloads: NotRequired[Union[Unset, bool]]
    is_template: NotRequired[Union[Unset, bool]]


__all__ = [
    "RootType",
    "SimpleUserType",
    "IntegrationType",
    "IntegrationPropPermissionsType",
    "BasicErrorType",
    "ValidationErrorSimpleType",
    "WebhookConfigType",
    "HookDeliveryItemType",
    "ScimErrorType",
    "ValidationErrorType",
    "ValidationErrorPropErrorsItemsType",
    "HookDeliveryType",
    "HookDeliveryPropRequestType",
    "HookDeliveryPropRequestPropHeadersType",
    "HookDeliveryPropRequestPropPayloadType",
    "HookDeliveryPropResponseType",
    "HookDeliveryPropResponsePropHeadersType",
    "EnterpriseType",
    "AppPermissionsType",
    "InstallationType",
    "InstallationPropAccountType",
    "LicenseSimpleType",
    "RepositoryType",
    "RepositoryPropPermissionsType",
    "RepositoryPropTemplateRepositoryType",
    "RepositoryPropTemplateRepositoryPropOwnerType",
    "RepositoryPropTemplateRepositoryPropPermissionsType",
    "InstallationTokenType",
    "ApplicationGrantType",
    "ApplicationGrantPropAppType",
    "ScopedInstallationType",
    "AuthorizationType",
    "AuthorizationPropAppType",
    "CodeOfConductType",
    "ActionsCacheUsageOrgEnterpriseType",
    "ActionsOidcCustomIssuerPolicyForEnterpriseType",
    "ActionsEnterprisePermissionsType",
    "OrganizationSimpleType",
    "SelectedActionsType",
    "ActionsGetDefaultWorkflowPermissionsType",
    "ActionsSetDefaultWorkflowPermissionsType",
    "RunnerGroupsEnterpriseType",
    "RunnerLabelType",
    "RunnerType",
    "RunnerApplicationType",
    "AuthenticationTokenType",
    "AuthenticationTokenPropPermissionsType",
    "AuditLogEventType",
    "AuditLogEventPropActorLocationType",
    "AuditLogEventPropDataType",
    "AuditLogEventPropConfigItemsType",
    "AuditLogEventPropConfigWasItemsType",
    "AuditLogEventPropEventsItemsType",
    "AuditLogEventPropEventsWereItemsType",
    "CodeScanningAlertRuleType",
    "CodeScanningAnalysisToolType",
    "CodeScanningAlertLocationType",
    "CodeScanningAlertInstanceType",
    "CodeScanningAlertInstancePropMessageType",
    "SimpleRepositoryType",
    "CodeScanningOrganizationAlertItemsType",
    "OrganizationSecretScanningAlertType",
    "ActionsBillingUsageType",
    "ActionsBillingUsagePropMinutesUsedBreakdownType",
    "AdvancedSecurityActiveCommittersUserType",
    "AdvancedSecurityActiveCommittersRepositoryType",
    "AdvancedSecurityActiveCommittersType",
    "PackagesBillingUsageType",
    "CombinedBillingUsageType",
    "ActorType",
    "MilestoneType",
    "ReactionRollupType",
    "IssueType",
    "IssuePropLabelsItemsOneof1Type",
    "IssuePropPullRequestType",
    "IssueCommentType",
    "EventType",
    "EventPropRepoType",
    "EventPropPayloadType",
    "EventPropPayloadPropPagesItemsType",
    "LinkWithTypeType",
    "FeedType",
    "FeedPropLinksType",
    "BaseGistType",
    "BaseGistPropFilesType",
    "PublicUserType",
    "PublicUserPropPlanType",
    "GistHistoryType",
    "GistHistoryPropChangeStatusType",
    "GistSimpleType",
    "GistSimplePropForksItemsType",
    "GistSimplePropForkOfType",
    "GistSimplePropForkOfPropFilesType",
    "GistSimplePropFilesType",
    "GistCommentType",
    "GistCommitType",
    "GistCommitPropChangeStatusType",
    "GitignoreTemplateType",
    "LicenseType",
    "MarketplaceListingPlanType",
    "MarketplacePurchaseType",
    "MarketplacePurchasePropMarketplacePendingChangeType",
    "MarketplacePurchasePropMarketplacePurchaseType",
    "ApiOverviewType",
    "ApiOverviewPropSshKeyFingerprintsType",
    "MinimalRepositoryType",
    "MinimalRepositoryPropPermissionsType",
    "MinimalRepositoryPropLicenseType",
    "ThreadType",
    "ThreadPropSubjectType",
    "ThreadSubscriptionType",
    "OrganizationCustomRepositoryRoleType",
    "OrganizationFullType",
    "OrganizationFullPropPlanType",
    "ActionsCacheUsageByRepositoryType",
    "OidcCustomSubType",
    "EmptyObjectType",
    "ActionsOrganizationPermissionsType",
    "RunnerGroupsOrgType",
    "OrganizationActionsSecretType",
    "ActionsPublicKeyType",
    "CodespaceMachineType",
    "CodespaceType",
    "CodespacePropGitStatusType",
    "CodespacePropRuntimeConstraintsType",
    "CredentialAuthorizationType",
    "OrganizationDependabotSecretType",
    "DependabotPublicKeyType",
    "ExternalGroupType",
    "ExternalGroupPropTeamsItemsType",
    "ExternalGroupPropMembersItemsType",
    "ExternalGroupsType",
    "ExternalGroupsPropGroupsItemsType",
    "OrganizationInvitationType",
    "OrgHookType",
    "OrgHookPropConfigType",
    "InteractionLimitResponseType",
    "InteractionLimitType",
    "TeamSimpleType",
    "TeamType",
    "TeamPropPermissionsType",
    "OrgMembershipType",
    "OrgMembershipPropPermissionsType",
    "MigrationType",
    "PackageType",
    "PackageVersionType",
    "PackageVersionPropMetadataType",
    "PackageVersionPropMetadataPropContainerType",
    "PackageVersionPropMetadataPropDockerType",
    "ProjectType",
    "GroupMappingType",
    "GroupMappingPropGroupsItemsType",
    "TeamFullType",
    "TeamDiscussionType",
    "TeamDiscussionCommentType",
    "ReactionType",
    "TeamMembershipType",
    "TeamProjectType",
    "TeamProjectPropPermissionsType",
    "TeamRepositoryType",
    "TeamRepositoryPropPermissionsType",
    "ProjectCardType",
    "ProjectColumnType",
    "ProjectCollaboratorPermissionType",
    "RateLimitType",
    "RateLimitOverviewType",
    "RateLimitOverviewPropResourcesType",
    "CodeOfConductSimpleType",
    "SecurityAndAnalysisType",
    "SecurityAndAnalysisPropAdvancedSecurityType",
    "SecurityAndAnalysisPropSecretScanningType",
    "SecurityAndAnalysisPropSecretScanningPushProtectionType",
    "FullRepositoryType",
    "FullRepositoryPropPermissionsType",
    "ArtifactType",
    "ArtifactPropWorkflowRunType",
    "ActionsCacheListType",
    "ActionsCacheListPropActionsCachesItemsType",
    "JobType",
    "JobPropStepsItemsType",
    "OptOutOidcCustomSubType",
    "ActionsRepositoryPermissionsType",
    "ActionsWorkflowAccessToRepositoryType",
    "ReferencedWorkflowType",
    "PullRequestMinimalType",
    "PullRequestMinimalPropHeadType",
    "PullRequestMinimalPropHeadPropRepoType",
    "PullRequestMinimalPropBaseType",
    "PullRequestMinimalPropBasePropRepoType",
    "SimpleCommitType",
    "SimpleCommitPropAuthorType",
    "SimpleCommitPropCommitterType",
    "WorkflowRunType",
    "EnvironmentApprovalsType",
    "EnvironmentApprovalsPropEnvironmentsItemsType",
    "PendingDeploymentType",
    "PendingDeploymentPropEnvironmentType",
    "PendingDeploymentPropReviewersItemsType",
    "DeploymentType",
    "DeploymentPropPayloadOneof0Type",
    "WorkflowRunUsageType",
    "WorkflowRunUsagePropBillableType",
    "WorkflowRunUsagePropBillablePropUbuntuType",
    "WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItemsType",
    "WorkflowRunUsagePropBillablePropMacosType",
    "WorkflowRunUsagePropBillablePropMacosPropJobRunsItemsType",
    "WorkflowRunUsagePropBillablePropWindowsType",
    "WorkflowRunUsagePropBillablePropWindowsPropJobRunsItemsType",
    "ActionsSecretType",
    "WorkflowType",
    "WorkflowUsageType",
    "WorkflowUsagePropBillableType",
    "WorkflowUsagePropBillablePropUbuntuType",
    "WorkflowUsagePropBillablePropMacosType",
    "WorkflowUsagePropBillablePropWindowsType",
    "AutolinkType",
    "ProtectedBranchRequiredStatusCheckType",
    "ProtectedBranchRequiredStatusCheckPropChecksItemsType",
    "ProtectedBranchAdminEnforcedType",
    "ProtectedBranchPullRequestReviewType",
    "ProtectedBranchPullRequestReviewPropDismissalRestrictionsType",
    "ProtectedBranchPullRequestReviewPropBypassPullRequestAllowancesType",
    "BranchRestrictionPolicyType",
    "BranchRestrictionPolicyPropUsersItemsType",
    "BranchRestrictionPolicyPropTeamsItemsType",
    "BranchRestrictionPolicyPropAppsItemsType",
    "BranchRestrictionPolicyPropAppsItemsPropOwnerType",
    "BranchRestrictionPolicyPropAppsItemsPropPermissionsType",
    "BranchProtectionType",
    "BranchProtectionPropRequiredLinearHistoryType",
    "BranchProtectionPropAllowForcePushesType",
    "BranchProtectionPropAllowDeletionsType",
    "BranchProtectionPropBlockCreationsType",
    "BranchProtectionPropRequiredConversationResolutionType",
    "BranchProtectionPropRequiredSignaturesType",
    "ShortBranchType",
    "ShortBranchPropCommitType",
    "GitUserType",
    "VerificationType",
    "DiffEntryType",
    "CommitType",
    "CommitPropCommitType",
    "CommitPropCommitPropTreeType",
    "CommitPropParentsItemsType",
    "CommitPropStatsType",
    "BranchWithProtectionType",
    "BranchWithProtectionPropLinksType",
    "StatusCheckPolicyType",
    "StatusCheckPolicyPropChecksItemsType",
    "ProtectedBranchType",
    "ProtectedBranchPropRequiredPullRequestReviewsType",
    "ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictionsType",
    "ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowancesType",
    "ProtectedBranchPropRequiredSignaturesType",
    "ProtectedBranchPropEnforceAdminsType",
    "ProtectedBranchPropRequiredLinearHistoryType",
    "ProtectedBranchPropAllowForcePushesType",
    "ProtectedBranchPropAllowDeletionsType",
    "ProtectedBranchPropRequiredConversationResolutionType",
    "ProtectedBranchPropBlockCreationsType",
    "DeploymentSimpleType",
    "CheckRunType",
    "CheckRunPropOutputType",
    "CheckRunPropCheckSuiteType",
    "CheckAnnotationType",
    "CheckSuiteType",
    "CheckSuitePreferenceType",
    "CheckSuitePreferencePropPreferencesType",
    "CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItemsType",
    "CodeScanningAlertRuleSummaryType",
    "CodeScanningAlertItemsType",
    "CodeScanningAlertType",
    "CodeScanningAnalysisType",
    "CodeScanningAnalysisDeletionType",
    "CodeScanningSarifsReceiptType",
    "CodeScanningSarifsStatusType",
    "CodeownersErrorsType",
    "CodeownersErrorsPropErrorsItemsType",
    "RepoCodespacesSecretType",
    "CodespacesPublicKeyType",
    "CollaboratorType",
    "CollaboratorPropPermissionsType",
    "RepositoryInvitationType",
    "RepositoryCollaboratorPermissionType",
    "CommitCommentType",
    "BranchShortType",
    "BranchShortPropCommitType",
    "LinkType",
    "AutoMergeType",
    "PullRequestSimpleType",
    "PullRequestSimplePropLabelsItemsType",
    "PullRequestSimplePropHeadType",
    "PullRequestSimplePropBaseType",
    "PullRequestSimplePropLinksType",
    "SimpleCommitStatusType",
    "CombinedCommitStatusType",
    "StatusType",
    "CommunityHealthFileType",
    "CommunityProfileType",
    "CommunityProfilePropFilesType",
    "CommitComparisonType",
    "ContentTreeType",
    "ContentTreePropEntriesItemsType",
    "ContentTreePropEntriesItemsPropLinksType",
    "ContentTreePropLinksType",
    "ContentDirectoryItemsType",
    "ContentDirectoryItemsPropLinksType",
    "ContentFileType",
    "ContentFilePropLinksType",
    "ContentSymlinkType",
    "ContentSymlinkPropLinksType",
    "ContentSubmoduleType",
    "ContentSubmodulePropLinksType",
    "FileCommitType",
    "FileCommitPropContentType",
    "FileCommitPropContentPropLinksType",
    "FileCommitPropCommitType",
    "FileCommitPropCommitPropAuthorType",
    "FileCommitPropCommitPropCommitterType",
    "FileCommitPropCommitPropTreeType",
    "FileCommitPropCommitPropParentsItemsType",
    "FileCommitPropCommitPropVerificationType",
    "ContributorType",
    "DependabotSecretType",
    "DependencyGraphDiffItemsType",
    "DependencyGraphDiffItemsPropVulnerabilitiesItemsType",
    "MetadataType",
    "DependencyType",
    "ManifestType",
    "ManifestPropFileType",
    "SnapshotType",
    "SnapshotPropJobType",
    "SnapshotPropDetectorType",
    "SnapshotPropManifestsType",
    "DeploymentStatusType",
    "DeploymentBranchPolicyType",
    "EnvironmentType",
    "EnvironmentPropProtectionRulesItemsAnyof0Type",
    "EnvironmentPropProtectionRulesItemsAnyof1Type",
    "EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItemsType",
    "EnvironmentPropProtectionRulesItemsAnyof2Type",
    "ShortBlobType",
    "BlobType",
    "GitCommitType",
    "GitCommitPropAuthorType",
    "GitCommitPropCommitterType",
    "GitCommitPropTreeType",
    "GitCommitPropParentsItemsType",
    "GitCommitPropVerificationType",
    "GitRefType",
    "GitRefPropObjectType",
    "GitTagType",
    "GitTagPropTaggerType",
    "GitTagPropObjectType",
    "GitTreeType",
    "GitTreePropTreeItemsType",
    "HookResponseType",
    "HookType",
    "HookPropConfigType",
    "ImportType",
    "ImportPropProjectChoicesItemsType",
    "PorterAuthorType",
    "PorterLargeFileType",
    "IssueEventLabelType",
    "IssueEventDismissedReviewType",
    "IssueEventMilestoneType",
    "IssueEventProjectCardType",
    "IssueEventRenameType",
    "IssueEventType",
    "LabeledIssueEventType",
    "LabeledIssueEventPropLabelType",
    "UnlabeledIssueEventType",
    "UnlabeledIssueEventPropLabelType",
    "AssignedIssueEventType",
    "UnassignedIssueEventType",
    "MilestonedIssueEventType",
    "MilestonedIssueEventPropMilestoneType",
    "DemilestonedIssueEventType",
    "DemilestonedIssueEventPropMilestoneType",
    "RenamedIssueEventType",
    "RenamedIssueEventPropRenameType",
    "ReviewRequestedIssueEventType",
    "ReviewRequestRemovedIssueEventType",
    "ReviewDismissedIssueEventType",
    "ReviewDismissedIssueEventPropDismissedReviewType",
    "LockedIssueEventType",
    "AddedToProjectIssueEventType",
    "AddedToProjectIssueEventPropProjectCardType",
    "MovedColumnInProjectIssueEventType",
    "MovedColumnInProjectIssueEventPropProjectCardType",
    "RemovedFromProjectIssueEventType",
    "RemovedFromProjectIssueEventPropProjectCardType",
    "ConvertedNoteToIssueIssueEventType",
    "ConvertedNoteToIssueIssueEventPropProjectCardType",
    "LabelType",
    "TimelineCommentEventType",
    "TimelineCrossReferencedEventType",
    "TimelineCrossReferencedEventPropSourceType",
    "TimelineCommittedEventType",
    "TimelineCommittedEventPropAuthorType",
    "TimelineCommittedEventPropCommitterType",
    "TimelineCommittedEventPropTreeType",
    "TimelineCommittedEventPropParentsItemsType",
    "TimelineCommittedEventPropVerificationType",
    "TimelineReviewedEventType",
    "TimelineReviewedEventPropLinksType",
    "TimelineReviewedEventPropLinksPropHtmlType",
    "TimelineReviewedEventPropLinksPropPullRequestType",
    "PullRequestReviewCommentType",
    "PullRequestReviewCommentPropLinksType",
    "PullRequestReviewCommentPropLinksPropSelfType",
    "PullRequestReviewCommentPropLinksPropHtmlType",
    "PullRequestReviewCommentPropLinksPropPullRequestType",
    "TimelineLineCommentedEventType",
    "TimelineCommitCommentedEventType",
    "TimelineAssignedIssueEventType",
    "TimelineUnassignedIssueEventType",
    "StateChangeIssueEventType",
    "DeployKeyType",
    "LanguageType",
    "LicenseContentType",
    "LicenseContentPropLinksType",
    "MergedUpstreamType",
    "PagesSourceHashType",
    "PagesHttpsCertificateType",
    "PageType",
    "PageBuildType",
    "PageBuildPropErrorType",
    "PageBuildStatusType",
    "PagesHealthCheckType",
    "PagesHealthCheckPropDomainType",
    "PagesHealthCheckPropAltDomainType",
    "PullRequestType",
    "PullRequestPropLabelsItemsType",
    "PullRequestPropHeadType",
    "PullRequestPropHeadPropRepoType",
    "PullRequestPropHeadPropRepoPropOwnerType",
    "PullRequestPropHeadPropRepoPropPermissionsType",
    "PullRequestPropHeadPropRepoPropLicenseType",
    "PullRequestPropHeadPropUserType",
    "PullRequestPropBaseType",
    "PullRequestPropBasePropRepoType",
    "PullRequestPropBasePropRepoPropOwnerType",
    "PullRequestPropBasePropRepoPropPermissionsType",
    "PullRequestPropBasePropUserType",
    "PullRequestPropLinksType",
    "PullRequestMergeResultType",
    "PullRequestReviewRequestType",
    "PullRequestReviewType",
    "PullRequestReviewPropLinksType",
    "PullRequestReviewPropLinksPropHtmlType",
    "PullRequestReviewPropLinksPropPullRequestType",
    "ReviewCommentType",
    "ReviewCommentPropLinksType",
    "ReleaseAssetType",
    "ReleaseType",
    "ReleaseNotesContentType",
    "SecretScanningAlertType",
    "SecretScanningLocationCommitType",
    "SecretScanningLocationType",
    "StargazerType",
    "CommitActivityType",
    "ContributorActivityType",
    "ContributorActivityPropWeeksItemsType",
    "ParticipationStatsType",
    "RepositorySubscriptionType",
    "TagType",
    "TagPropCommitType",
    "TagProtectionType",
    "TopicType",
    "TrafficType",
    "CloneTrafficType",
    "ContentTrafficType",
    "ReferrerTrafficType",
    "ViewTrafficType",
    "ScimGroupListEnterpriseType",
    "ScimGroupListEnterprisePropResourcesItemsType",
    "ScimGroupListEnterprisePropResourcesItemsPropMembersItemsType",
    "ScimGroupListEnterprisePropResourcesItemsPropMetaType",
    "ScimEnterpriseGroupType",
    "ScimEnterpriseGroupPropMembersItemsType",
    "ScimEnterpriseGroupPropMetaType",
    "ScimUserListEnterpriseType",
    "ScimUserListEnterprisePropResourcesItemsType",
    "ScimUserListEnterprisePropResourcesItemsPropNameType",
    "ScimUserListEnterprisePropResourcesItemsPropEmailsItemsType",
    "ScimUserListEnterprisePropResourcesItemsPropGroupsItemsType",
    "ScimUserListEnterprisePropResourcesItemsPropMetaType",
    "ScimEnterpriseUserType",
    "ScimEnterpriseUserPropNameType",
    "ScimEnterpriseUserPropEmailsItemsType",
    "ScimEnterpriseUserPropGroupsItemsType",
    "ScimEnterpriseUserPropMetaType",
    "ScimUserType",
    "ScimUserPropNameType",
    "ScimUserPropEmailsItemsType",
    "ScimUserPropMetaType",
    "ScimUserPropOperationsItemsType",
    "ScimUserPropOperationsItemsPropValueOneof1Type",
    "ScimUserListType",
    "SearchResultTextMatchesItemsType",
    "SearchResultTextMatchesItemsPropMatchesItemsType",
    "CodeSearchResultItemType",
    "CommitSearchResultItemType",
    "CommitSearchResultItemPropCommitType",
    "CommitSearchResultItemPropCommitPropAuthorType",
    "CommitSearchResultItemPropCommitPropTreeType",
    "CommitSearchResultItemPropParentsItemsType",
    "IssueSearchResultItemType",
    "IssueSearchResultItemPropLabelsItemsType",
    "IssueSearchResultItemPropPullRequestType",
    "LabelSearchResultItemType",
    "RepoSearchResultItemType",
    "RepoSearchResultItemPropPermissionsType",
    "TopicSearchResultItemType",
    "TopicSearchResultItemPropRelatedItemsType",
    "TopicSearchResultItemPropRelatedItemsPropTopicRelationType",
    "TopicSearchResultItemPropAliasesItemsType",
    "TopicSearchResultItemPropAliasesItemsPropTopicRelationType",
    "UserSearchResultItemType",
    "PrivateUserType",
    "PrivateUserPropPlanType",
    "CodespacesSecretType",
    "CodespacesUserPublicKeyType",
    "CodespaceExportDetailsType",
    "EmailType",
    "GpgKeyType",
    "GpgKeyPropEmailsItemsType",
    "GpgKeyPropSubkeysItemsType",
    "KeyType",
    "MarketplaceAccountType",
    "UserMarketplacePurchaseType",
    "StarredRepositoryType",
    "HovercardType",
    "HovercardPropContextsItemsType",
    "KeySimpleType",
    "AppManifestsCodeConversionsPostResponse201Type",
    "AppManifestsCodeConversionsPostResponse201Allof1Type",
    "AppHookConfigPatchBodyType",
    "AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type",
    "AppInstallationsInstallationIdAccessTokensPostBodyType",
    "ApplicationsClientIdGrantDeleteBodyType",
    "ApplicationsClientIdTokenPostBodyType",
    "ApplicationsClientIdTokenDeleteBodyType",
    "ApplicationsClientIdTokenPatchBodyType",
    "ApplicationsClientIdTokenScopedPostBodyType",
    "AuthorizationsPostBodyType",
    "AuthorizationsClientsClientIdPutBodyType",
    "AuthorizationsClientsClientIdFingerprintPutBodyType",
    "AuthorizationsAuthorizationIdPatchBodyType",
    "EmojisGetResponse200Type",
    "EnterprisesEnterpriseActionsPermissionsPutBodyType",
    "EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200Type",
    "EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType",
    "EnterprisesEnterpriseActionsRunnerGroupsGetResponse200Type",
    "EnterprisesEnterpriseActionsRunnerGroupsPostBodyType",
    "EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType",
    "EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200Type",
    "EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType",
    "EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type",
    "EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType",
    "EnterprisesEnterpriseActionsRunnersGetResponse200Type",
    "EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type",
    "EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType",
    "EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType",
    "EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type",
    "EnterprisesEnterpriseCodeScanningAlertsGetResponse503Type",
    "GistsPostBodyType",
    "GistsPostBodyPropFilesType",
    "GistsGistIdGetResponse403Type",
    "GistsGistIdGetResponse403PropBlockType",
    "GistsGistIdPatchBodyType",
    "GistsGistIdPatchBodyPropFilesType",
    "GistsGistIdCommentsPostBodyType",
    "GistsGistIdCommentsCommentIdPatchBodyType",
    "GistsGistIdStarGetResponse404Type",
    "InstallationRepositoriesGetResponse200Type",
    "MarkdownPostBodyType",
    "NotificationsPutBodyType",
    "NotificationsPutResponse202Type",
    "NotificationsThreadsThreadIdSubscriptionPutBodyType",
    "OrganizationsOrganizationIdCustomRolesGetResponse200Type",
    "OrgsOrgPatchBodyType",
    "OrgsOrgActionsCacheUsageByRepositoryGetResponse200Type",
    "OrgsOrgActionsPermissionsPutBodyType",
    "OrgsOrgActionsPermissionsRepositoriesGetResponse200Type",
    "OrgsOrgActionsPermissionsRepositoriesPutBodyType",
    "OrgsOrgActionsRunnerGroupsGetResponse200Type",
    "OrgsOrgActionsRunnerGroupsPostBodyType",
    "OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType",
    "OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200Type",
    "OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType",
    "OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type",
    "OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType",
    "OrgsOrgActionsRunnersGetResponse200Type",
    "OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType",
    "OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType",
    "OrgsOrgActionsSecretsGetResponse200Type",
    "OrgsOrgActionsSecretsSecretNamePutBodyType",
    "OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200Type",
    "OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType",
    "OrgsOrgCodespacesGetResponse200Type",
    "OrgsOrgDependabotSecretsGetResponse200Type",
    "OrgsOrgDependabotSecretsSecretNamePutBodyType",
    "OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200Type",
    "OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType",
    "OrgsOrgHooksPostBodyType",
    "OrgsOrgHooksPostBodyPropConfigType",
    "OrgsOrgHooksHookIdPatchBodyType",
    "OrgsOrgHooksHookIdPatchBodyPropConfigType",
    "OrgsOrgHooksHookIdConfigPatchBodyType",
    "OrgsOrgInstallationsGetResponse200Type",
    "OrgsOrgInteractionLimitsGetResponse200Anyof1Type",
    "OrgsOrgInvitationsPostBodyType",
    "OrgsOrgMembershipsUsernamePutBodyType",
    "OrgsOrgMigrationsPostBodyType",
    "OrgsOrgOutsideCollaboratorsUsernamePutBodyType",
    "OrgsOrgOutsideCollaboratorsUsernamePutResponse202Type",
    "OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422Type",
    "OrgsOrgProjectsPostBodyType",
    "OrgsOrgReposPostBodyType",
    "OrgsOrgTeamsPostBodyType",
    "OrgsOrgTeamsTeamSlugPatchBodyType",
    "OrgsOrgTeamsTeamSlugDiscussionsPostBodyType",
    "OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType",
    "OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType",
    "OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType",
    "OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType",
    "OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType",
    "OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType",
    "OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType",
    "OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType",
    "OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403Type",
    "OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType",
    "OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType",
    "OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItemsType",
    "ProjectsColumnsCardsCardIdDeleteResponse403Type",
    "ProjectsColumnsCardsCardIdPatchBodyType",
    "ProjectsColumnsCardsCardIdMovesPostBodyType",
    "ProjectsColumnsCardsCardIdMovesPostResponse201Type",
    "ProjectsColumnsCardsCardIdMovesPostResponse403Type",
    "ProjectsColumnsCardsCardIdMovesPostResponse403PropErrorsItemsType",
    "ProjectsColumnsCardsCardIdMovesPostResponse503Type",
    "ProjectsColumnsCardsCardIdMovesPostResponse503PropErrorsItemsType",
    "ProjectsColumnsColumnIdPatchBodyType",
    "ProjectsColumnsColumnIdCardsPostBodyOneof0Type",
    "ProjectsColumnsColumnIdCardsPostBodyOneof1Type",
    "ProjectsColumnsColumnIdCardsPostResponse503Type",
    "ProjectsColumnsColumnIdCardsPostResponse503PropErrorsItemsType",
    "ProjectsColumnsColumnIdMovesPostBodyType",
    "ProjectsColumnsColumnIdMovesPostResponse201Type",
    "ProjectsProjectIdDeleteResponse403Type",
    "ProjectsProjectIdPatchBodyType",
    "ProjectsProjectIdPatchResponse403Type",
    "ProjectsProjectIdCollaboratorsUsernamePutBodyType",
    "ProjectsProjectIdColumnsPostBodyType",
    "ReposOwnerRepoDeleteResponse403Type",
    "ReposOwnerRepoPatchBodyType",
    "ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType",
    "ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropAdvancedSecurityType",
    "ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanningType",
    "ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanningPushProtectionType",
    "ReposOwnerRepoActionsArtifactsGetResponse200Type",
    "ReposOwnerRepoActionsJobsJobIdRerunPostBodyType",
    "ReposOwnerRepoActionsPermissionsPutBodyType",
    "ReposOwnerRepoActionsRunnersGetResponse200Type",
    "ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType",
    "ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType",
    "ReposOwnerRepoActionsRunsGetResponse200Type",
    "ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200Type",
    "ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200Type",
    "ReposOwnerRepoActionsRunsRunIdCancelPostResponse202Type",
    "ReposOwnerRepoActionsRunsRunIdJobsGetResponse200Type",
    "ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType",
    "ReposOwnerRepoActionsRunsRunIdRerunPostBodyType",
    "ReposOwnerRepoActionsRunsRunIdRerunPostResponse201Type",
    "ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType",
    "ReposOwnerRepoActionsSecretsGetResponse200Type",
    "ReposOwnerRepoActionsSecretsSecretNamePutBodyType",
    "ReposOwnerRepoActionsSecretsSecretNamePutResponse201Type",
    "ReposOwnerRepoActionsWorkflowsGetResponse200Type",
    "ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType",
    "ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType",
    "ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200Type",
    "ReposOwnerRepoAutolinksPostBodyType",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyType",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksPropChecksItemsType",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropDismissalRestrictionsType",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropBypassPullRequestAllowancesType",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType",
    "ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType",
    "ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType",
    "ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType",
    "ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType",
    "ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType",
    "ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type",
    "ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type",
    "ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type",
    "ReposOwnerRepoBranchesBranchRenamePostBodyType",
    "ReposOwnerRepoCheckRunsCheckRunIdRerequestPostResponse201Type",
    "ReposOwnerRepoCheckSuitesPostBodyType",
    "ReposOwnerRepoCheckSuitesPreferencesPatchBodyType",
    "ReposOwnerRepoCheckSuitesPreferencesPatchBodyPropAutoTriggerChecksItemsType",
    "ReposOwnerRepoCheckSuitesCheckSuiteIdCheckRunsGetResponse200Type",
    "ReposOwnerRepoCheckSuitesCheckSuiteIdRerequestPostResponse201Type",
    "ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBodyType",
    "ReposOwnerRepoCodeScanningSarifsPostBodyType",
    "ReposOwnerRepoCodespacesGetResponse200Type",
    "ReposOwnerRepoCodespacesPostBodyType",
    "ReposOwnerRepoCodespacesDevcontainersGetResponse200Type",
    "ReposOwnerRepoCodespacesDevcontainersGetResponse200PropDevcontainersItemsType",
    "ReposOwnerRepoCodespacesMachinesGetResponse200Type",
    "ReposOwnerRepoCodespacesNewGetResponse200Type",
    "ReposOwnerRepoCodespacesNewGetResponse200PropDefaultsType",
    "ReposOwnerRepoCodespacesSecretsGetResponse200Type",
    "ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType",
    "ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201Type",
    "ReposOwnerRepoCollaboratorsUsernamePutBodyType",
    "ReposOwnerRepoCommentsCommentIdPatchBodyType",
    "ReposOwnerRepoCommentsCommentIdReactionsPostBodyType",
    "ReposOwnerRepoCommitsCommitShaCommentsPostBodyType",
    "ReposOwnerRepoCommitsRefCheckRunsGetResponse200Type",
    "ReposOwnerRepoCommitsRefCheckSuitesGetResponse200Type",
    "ReposOwnerRepoContentsPathPutBodyType",
    "ReposOwnerRepoContentsPathPutBodyPropCommitterType",
    "ReposOwnerRepoContentsPathPutBodyPropAuthorType",
    "ReposOwnerRepoContentsPathDeleteBodyType",
    "ReposOwnerRepoContentsPathDeleteBodyPropCommitterType",
    "ReposOwnerRepoContentsPathDeleteBodyPropAuthorType",
    "ReposOwnerRepoDependabotSecretsGetResponse200Type",
    "ReposOwnerRepoDependabotSecretsSecretNamePutBodyType",
    "ReposOwnerRepoDependencyGraphSnapshotsPostResponse201Type",
    "ReposOwnerRepoDeploymentsPostBodyType",
    "ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type",
    "ReposOwnerRepoDeploymentsPostResponse202Type",
    "ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType",
    "ReposOwnerRepoDispatchesPostBodyType",
    "ReposOwnerRepoDispatchesPostBodyPropClientPayloadType",
    "ReposOwnerRepoEnvironmentsGetResponse200Type",
    "ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType",
    "ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType",
    "ReposOwnerRepoForksPostBodyType",
    "ReposOwnerRepoGitBlobsPostBodyType",
    "ReposOwnerRepoGitCommitsPostBodyType",
    "ReposOwnerRepoGitCommitsPostBodyPropAuthorType",
    "ReposOwnerRepoGitCommitsPostBodyPropCommitterType",
    "ReposOwnerRepoGitRefsPostBodyType",
    "ReposOwnerRepoGitRefsRefPatchBodyType",
    "ReposOwnerRepoGitTagsPostBodyType",
    "ReposOwnerRepoGitTagsPostBodyPropTaggerType",
    "ReposOwnerRepoGitTreesPostBodyType",
    "ReposOwnerRepoGitTreesPostBodyPropTreeItemsType",
    "ReposOwnerRepoHooksPostBodyType",
    "ReposOwnerRepoHooksPostBodyPropConfigType",
    "ReposOwnerRepoHooksHookIdPatchBodyType",
    "ReposOwnerRepoHooksHookIdPatchBodyPropConfigType",
    "ReposOwnerRepoHooksHookIdConfigPatchBodyType",
    "ReposOwnerRepoImportPutBodyType",
    "ReposOwnerRepoImportPatchBodyType",
    "ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType",
    "ReposOwnerRepoImportLfsPatchBodyType",
    "ReposOwnerRepoInteractionLimitsGetResponse200Anyof1Type",
    "ReposOwnerRepoInvitationsInvitationIdPatchBodyType",
    "ReposOwnerRepoIssuesPostBodyType",
    "ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1Type",
    "ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType",
    "ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType",
    "ReposOwnerRepoIssuesIssueNumberPatchBodyType",
    "ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1Type",
    "ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType",
    "ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType",
    "ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType",
    "ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type",
    "ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type",
    "ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItemsType",
    "ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType",
    "ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type",
    "ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type",
    "ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItemsType",
    "ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType",
    "ReposOwnerRepoIssuesIssueNumberLockPutBodyType",
    "ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType",
    "ReposOwnerRepoKeysPostBodyType",
    "ReposOwnerRepoLabelsPostBodyType",
    "ReposOwnerRepoLabelsNamePatchBodyType",
    "ReposOwnerRepoMergeUpstreamPostBodyType",
    "ReposOwnerRepoMergesPostBodyType",
    "ReposOwnerRepoMilestonesPostBodyType",
    "ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType",
    "ReposOwnerRepoNotificationsPutBodyType",
    "ReposOwnerRepoNotificationsPutResponse202Type",
    "ReposOwnerRepoPagesPostBodyType",
    "ReposOwnerRepoPagesPostBodyPropSourceType",
    "ReposOwnerRepoProjectsPostBodyType",
    "ReposOwnerRepoPullsPostBodyType",
    "ReposOwnerRepoPullsCommentsCommentIdPatchBodyType",
    "ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType",
    "ReposOwnerRepoPullsPullNumberPatchBodyType",
    "ReposOwnerRepoPullsPullNumberCodespacesPostBodyType",
    "ReposOwnerRepoPullsPullNumberCommentsPostBodyType",
    "ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType",
    "ReposOwnerRepoPullsPullNumberMergePutBodyType",
    "ReposOwnerRepoPullsPullNumberMergePutResponse405Type",
    "ReposOwnerRepoPullsPullNumberMergePutResponse409Type",
    "ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType",
    "ReposOwnerRepoPullsPullNumberReviewsPostBodyType",
    "ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType",
    "ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType",
    "ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType",
    "ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType",
    "ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType",
    "ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type",
    "ReposOwnerRepoReleasesPostBodyType",
    "ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType",
    "ReposOwnerRepoReleasesGenerateNotesPostBodyType",
    "ReposOwnerRepoReleasesReleaseIdPatchBodyType",
    "ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType",
    "ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyType",
    "ReposOwnerRepoStatusesShaPostBodyType",
    "ReposOwnerRepoSubscriptionPutBodyType",
    "ReposOwnerRepoTagsProtectionPostBodyType",
    "ReposOwnerRepoTopicsPutBodyType",
    "ReposOwnerRepoTransferPostBodyType",
    "ReposTemplateOwnerTemplateRepoGeneratePostBodyType",
    "RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200Type",
    "RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType",
    "ScimV2EnterprisesEnterpriseGroupsPostBodyType",
    "ScimV2EnterprisesEnterpriseGroupsPostBodyPropMembersItemsType",
    "ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyType",
    "ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyPropMembersItemsType",
    "ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyType",
    "ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyPropOperationsItemsType",
    "ScimV2EnterprisesEnterpriseUsersPostBodyType",
    "ScimV2EnterprisesEnterpriseUsersPostBodyPropNameType",
    "ScimV2EnterprisesEnterpriseUsersPostBodyPropEmailsItemsType",
    "ScimV2EnterprisesEnterpriseUsersPostBodyPropGroupsItemsType",
    "ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyType",
    "ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropNameType",
    "ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropEmailsItemsType",
    "ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropGroupsItemsType",
    "ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyType",
    "ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyPropOperationsItemsType",
    "ScimV2OrganizationsOrgUsersPostBodyType",
    "ScimV2OrganizationsOrgUsersPostBodyPropNameType",
    "ScimV2OrganizationsOrgUsersPostBodyPropEmailsItemsType",
    "ScimV2OrganizationsOrgUsersScimUserIdPutBodyType",
    "ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropNameType",
    "ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropEmailsItemsType",
    "ScimV2OrganizationsOrgUsersScimUserIdPatchBodyType",
    "ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsType",
    "ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsPropValueOneof0Type",
    "ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsPropValueOneof1ItemsType",
    "SearchCodeGetResponse200Type",
    "SearchCommitsGetResponse200Type",
    "SearchIssuesGetResponse200Type",
    "SearchLabelsGetResponse200Type",
    "SearchRepositoriesGetResponse200Type",
    "SearchTopicsGetResponse200Type",
    "SearchUsersGetResponse200Type",
    "TeamsTeamIdPatchBodyType",
    "TeamsTeamIdDiscussionsPostBodyType",
    "TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType",
    "TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType",
    "TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType",
    "TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType",
    "TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType",
    "TeamsTeamIdMembershipsUsernamePutBodyType",
    "TeamsTeamIdProjectsProjectIdPutBodyType",
    "TeamsTeamIdProjectsProjectIdPutResponse403Type",
    "TeamsTeamIdReposOwnerRepoPutBodyType",
    "TeamsTeamIdTeamSyncGroupMappingsPatchBodyType",
    "TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItemsType",
    "UserPatchBodyType",
    "UserCodespacesGetResponse200Type",
    "UserCodespacesPostBodyOneof0Type",
    "UserCodespacesPostBodyOneof1Type",
    "UserCodespacesPostBodyOneof1PropPullRequestType",
    "UserCodespacesSecretsGetResponse200Type",
    "UserCodespacesSecretsSecretNamePutBodyType",
    "UserCodespacesSecretsSecretNamePutResponse201Type",
    "UserCodespacesSecretsSecretNameRepositoriesGetResponse200Type",
    "UserCodespacesSecretsSecretNameRepositoriesPutBodyType",
    "UserCodespacesCodespaceNamePatchBodyType",
    "UserCodespacesCodespaceNameMachinesGetResponse200Type",
    "UserEmailVisibilityPatchBodyType",
    "UserEmailsPostBodyOneof0Type",
    "UserEmailsDeleteBodyOneof0Type",
    "UserGpgKeysPostBodyType",
    "UserInstallationsGetResponse200Type",
    "UserInstallationsInstallationIdRepositoriesGetResponse200Type",
    "UserInteractionLimitsGetResponse200Anyof1Type",
    "UserKeysPostBodyType",
    "UserMembershipsOrgsOrgPatchBodyType",
    "UserMigrationsPostBodyType",
    "UserProjectsPostBodyType",
    "UserReposPostBodyType",
]
