"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union, Literal

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    OrgsOrgTeamsPostBodyType,
    TeamsTeamIdPatchBodyType,
    OrgsOrgTeamsTeamSlugPatchBodyType,
    TeamsTeamIdDiscussionsPostBodyType,
    TeamsTeamIdReposOwnerRepoPutBodyType,
    TeamsTeamIdProjectsProjectIdPutBodyType,
    TeamsTeamIdMembershipsUsernamePutBodyType,
    OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
    OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType,
    TeamsTeamIdTeamSyncGroupMappingsPatchBodyType,
    OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType,
    OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType,
    OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType,
    TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType,
    OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType,
    TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType,
    TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItemsType,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
    OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItemsType,
    TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
)
from .models import (
    Team,
    TeamFull,
    BasicError,
    SimpleUser,
    TeamProject,
    GroupMapping,
    ExternalGroup,
    ExternalGroups,
    TeamDiscussion,
    TeamMembership,
    TeamRepository,
    ValidationError,
    MinimalRepository,
    OrgsOrgTeamsPostBody,
    TeamsTeamIdPatchBody,
    TeamDiscussionComment,
    OrganizationInvitation,
    OrgsOrgTeamsTeamSlugPatchBody,
    TeamsTeamIdDiscussionsPostBody,
    TeamsTeamIdReposOwnerRepoPutBody,
    TeamsTeamIdProjectsProjectIdPutBody,
    TeamsTeamIdMembershipsUsernamePutBody,
    OrgsOrgTeamsTeamSlugDiscussionsPostBody,
    OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody,
    TeamsTeamIdTeamSyncGroupMappingsPatchBody,
    TeamsTeamIdProjectsProjectIdPutResponse403,
    OrgsOrgTeamsTeamSlugExternalGroupsPatchBody,
    OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody,
    OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody,
    TeamsTeamIdDiscussionsDiscussionNumberPatchBody,
    OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBody,
    OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
    TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody,
    TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
    OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class TeamsClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def external_idp_group_info_for_org(
        self,
        org: str,
        group_id: int,
    ) -> "Response[ExternalGroup]":
        url = f"/orgs/{org}/external-group/{group_id}"

        return self._github.request(
            "GET",
            url,
            response_model=ExternalGroup,
        )

    async def async_external_idp_group_info_for_org(
        self,
        org: str,
        group_id: int,
    ) -> "Response[ExternalGroup]":
        url = f"/orgs/{org}/external-group/{group_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ExternalGroup,
        )

    def list_external_idp_groups_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = UNSET,
        display_name: Union[Unset, str] = UNSET,
    ) -> "Response[ExternalGroups]":
        url = f"/orgs/{org}/external-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "display_name": display_name,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ExternalGroups,
        )

    async def async_list_external_idp_groups_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = UNSET,
        display_name: Union[Unset, str] = UNSET,
    ) -> "Response[ExternalGroups]":
        url = f"/orgs/{org}/external-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "display_name": display_name,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ExternalGroups,
        )

    def list_idp_groups_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, str] = UNSET,
    ) -> "Response[GroupMapping]":
        url = f"/orgs/{org}/team-sync/groups"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=GroupMapping,
        )

    async def async_list_idp_groups_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, str] = UNSET,
    ) -> "Response[GroupMapping]":
        url = f"/orgs/{org}/team-sync/groups"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=GroupMapping,
        )

    def list(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/orgs/{org}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Team],
            error_models={
                "403": BasicError,
            },
        )

    async def async_list(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/orgs/{org}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Team],
            error_models={
                "403": BasicError,
            },
        )

    def create(
        self,
        org: str,
        *,
        name: str,
        description: Union[Unset, str] = UNSET,
        maintainers: Union[Unset, List[str]] = UNSET,
        repo_names: Union[Unset, List[str]] = UNSET,
        privacy: Union[Unset, Literal["secret", "closed"]] = UNSET,
        permission: Union[Unset, Literal["pull", "push"]] = "pull",
        parent_team_id: Union[Unset, int] = UNSET,
    ) -> "Response[TeamFull]":
        url = f"/orgs/{org}/teams"

        json = OrgsOrgTeamsPostBody(
            **{
                "name": name,
                "description": description,
                "maintainers": maintainers,
                "repo_names": repo_names,
                "privacy": privacy,
                "permission": permission,
                "parent_team_id": parent_team_id,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TeamFull,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_create(
        self,
        org: str,
        *,
        name: str,
        description: Union[Unset, str] = UNSET,
        maintainers: Union[Unset, List[str]] = UNSET,
        repo_names: Union[Unset, List[str]] = UNSET,
        privacy: Union[Unset, Literal["secret", "closed"]] = UNSET,
        permission: Union[Unset, Literal["pull", "push"]] = "pull",
        parent_team_id: Union[Unset, int] = UNSET,
    ) -> "Response[TeamFull]":
        url = f"/orgs/{org}/teams"

        json = OrgsOrgTeamsPostBody(
            **{
                "name": name,
                "description": description,
                "maintainers": maintainers,
                "repo_names": repo_names,
                "privacy": privacy,
                "permission": permission,
                "parent_team_id": parent_team_id,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TeamFull,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_by_name(
        self,
        org: str,
        team_slug: str,
    ) -> "Response[TeamFull]":
        url = f"/orgs/{org}/teams/{team_slug}"

        return self._github.request(
            "GET",
            url,
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_by_name(
        self,
        org: str,
        team_slug: str,
    ) -> "Response[TeamFull]":
        url = f"/orgs/{org}/teams/{team_slug}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete_in_org(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_in_org(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        name: Union[Unset, str] = UNSET,
        description: Union[Unset, str] = UNSET,
        privacy: Union[Unset, Literal["secret", "closed"]] = UNSET,
        permission: Union[Unset, Literal["pull", "push", "admin"]] = "pull",
        parent_team_id: Union[Unset, Union[int, None]] = UNSET,
    ) -> "Response[TeamFull]":
        url = f"/orgs/{org}/teams/{team_slug}"

        json = OrgsOrgTeamsTeamSlugPatchBody(
            **{
                "name": name,
                "description": description,
                "privacy": privacy,
                "permission": permission,
                "parent_team_id": parent_team_id,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=TeamFull,
        )

    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        name: Union[Unset, str] = UNSET,
        description: Union[Unset, str] = UNSET,
        privacy: Union[Unset, Literal["secret", "closed"]] = UNSET,
        permission: Union[Unset, Literal["pull", "push", "admin"]] = "pull",
        parent_team_id: Union[Unset, Union[int, None]] = UNSET,
    ) -> "Response[TeamFull]":
        url = f"/orgs/{org}/teams/{team_slug}"

        json = OrgsOrgTeamsTeamSlugPatchBody(
            **{
                "name": name,
                "description": description,
                "privacy": privacy,
                "permission": permission,
                "parent_team_id": parent_team_id,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=TeamFull,
        )

    def list_discussions_in_org(
        self,
        org: str,
        team_slug: str,
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        pinned: Union[Unset, str] = UNSET,
    ) -> "Response[List[TeamDiscussion]]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "pinned": pinned,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamDiscussion],
        )

    async def async_list_discussions_in_org(
        self,
        org: str,
        team_slug: str,
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        pinned: Union[Unset, str] = UNSET,
    ) -> "Response[List[TeamDiscussion]]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "pinned": pinned,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamDiscussion],
        )

    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        title: str,
        body: str,
        private: Union[Unset, bool] = False,
    ) -> "Response[TeamDiscussion]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        json = OrgsOrgTeamsTeamSlugDiscussionsPostBody(
            **{
                "title": title,
                "body": body,
                "private": private,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussion,
        )

    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        title: str,
        body: str,
        private: Union[Unset, bool] = False,
    ) -> "Response[TeamDiscussion]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        json = OrgsOrgTeamsTeamSlugDiscussionsPostBody(
            **{
                "title": title,
                "body": body,
                "private": private,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussion,
        )

    def get_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
    ) -> "Response[TeamDiscussion]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        return self._github.request(
            "GET",
            url,
            response_model=TeamDiscussion,
        )

    async def async_get_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
    ) -> "Response[TeamDiscussion]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=TeamDiscussion,
        )

    def delete_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        title: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
    ) -> "Response[TeamDiscussion]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        json = OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody(
            **{
                "title": title,
                "body": body,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussion,
        )

    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        title: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
    ) -> "Response[TeamDiscussion]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        json = OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody(
            **{
                "title": title,
                "body": body,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussion,
        )

    def list_discussion_comments_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[TeamDiscussionComment]]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamDiscussionComment],
        )

    async def async_list_discussion_comments_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[TeamDiscussionComment]]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamDiscussionComment],
        )

    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        json = OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussionComment,
        )

    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        json = OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussionComment,
        )

    def get_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        return self._github.request(
            "GET",
            url,
            response_model=TeamDiscussionComment,
        )

    async def async_get_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=TeamDiscussionComment,
        )

    def delete_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        json = OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody(
            **{
                "body": body,
            }
        ).dict(
            by_alias=True
        )

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussionComment,
        )

    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        json = OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody(
            **{
                "body": body,
            }
        ).dict(
            by_alias=True
        )

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussionComment,
        )

    def list_linked_external_idp_groups_to_team_for_org(
        self,
        org: str,
        team_slug: str,
    ) -> "Response[ExternalGroups]":
        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        return self._github.request(
            "GET",
            url,
            response_model=ExternalGroups,
        )

    async def async_list_linked_external_idp_groups_to_team_for_org(
        self,
        org: str,
        team_slug: str,
    ) -> "Response[ExternalGroups]":
        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ExternalGroups,
        )

    def unlink_external_idp_group_from_team_for_org(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_unlink_external_idp_group_from_team_for_org(
        self,
        org: str,
        team_slug: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        group_id: int,
    ) -> "Response[ExternalGroup]":
        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        json = OrgsOrgTeamsTeamSlugExternalGroupsPatchBody(
            **{
                "group_id": group_id,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ExternalGroup,
        )

    async def async_link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        group_id: int,
    ) -> "Response[ExternalGroup]":
        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        json = OrgsOrgTeamsTeamSlugExternalGroupsPatchBody(
            **{
                "group_id": group_id,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ExternalGroup,
        )

    def list_pending_invitations_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/orgs/{org}/teams/{team_slug}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationInvitation],
        )

    async def async_list_pending_invitations_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/orgs/{org}/teams/{team_slug}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationInvitation],
        )

    def list_members_in_org(
        self,
        org: str,
        team_slug: str,
        role: Union[Unset, Literal["member", "maintainer", "all"]] = "all",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/teams/{team_slug}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    async def async_list_members_in_org(
        self,
        org: str,
        team_slug: str,
        role: Union[Unset, Literal["member", "maintainer", "all"]] = "all",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/orgs/{org}/teams/{team_slug}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    def get_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
    ) -> "Response[TeamMembership]":
        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        return self._github.request(
            "GET",
            url,
            response_model=TeamMembership,
            error_models={},
        )

    async def async_get_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
    ) -> "Response[TeamMembership]":
        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=TeamMembership,
            error_models={},
        )

    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        role: Union[Unset, Literal["member", "maintainer"]] = "member",
    ) -> "Response[TeamMembership]":
        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        json = OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody(
            **{
                "role": role,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=TeamMembership,
            error_models={},
        )

    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        role: Union[Unset, Literal["member", "maintainer"]] = "member",
    ) -> "Response[TeamMembership]":
        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        json = OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody(
            **{
                "role": role,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=TeamMembership,
            error_models={},
        )

    def remove_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        return self._github.request(
            "DELETE",
            url,
            error_models={},
        )

    async def async_remove_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={},
        )

    def list_projects_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[TeamProject]]":
        url = f"/orgs/{org}/teams/{team_slug}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamProject],
        )

    async def async_list_projects_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[TeamProject]]":
        url = f"/orgs/{org}/teams/{team_slug}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamProject],
        )

    def check_permissions_for_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
    ) -> "Response[TeamProject]":
        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        return self._github.request(
            "GET",
            url,
            response_model=TeamProject,
            error_models={},
        )

    async def async_check_permissions_for_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
    ) -> "Response[TeamProject]":
        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=TeamProject,
            error_models={},
        )

    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        body: Union[
            Unset, Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        json = body

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "403": OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
            },
        )

    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        body: Union[
            Unset, Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        json = body

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "403": OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
            },
        )

    def remove_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_repos_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/teams/{team_slug}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
        )

    async def async_list_repos_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/teams/{team_slug}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
        )

    def check_permissions_for_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
    ) -> "Response[TeamRepository]":
        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        return self._github.request(
            "GET",
            url,
            response_model=TeamRepository,
            error_models={},
        )

    async def async_check_permissions_for_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
    ) -> "Response[TeamRepository]":
        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=TeamRepository,
            error_models={},
        )

    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        permission: Union[
            Unset, Literal["pull", "push", "admin", "maintain", "triage"]
        ] = "push",
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        json = OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody(
            **{
                "permission": permission,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        permission: Union[
            Unset, Literal["pull", "push", "admin", "maintain", "triage"]
        ] = "push",
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        json = OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody(
            **{
                "permission": permission,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def remove_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_idp_groups_in_org(
        self,
        org: str,
        team_slug: str,
    ) -> "Response[GroupMapping]":
        url = f"/orgs/{org}/teams/{team_slug}/team-sync/group-mappings"

        return self._github.request(
            "GET",
            url,
            response_model=GroupMapping,
        )

    async def async_list_idp_groups_in_org(
        self,
        org: str,
        team_slug: str,
    ) -> "Response[GroupMapping]":
        url = f"/orgs/{org}/teams/{team_slug}/team-sync/group-mappings"

        return await self._github.arequest(
            "GET",
            url,
            response_model=GroupMapping,
        )

    def create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        groups: Union[
            Unset,
            List[OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItemsType],
        ] = UNSET,
    ) -> "Response[GroupMapping]":
        url = f"/orgs/{org}/teams/{team_slug}/team-sync/group-mappings"

        json = OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBody(
            **{
                "groups": groups,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=GroupMapping,
        )

    async def async_create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        groups: Union[
            Unset,
            List[OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItemsType],
        ] = UNSET,
    ) -> "Response[GroupMapping]":
        url = f"/orgs/{org}/teams/{team_slug}/team-sync/group-mappings"

        json = OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBody(
            **{
                "groups": groups,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=GroupMapping,
        )

    def list_child_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/orgs/{org}/teams/{team_slug}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Team],
        )

    async def async_list_child_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/orgs/{org}/teams/{team_slug}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Team],
        )

    def get_legacy(
        self,
        team_id: int,
    ) -> "Response[TeamFull]":
        url = f"/teams/{team_id}"

        return self._github.request(
            "GET",
            url,
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_legacy(
        self,
        team_id: int,
    ) -> "Response[TeamFull]":
        url = f"/teams/{team_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete_legacy(
        self,
        team_id: int,
    ) -> "Response":
        url = f"/teams/{team_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_delete_legacy(
        self,
        team_id: int,
    ) -> "Response":
        url = f"/teams/{team_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def update_legacy(
        self,
        team_id: int,
        *,
        name: str,
        description: Union[Unset, str] = UNSET,
        privacy: Union[Unset, Literal["secret", "closed"]] = UNSET,
        permission: Union[Unset, Literal["pull", "push", "admin"]] = "pull",
        parent_team_id: Union[Unset, Union[int, None]] = UNSET,
    ) -> "Response[TeamFull]":
        url = f"/teams/{team_id}"

        json = TeamsTeamIdPatchBody(
            **{
                "name": name,
                "description": description,
                "privacy": privacy,
                "permission": permission,
                "parent_team_id": parent_team_id,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_update_legacy(
        self,
        team_id: int,
        *,
        name: str,
        description: Union[Unset, str] = UNSET,
        privacy: Union[Unset, Literal["secret", "closed"]] = UNSET,
        permission: Union[Unset, Literal["pull", "push", "admin"]] = "pull",
        parent_team_id: Union[Unset, Union[int, None]] = UNSET,
    ) -> "Response[TeamFull]":
        url = f"/teams/{team_id}"

        json = TeamsTeamIdPatchBody(
            **{
                "name": name,
                "description": description,
                "privacy": privacy,
                "permission": permission,
                "parent_team_id": parent_team_id,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_discussions_legacy(
        self,
        team_id: int,
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[TeamDiscussion]]":
        url = f"/teams/{team_id}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamDiscussion],
        )

    async def async_list_discussions_legacy(
        self,
        team_id: int,
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[TeamDiscussion]]":
        url = f"/teams/{team_id}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamDiscussion],
        )

    def create_discussion_legacy(
        self,
        team_id: int,
        *,
        title: str,
        body: str,
        private: Union[Unset, bool] = False,
    ) -> "Response[TeamDiscussion]":
        url = f"/teams/{team_id}/discussions"

        json = TeamsTeamIdDiscussionsPostBody(
            **{
                "title": title,
                "body": body,
                "private": private,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussion,
        )

    async def async_create_discussion_legacy(
        self,
        team_id: int,
        *,
        title: str,
        body: str,
        private: Union[Unset, bool] = False,
    ) -> "Response[TeamDiscussion]":
        url = f"/teams/{team_id}/discussions"

        json = TeamsTeamIdDiscussionsPostBody(
            **{
                "title": title,
                "body": body,
                "private": private,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussion,
        )

    def get_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
    ) -> "Response[TeamDiscussion]":
        url = f"/teams/{team_id}/discussions/{discussion_number}"

        return self._github.request(
            "GET",
            url,
            response_model=TeamDiscussion,
        )

    async def async_get_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
    ) -> "Response[TeamDiscussion]":
        url = f"/teams/{team_id}/discussions/{discussion_number}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=TeamDiscussion,
        )

    def delete_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
    ) -> "Response":
        url = f"/teams/{team_id}/discussions/{discussion_number}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
    ) -> "Response":
        url = f"/teams/{team_id}/discussions/{discussion_number}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        title: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
    ) -> "Response[TeamDiscussion]":
        url = f"/teams/{team_id}/discussions/{discussion_number}"

        json = TeamsTeamIdDiscussionsDiscussionNumberPatchBody(
            **{
                "title": title,
                "body": body,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussion,
        )

    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        title: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
    ) -> "Response[TeamDiscussion]":
        url = f"/teams/{team_id}/discussions/{discussion_number}"

        json = TeamsTeamIdDiscussionsDiscussionNumberPatchBody(
            **{
                "title": title,
                "body": body,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussion,
        )

    def list_discussion_comments_legacy(
        self,
        team_id: int,
        discussion_number: int,
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[TeamDiscussionComment]]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamDiscussionComment],
        )

    async def async_list_discussion_comments_legacy(
        self,
        team_id: int,
        discussion_number: int,
        direction: Union[Unset, Literal["asc", "desc"]] = "desc",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[TeamDiscussionComment]]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamDiscussionComment],
        )

    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        json = TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussionComment,
        )

    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        json = TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussionComment,
        )

    def get_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        return self._github.request(
            "GET",
            url,
            response_model=TeamDiscussionComment,
        )

    async def async_get_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=TeamDiscussionComment,
        )

    def delete_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
    ) -> "Response":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
    ) -> "Response":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        json = TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussionComment,
        )

    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        body: str,
    ) -> "Response[TeamDiscussionComment]":
        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        json = TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=TeamDiscussionComment,
        )

    def list_pending_invitations_legacy(
        self,
        team_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/teams/{team_id}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationInvitation],
        )

    async def async_list_pending_invitations_legacy(
        self,
        team_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[OrganizationInvitation]]":
        url = f"/teams/{team_id}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[OrganizationInvitation],
        )

    def list_members_legacy(
        self,
        team_id: int,
        role: Union[Unset, Literal["member", "maintainer", "all"]] = "all",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/teams/{team_id}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_members_legacy(
        self,
        team_id: int,
        role: Union[Unset, Literal["member", "maintainer", "all"]] = "all",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/teams/{team_id}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    def get_member_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/members/{username}"

        return self._github.request(
            "GET",
            url,
            error_models={},
        )

    async def async_get_member_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/members/{username}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={},
        )

    def add_member_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/members/{username}"

        return self._github.request(
            "PUT",
            url,
            error_models={
                "403": BasicError,
            },
        )

    async def async_add_member_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/members/{username}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={
                "403": BasicError,
            },
        )

    def remove_member_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/members/{username}"

        return self._github.request(
            "DELETE",
            url,
            error_models={},
        )

    async def async_remove_member_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/members/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={},
        )

    def get_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response[TeamMembership]":
        url = f"/teams/{team_id}/memberships/{username}"

        return self._github.request(
            "GET",
            url,
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response[TeamMembership]":
        url = f"/teams/{team_id}/memberships/{username}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        role: Union[Unset, Literal["member", "maintainer"]] = "member",
    ) -> "Response[TeamMembership]":
        url = f"/teams/{team_id}/memberships/{username}"

        json = TeamsTeamIdMembershipsUsernamePutBody(
            **{
                "role": role,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        role: Union[Unset, Literal["member", "maintainer"]] = "member",
    ) -> "Response[TeamMembership]":
        url = f"/teams/{team_id}/memberships/{username}"

        json = TeamsTeamIdMembershipsUsernamePutBody(
            **{
                "role": role,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    def remove_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/memberships/{username}"

        return self._github.request(
            "DELETE",
            url,
            error_models={},
        )

    async def async_remove_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
    ) -> "Response":
        url = f"/teams/{team_id}/memberships/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={},
        )

    def list_projects_legacy(
        self,
        team_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[TeamProject]]":
        url = f"/teams/{team_id}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamProject],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_projects_legacy(
        self,
        team_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[TeamProject]]":
        url = f"/teams/{team_id}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamProject],
            error_models={
                "404": BasicError,
            },
        )

    def check_permissions_for_project_legacy(
        self,
        team_id: int,
        project_id: int,
    ) -> "Response[TeamProject]":
        url = f"/teams/{team_id}/projects/{project_id}"

        return self._github.request(
            "GET",
            url,
            response_model=TeamProject,
            error_models={},
        )

    async def async_check_permissions_for_project_legacy(
        self,
        team_id: int,
        project_id: int,
    ) -> "Response[TeamProject]":
        url = f"/teams/{team_id}/projects/{project_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=TeamProject,
            error_models={},
        )

    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        permission: Union[Unset, Literal["read", "write", "admin"]] = UNSET,
    ) -> "Response":
        url = f"/teams/{team_id}/projects/{project_id}"

        json = TeamsTeamIdProjectsProjectIdPutBody(
            **{
                "permission": permission,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "403": TeamsTeamIdProjectsProjectIdPutResponse403,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        permission: Union[Unset, Literal["read", "write", "admin"]] = UNSET,
    ) -> "Response":
        url = f"/teams/{team_id}/projects/{project_id}"

        json = TeamsTeamIdProjectsProjectIdPutBody(
            **{
                "permission": permission,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "403": TeamsTeamIdProjectsProjectIdPutResponse403,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def remove_project_legacy(
        self,
        team_id: int,
        project_id: int,
    ) -> "Response":
        url = f"/teams/{team_id}/projects/{project_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_remove_project_legacy(
        self,
        team_id: int,
        project_id: int,
    ) -> "Response":
        url = f"/teams/{team_id}/projects/{project_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_repos_legacy(
        self,
        team_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/teams/{team_id}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_legacy(
        self,
        team_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/teams/{team_id}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    def check_permissions_for_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
    ) -> "Response[TeamRepository]":
        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        return self._github.request(
            "GET",
            url,
            response_model=TeamRepository,
            error_models={},
        )

    async def async_check_permissions_for_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
    ) -> "Response[TeamRepository]":
        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=TeamRepository,
            error_models={},
        )

    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        permission: Union[Unset, Literal["pull", "push", "admin"]] = UNSET,
    ) -> "Response":
        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        json = TeamsTeamIdReposOwnerRepoPutBody(
            **{
                "permission": permission,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        permission: Union[Unset, Literal["pull", "push", "admin"]] = UNSET,
    ) -> "Response":
        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        json = TeamsTeamIdReposOwnerRepoPutBody(
            **{
                "permission": permission,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def remove_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_idp_groups_for_legacy(
        self,
        team_id: int,
    ) -> "Response[GroupMapping]":
        url = f"/teams/{team_id}/team-sync/group-mappings"

        return self._github.request(
            "GET",
            url,
            response_model=GroupMapping,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_idp_groups_for_legacy(
        self,
        team_id: int,
    ) -> "Response[GroupMapping]":
        url = f"/teams/{team_id}/team-sync/group-mappings"

        return await self._github.arequest(
            "GET",
            url,
            response_model=GroupMapping,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        groups: List[TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItemsType],
        synced_at: Union[Unset, str] = UNSET,
    ) -> "Response[GroupMapping]":
        url = f"/teams/{team_id}/team-sync/group-mappings"

        json = TeamsTeamIdTeamSyncGroupMappingsPatchBody(
            **{
                "groups": groups,
                "synced_at": synced_at,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=GroupMapping,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        groups: List[TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItemsType],
        synced_at: Union[Unset, str] = UNSET,
    ) -> "Response[GroupMapping]":
        url = f"/teams/{team_id}/team-sync/group-mappings"

        json = TeamsTeamIdTeamSyncGroupMappingsPatchBody(
            **{
                "groups": groups,
                "synced_at": synced_at,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=GroupMapping,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_child_legacy(
        self,
        team_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/teams/{team_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Team],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_child_legacy(
        self,
        team_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/teams/{team_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Team],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[TeamFull]]":
        url = "/user/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamFull],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[TeamFull]]":
        url = "/user/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[TeamFull],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )
