"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, Any, List, Union, Literal

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    UserReposPostBodyType,
    OrgsOrgReposPostBodyType,
    ReposOwnerRepoPatchBodyType,
    ReposOwnerRepoKeysPostBodyType,
    ReposOwnerRepoForksPostBodyType,
    ReposOwnerRepoHooksPostBodyType,
    ReposOwnerRepoPagesPostBodyType,
    ReposOwnerRepoTopicsPutBodyType,
    ReposOwnerRepoMergesPostBodyType,
    ReposOwnerRepoReleasesPostBodyType,
    ReposOwnerRepoTransferPostBodyType,
    ReposOwnerRepoAutolinksPostBodyType,
    ReposOwnerRepoDispatchesPostBodyType,
    ReposOwnerRepoContentsPathPutBodyType,
    ReposOwnerRepoDeploymentsPostBodyType,
    ReposOwnerRepoStatusesShaPostBodyType,
    ReposOwnerRepoHooksHookIdPatchBodyType,
    ReposOwnerRepoMergeUpstreamPostBodyType,
    ReposOwnerRepoContentsPathDeleteBodyType,
    ReposOwnerRepoTagsProtectionPostBodyType,
    ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ReposOwnerRepoHooksHookIdConfigPatchBodyType,
    ReposOwnerRepoReleasesReleaseIdPatchBodyType,
    ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ReposOwnerRepoCollaboratorsUsernamePutBodyType,
    ReposOwnerRepoContentsPathPutBodyPropAuthorType,
    ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ReposOwnerRepoHooksHookIdPatchBodyPropConfigType,
    ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType,
    ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ReposOwnerRepoContentsPathDeleteBodyPropAuthorType,
    ReposOwnerRepoContentsPathPutBodyPropCommitterType,
    ReposOwnerRepoInvitationsInvitationIdPatchBodyType,
    ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType,
    ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType,
    ReposOwnerRepoContentsPathDeleteBodyPropCommitterType,
    ReposOwnerRepoDispatchesPostBodyPropClientPayloadType,
    ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type,
    ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType,
    ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType,
    ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType,
    ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType,
)
from .models import (
    Tag,
    Hook,
    Page,
    Team,
    Topic,
    Commit,
    Status,
    Release,
    Autolink,
    Language,
    DeployKey,
    PageBuild,
    BasicError,
    Deployment,
    FileCommit,
    Repository,
    SimpleUser,
    BranchShort,
    ContentFile,
    ContentTree,
    Contributor,
    Environment,
    Integration,
    ShortBranch,
    ViewTraffic,
    CloneTraffic,
    Collaborator,
    HookDelivery,
    ReleaseAsset,
    CommitComment,
    TagProtection,
    WebhookConfig,
    CommitActivity,
    ContentTraffic,
    FullRepository,
    MergedUpstream,
    PageBuildStatus,
    ProtectedBranch,
    ReferrerTraffic,
    ValidationError,
    BranchProtection,
    CodeownersErrors,
    CommitComparison,
    CommunityProfile,
    DeploymentStatus,
    HookDeliveryItem,
    PagesHealthCheck,
    MinimalRepository,
    PullRequestSimple,
    StatusCheckPolicy,
    UserReposPostBody,
    ParticipationStats,
    ContributorActivity,
    ReleaseNotesContent,
    BranchWithProtection,
    CombinedCommitStatus,
    OrgsOrgReposPostBody,
    RepositoryInvitation,
    ValidationErrorSimple,
    BranchRestrictionPolicy,
    ReposOwnerRepoPatchBody,
    ReposOwnerRepoKeysPostBody,
    ReposOwnerRepoForksPostBody,
    ReposOwnerRepoHooksPostBody,
    ReposOwnerRepoPagesPostBody,
    ReposOwnerRepoTopicsPutBody,
    ProtectedBranchAdminEnforced,
    ReposOwnerRepoMergesPostBody,
    ReposOwnerRepoReleasesPostBody,
    ReposOwnerRepoTransferPostBody,
    ReposOwnerRepoAutolinksPostBody,
    ReposOwnerRepoDeleteResponse403,
    ProtectedBranchPullRequestReview,
    RepositoryCollaboratorPermission,
    ReposOwnerRepoDispatchesPostBody,
    ReposOwnerRepoContentsPathPutBody,
    ReposOwnerRepoDeploymentsPostBody,
    ReposOwnerRepoStatusesShaPostBody,
    ReposOwnerRepoHooksHookIdPatchBody,
    ReposOwnerRepoMergeUpstreamPostBody,
    ReposOwnerRepoContentsPathDeleteBody,
    ReposOwnerRepoTagsProtectionPostBody,
    ReposOwnerRepoCommentsCommentIdPatchBody,
    ReposOwnerRepoEnvironmentsGetResponse200,
    ReposOwnerRepoHooksHookIdConfigPatchBody,
    ReposOwnerRepoReleasesReleaseIdPatchBody,
    ReposOwnerRepoBranchesBranchRenamePostBody,
    ReposOwnerRepoCollaboratorsUsernamePutBody,
    ReposOwnerRepoReleasesGenerateNotesPostBody,
    ReposOwnerRepoReleasesAssetsAssetIdPatchBody,
    ReposOwnerRepoBranchesBranchProtectionPutBody,
    ReposOwnerRepoCommitsCommitShaCommentsPostBody,
    ReposOwnerRepoInvitationsInvitationIdPatchBody,
    ReposTemplateOwnerTemplateRepoGeneratePostBody,
    ReposOwnerRepoEnvironmentsEnvironmentNamePutBody,
    AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
    EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
    ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class ReposClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_for_org(
        self,
        org: str,
        type: Union[
            Unset,
            Literal[
                "all", "public", "private", "forks", "sources", "member", "internal"
            ],
        ] = UNSET,
        sort: Union[
            Unset, Literal["created", "updated", "pushed", "full_name"]
        ] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
        )

    async def async_list_for_org(
        self,
        org: str,
        type: Union[
            Unset,
            Literal[
                "all", "public", "private", "forks", "sources", "member", "internal"
            ],
        ] = UNSET,
        sort: Union[
            Unset, Literal["created", "updated", "pushed", "full_name"]
        ] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
        )

    def create_in_org(
        self,
        org: str,
        *,
        name: str,
        description: Union[Unset, str] = UNSET,
        homepage: Union[Unset, str] = UNSET,
        private: Union[Unset, bool] = False,
        visibility: Union[Unset, Literal["public", "private", "internal"]] = UNSET,
        has_issues: Union[Unset, bool] = True,
        has_projects: Union[Unset, bool] = True,
        has_wiki: Union[Unset, bool] = True,
        is_template: Union[Unset, bool] = False,
        team_id: Union[Unset, int] = UNSET,
        auto_init: Union[Unset, bool] = False,
        gitignore_template: Union[Unset, str] = UNSET,
        license_template: Union[Unset, str] = UNSET,
        allow_squash_merge: Union[Unset, bool] = True,
        allow_merge_commit: Union[Unset, bool] = True,
        allow_rebase_merge: Union[Unset, bool] = True,
        allow_auto_merge: Union[Unset, bool] = False,
        delete_branch_on_merge: Union[Unset, bool] = False,
        use_squash_pr_title_as_default: Union[Unset, bool] = False,
    ) -> "Response[Repository]":
        url = f"/orgs/{org}/repos"

        json = OrgsOrgReposPostBody(
            **{
                "name": name,
                "description": description,
                "homepage": homepage,
                "private": private,
                "visibility": visibility,
                "has_issues": has_issues,
                "has_projects": has_projects,
                "has_wiki": has_wiki,
                "is_template": is_template,
                "team_id": team_id,
                "auto_init": auto_init,
                "gitignore_template": gitignore_template,
                "license_template": license_template,
                "allow_squash_merge": allow_squash_merge,
                "allow_merge_commit": allow_merge_commit,
                "allow_rebase_merge": allow_rebase_merge,
                "allow_auto_merge": allow_auto_merge,
                "delete_branch_on_merge": delete_branch_on_merge,
                "use_squash_pr_title_as_default": use_squash_pr_title_as_default,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Repository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    async def async_create_in_org(
        self,
        org: str,
        *,
        name: str,
        description: Union[Unset, str] = UNSET,
        homepage: Union[Unset, str] = UNSET,
        private: Union[Unset, bool] = False,
        visibility: Union[Unset, Literal["public", "private", "internal"]] = UNSET,
        has_issues: Union[Unset, bool] = True,
        has_projects: Union[Unset, bool] = True,
        has_wiki: Union[Unset, bool] = True,
        is_template: Union[Unset, bool] = False,
        team_id: Union[Unset, int] = UNSET,
        auto_init: Union[Unset, bool] = False,
        gitignore_template: Union[Unset, str] = UNSET,
        license_template: Union[Unset, str] = UNSET,
        allow_squash_merge: Union[Unset, bool] = True,
        allow_merge_commit: Union[Unset, bool] = True,
        allow_rebase_merge: Union[Unset, bool] = True,
        allow_auto_merge: Union[Unset, bool] = False,
        delete_branch_on_merge: Union[Unset, bool] = False,
        use_squash_pr_title_as_default: Union[Unset, bool] = False,
    ) -> "Response[Repository]":
        url = f"/orgs/{org}/repos"

        json = OrgsOrgReposPostBody(
            **{
                "name": name,
                "description": description,
                "homepage": homepage,
                "private": private,
                "visibility": visibility,
                "has_issues": has_issues,
                "has_projects": has_projects,
                "has_wiki": has_wiki,
                "is_template": is_template,
                "team_id": team_id,
                "auto_init": auto_init,
                "gitignore_template": gitignore_template,
                "license_template": license_template,
                "allow_squash_merge": allow_squash_merge,
                "allow_merge_commit": allow_merge_commit,
                "allow_rebase_merge": allow_rebase_merge,
                "allow_auto_merge": allow_auto_merge,
                "delete_branch_on_merge": delete_branch_on_merge,
                "use_squash_pr_title_as_default": use_squash_pr_title_as_default,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Repository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def get(
        self,
        owner: str,
        repo: str,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}"

        return self._github.request(
            "GET",
            url,
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": ReposOwnerRepoDeleteResponse403,
                "404": BasicError,
            },
        )

    async def async_delete(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": ReposOwnerRepoDeleteResponse403,
                "404": BasicError,
            },
        )

    def update(
        self,
        owner: str,
        repo: str,
        *,
        name: Union[Unset, str] = UNSET,
        description: Union[Unset, str] = UNSET,
        homepage: Union[Unset, str] = UNSET,
        private: Union[Unset, bool] = False,
        visibility: Union[Unset, Literal["public", "private", "internal"]] = UNSET,
        security_and_analysis: Union[
            Unset, Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]
        ] = UNSET,
        has_issues: Union[Unset, bool] = True,
        has_projects: Union[Unset, bool] = True,
        has_wiki: Union[Unset, bool] = True,
        is_template: Union[Unset, bool] = False,
        default_branch: Union[Unset, str] = UNSET,
        allow_squash_merge: Union[Unset, bool] = True,
        allow_merge_commit: Union[Unset, bool] = True,
        allow_rebase_merge: Union[Unset, bool] = True,
        allow_auto_merge: Union[Unset, bool] = False,
        delete_branch_on_merge: Union[Unset, bool] = False,
        allow_update_branch: Union[Unset, bool] = False,
        use_squash_pr_title_as_default: Union[Unset, bool] = False,
        archived: Union[Unset, bool] = False,
        allow_forking: Union[Unset, bool] = False,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}"

        json = ReposOwnerRepoPatchBody(
            **{
                "name": name,
                "description": description,
                "homepage": homepage,
                "private": private,
                "visibility": visibility,
                "security_and_analysis": security_and_analysis,
                "has_issues": has_issues,
                "has_projects": has_projects,
                "has_wiki": has_wiki,
                "is_template": is_template,
                "default_branch": default_branch,
                "allow_squash_merge": allow_squash_merge,
                "allow_merge_commit": allow_merge_commit,
                "allow_rebase_merge": allow_rebase_merge,
                "allow_auto_merge": allow_auto_merge,
                "delete_branch_on_merge": delete_branch_on_merge,
                "allow_update_branch": allow_update_branch,
                "use_squash_pr_title_as_default": use_squash_pr_title_as_default,
                "archived": archived,
                "allow_forking": allow_forking,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        name: Union[Unset, str] = UNSET,
        description: Union[Unset, str] = UNSET,
        homepage: Union[Unset, str] = UNSET,
        private: Union[Unset, bool] = False,
        visibility: Union[Unset, Literal["public", "private", "internal"]] = UNSET,
        security_and_analysis: Union[
            Unset, Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]
        ] = UNSET,
        has_issues: Union[Unset, bool] = True,
        has_projects: Union[Unset, bool] = True,
        has_wiki: Union[Unset, bool] = True,
        is_template: Union[Unset, bool] = False,
        default_branch: Union[Unset, str] = UNSET,
        allow_squash_merge: Union[Unset, bool] = True,
        allow_merge_commit: Union[Unset, bool] = True,
        allow_rebase_merge: Union[Unset, bool] = True,
        allow_auto_merge: Union[Unset, bool] = False,
        delete_branch_on_merge: Union[Unset, bool] = False,
        allow_update_branch: Union[Unset, bool] = False,
        use_squash_pr_title_as_default: Union[Unset, bool] = False,
        archived: Union[Unset, bool] = False,
        allow_forking: Union[Unset, bool] = False,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}"

        json = ReposOwnerRepoPatchBody(
            **{
                "name": name,
                "description": description,
                "homepage": homepage,
                "private": private,
                "visibility": visibility,
                "security_and_analysis": security_and_analysis,
                "has_issues": has_issues,
                "has_projects": has_projects,
                "has_wiki": has_wiki,
                "is_template": is_template,
                "default_branch": default_branch,
                "allow_squash_merge": allow_squash_merge,
                "allow_merge_commit": allow_merge_commit,
                "allow_rebase_merge": allow_rebase_merge,
                "allow_auto_merge": allow_auto_merge,
                "delete_branch_on_merge": delete_branch_on_merge,
                "allow_update_branch": allow_update_branch,
                "use_squash_pr_title_as_default": use_squash_pr_title_as_default,
                "archived": archived,
                "allow_forking": allow_forking,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_autolinks(
        self,
        owner: str,
        repo: str,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Autolink]]":
        url = f"/repos/{owner}/{repo}/autolinks"

        params = {
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Autolink],
        )

    async def async_list_autolinks(
        self,
        owner: str,
        repo: str,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Autolink]]":
        url = f"/repos/{owner}/{repo}/autolinks"

        params = {
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Autolink],
        )

    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        key_prefix: str,
        url_template: str,
    ) -> "Response[Autolink]":
        url = f"/repos/{owner}/{repo}/autolinks"

        json = ReposOwnerRepoAutolinksPostBody(
            **{
                "key_prefix": key_prefix,
                "url_template": url_template,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Autolink,
            error_models={
                "422": ValidationError,
            },
        )

    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        key_prefix: str,
        url_template: str,
    ) -> "Response[Autolink]":
        url = f"/repos/{owner}/{repo}/autolinks"

        json = ReposOwnerRepoAutolinksPostBody(
            **{
                "key_prefix": key_prefix,
                "url_template": url_template,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Autolink,
            error_models={
                "422": ValidationError,
            },
        )

    def get_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
    ) -> "Response[Autolink]":
        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Autolink,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
    ) -> "Response[Autolink]":
        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Autolink,
            error_models={
                "404": BasicError,
            },
        )

    def delete_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def enable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_enable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def disable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_disable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_branches(
        self,
        owner: str,
        repo: str,
        protected: Union[Unset, bool] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ShortBranch]]":
        url = f"/repos/{owner}/{repo}/branches"

        params = {
            "protected": protected,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ShortBranch],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_branches(
        self,
        owner: str,
        repo: str,
        protected: Union[Unset, bool] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ShortBranch]]":
        url = f"/repos/{owner}/{repo}/branches"

        params = {
            "protected": protected,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ShortBranch],
            error_models={
                "404": BasicError,
            },
        )

    def get_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[BranchWithProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}"

        return self._github.request(
            "GET",
            url,
            response_model=BranchWithProtection,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[BranchWithProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=BranchWithProtection,
            error_models={
                "404": BasicError,
            },
        )

    def get_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[BranchProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        return self._github.request(
            "GET",
            url,
            response_model=BranchProtection,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[BranchProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        return await self._github.arequest(
            "GET",
            url,
            response_model=BranchProtection,
            error_models={
                "404": BasicError,
            },
        )

    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        required_status_checks: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
            None,
        ],
        enforce_admins: Union[bool, None],
        required_pull_request_reviews: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
            None,
        ],
        restrictions: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
        ],
        required_linear_history: Union[Unset, bool] = UNSET,
        allow_force_pushes: Union[Unset, Union[bool, None]] = UNSET,
        allow_deletions: Union[Unset, bool] = UNSET,
        block_creations: Union[Unset, bool] = UNSET,
        required_conversation_resolution: Union[Unset, bool] = UNSET,
    ) -> "Response[ProtectedBranch]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        json = ReposOwnerRepoBranchesBranchProtectionPutBody(
            **{
                "required_status_checks": required_status_checks,
                "enforce_admins": enforce_admins,
                "required_pull_request_reviews": required_pull_request_reviews,
                "restrictions": restrictions,
                "required_linear_history": required_linear_history,
                "allow_force_pushes": allow_force_pushes,
                "allow_deletions": allow_deletions,
                "block_creations": block_creations,
                "required_conversation_resolution": required_conversation_resolution,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ProtectedBranch,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        required_status_checks: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
            None,
        ],
        enforce_admins: Union[bool, None],
        required_pull_request_reviews: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
            None,
        ],
        restrictions: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
        ],
        required_linear_history: Union[Unset, bool] = UNSET,
        allow_force_pushes: Union[Unset, Union[bool, None]] = UNSET,
        allow_deletions: Union[Unset, bool] = UNSET,
        block_creations: Union[Unset, bool] = UNSET,
        required_conversation_resolution: Union[Unset, bool] = UNSET,
    ) -> "Response[ProtectedBranch]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        json = ReposOwnerRepoBranchesBranchProtectionPutBody(
            **{
                "required_status_checks": required_status_checks,
                "enforce_admins": enforce_admins,
                "required_pull_request_reviews": required_pull_request_reviews,
                "restrictions": restrictions,
                "required_linear_history": required_linear_history,
                "allow_force_pushes": allow_force_pushes,
                "allow_deletions": allow_deletions,
                "block_creations": block_creations,
                "required_conversation_resolution": required_conversation_resolution,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ProtectedBranch,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    def delete_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
            },
        )

    async def async_delete_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
            },
        )

    def get_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        return self._github.request(
            "GET",
            url,
            response_model=ProtectedBranchAdminEnforced,
        )

    async def async_get_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ProtectedBranchAdminEnforced,
        )

    def set_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        return self._github.request(
            "POST",
            url,
            response_model=ProtectedBranchAdminEnforced,
        )

    async def async_set_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        return await self._github.arequest(
            "POST",
            url,
            response_model=ProtectedBranchAdminEnforced,
        )

    def delete_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def get_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        return self._github.request(
            "GET",
            url,
            response_model=ProtectedBranchPullRequestReview,
        )

    async def async_get_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ProtectedBranchPullRequestReview,
        )

    def delete_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        dismissal_restrictions: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType,
        ] = UNSET,
        dismiss_stale_reviews: Union[Unset, bool] = UNSET,
        require_code_owner_reviews: Union[Unset, bool] = UNSET,
        required_approving_review_count: Union[Unset, int] = UNSET,
        bypass_pull_request_allowances: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType,
        ] = UNSET,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        json = (
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody(
                **{
                    "dismissal_restrictions": dismissal_restrictions,
                    "dismiss_stale_reviews": dismiss_stale_reviews,
                    "require_code_owner_reviews": require_code_owner_reviews,
                    "required_approving_review_count": required_approving_review_count,
                    "bypass_pull_request_allowances": bypass_pull_request_allowances,
                }
            ).dict(by_alias=True)
        )

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ProtectedBranchPullRequestReview,
            error_models={
                "422": ValidationError,
            },
        )

    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        dismissal_restrictions: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType,
        ] = UNSET,
        dismiss_stale_reviews: Union[Unset, bool] = UNSET,
        require_code_owner_reviews: Union[Unset, bool] = UNSET,
        required_approving_review_count: Union[Unset, int] = UNSET,
        bypass_pull_request_allowances: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType,
        ] = UNSET,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        json = (
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody(
                **{
                    "dismissal_restrictions": dismissal_restrictions,
                    "dismiss_stale_reviews": dismiss_stale_reviews,
                    "require_code_owner_reviews": require_code_owner_reviews,
                    "required_approving_review_count": required_approving_review_count,
                    "bypass_pull_request_allowances": bypass_pull_request_allowances,
                }
            ).dict(by_alias=True)
        )

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ProtectedBranchPullRequestReview,
            error_models={
                "422": ValidationError,
            },
        )

    def get_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        return self._github.request(
            "GET",
            url,
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    def create_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        return self._github.request(
            "POST",
            url,
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    async def async_create_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        return await self._github.arequest(
            "POST",
            url,
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    def delete_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def get_status_checks_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[StatusCheckPolicy]":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        return self._github.request(
            "GET",
            url,
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_status_checks_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[StatusCheckPolicy]":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        return await self._github.arequest(
            "GET",
            url,
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
            },
        )

    def remove_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        strict: Union[Unset, bool] = UNSET,
        contexts: Union[Unset, List[str]] = UNSET,
        checks: Union[
            Unset,
            List[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ],
        ] = UNSET,
    ) -> "Response[StatusCheckPolicy]":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        json = ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody(
            **{
                "strict": strict,
                "contexts": contexts,
                "checks": checks,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        strict: Union[Unset, bool] = UNSET,
        contexts: Union[Unset, List[str]] = UNSET,
        checks: Union[
            Unset,
            List[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ],
        ] = UNSET,
    ) -> "Response[StatusCheckPolicy]":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        json = ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody(
            **{
                "strict": strict,
                "contexts": contexts,
                "checks": checks,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_all_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        return self._github.request(
            "GET",
            url,
            response_model=List[str],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[str],
            error_models={
                "404": BasicError,
            },
        )

    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        json = body

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        json = body

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        json = body

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[str],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        json = body

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[str],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[BranchRestrictionPolicy]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        return self._github.request(
            "GET",
            url,
            response_model=BranchRestrictionPolicy,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[BranchRestrictionPolicy]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=BranchRestrictionPolicy,
            error_models={
                "404": BasicError,
            },
        )

    def delete_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_apps_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        return self._github.request(
            "GET",
            url,
            response_model=List[Integration],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_apps_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[Integration],
            error_models={
                "404": BasicError,
            },
        )

    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        json = body

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        json = body

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        json = body

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        json = body

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    def get_teams_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        return self._github.request(
            "GET",
            url,
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_teams_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        json = body

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        json = body

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        json = body

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        json = body

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    def get_users_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        return self._github.request(
            "GET",
            url,
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_users_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        json = body

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        json = body

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        json = body

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        body: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        json = body

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        new_name: str,
    ) -> "Response[BranchWithProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/rename"

        json = ReposOwnerRepoBranchesBranchRenamePostBody(
            **{
                "new_name": new_name,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=BranchWithProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        new_name: str,
    ) -> "Response[BranchWithProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/rename"

        json = ReposOwnerRepoBranchesBranchRenamePostBody(
            **{
                "new_name": new_name,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=BranchWithProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def codeowners_errors(
        self,
        owner: str,
        repo: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[CodeownersErrors]":
        url = f"/repos/{owner}/{repo}/codeowners/errors"

        params = {
            "ref": ref,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CodeownersErrors,
            error_models={},
        )

    async def async_codeowners_errors(
        self,
        owner: str,
        repo: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[CodeownersErrors]":
        url = f"/repos/{owner}/{repo}/codeowners/errors"

        params = {
            "ref": ref,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CodeownersErrors,
            error_models={},
        )

    def list_collaborators(
        self,
        owner: str,
        repo: str,
        affiliation: Union[Unset, Literal["outside", "direct", "all"]] = "all",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Collaborator]]":
        url = f"/repos/{owner}/{repo}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Collaborator],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_collaborators(
        self,
        owner: str,
        repo: str,
        affiliation: Union[Unset, Literal["outside", "direct", "all"]] = "all",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Collaborator]]":
        url = f"/repos/{owner}/{repo}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Collaborator],
            error_models={
                "404": BasicError,
            },
        )

    def check_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        return self._github.request(
            "GET",
            url,
            error_models={},
        )

    async def async_check_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={},
        )

    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        permission: Union[
            Unset, Literal["pull", "push", "admin", "maintain", "triage"]
        ] = "push",
    ) -> "Response[RepositoryInvitation]":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        json = ReposOwnerRepoCollaboratorsUsernamePutBody(
            **{
                "permission": permission,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=RepositoryInvitation,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        permission: Union[
            Unset, Literal["pull", "push", "admin", "maintain", "triage"]
        ] = "push",
    ) -> "Response[RepositoryInvitation]":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        json = ReposOwnerRepoCollaboratorsUsernamePutBody(
            **{
                "permission": permission,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=RepositoryInvitation,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def remove_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_collaborator_permission_level(
        self,
        owner: str,
        repo: str,
        username: str,
    ) -> "Response[RepositoryCollaboratorPermission]":
        url = f"/repos/{owner}/{repo}/collaborators/{username}/permission"

        return self._github.request(
            "GET",
            url,
            response_model=RepositoryCollaboratorPermission,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_collaborator_permission_level(
        self,
        owner: str,
        repo: str,
        username: str,
    ) -> "Response[RepositoryCollaboratorPermission]":
        url = f"/repos/{owner}/{repo}/collaborators/{username}/permission"

        return await self._github.arequest(
            "GET",
            url,
            response_model=RepositoryCollaboratorPermission,
            error_models={
                "404": BasicError,
            },
        )

    def list_commit_comments_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[CommitComment]]":
        url = f"/repos/{owner}/{repo}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[CommitComment],
        )

    async def async_list_commit_comments_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[CommitComment]]":
        url = f"/repos/{owner}/{repo}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[CommitComment],
        )

    def get_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        return self._github.request(
            "GET",
            url,
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        body: str,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        json = ReposOwnerRepoCommentsCommentIdPatchBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        body: str,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        json = ReposOwnerRepoCommentsCommentIdPatchBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        owner: str,
        repo: str,
        sha: Union[Unset, str] = UNSET,
        path: Union[Unset, str] = UNSET,
        author: Union[Unset, str] = UNSET,
        since: Union[Unset, datetime] = UNSET,
        until: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Commit]]":
        url = f"/repos/{owner}/{repo}/commits"

        params = {
            "sha": sha,
            "path": path,
            "author": author,
            "since": since,
            "until": until,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Commit],
            error_models={
                "500": BasicError,
                "400": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_list_commits(
        self,
        owner: str,
        repo: str,
        sha: Union[Unset, str] = UNSET,
        path: Union[Unset, str] = UNSET,
        author: Union[Unset, str] = UNSET,
        since: Union[Unset, datetime] = UNSET,
        until: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Commit]]":
        url = f"/repos/{owner}/{repo}/commits"

        params = {
            "sha": sha,
            "path": path,
            "author": author,
            "since": since,
            "until": until,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Commit],
            error_models={
                "500": BasicError,
                "400": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def list_branches_for_head_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
    ) -> "Response[List[BranchShort]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head"

        return self._github.request(
            "GET",
            url,
            response_model=List[BranchShort],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_branches_for_head_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
    ) -> "Response[List[BranchShort]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[BranchShort],
            error_models={
                "422": ValidationError,
            },
        )

    def list_comments_for_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[CommitComment]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[CommitComment],
        )

    async def async_list_comments_for_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[CommitComment]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[CommitComment],
        )

    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        body: str,
        path: Union[Unset, str] = UNSET,
        position: Union[Unset, int] = UNSET,
        line: Union[Unset, int] = UNSET,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        json = ReposOwnerRepoCommitsCommitShaCommentsPostBody(
            **{
                "body": body,
                "path": path,
                "position": position,
                "line": line,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=CommitComment,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        body: str,
        path: Union[Unset, str] = UNSET,
        position: Union[Unset, int] = UNSET,
        line: Union[Unset, int] = UNSET,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        json = ReposOwnerRepoCommitsCommitShaCommentsPostBody(
            **{
                "body": body,
                "path": path,
                "position": position,
                "line": line,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=CommitComment,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_pull_requests_associated_with_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PullRequestSimple]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/pulls"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PullRequestSimple],
        )

    async def async_list_pull_requests_associated_with_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PullRequestSimple]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/pulls"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PullRequestSimple],
        )

    def get_commit(
        self,
        owner: str,
        repo: str,
        ref: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[Commit]":
        url = f"/repos/{owner}/{repo}/commits/{ref}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Commit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_commit(
        self,
        owner: str,
        repo: str,
        ref: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[Commit]":
        url = f"/repos/{owner}/{repo}/commits/{ref}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Commit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_combined_status_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[CombinedCommitStatus]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/status"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CombinedCommitStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_combined_status_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[CombinedCommitStatus]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/status"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CombinedCommitStatus,
            error_models={
                "404": BasicError,
            },
        )

    def list_commit_statuses_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Status]]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Status],
        )

    async def async_list_commit_statuses_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Status]]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Status],
        )

    def get_community_profile_metrics(
        self,
        owner: str,
        repo: str,
    ) -> "Response[CommunityProfile]":
        url = f"/repos/{owner}/{repo}/community/profile"

        return self._github.request(
            "GET",
            url,
            response_model=CommunityProfile,
        )

    async def async_get_community_profile_metrics(
        self,
        owner: str,
        repo: str,
    ) -> "Response[CommunityProfile]":
        url = f"/repos/{owner}/{repo}/community/profile"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CommunityProfile,
        )

    def compare_commits(
        self,
        owner: str,
        repo: str,
        basehead: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[CommitComparison]":
        url = f"/repos/{owner}/{repo}/compare/{basehead}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CommitComparison,
            error_models={
                "500": BasicError,
                "404": BasicError,
            },
        )

    async def async_compare_commits(
        self,
        owner: str,
        repo: str,
        basehead: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[CommitComparison]":
        url = f"/repos/{owner}/{repo}/compare/{basehead}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CommitComparison,
            error_models={
                "500": BasicError,
                "404": BasicError,
            },
        )

    def get_content(
        self,
        owner: str,
        repo: str,
        path: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ContentTree]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        params = {
            "ref": ref,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ContentTree,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_content(
        self,
        owner: str,
        repo: str,
        path: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ContentTree]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        params = {
            "ref": ref,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ContentTree,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        message: str,
        content: str,
        sha: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        committer: Union[
            Unset, ReposOwnerRepoContentsPathPutBodyPropCommitterType
        ] = UNSET,
        author: Union[Unset, ReposOwnerRepoContentsPathPutBodyPropAuthorType] = UNSET,
    ) -> "Response[FileCommit]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        json = ReposOwnerRepoContentsPathPutBody(
            **{
                "message": message,
                "content": content,
                "sha": sha,
                "branch": branch,
                "committer": committer,
                "author": author,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=FileCommit,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "409": BasicError,
            },
        )

    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        message: str,
        content: str,
        sha: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        committer: Union[
            Unset, ReposOwnerRepoContentsPathPutBodyPropCommitterType
        ] = UNSET,
        author: Union[Unset, ReposOwnerRepoContentsPathPutBodyPropAuthorType] = UNSET,
    ) -> "Response[FileCommit]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        json = ReposOwnerRepoContentsPathPutBody(
            **{
                "message": message,
                "content": content,
                "sha": sha,
                "branch": branch,
                "committer": committer,
                "author": author,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=FileCommit,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "409": BasicError,
            },
        )

    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        message: str,
        sha: str,
        branch: Union[Unset, str] = UNSET,
        committer: Union[
            Unset, ReposOwnerRepoContentsPathDeleteBodyPropCommitterType
        ] = UNSET,
        author: Union[
            Unset, ReposOwnerRepoContentsPathDeleteBodyPropAuthorType
        ] = UNSET,
    ) -> "Response[FileCommit]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        json = ReposOwnerRepoContentsPathDeleteBody(
            **{
                "message": message,
                "sha": sha,
                "branch": branch,
                "committer": committer,
                "author": author,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=FileCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        message: str,
        sha: str,
        branch: Union[Unset, str] = UNSET,
        committer: Union[
            Unset, ReposOwnerRepoContentsPathDeleteBodyPropCommitterType
        ] = UNSET,
        author: Union[
            Unset, ReposOwnerRepoContentsPathDeleteBodyPropAuthorType
        ] = UNSET,
    ) -> "Response[FileCommit]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        json = ReposOwnerRepoContentsPathDeleteBody(
            **{
                "message": message,
                "sha": sha,
                "branch": branch,
                "committer": committer,
                "author": author,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=FileCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_contributors(
        self,
        owner: str,
        repo: str,
        anon: Union[Unset, str] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Contributor]]":
        url = f"/repos/{owner}/{repo}/contributors"

        params = {
            "anon": anon,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Contributor],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_contributors(
        self,
        owner: str,
        repo: str,
        anon: Union[Unset, str] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Contributor]]":
        url = f"/repos/{owner}/{repo}/contributors"

        params = {
            "anon": anon,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Contributor],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_deployments(
        self,
        owner: str,
        repo: str,
        sha: Union[Unset, str] = "none",
        ref: Union[Unset, str] = "none",
        task: Union[Unset, str] = "none",
        environment: Union[Unset, Union[str, None]] = "none",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Deployment]]":
        url = f"/repos/{owner}/{repo}/deployments"

        params = {
            "sha": sha,
            "ref": ref,
            "task": task,
            "environment": environment,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Deployment],
        )

    async def async_list_deployments(
        self,
        owner: str,
        repo: str,
        sha: Union[Unset, str] = "none",
        ref: Union[Unset, str] = "none",
        task: Union[Unset, str] = "none",
        environment: Union[Unset, Union[str, None]] = "none",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Deployment]]":
        url = f"/repos/{owner}/{repo}/deployments"

        params = {
            "sha": sha,
            "ref": ref,
            "task": task,
            "environment": environment,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Deployment],
        )

    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        ref: str,
        task: Union[Unset, str] = "deploy",
        auto_merge: Union[Unset, bool] = True,
        required_contexts: Union[Unset, List[str]] = UNSET,
        payload: Union[
            Unset, Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]
        ] = UNSET,
        environment: Union[Unset, str] = "production",
        description: Union[Unset, Union[str, None]] = "",
        transient_environment: Union[Unset, bool] = False,
        production_environment: Union[Unset, bool] = UNSET,
    ) -> "Response[Deployment]":
        url = f"/repos/{owner}/{repo}/deployments"

        json = ReposOwnerRepoDeploymentsPostBody(
            **{
                "ref": ref,
                "task": task,
                "auto_merge": auto_merge,
                "required_contexts": required_contexts,
                "payload": payload,
                "environment": environment,
                "description": description,
                "transient_environment": transient_environment,
                "production_environment": production_environment,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Deployment,
            error_models={
                "422": ValidationError,
            },
        )

    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        ref: str,
        task: Union[Unset, str] = "deploy",
        auto_merge: Union[Unset, bool] = True,
        required_contexts: Union[Unset, List[str]] = UNSET,
        payload: Union[
            Unset, Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]
        ] = UNSET,
        environment: Union[Unset, str] = "production",
        description: Union[Unset, Union[str, None]] = "",
        transient_environment: Union[Unset, bool] = False,
        production_environment: Union[Unset, bool] = UNSET,
    ) -> "Response[Deployment]":
        url = f"/repos/{owner}/{repo}/deployments"

        json = ReposOwnerRepoDeploymentsPostBody(
            **{
                "ref": ref,
                "task": task,
                "auto_merge": auto_merge,
                "required_contexts": required_contexts,
                "payload": payload,
                "environment": environment,
                "description": description,
                "transient_environment": transient_environment,
                "production_environment": production_environment,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Deployment,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
    ) -> "Response[Deployment]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Deployment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
    ) -> "Response[Deployment]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Deployment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_delete_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_deployment_statuses(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[DeploymentStatus]]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[DeploymentStatus],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_deployment_statuses(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[DeploymentStatus]]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[DeploymentStatus],
            error_models={
                "404": BasicError,
            },
        )

    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        state: Literal[
            "error",
            "failure",
            "inactive",
            "in_progress",
            "queued",
            "pending",
            "success",
        ],
        target_url: Union[Unset, str] = "",
        log_url: Union[Unset, str] = "",
        description: Union[Unset, str] = "",
        environment: Union[Unset, Literal["production", "staging", "qa"]] = UNSET,
        environment_url: Union[Unset, str] = "",
        auto_inactive: Union[Unset, bool] = UNSET,
    ) -> "Response[DeploymentStatus]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        json = ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody(
            **{
                "state": state,
                "target_url": target_url,
                "log_url": log_url,
                "description": description,
                "environment": environment,
                "environment_url": environment_url,
                "auto_inactive": auto_inactive,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=DeploymentStatus,
            error_models={
                "422": ValidationError,
            },
        )

    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        state: Literal[
            "error",
            "failure",
            "inactive",
            "in_progress",
            "queued",
            "pending",
            "success",
        ],
        target_url: Union[Unset, str] = "",
        log_url: Union[Unset, str] = "",
        description: Union[Unset, str] = "",
        environment: Union[Unset, Literal["production", "staging", "qa"]] = UNSET,
        environment_url: Union[Unset, str] = "",
        auto_inactive: Union[Unset, bool] = UNSET,
    ) -> "Response[DeploymentStatus]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        json = ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody(
            **{
                "state": state,
                "target_url": target_url,
                "log_url": log_url,
                "description": description,
                "environment": environment,
                "environment_url": environment_url,
                "auto_inactive": auto_inactive,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=DeploymentStatus,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        status_id: int,
    ) -> "Response[DeploymentStatus]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}"

        return self._github.request(
            "GET",
            url,
            response_model=DeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        status_id: int,
    ) -> "Response[DeploymentStatus]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=DeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        event_type: str,
        client_payload: Union[
            Unset, ReposOwnerRepoDispatchesPostBodyPropClientPayloadType
        ] = UNSET,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/dispatches"

        json = ReposOwnerRepoDispatchesPostBody(
            **{
                "event_type": event_type,
                "client_payload": client_payload,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            error_models={
                "422": ValidationError,
            },
        )

    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        event_type: str,
        client_payload: Union[
            Unset, ReposOwnerRepoDispatchesPostBodyPropClientPayloadType
        ] = UNSET,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/dispatches"

        json = ReposOwnerRepoDispatchesPostBody(
            **{
                "event_type": event_type,
                "client_payload": client_payload,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            error_models={
                "422": ValidationError,
            },
        )

    def get_all_environments(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoEnvironmentsGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoEnvironmentsGetResponse200,
        )

    async def async_get_all_environments(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoEnvironmentsGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoEnvironmentsGetResponse200,
        )

    def get_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
    ) -> "Response[Environment]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        return self._github.request(
            "GET",
            url,
            response_model=Environment,
        )

    async def async_get_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
    ) -> "Response[Environment]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Environment,
        )

    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        body: Union[
            Unset, Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
    ) -> "Response[Environment]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        json = body

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Environment,
            error_models={
                "422": BasicError,
            },
        )

    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        body: Union[
            Unset, Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
    ) -> "Response[Environment]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        json = body

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Environment,
            error_models={
                "422": BasicError,
            },
        )

    def delete_an_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_an_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_forks(
        self,
        owner: str,
        repo: str,
        sort: Union[
            Unset, Literal["newest", "oldest", "stargazers", "watchers"]
        ] = "newest",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/repos/{owner}/{repo}/forks"

        params = {
            "sort": sort,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "400": BasicError,
            },
        )

    async def async_list_forks(
        self,
        owner: str,
        repo: str,
        sort: Union[
            Unset, Literal["newest", "oldest", "stargazers", "watchers"]
        ] = "newest",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/repos/{owner}/{repo}/forks"

        params = {
            "sort": sort,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "400": BasicError,
            },
        )

    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[Unset, Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}/forks"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[Unset, Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}/forks"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_webhooks(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Hook]]":
        url = f"/repos/{owner}/{repo}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Hook],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_webhooks(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Hook]]":
        url = f"/repos/{owner}/{repo}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Hook],
            error_models={
                "404": BasicError,
            },
        )

    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[Unset, Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Hook,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[Unset, Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Hook,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Hook,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Hook,
            error_models={
                "404": BasicError,
            },
        )

    def delete_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        config: Union[Unset, ReposOwnerRepoHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Union[Unset, List[str]] = ["push"],
        add_events: Union[Unset, List[str]] = UNSET,
        remove_events: Union[Unset, List[str]] = UNSET,
        active: Union[Unset, bool] = True,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        json = ReposOwnerRepoHooksHookIdPatchBody(
            **{
                "config": config,
                "events": events,
                "add_events": add_events,
                "remove_events": remove_events,
                "active": active,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Hook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        config: Union[Unset, ReposOwnerRepoHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Union[Unset, List[str]] = ["push"],
        add_events: Union[Unset, List[str]] = UNSET,
        remove_events: Union[Unset, List[str]] = UNSET,
        active: Union[Unset, bool] = True,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        json = ReposOwnerRepoHooksHookIdPatchBody(
            **{
                "config": config,
                "events": events,
                "add_events": add_events,
                "remove_events": remove_events,
                "active": active,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Hook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response[WebhookConfig]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        return self._github.request(
            "GET",
            url,
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response[WebhookConfig]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        return await self._github.arequest(
            "GET",
            url,
            response_model=WebhookConfig,
        )

    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        url: Union[Unset, str] = UNSET,
        content_type: Union[Unset, str] = UNSET,
        secret: Union[Unset, str] = UNSET,
        insecure_ssl: Union[Unset, Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        json = ReposOwnerRepoHooksHookIdConfigPatchBody(
            **{
                "url": url,
                "content_type": content_type,
                "secret": secret,
                "insecure_ssl": insecure_ssl,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=WebhookConfig,
        )

    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        url: Union[Unset, str] = UNSET,
        content_type: Union[Unset, str] = UNSET,
        secret: Union[Unset, str] = UNSET,
        insecure_ssl: Union[Unset, Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        json = ReposOwnerRepoHooksHookIdConfigPatchBody(
            **{
                "url": url,
                "content_type": content_type,
                "secret": secret,
                "insecure_ssl": insecure_ssl,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        per_page: Union[Unset, int] = 30,
        cursor: Union[Unset, str] = UNSET,
    ) -> "Response[List[HookDeliveryItem]]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        per_page: Union[Unset, int] = 30,
        cursor: Union[Unset, str] = UNSET,
    ) -> "Response[List[HookDeliveryItem]]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[HookDelivery]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}"

        return self._github.request(
            "GET",
            url,
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[HookDelivery]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        return self._github.request(
            "POST",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def ping_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/pings"

        return self._github.request(
            "POST",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_ping_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/pings"

        return await self._github.arequest(
            "POST",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def test_push_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/tests"

        return self._github.request(
            "POST",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_test_push_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/tests"

        return await self._github.arequest(
            "POST",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def list_invitations(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[RepositoryInvitation]]":
        url = f"/repos/{owner}/{repo}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[RepositoryInvitation],
        )

    async def async_list_invitations(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[RepositoryInvitation]]":
        url = f"/repos/{owner}/{repo}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[RepositoryInvitation],
        )

    def delete_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        permissions: Union[
            Unset, Literal["read", "write", "maintain", "triage", "admin"]
        ] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        json = ReposOwnerRepoInvitationsInvitationIdPatchBody(
            **{
                "permissions": permissions,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RepositoryInvitation,
        )

    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        permissions: Union[
            Unset, Literal["read", "write", "maintain", "triage", "admin"]
        ] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        json = ReposOwnerRepoInvitationsInvitationIdPatchBody(
            **{
                "permissions": permissions,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RepositoryInvitation,
        )

    def list_deploy_keys(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[DeployKey]]":
        url = f"/repos/{owner}/{repo}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[DeployKey],
        )

    async def async_list_deploy_keys(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[DeployKey]]":
        url = f"/repos/{owner}/{repo}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[DeployKey],
        )

    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        title: Union[Unset, str] = UNSET,
        key: str,
        read_only: Union[Unset, bool] = UNSET,
    ) -> "Response[DeployKey]":
        url = f"/repos/{owner}/{repo}/keys"

        json = ReposOwnerRepoKeysPostBody(
            **{
                "title": title,
                "key": key,
                "read_only": read_only,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=DeployKey,
            error_models={
                "422": ValidationError,
            },
        )

    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        title: Union[Unset, str] = UNSET,
        key: str,
        read_only: Union[Unset, bool] = UNSET,
    ) -> "Response[DeployKey]":
        url = f"/repos/{owner}/{repo}/keys"

        json = ReposOwnerRepoKeysPostBody(
            **{
                "title": title,
                "key": key,
                "read_only": read_only,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=DeployKey,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
    ) -> "Response[DeployKey]":
        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        return self._github.request(
            "GET",
            url,
            response_model=DeployKey,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
    ) -> "Response[DeployKey]":
        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=DeployKey,
            error_models={
                "404": BasicError,
            },
        )

    def delete_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_languages(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Language]":
        url = f"/repos/{owner}/{repo}/languages"

        return self._github.request(
            "GET",
            url,
            response_model=Language,
        )

    async def async_list_languages(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Language]":
        url = f"/repos/{owner}/{repo}/languages"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Language,
        )

    def enable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/repos/{owner}/{repo}/lfs"

        return self._github.request(
            "PUT",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={},
        )

    async def async_enable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/repos/{owner}/{repo}/lfs"

        return await self._github.arequest(
            "PUT",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={},
        )

    def disable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/lfs"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_disable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/lfs"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        branch: str,
    ) -> "Response[MergedUpstream]":
        url = f"/repos/{owner}/{repo}/merge-upstream"

        json = ReposOwnerRepoMergeUpstreamPostBody(
            **{
                "branch": branch,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=MergedUpstream,
            error_models={},
        )

    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        branch: str,
    ) -> "Response[MergedUpstream]":
        url = f"/repos/{owner}/{repo}/merge-upstream"

        json = ReposOwnerRepoMergeUpstreamPostBody(
            **{
                "branch": branch,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=MergedUpstream,
            error_models={},
        )

    def merge(
        self,
        owner: str,
        repo: str,
        *,
        base: str,
        head: str,
        commit_message: Union[Unset, str] = UNSET,
    ) -> "Response[Commit]":
        url = f"/repos/{owner}/{repo}/merges"

        json = ReposOwnerRepoMergesPostBody(
            **{
                "base": base,
                "head": head,
                "commit_message": commit_message,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Commit,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        base: str,
        head: str,
        commit_message: Union[Unset, str] = UNSET,
    ) -> "Response[Commit]":
        url = f"/repos/{owner}/{repo}/merges"

        json = ReposOwnerRepoMergesPostBody(
            **{
                "base": base,
                "head": head,
                "commit_message": commit_message,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Commit,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def get_pages(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Page]":
        url = f"/repos/{owner}/{repo}/pages"

        return self._github.request(
            "GET",
            url,
            response_model=Page,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Page]":
        url = f"/repos/{owner}/{repo}/pages"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Page,
            error_models={
                "404": BasicError,
            },
        )

    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[Any, Any, Any, Any],
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pages"

        json = body

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "422": ValidationError,
                "400": BasicError,
            },
        )

    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[Any, Any, Any, Any],
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pages"

        json = body

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "422": ValidationError,
                "400": BasicError,
            },
        )

    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[ReposOwnerRepoPagesPostBodyType, None, Any],
    ) -> "Response[Page]":
        url = f"/repos/{owner}/{repo}/pages"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Page,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[ReposOwnerRepoPagesPostBodyType, None, Any],
    ) -> "Response[Page]":
        url = f"/repos/{owner}/{repo}/pages"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Page,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    def delete_pages_site(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pages"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_delete_pages_site(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pages"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_pages_builds(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PageBuild]]":
        url = f"/repos/{owner}/{repo}/pages/builds"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PageBuild],
        )

    async def async_list_pages_builds(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PageBuild]]":
        url = f"/repos/{owner}/{repo}/pages/builds"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PageBuild],
        )

    def request_pages_build(
        self,
        owner: str,
        repo: str,
    ) -> "Response[PageBuildStatus]":
        url = f"/repos/{owner}/{repo}/pages/builds"

        return self._github.request(
            "POST",
            url,
            response_model=PageBuildStatus,
        )

    async def async_request_pages_build(
        self,
        owner: str,
        repo: str,
    ) -> "Response[PageBuildStatus]":
        url = f"/repos/{owner}/{repo}/pages/builds"

        return await self._github.arequest(
            "POST",
            url,
            response_model=PageBuildStatus,
        )

    def get_latest_pages_build(
        self,
        owner: str,
        repo: str,
    ) -> "Response[PageBuild]":
        url = f"/repos/{owner}/{repo}/pages/builds/latest"

        return self._github.request(
            "GET",
            url,
            response_model=PageBuild,
        )

    async def async_get_latest_pages_build(
        self,
        owner: str,
        repo: str,
    ) -> "Response[PageBuild]":
        url = f"/repos/{owner}/{repo}/pages/builds/latest"

        return await self._github.arequest(
            "GET",
            url,
            response_model=PageBuild,
        )

    def get_pages_build(
        self,
        owner: str,
        repo: str,
        build_id: int,
    ) -> "Response[PageBuild]":
        url = f"/repos/{owner}/{repo}/pages/builds/{build_id}"

        return self._github.request(
            "GET",
            url,
            response_model=PageBuild,
        )

    async def async_get_pages_build(
        self,
        owner: str,
        repo: str,
        build_id: int,
    ) -> "Response[PageBuild]":
        url = f"/repos/{owner}/{repo}/pages/builds/{build_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=PageBuild,
        )

    def get_pages_health_check(
        self,
        owner: str,
        repo: str,
    ) -> "Response[PagesHealthCheck]":
        url = f"/repos/{owner}/{repo}/pages/health"

        return self._github.request(
            "GET",
            url,
            response_model=PagesHealthCheck,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages_health_check(
        self,
        owner: str,
        repo: str,
    ) -> "Response[PagesHealthCheck]":
        url = f"/repos/{owner}/{repo}/pages/health"

        return await self._github.arequest(
            "GET",
            url,
            response_model=PagesHealthCheck,
            error_models={
                "404": BasicError,
            },
        )

    def get_readme(
        self,
        owner: str,
        repo: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ContentFile]":
        url = f"/repos/{owner}/{repo}/readme"

        params = {
            "ref": ref,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_readme(
        self,
        owner: str,
        repo: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ContentFile]":
        url = f"/repos/{owner}/{repo}/readme"

        params = {
            "ref": ref,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_readme_in_directory(
        self,
        owner: str,
        repo: str,
        dir_: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ContentFile]":
        url = f"/repos/{owner}/{repo}/readme/{dir}"

        params = {
            "ref": ref,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_readme_in_directory(
        self,
        owner: str,
        repo: str,
        dir_: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ContentFile]":
        url = f"/repos/{owner}/{repo}/readme/{dir}"

        params = {
            "ref": ref,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_releases(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Release]]":
        url = f"/repos/{owner}/{repo}/releases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Release],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_releases(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Release]]":
        url = f"/repos/{owner}/{repo}/releases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Release],
            error_models={
                "404": BasicError,
            },
        )

    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        tag_name: str,
        target_commitish: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
        draft: Union[Unset, bool] = False,
        prerelease: Union[Unset, bool] = False,
        discussion_category_name: Union[Unset, str] = UNSET,
        generate_release_notes: Union[Unset, bool] = False,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases"

        json = ReposOwnerRepoReleasesPostBody(
            **{
                "tag_name": tag_name,
                "target_commitish": target_commitish,
                "name": name,
                "body": body,
                "draft": draft,
                "prerelease": prerelease,
                "discussion_category_name": discussion_category_name,
                "generate_release_notes": generate_release_notes,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Release,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        tag_name: str,
        target_commitish: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
        draft: Union[Unset, bool] = False,
        prerelease: Union[Unset, bool] = False,
        discussion_category_name: Union[Unset, str] = UNSET,
        generate_release_notes: Union[Unset, bool] = False,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases"

        json = ReposOwnerRepoReleasesPostBody(
            **{
                "tag_name": tag_name,
                "target_commitish": target_commitish,
                "name": name,
                "body": body,
                "draft": draft,
                "prerelease": prerelease,
                "discussion_category_name": discussion_category_name,
                "generate_release_notes": generate_release_notes,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Release,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        return self._github.request(
            "GET",
            url,
            response_model=ReleaseAsset,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ReleaseAsset,
            error_models={
                "404": BasicError,
            },
        )

    def delete_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        name: Union[Unset, str] = UNSET,
        label: Union[Unset, str] = UNSET,
        state: Union[Unset, str] = UNSET,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        json = ReposOwnerRepoReleasesAssetsAssetIdPatchBody(
            **{
                "name": name,
                "label": label,
                "state": state,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ReleaseAsset,
        )

    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        name: Union[Unset, str] = UNSET,
        label: Union[Unset, str] = UNSET,
        state: Union[Unset, str] = UNSET,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        json = ReposOwnerRepoReleasesAssetsAssetIdPatchBody(
            **{
                "name": name,
                "label": label,
                "state": state,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ReleaseAsset,
        )

    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        tag_name: str,
        target_commitish: Union[Unset, str] = UNSET,
        previous_tag_name: Union[Unset, str] = UNSET,
        configuration_file_path: Union[Unset, str] = UNSET,
    ) -> "Response[ReleaseNotesContent]":
        url = f"/repos/{owner}/{repo}/releases/generate-notes"

        json = ReposOwnerRepoReleasesGenerateNotesPostBody(
            **{
                "tag_name": tag_name,
                "target_commitish": target_commitish,
                "previous_tag_name": previous_tag_name,
                "configuration_file_path": configuration_file_path,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ReleaseNotesContent,
            error_models={
                "404": BasicError,
            },
        )

    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        tag_name: str,
        target_commitish: Union[Unset, str] = UNSET,
        previous_tag_name: Union[Unset, str] = UNSET,
        configuration_file_path: Union[Unset, str] = UNSET,
    ) -> "Response[ReleaseNotesContent]":
        url = f"/repos/{owner}/{repo}/releases/generate-notes"

        json = ReposOwnerRepoReleasesGenerateNotesPostBody(
            **{
                "tag_name": tag_name,
                "target_commitish": target_commitish,
                "previous_tag_name": previous_tag_name,
                "configuration_file_path": configuration_file_path,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ReleaseNotesContent,
            error_models={
                "404": BasicError,
            },
        )

    def get_latest_release(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/latest"

        return self._github.request(
            "GET",
            url,
            response_model=Release,
        )

    async def async_get_latest_release(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/latest"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Release,
        )

    def get_release_by_tag(
        self,
        owner: str,
        repo: str,
        tag: str,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/tags/{tag}"

        return self._github.request(
            "GET",
            url,
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release_by_tag(
        self,
        owner: str,
        repo: str,
        tag: str,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/tags/{tag}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def get_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def delete_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        tag_name: Union[Unset, str] = UNSET,
        target_commitish: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
        draft: Union[Unset, bool] = UNSET,
        prerelease: Union[Unset, bool] = UNSET,
        discussion_category_name: Union[Unset, str] = UNSET,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        json = ReposOwnerRepoReleasesReleaseIdPatchBody(
            **{
                "tag_name": tag_name,
                "target_commitish": target_commitish,
                "name": name,
                "body": body,
                "draft": draft,
                "prerelease": prerelease,
                "discussion_category_name": discussion_category_name,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        tag_name: Union[Unset, str] = UNSET,
        target_commitish: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
        draft: Union[Unset, bool] = UNSET,
        prerelease: Union[Unset, bool] = UNSET,
        discussion_category_name: Union[Unset, str] = UNSET,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        json = ReposOwnerRepoReleasesReleaseIdPatchBody(
            **{
                "tag_name": tag_name,
                "target_commitish": target_commitish,
                "name": name,
                "body": body,
                "draft": draft,
                "prerelease": prerelease,
                "discussion_category_name": discussion_category_name,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def list_release_assets(
        self,
        owner: str,
        repo: str,
        release_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ReleaseAsset]]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ReleaseAsset],
        )

    async def async_list_release_assets(
        self,
        owner: str,
        repo: str,
        release_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ReleaseAsset]]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ReleaseAsset],
        )

    def upload_release_asset(
        self,
        owner: str,
        repo: str,
        release_id: int,
        name: str,
        label: Union[Unset, str] = UNSET,
        *,
        body: Union[Unset, str] = UNSET,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "name": name,
            "label": label,
        }

        content = body

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(params),
            content=exclude_unset(content),
            response_model=ReleaseAsset,
            error_models={},
        )

    async def async_upload_release_asset(
        self,
        owner: str,
        repo: str,
        release_id: int,
        name: str,
        label: Union[Unset, str] = UNSET,
        *,
        body: Union[Unset, str] = UNSET,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "name": name,
            "label": label,
        }

        content = body

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(params),
            content=exclude_unset(content),
            response_model=ReleaseAsset,
            error_models={},
        )

    def get_code_frequency_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[List[int]]]":
        url = f"/repos/{owner}/{repo}/stats/code_frequency"

        return self._github.request(
            "GET",
            url,
            response_model=List[List[int]],
        )

    async def async_get_code_frequency_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[List[int]]]":
        url = f"/repos/{owner}/{repo}/stats/code_frequency"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[List[int]],
        )

    def get_commit_activity_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[CommitActivity]]":
        url = f"/repos/{owner}/{repo}/stats/commit_activity"

        return self._github.request(
            "GET",
            url,
            response_model=List[CommitActivity],
        )

    async def async_get_commit_activity_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[CommitActivity]]":
        url = f"/repos/{owner}/{repo}/stats/commit_activity"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[CommitActivity],
        )

    def get_contributors_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[ContributorActivity]]":
        url = f"/repos/{owner}/{repo}/stats/contributors"

        return self._github.request(
            "GET",
            url,
            response_model=List[ContributorActivity],
        )

    async def async_get_contributors_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[ContributorActivity]]":
        url = f"/repos/{owner}/{repo}/stats/contributors"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[ContributorActivity],
        )

    def get_participation_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ParticipationStats]":
        url = f"/repos/{owner}/{repo}/stats/participation"

        return self._github.request(
            "GET",
            url,
            response_model=ParticipationStats,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_participation_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ParticipationStats]":
        url = f"/repos/{owner}/{repo}/stats/participation"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ParticipationStats,
            error_models={
                "404": BasicError,
            },
        )

    def get_punch_card_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[List[int]]]":
        url = f"/repos/{owner}/{repo}/stats/punch_card"

        return self._github.request(
            "GET",
            url,
            response_model=List[List[int]],
        )

    async def async_get_punch_card_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[List[int]]]":
        url = f"/repos/{owner}/{repo}/stats/punch_card"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[List[int]],
        )

    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        state: Literal["error", "failure", "pending", "success"],
        target_url: Union[Unset, Union[str, None]] = UNSET,
        description: Union[Unset, Union[str, None]] = UNSET,
        context: Union[Unset, str] = "default",
    ) -> "Response[Status]":
        url = f"/repos/{owner}/{repo}/statuses/{sha}"

        json = ReposOwnerRepoStatusesShaPostBody(
            **{
                "state": state,
                "target_url": target_url,
                "description": description,
                "context": context,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Status,
        )

    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        state: Literal["error", "failure", "pending", "success"],
        target_url: Union[Unset, Union[str, None]] = UNSET,
        description: Union[Unset, Union[str, None]] = UNSET,
        context: Union[Unset, str] = "default",
    ) -> "Response[Status]":
        url = f"/repos/{owner}/{repo}/statuses/{sha}"

        json = ReposOwnerRepoStatusesShaPostBody(
            **{
                "state": state,
                "target_url": target_url,
                "description": description,
                "context": context,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Status,
        )

    def list_tags(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Tag]]":
        url = f"/repos/{owner}/{repo}/tags"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Tag],
        )

    async def async_list_tags(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Tag]]":
        url = f"/repos/{owner}/{repo}/tags"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Tag],
        )

    def list_tag_protection(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[TagProtection]]":
        url = f"/repos/{owner}/{repo}/tags/protection"

        return self._github.request(
            "GET",
            url,
            response_model=List[TagProtection],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_tag_protection(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[TagProtection]]":
        url = f"/repos/{owner}/{repo}/tags/protection"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[TagProtection],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        pattern: str,
    ) -> "Response[TagProtection]":
        url = f"/repos/{owner}/{repo}/tags/protection"

        json = ReposOwnerRepoTagsProtectionPostBody(
            **{
                "pattern": pattern,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TagProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        pattern: str,
    ) -> "Response[TagProtection]":
        url = f"/repos/{owner}/{repo}/tags/protection"

        json = ReposOwnerRepoTagsProtectionPostBody(
            **{
                "pattern": pattern,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TagProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_tag_protection(
        self,
        owner: str,
        repo: str,
        tag_protection_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/tags/protection/{tag_protection_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_tag_protection(
        self,
        owner: str,
        repo: str,
        tag_protection_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/tags/protection/{tag_protection_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def download_tarball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/tarball/{ref}"

        return self._github.request(
            "GET",
            url,
        )

    async def async_download_tarball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/tarball/{ref}"

        return await self._github.arequest(
            "GET",
            url,
        )

    def list_teams(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Team],
        )

    async def async_list_teams(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Team],
        )

    def get_all_topics(
        self,
        owner: str,
        repo: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[Topic]":
        url = f"/repos/{owner}/{repo}/topics"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Topic,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_topics(
        self,
        owner: str,
        repo: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[Topic]":
        url = f"/repos/{owner}/{repo}/topics"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Topic,
            error_models={
                "404": BasicError,
            },
        )

    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        names: List[str],
    ) -> "Response[Topic]":
        url = f"/repos/{owner}/{repo}/topics"

        json = ReposOwnerRepoTopicsPutBody(
            **{
                "names": names,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Topic,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        names: List[str],
    ) -> "Response[Topic]":
        url = f"/repos/{owner}/{repo}/topics"

        json = ReposOwnerRepoTopicsPutBody(
            **{
                "names": names,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Topic,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_clones(
        self,
        owner: str,
        repo: str,
        per: Union[Unset, Literal["", "day", "week"]] = "day",
    ) -> "Response[CloneTraffic]":
        url = f"/repos/{owner}/{repo}/traffic/clones"

        params = {
            "per": per,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CloneTraffic,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_clones(
        self,
        owner: str,
        repo: str,
        per: Union[Unset, Literal["", "day", "week"]] = "day",
    ) -> "Response[CloneTraffic]":
        url = f"/repos/{owner}/{repo}/traffic/clones"

        params = {
            "per": per,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CloneTraffic,
            error_models={
                "403": BasicError,
            },
        )

    def get_top_paths(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[ContentTraffic]]":
        url = f"/repos/{owner}/{repo}/traffic/popular/paths"

        return self._github.request(
            "GET",
            url,
            response_model=List[ContentTraffic],
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_top_paths(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[ContentTraffic]]":
        url = f"/repos/{owner}/{repo}/traffic/popular/paths"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[ContentTraffic],
            error_models={
                "403": BasicError,
            },
        )

    def get_top_referrers(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[ReferrerTraffic]]":
        url = f"/repos/{owner}/{repo}/traffic/popular/referrers"

        return self._github.request(
            "GET",
            url,
            response_model=List[ReferrerTraffic],
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_top_referrers(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[ReferrerTraffic]]":
        url = f"/repos/{owner}/{repo}/traffic/popular/referrers"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[ReferrerTraffic],
            error_models={
                "403": BasicError,
            },
        )

    def get_views(
        self,
        owner: str,
        repo: str,
        per: Union[Unset, Literal["", "day", "week"]] = "day",
    ) -> "Response[ViewTraffic]":
        url = f"/repos/{owner}/{repo}/traffic/views"

        params = {
            "per": per,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ViewTraffic,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_views(
        self,
        owner: str,
        repo: str,
        per: Union[Unset, Literal["", "day", "week"]] = "day",
    ) -> "Response[ViewTraffic]":
        url = f"/repos/{owner}/{repo}/traffic/views"

        params = {
            "per": per,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ViewTraffic,
            error_models={
                "403": BasicError,
            },
        )

    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        new_owner: str,
        team_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[MinimalRepository]":
        url = f"/repos/{owner}/{repo}/transfer"

        json = ReposOwnerRepoTransferPostBody(
            **{
                "new_owner": new_owner,
                "team_ids": team_ids,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=MinimalRepository,
        )

    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        new_owner: str,
        team_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[MinimalRepository]":
        url = f"/repos/{owner}/{repo}/transfer"

        json = ReposOwnerRepoTransferPostBody(
            **{
                "new_owner": new_owner,
                "team_ids": team_ids,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=MinimalRepository,
        )

    def check_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        return self._github.request(
            "GET",
            url,
            error_models={},
        )

    async def async_check_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        return await self._github.arequest(
            "GET",
            url,
            error_models={},
        )

    def enable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_enable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def disable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_disable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def download_zipball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/zipball/{ref}"

        return self._github.request(
            "GET",
            url,
        )

    async def async_download_zipball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/zipball/{ref}"

        return await self._github.arequest(
            "GET",
            url,
        )

    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        owner: Union[Unset, str] = UNSET,
        name: str,
        description: Union[Unset, str] = UNSET,
        include_all_branches: Union[Unset, bool] = False,
        private: Union[Unset, bool] = False,
    ) -> "Response[Repository]":
        url = f"/repos/{template_owner}/{template_repo}/generate"

        json = ReposTemplateOwnerTemplateRepoGeneratePostBody(
            **{
                "owner": owner,
                "name": name,
                "description": description,
                "include_all_branches": include_all_branches,
                "private": private,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Repository,
        )

    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        owner: Union[Unset, str] = UNSET,
        name: str,
        description: Union[Unset, str] = UNSET,
        include_all_branches: Union[Unset, bool] = False,
        private: Union[Unset, bool] = False,
    ) -> "Response[Repository]":
        url = f"/repos/{template_owner}/{template_repo}/generate"

        json = ReposTemplateOwnerTemplateRepoGeneratePostBody(
            **{
                "owner": owner,
                "name": name,
                "description": description,
                "include_all_branches": include_all_branches,
                "private": private,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Repository,
        )

    def list_public(
        self,
        since: Union[Unset, int] = UNSET,
    ) -> "Response[List[MinimalRepository]]":
        url = "/repositories"

        params = {
            "since": since,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_public(
        self,
        since: Union[Unset, int] = UNSET,
    ) -> "Response[List[MinimalRepository]]":
        url = "/repositories"

        params = {
            "since": since,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        visibility: Union[Unset, Literal["all", "public", "private"]] = "all",
        affiliation: Union[Unset, str] = "owner,collaborator,organization_member",
        type: Union[
            Unset, Literal["all", "owner", "public", "private", "member"]
        ] = "all",
        sort: Union[
            Unset, Literal["created", "updated", "pushed", "full_name"]
        ] = "full_name",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        since: Union[Unset, datetime] = UNSET,
        before: Union[Unset, datetime] = UNSET,
    ) -> "Response[List[Repository]]":
        url = "/user/repos"

        params = {
            "visibility": visibility,
            "affiliation": affiliation,
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "since": since,
            "before": before,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Repository],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        visibility: Union[Unset, Literal["all", "public", "private"]] = "all",
        affiliation: Union[Unset, str] = "owner,collaborator,organization_member",
        type: Union[
            Unset, Literal["all", "owner", "public", "private", "member"]
        ] = "all",
        sort: Union[
            Unset, Literal["created", "updated", "pushed", "full_name"]
        ] = "full_name",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        since: Union[Unset, datetime] = UNSET,
        before: Union[Unset, datetime] = UNSET,
    ) -> "Response[List[Repository]]":
        url = "/user/repos"

        params = {
            "visibility": visibility,
            "affiliation": affiliation,
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "since": since,
            "before": before,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Repository],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def create_for_authenticated_user(
        self,
        *,
        name: str,
        description: Union[Unset, str] = UNSET,
        homepage: Union[Unset, str] = UNSET,
        private: Union[Unset, bool] = False,
        has_issues: Union[Unset, bool] = True,
        has_projects: Union[Unset, bool] = True,
        has_wiki: Union[Unset, bool] = True,
        team_id: Union[Unset, int] = UNSET,
        auto_init: Union[Unset, bool] = False,
        gitignore_template: Union[Unset, str] = UNSET,
        license_template: Union[Unset, str] = UNSET,
        allow_squash_merge: Union[Unset, bool] = True,
        allow_merge_commit: Union[Unset, bool] = True,
        allow_rebase_merge: Union[Unset, bool] = True,
        allow_auto_merge: Union[Unset, bool] = False,
        delete_branch_on_merge: Union[Unset, bool] = False,
        has_downloads: Union[Unset, bool] = True,
        is_template: Union[Unset, bool] = False,
    ) -> "Response[Repository]":
        url = "/user/repos"

        json = UserReposPostBody(
            **{
                "name": name,
                "description": description,
                "homepage": homepage,
                "private": private,
                "has_issues": has_issues,
                "has_projects": has_projects,
                "has_wiki": has_wiki,
                "team_id": team_id,
                "auto_init": auto_init,
                "gitignore_template": gitignore_template,
                "license_template": license_template,
                "allow_squash_merge": allow_squash_merge,
                "allow_merge_commit": allow_merge_commit,
                "allow_rebase_merge": allow_rebase_merge,
                "allow_auto_merge": allow_auto_merge,
                "delete_branch_on_merge": delete_branch_on_merge,
                "has_downloads": has_downloads,
                "is_template": is_template,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Repository,
            error_models={
                "401": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "400": BasicError,
            },
        )

    async def async_create_for_authenticated_user(
        self,
        *,
        name: str,
        description: Union[Unset, str] = UNSET,
        homepage: Union[Unset, str] = UNSET,
        private: Union[Unset, bool] = False,
        has_issues: Union[Unset, bool] = True,
        has_projects: Union[Unset, bool] = True,
        has_wiki: Union[Unset, bool] = True,
        team_id: Union[Unset, int] = UNSET,
        auto_init: Union[Unset, bool] = False,
        gitignore_template: Union[Unset, str] = UNSET,
        license_template: Union[Unset, str] = UNSET,
        allow_squash_merge: Union[Unset, bool] = True,
        allow_merge_commit: Union[Unset, bool] = True,
        allow_rebase_merge: Union[Unset, bool] = True,
        allow_auto_merge: Union[Unset, bool] = False,
        delete_branch_on_merge: Union[Unset, bool] = False,
        has_downloads: Union[Unset, bool] = True,
        is_template: Union[Unset, bool] = False,
    ) -> "Response[Repository]":
        url = "/user/repos"

        json = UserReposPostBody(
            **{
                "name": name,
                "description": description,
                "homepage": homepage,
                "private": private,
                "has_issues": has_issues,
                "has_projects": has_projects,
                "has_wiki": has_wiki,
                "team_id": team_id,
                "auto_init": auto_init,
                "gitignore_template": gitignore_template,
                "license_template": license_template,
                "allow_squash_merge": allow_squash_merge,
                "allow_merge_commit": allow_merge_commit,
                "allow_rebase_merge": allow_rebase_merge,
                "allow_auto_merge": allow_auto_merge,
                "delete_branch_on_merge": delete_branch_on_merge,
                "has_downloads": has_downloads,
                "is_template": is_template,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Repository,
            error_models={
                "401": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "400": BasicError,
            },
        )

    def list_invitations_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[RepositoryInvitation]]":
        url = "/user/repository_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[RepositoryInvitation],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_invitations_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[RepositoryInvitation]]":
        url = "/user/repository_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[RepositoryInvitation],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def decline_invitation_for_authenticated_user(
        self,
        invitation_id: int,
    ) -> "Response":
        url = f"/user/repository_invitations/{invitation_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "409": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_decline_invitation_for_authenticated_user(
        self,
        invitation_id: int,
    ) -> "Response":
        url = f"/user/repository_invitations/{invitation_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "409": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def accept_invitation_for_authenticated_user(
        self,
        invitation_id: int,
    ) -> "Response":
        url = f"/user/repository_invitations/{invitation_id}"

        return self._github.request(
            "PATCH",
            url,
            error_models={
                "403": BasicError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    async def async_accept_invitation_for_authenticated_user(
        self,
        invitation_id: int,
    ) -> "Response":
        url = f"/user/repository_invitations/{invitation_id}"

        return await self._github.arequest(
            "PATCH",
            url,
            error_models={
                "403": BasicError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        type: Union[Unset, Literal["all", "owner", "member"]] = "owner",
        sort: Union[
            Unset, Literal["created", "updated", "pushed", "full_name"]
        ] = "full_name",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/users/{username}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
        )

    async def async_list_for_user(
        self,
        username: str,
        type: Union[Unset, Literal["all", "owner", "member"]] = "owner",
        sort: Union[
            Unset, Literal["created", "updated", "pushed", "full_name"]
        ] = "full_name",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/users/{username}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
        )
