"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, Any, List, Union, Literal

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    ReposOwnerRepoPullsPostBodyType,
    ReposOwnerRepoPullsPullNumberPatchBodyType,
    ReposOwnerRepoPullsPullNumberMergePutBodyType,
    ReposOwnerRepoPullsPullNumberReviewsPostBodyType,
    ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
    ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
    ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType,
    ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
    ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
    ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
    ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
    ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType,
    ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
)
from .models import (
    Commit,
    DiffEntry,
    BasicError,
    PullRequest,
    ReviewComment,
    ValidationError,
    PullRequestReview,
    PullRequestSimple,
    ValidationErrorSimple,
    PullRequestMergeResult,
    PullRequestReviewComment,
    PullRequestReviewRequest,
    ReposOwnerRepoPullsPostBody,
    ReposOwnerRepoPullsPullNumberPatchBody,
    ReposOwnerRepoPullsPullNumberMergePutBody,
    ReposOwnerRepoPullsPullNumberReviewsPostBody,
    ReposOwnerRepoPullsCommentsCommentIdPatchBody,
    ReposOwnerRepoPullsPullNumberCommentsPostBody,
    ReposOwnerRepoPullsPullNumberMergePutResponse405,
    ReposOwnerRepoPullsPullNumberMergePutResponse409,
    ReposOwnerRepoPullsPullNumberUpdateBranchPutBody,
    ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody,
    ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
    ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody,
    ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody,
    ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody,
    ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class PullsClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list(
        self,
        owner: str,
        repo: str,
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        head: Union[Unset, str] = UNSET,
        base: Union[Unset, str] = UNSET,
        sort: Union[
            Unset, Literal["created", "updated", "popularity", "long-running"]
        ] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PullRequestSimple]]":
        url = f"/repos/{owner}/{repo}/pulls"

        params = {
            "state": state,
            "head": head,
            "base": base,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PullRequestSimple],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list(
        self,
        owner: str,
        repo: str,
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        head: Union[Unset, str] = UNSET,
        base: Union[Unset, str] = UNSET,
        sort: Union[
            Unset, Literal["created", "updated", "popularity", "long-running"]
        ] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PullRequestSimple]]":
        url = f"/repos/{owner}/{repo}/pulls"

        params = {
            "state": state,
            "head": head,
            "base": base,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PullRequestSimple],
            error_models={
                "422": ValidationError,
            },
        )

    def create(
        self,
        owner: str,
        repo: str,
        *,
        title: Union[Unset, str] = UNSET,
        head: str,
        base: str,
        body: Union[Unset, str] = UNSET,
        maintainer_can_modify: Union[Unset, bool] = UNSET,
        draft: Union[Unset, bool] = UNSET,
        issue: Union[Unset, int] = UNSET,
    ) -> "Response[PullRequest]":
        url = f"/repos/{owner}/{repo}/pulls"

        json = ReposOwnerRepoPullsPostBody(
            **{
                "title": title,
                "head": head,
                "base": base,
                "body": body,
                "maintainer_can_modify": maintainer_can_modify,
                "draft": draft,
                "issue": issue,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PullRequest,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        title: Union[Unset, str] = UNSET,
        head: str,
        base: str,
        body: Union[Unset, str] = UNSET,
        maintainer_can_modify: Union[Unset, bool] = UNSET,
        draft: Union[Unset, bool] = UNSET,
        issue: Union[Unset, int] = UNSET,
    ) -> "Response[PullRequest]":
        url = f"/repos/{owner}/{repo}/pulls"

        json = ReposOwnerRepoPullsPostBody(
            **{
                "title": title,
                "head": head,
                "base": base,
                "body": body,
                "maintainer_can_modify": maintainer_can_modify,
                "draft": draft,
                "issue": issue,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PullRequest,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_review_comments_for_repo(
        self,
        owner: str,
        repo: str,
        sort: Union[Unset, Literal["created", "updated", "created_at"]] = UNSET,
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PullRequestReviewComment]]":
        url = f"/repos/{owner}/{repo}/pulls/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PullRequestReviewComment],
        )

    async def async_list_review_comments_for_repo(
        self,
        owner: str,
        repo: str,
        sort: Union[Unset, Literal["created", "updated", "created_at"]] = UNSET,
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PullRequestReviewComment]]":
        url = f"/repos/{owner}/{repo}/pulls/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PullRequestReviewComment],
        )

    def get_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        return self._github.request(
            "GET",
            url,
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        body: str,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        json = ReposOwnerRepoPullsCommentsCommentIdPatchBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReviewComment,
        )

    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        body: str,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        json = ReposOwnerRepoPullsCommentsCommentIdPatchBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReviewComment,
        )

    def get(
        self,
        owner: str,
        repo: str,
        pull_number: int,
    ) -> "Response[PullRequest]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        return self._github.request(
            "GET",
            url,
            response_model=PullRequest,
            error_models={
                "500": BasicError,
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        pull_number: int,
    ) -> "Response[PullRequest]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=PullRequest,
            error_models={
                "500": BasicError,
                "404": BasicError,
            },
        )

    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        title: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
        state: Union[Unset, Literal["open", "closed"]] = UNSET,
        base: Union[Unset, str] = UNSET,
        maintainer_can_modify: Union[Unset, bool] = UNSET,
    ) -> "Response[PullRequest]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        json = ReposOwnerRepoPullsPullNumberPatchBody(
            **{
                "title": title,
                "body": body,
                "state": state,
                "base": base,
                "maintainer_can_modify": maintainer_can_modify,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=PullRequest,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        title: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
        state: Union[Unset, Literal["open", "closed"]] = UNSET,
        base: Union[Unset, str] = UNSET,
        maintainer_can_modify: Union[Unset, bool] = UNSET,
    ) -> "Response[PullRequest]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        json = ReposOwnerRepoPullsPullNumberPatchBody(
            **{
                "title": title,
                "body": body,
                "state": state,
                "base": base,
                "maintainer_can_modify": maintainer_can_modify,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=PullRequest,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_review_comments(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        sort: Union[Unset, Literal["created", "updated"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PullRequestReviewComment]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PullRequestReviewComment],
        )

    async def async_list_review_comments(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        sort: Union[Unset, Literal["created", "updated"]] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        since: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PullRequestReviewComment]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PullRequestReviewComment],
        )

    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        body: str,
        commit_id: Union[Unset, str] = UNSET,
        path: Union[Unset, str] = UNSET,
        position: Union[Unset, int] = UNSET,
        side: Union[Unset, Literal["LEFT", "RIGHT"]] = UNSET,
        line: Union[Unset, int] = UNSET,
        start_line: Union[Unset, int] = UNSET,
        start_side: Union[Unset, Literal["LEFT", "RIGHT", "side"]] = UNSET,
        in_reply_to: Union[Unset, int] = UNSET,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        json = ReposOwnerRepoPullsPullNumberCommentsPostBody(
            **{
                "body": body,
                "commit_id": commit_id,
                "path": path,
                "position": position,
                "side": side,
                "line": line,
                "start_line": start_line,
                "start_side": start_side,
                "in_reply_to": in_reply_to,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReviewComment,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        body: str,
        commit_id: Union[Unset, str] = UNSET,
        path: Union[Unset, str] = UNSET,
        position: Union[Unset, int] = UNSET,
        side: Union[Unset, Literal["LEFT", "RIGHT"]] = UNSET,
        line: Union[Unset, int] = UNSET,
        start_line: Union[Unset, int] = UNSET,
        start_side: Union[Unset, Literal["LEFT", "RIGHT", "side"]] = UNSET,
        in_reply_to: Union[Unset, int] = UNSET,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        json = ReposOwnerRepoPullsPullNumberCommentsPostBody(
            **{
                "body": body,
                "commit_id": commit_id,
                "path": path,
                "position": position,
                "side": side,
                "line": line,
                "start_line": start_line,
                "start_side": start_side,
                "in_reply_to": in_reply_to,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReviewComment,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        body: str,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies"

        json = ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        body: str,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies"

        json = ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Commit]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Commit],
        )

    async def async_list_commits(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Commit]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Commit],
        )

    def list_files(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[DiffEntry]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/files"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[DiffEntry],
            error_models={
                "422": ValidationError,
                "500": BasicError,
            },
        )

    async def async_list_files(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[DiffEntry]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/files"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[DiffEntry],
            error_models={
                "422": ValidationError,
                "500": BasicError,
            },
        )

    def check_if_merged(
        self,
        owner: str,
        repo: str,
        pull_number: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        return self._github.request(
            "GET",
            url,
            error_models={},
        )

    async def async_check_if_merged(
        self,
        owner: str,
        repo: str,
        pull_number: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        return await self._github.arequest(
            "GET",
            url,
            error_models={},
        )

    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        body: Union[
            Unset, Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
    ) -> "Response[PullRequestMergeResult]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        json = body

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=PullRequestMergeResult,
            error_models={
                "405": ReposOwnerRepoPullsPullNumberMergePutResponse405,
                "409": ReposOwnerRepoPullsPullNumberMergePutResponse409,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        body: Union[
            Unset, Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
    ) -> "Response[PullRequestMergeResult]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        json = body

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=PullRequestMergeResult,
            error_models={
                "405": ReposOwnerRepoPullsPullNumberMergePutResponse405,
                "409": ReposOwnerRepoPullsPullNumberMergePutResponse409,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[PullRequestReviewRequest]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=PullRequestReviewRequest,
        )

    async def async_list_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[PullRequestReviewRequest]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=PullRequestReviewRequest,
        )

    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        body: Union[Unset, Union[Any, Any]] = UNSET,
    ) -> "Response[PullRequestSimple]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PullRequestSimple,
            error_models={
                "403": BasicError,
            },
        )

    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        body: Union[Unset, Union[Any, Any]] = UNSET,
    ) -> "Response[PullRequestSimple]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PullRequestSimple,
            error_models={
                "403": BasicError,
            },
        )

    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        reviewers: List[str],
        team_reviewers: Union[Unset, List[str]] = UNSET,
    ) -> "Response[PullRequestSimple]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        json = ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody(
            **{
                "reviewers": reviewers,
                "team_reviewers": team_reviewers,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=PullRequestSimple,
            error_models={
                "422": ValidationError,
            },
        )

    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        reviewers: List[str],
        team_reviewers: Union[Unset, List[str]] = UNSET,
    ) -> "Response[PullRequestSimple]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        json = ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody(
            **{
                "reviewers": reviewers,
                "team_reviewers": team_reviewers,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=PullRequestSimple,
            error_models={
                "422": ValidationError,
            },
        )

    def list_reviews(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PullRequestReview]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PullRequestReview],
        )

    async def async_list_reviews(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PullRequestReview]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PullRequestReview],
        )

    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        commit_id: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
        event: Union[Unset, Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]] = UNSET,
        comments: Union[
            Unset,
            List[ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType],
        ] = UNSET,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        json = ReposOwnerRepoPullsPullNumberReviewsPostBody(
            **{
                "commit_id": commit_id,
                "body": body,
                "event": event,
                "comments": comments,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        commit_id: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
        event: Union[Unset, Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]] = UNSET,
        comments: Union[
            Unset,
            List[ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType],
        ] = UNSET,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        json = ReposOwnerRepoPullsPullNumberReviewsPostBody(
            **{
                "commit_id": commit_id,
                "body": body,
                "event": event,
                "comments": comments,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    def get_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        return self._github.request(
            "GET",
            url,
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
            },
        )

    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        body: str,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        json = ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        body: str,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        json = ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody(
            **{
                "body": body,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    def delete_pending_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        return self._github.request(
            "DELETE",
            url,
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    async def async_delete_pending_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    def list_comments_for_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ReviewComment]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ReviewComment],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_comments_for_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ReviewComment]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ReviewComment],
            error_models={
                "404": BasicError,
            },
        )

    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        message: str,
        event: Union[Unset, Literal["DISMISS"]] = UNSET,
    ) -> "Response[PullRequestReview]":
        url = (
            f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals"
        )

        json = ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody(
            **{
                "message": message,
                "event": event,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        message: str,
        event: Union[Unset, Literal["DISMISS"]] = UNSET,
    ) -> "Response[PullRequestReview]":
        url = (
            f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals"
        )

        json = ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody(
            **{
                "message": message,
                "event": event,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        body: Union[Unset, str] = UNSET,
        event: Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"],
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events"

        json = ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody(
            **{
                "body": body,
                "event": event,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        body: Union[Unset, str] = UNSET,
        event: Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"],
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events"

        json = ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody(
            **{
                "body": body,
                "event": event,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        body: Union[
            Unset, Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
    ) -> "Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/update-branch"

        json = body

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        body: Union[
            Unset, Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
    ) -> "Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/update-branch"

        json = body

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )
