"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union, Literal

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    UserProjectsPostBodyType,
    OrgsOrgProjectsPostBodyType,
    ProjectsProjectIdPatchBodyType,
    ReposOwnerRepoProjectsPostBodyType,
    ProjectsColumnsColumnIdPatchBodyType,
    ProjectsProjectIdColumnsPostBodyType,
    ProjectsColumnsCardsCardIdPatchBodyType,
    ProjectsColumnsColumnIdMovesPostBodyType,
    ProjectsColumnsCardsCardIdMovesPostBodyType,
    ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
    ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
    ProjectsProjectIdCollaboratorsUsernamePutBodyType,
)
from .models import (
    Project,
    BasicError,
    SimpleUser,
    ProjectCard,
    ProjectColumn,
    ValidationError,
    UserProjectsPostBody,
    ValidationErrorSimple,
    OrgsOrgProjectsPostBody,
    ProjectsProjectIdPatchBody,
    ProjectCollaboratorPermission,
    ReposOwnerRepoProjectsPostBody,
    ProjectsColumnsColumnIdPatchBody,
    ProjectsProjectIdColumnsPostBody,
    ProjectsProjectIdPatchResponse403,
    ProjectsProjectIdDeleteResponse403,
    ProjectsColumnsCardsCardIdPatchBody,
    ProjectsColumnsColumnIdMovesPostBody,
    ProjectsColumnsCardsCardIdMovesPostBody,
    ProjectsColumnsColumnIdCardsPostBodyOneof0,
    ProjectsColumnsColumnIdCardsPostBodyOneof1,
    ProjectsColumnsCardsCardIdDeleteResponse403,
    ProjectsColumnsColumnIdCardsPostResponse503,
    ProjectsColumnsColumnIdMovesPostResponse201,
    ProjectsProjectIdCollaboratorsUsernamePutBody,
    ProjectsColumnsCardsCardIdMovesPostResponse201,
    ProjectsColumnsCardsCardIdMovesPostResponse403,
    ProjectsColumnsCardsCardIdMovesPostResponse503,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class ProjectsClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_for_org(
        self,
        org: str,
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Project]]":
        url = f"/orgs/{org}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Project],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_for_org(
        self,
        org: str,
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Project]]":
        url = f"/orgs/{org}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Project],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    def create_for_org(
        self,
        org: str,
        *,
        name: str,
        body: Union[Unset, str] = UNSET,
    ) -> "Response[Project]":
        url = f"/orgs/{org}/projects"

        json = OrgsOrgProjectsPostBody(
            **{
                "name": name,
                "body": body,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_create_for_org(
        self,
        org: str,
        *,
        name: str,
        body: Union[Unset, str] = UNSET,
    ) -> "Response[Project]":
        url = f"/orgs/{org}/projects"

        json = OrgsOrgProjectsPostBody(
            **{
                "name": name,
                "body": body,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_card(
        self,
        card_id: int,
    ) -> "Response[ProjectCard]":
        url = f"/projects/columns/cards/{card_id}"

        return self._github.request(
            "GET",
            url,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_card(
        self,
        card_id: int,
    ) -> "Response[ProjectCard]":
        url = f"/projects/columns/cards/{card_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    def delete_card(
        self,
        card_id: int,
    ) -> "Response":
        url = f"/projects/columns/cards/{card_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": ProjectsColumnsCardsCardIdDeleteResponse403,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_card(
        self,
        card_id: int,
    ) -> "Response":
        url = f"/projects/columns/cards/{card_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": ProjectsColumnsCardsCardIdDeleteResponse403,
                "401": BasicError,
                "404": BasicError,
            },
        )

    def update_card(
        self,
        card_id: int,
        *,
        note: Union[Unset, Union[str, None]] = UNSET,
        archived: Union[Unset, bool] = UNSET,
    ) -> "Response[ProjectCard]":
        url = f"/projects/columns/cards/{card_id}"

        json = ProjectsColumnsCardsCardIdPatchBody(
            **{
                "note": note,
                "archived": archived,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_update_card(
        self,
        card_id: int,
        *,
        note: Union[Unset, Union[str, None]] = UNSET,
        archived: Union[Unset, bool] = UNSET,
    ) -> "Response[ProjectCard]":
        url = f"/projects/columns/cards/{card_id}"

        json = ProjectsColumnsCardsCardIdPatchBody(
            **{
                "note": note,
                "archived": archived,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def move_card(
        self,
        card_id: int,
        *,
        position: str,
        column_id: Union[Unset, int] = UNSET,
    ) -> "Response[ProjectsColumnsCardsCardIdMovesPostResponse201]":
        url = f"/projects/columns/cards/{card_id}/moves"

        json = ProjectsColumnsCardsCardIdMovesPostBody(
            **{
                "position": position,
                "column_id": column_id,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ProjectsColumnsCardsCardIdMovesPostResponse201,
            error_models={
                "403": ProjectsColumnsCardsCardIdMovesPostResponse403,
                "401": BasicError,
                "503": ProjectsColumnsCardsCardIdMovesPostResponse503,
                "422": ValidationError,
            },
        )

    async def async_move_card(
        self,
        card_id: int,
        *,
        position: str,
        column_id: Union[Unset, int] = UNSET,
    ) -> "Response[ProjectsColumnsCardsCardIdMovesPostResponse201]":
        url = f"/projects/columns/cards/{card_id}/moves"

        json = ProjectsColumnsCardsCardIdMovesPostBody(
            **{
                "position": position,
                "column_id": column_id,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ProjectsColumnsCardsCardIdMovesPostResponse201,
            error_models={
                "403": ProjectsColumnsCardsCardIdMovesPostResponse403,
                "401": BasicError,
                "503": ProjectsColumnsCardsCardIdMovesPostResponse503,
                "422": ValidationError,
            },
        )

    def get_column(
        self,
        column_id: int,
    ) -> "Response[ProjectColumn]":
        url = f"/projects/columns/{column_id}"

        return self._github.request(
            "GET",
            url,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_column(
        self,
        column_id: int,
    ) -> "Response[ProjectColumn]":
        url = f"/projects/columns/{column_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    def delete_column(
        self,
        column_id: int,
    ) -> "Response":
        url = f"/projects/columns/{column_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_column(
        self,
        column_id: int,
    ) -> "Response":
        url = f"/projects/columns/{column_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def update_column(
        self,
        column_id: int,
        *,
        name: str,
    ) -> "Response[ProjectColumn]":
        url = f"/projects/columns/{column_id}"

        json = ProjectsColumnsColumnIdPatchBody(
            **{
                "name": name,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_update_column(
        self,
        column_id: int,
        *,
        name: str,
    ) -> "Response[ProjectColumn]":
        url = f"/projects/columns/{column_id}"

        json = ProjectsColumnsColumnIdPatchBody(
            **{
                "name": name,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_cards(
        self,
        column_id: int,
        archived_state: Union[
            Unset, Literal["all", "archived", "not_archived"]
        ] = "not_archived",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ProjectCard]]":
        url = f"/projects/columns/{column_id}/cards"

        params = {
            "archived_state": archived_state,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ProjectCard],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_cards(
        self,
        column_id: int,
        archived_state: Union[
            Unset, Literal["all", "archived", "not_archived"]
        ] = "not_archived",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ProjectCard]]":
        url = f"/projects/columns/{column_id}/cards"

        params = {
            "archived_state": archived_state,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ProjectCard],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def create_card(
        self,
        column_id: int,
        *,
        body: Union[
            ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
            ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ],
    ) -> "Response[ProjectCard]":
        url = f"/projects/columns/{column_id}/cards"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": Union[ValidationError, ValidationErrorSimple],
                "503": ProjectsColumnsColumnIdCardsPostResponse503,
            },
        )

    async def async_create_card(
        self,
        column_id: int,
        *,
        body: Union[
            ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
            ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ],
    ) -> "Response[ProjectCard]":
        url = f"/projects/columns/{column_id}/cards"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": Union[ValidationError, ValidationErrorSimple],
                "503": ProjectsColumnsColumnIdCardsPostResponse503,
            },
        )

    def move_column(
        self,
        column_id: int,
        *,
        position: str,
    ) -> "Response[ProjectsColumnsColumnIdMovesPostResponse201]":
        url = f"/projects/columns/{column_id}/moves"

        json = ProjectsColumnsColumnIdMovesPostBody(
            **{
                "position": position,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ProjectsColumnsColumnIdMovesPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    async def async_move_column(
        self,
        column_id: int,
        *,
        position: str,
    ) -> "Response[ProjectsColumnsColumnIdMovesPostResponse201]":
        url = f"/projects/columns/{column_id}/moves"

        json = ProjectsColumnsColumnIdMovesPostBody(
            **{
                "position": position,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ProjectsColumnsColumnIdMovesPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    def get(
        self,
        project_id: int,
    ) -> "Response[Project]":
        url = f"/projects/{project_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get(
        self,
        project_id: int,
    ) -> "Response[Project]":
        url = f"/projects/{project_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete(
        self,
        project_id: int,
    ) -> "Response":
        url = f"/projects/{project_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": ProjectsProjectIdDeleteResponse403,
                "401": BasicError,
                "410": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete(
        self,
        project_id: int,
    ) -> "Response":
        url = f"/projects/{project_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": ProjectsProjectIdDeleteResponse403,
                "401": BasicError,
                "410": BasicError,
                "404": BasicError,
            },
        )

    def update(
        self,
        project_id: int,
        *,
        name: Union[Unset, str] = UNSET,
        body: Union[Unset, Union[str, None]] = UNSET,
        state: Union[Unset, str] = UNSET,
        organization_permission: Union[
            Unset, Literal["read", "write", "admin", "none"]
        ] = UNSET,
        private: Union[Unset, bool] = UNSET,
    ) -> "Response[Project]":
        url = f"/projects/{project_id}"

        json = ProjectsProjectIdPatchBody(
            **{
                "name": name,
                "body": body,
                "state": state,
                "organization_permission": organization_permission,
                "private": private,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Project,
            error_models={
                "403": ProjectsProjectIdPatchResponse403,
                "401": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_update(
        self,
        project_id: int,
        *,
        name: Union[Unset, str] = UNSET,
        body: Union[Unset, Union[str, None]] = UNSET,
        state: Union[Unset, str] = UNSET,
        organization_permission: Union[
            Unset, Literal["read", "write", "admin", "none"]
        ] = UNSET,
        private: Union[Unset, bool] = UNSET,
    ) -> "Response[Project]":
        url = f"/projects/{project_id}"

        json = ProjectsProjectIdPatchBody(
            **{
                "name": name,
                "body": body,
                "state": state,
                "organization_permission": organization_permission,
                "private": private,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Project,
            error_models={
                "403": ProjectsProjectIdPatchResponse403,
                "401": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_collaborators(
        self,
        project_id: int,
        affiliation: Union[Unset, Literal["outside", "direct", "all"]] = "all",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/projects/{project_id}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_collaborators(
        self,
        project_id: int,
        affiliation: Union[Unset, Literal["outside", "direct", "all"]] = "all",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/projects/{project_id}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        body: Union[
            Unset, Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
    ) -> "Response":
        url = f"/projects/{project_id}/collaborators/{username}"

        json = body

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        body: Union[
            Unset, Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
    ) -> "Response":
        url = f"/projects/{project_id}/collaborators/{username}"

        json = body

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def remove_collaborator(
        self,
        project_id: int,
        username: str,
    ) -> "Response":
        url = f"/projects/{project_id}/collaborators/{username}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    async def async_remove_collaborator(
        self,
        project_id: int,
        username: str,
    ) -> "Response":
        url = f"/projects/{project_id}/collaborators/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    def get_permission_for_user(
        self,
        project_id: int,
        username: str,
    ) -> "Response[ProjectCollaboratorPermission]":
        url = f"/projects/{project_id}/collaborators/{username}/permission"

        return self._github.request(
            "GET",
            url,
            response_model=ProjectCollaboratorPermission,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_permission_for_user(
        self,
        project_id: int,
        username: str,
    ) -> "Response[ProjectCollaboratorPermission]":
        url = f"/projects/{project_id}/collaborators/{username}/permission"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ProjectCollaboratorPermission,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_columns(
        self,
        project_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ProjectColumn]]":
        url = f"/projects/{project_id}/columns"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ProjectColumn],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_columns(
        self,
        project_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ProjectColumn]]":
        url = f"/projects/{project_id}/columns"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ProjectColumn],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def create_column(
        self,
        project_id: int,
        *,
        name: str,
    ) -> "Response[ProjectColumn]":
        url = f"/projects/{project_id}/columns"

        json = ProjectsProjectIdColumnsPostBody(
            **{
                "name": name,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    async def async_create_column(
        self,
        project_id: int,
        *,
        name: str,
    ) -> "Response[ProjectColumn]":
        url = f"/projects/{project_id}/columns"

        json = ProjectsProjectIdColumnsPostBody(
            **{
                "name": name,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    def list_for_repo(
        self,
        owner: str,
        repo: str,
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Project]]":
        url = f"/repos/{owner}/{repo}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Project],
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_for_repo(
        self,
        owner: str,
        repo: str,
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Project]]":
        url = f"/repos/{owner}/{repo}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Project],
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        name: str,
        body: Union[Unset, str] = UNSET,
    ) -> "Response[Project]":
        url = f"/repos/{owner}/{repo}/projects"

        json = ReposOwnerRepoProjectsPostBody(
            **{
                "name": name,
                "body": body,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        name: str,
        body: Union[Unset, str] = UNSET,
    ) -> "Response[Project]":
        url = f"/repos/{owner}/{repo}/projects"

        json = ReposOwnerRepoProjectsPostBody(
            **{
                "name": name,
                "body": body,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def create_for_authenticated_user(
        self,
        *,
        name: str,
        body: Union[Unset, Union[str, None]] = UNSET,
    ) -> "Response[Project]":
        url = "/user/projects"

        json = UserProjectsPostBody(
            **{
                "name": name,
                "body": body,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_create_for_authenticated_user(
        self,
        *,
        name: str,
        body: Union[Unset, Union[str, None]] = UNSET,
    ) -> "Response[Project]":
        url = "/user/projects"

        json = UserProjectsPostBody(
            **{
                "name": name,
                "body": body,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_for_user(
        self,
        username: str,
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Project]]":
        url = f"/users/{username}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Project],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_for_user(
        self,
        username: str,
        state: Union[Unset, Literal["open", "closed", "all"]] = "open",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Project]]":
        url = f"/users/{username}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Project],
            error_models={
                "422": ValidationError,
            },
        )
