"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List

from githubkit.utils import exclude_unset

from .types import OidcCustomSubType
from .models import BasicError, EmptyObject, OidcCustomSub

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class OidcClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get_oidc_custom_sub_template_for_org(
        self,
        org: str,
    ) -> "Response[OidcCustomSub]":
        url = f"/orgs/{org}/actions/oidc/customization/sub"

        return self._github.request(
            "GET",
            url,
            response_model=OidcCustomSub,
        )

    async def async_get_oidc_custom_sub_template_for_org(
        self,
        org: str,
    ) -> "Response[OidcCustomSub]":
        url = f"/orgs/{org}/actions/oidc/customization/sub"

        return await self._github.arequest(
            "GET",
            url,
            response_model=OidcCustomSub,
        )

    def update_oidc_custom_sub_template_for_org(
        self,
        org: str,
        *,
        include_claim_keys: List[str],
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/actions/oidc/customization/sub"

        json = OidcCustomSub(
            **{
                "include_claim_keys": include_claim_keys,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_update_oidc_custom_sub_template_for_org(
        self,
        org: str,
        *,
        include_claim_keys: List[str],
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/actions/oidc/customization/sub"

        json = OidcCustomSub(
            **{
                "include_claim_keys": include_claim_keys,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )
