"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    AuthorizationsPostBodyType,
    AuthorizationsClientsClientIdPutBodyType,
    AuthorizationsAuthorizationIdPatchBodyType,
    AuthorizationsClientsClientIdFingerprintPutBodyType,
)
from .models import (
    BasicError,
    Authorization,
    ValidationError,
    ApplicationGrant,
    AuthorizationsPostBody,
    AuthorizationsClientsClientIdPutBody,
    AuthorizationsAuthorizationIdPatchBody,
    AuthorizationsClientsClientIdFingerprintPutBody,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class OauthAuthorizationsClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_grants(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        client_id: Union[Unset, str] = UNSET,
    ) -> "Response[List[ApplicationGrant]]":
        url = "/applications/grants"

        params = {
            "per_page": per_page,
            "page": page,
            "client_id": client_id,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ApplicationGrant],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_grants(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        client_id: Union[Unset, str] = UNSET,
    ) -> "Response[List[ApplicationGrant]]":
        url = "/applications/grants"

        params = {
            "per_page": per_page,
            "page": page,
            "client_id": client_id,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ApplicationGrant],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    def get_grant(
        self,
        grant_id: int,
    ) -> "Response[ApplicationGrant]":
        url = f"/applications/grants/{grant_id}"

        return self._github.request(
            "GET",
            url,
            response_model=ApplicationGrant,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_grant(
        self,
        grant_id: int,
    ) -> "Response[ApplicationGrant]":
        url = f"/applications/grants/{grant_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ApplicationGrant,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_grant(
        self,
        grant_id: int,
    ) -> "Response":
        url = f"/applications/grants/{grant_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_grant(
        self,
        grant_id: int,
    ) -> "Response":
        url = f"/applications/grants/{grant_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_authorizations(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        client_id: Union[Unset, str] = UNSET,
    ) -> "Response[List[Authorization]]":
        url = "/authorizations"

        params = {
            "per_page": per_page,
            "page": page,
            "client_id": client_id,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Authorization],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_authorizations(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        client_id: Union[Unset, str] = UNSET,
    ) -> "Response[List[Authorization]]":
        url = "/authorizations"

        params = {
            "per_page": per_page,
            "page": page,
            "client_id": client_id,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Authorization],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    def create_authorization(
        self,
        *,
        scopes: Union[Unset, Union[List[str], None]] = UNSET,
        note: Union[Unset, str] = UNSET,
        note_url: Union[Unset, str] = UNSET,
        client_id: Union[Unset, str] = UNSET,
        client_secret: Union[Unset, str] = UNSET,
        fingerprint: Union[Unset, str] = UNSET,
    ) -> "Response[Authorization]":
        url = "/authorizations"

        json = AuthorizationsPostBody(
            **{
                "scopes": scopes,
                "note": note,
                "note_url": note_url,
                "client_id": client_id,
                "client_secret": client_secret,
                "fingerprint": fingerprint,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
                "410": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_create_authorization(
        self,
        *,
        scopes: Union[Unset, Union[List[str], None]] = UNSET,
        note: Union[Unset, str] = UNSET,
        note_url: Union[Unset, str] = UNSET,
        client_id: Union[Unset, str] = UNSET,
        client_secret: Union[Unset, str] = UNSET,
        fingerprint: Union[Unset, str] = UNSET,
    ) -> "Response[Authorization]":
        url = "/authorizations"

        json = AuthorizationsPostBody(
            **{
                "scopes": scopes,
                "note": note,
                "note_url": note_url,
                "client_id": client_id,
                "client_secret": client_secret,
                "fingerprint": fingerprint,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
                "410": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_or_create_authorization_for_app(
        self,
        client_id: str,
        *,
        client_secret: str,
        scopes: Union[Unset, Union[List[str], None]] = UNSET,
        note: Union[Unset, str] = UNSET,
        note_url: Union[Unset, str] = UNSET,
        fingerprint: Union[Unset, str] = UNSET,
    ) -> "Response[Authorization]":
        url = f"/authorizations/clients/{client_id}"

        json = AuthorizationsClientsClientIdPutBody(
            **{
                "client_secret": client_secret,
                "scopes": scopes,
                "note": note,
                "note_url": note_url,
                "fingerprint": fingerprint,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_or_create_authorization_for_app(
        self,
        client_id: str,
        *,
        client_secret: str,
        scopes: Union[Unset, Union[List[str], None]] = UNSET,
        note: Union[Unset, str] = UNSET,
        note_url: Union[Unset, str] = UNSET,
        fingerprint: Union[Unset, str] = UNSET,
    ) -> "Response[Authorization]":
        url = f"/authorizations/clients/{client_id}"

        json = AuthorizationsClientsClientIdPutBody(
            **{
                "client_secret": client_secret,
                "scopes": scopes,
                "note": note,
                "note_url": note_url,
                "fingerprint": fingerprint,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_or_create_authorization_for_app_and_fingerprint(
        self,
        client_id: str,
        fingerprint: str,
        *,
        client_secret: str,
        scopes: Union[Unset, Union[List[str], None]] = UNSET,
        note: Union[Unset, str] = UNSET,
        note_url: Union[Unset, str] = UNSET,
    ) -> "Response[Authorization]":
        url = f"/authorizations/clients/{client_id}/{fingerprint}"

        json = AuthorizationsClientsClientIdFingerprintPutBody(
            **{
                "client_secret": client_secret,
                "scopes": scopes,
                "note": note,
                "note_url": note_url,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
            },
        )

    async def async_get_or_create_authorization_for_app_and_fingerprint(
        self,
        client_id: str,
        fingerprint: str,
        *,
        client_secret: str,
        scopes: Union[Unset, Union[List[str], None]] = UNSET,
        note: Union[Unset, str] = UNSET,
        note_url: Union[Unset, str] = UNSET,
    ) -> "Response[Authorization]":
        url = f"/authorizations/clients/{client_id}/{fingerprint}"

        json = AuthorizationsClientsClientIdFingerprintPutBody(
            **{
                "client_secret": client_secret,
                "scopes": scopes,
                "note": note,
                "note_url": note_url,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
            },
        )

    def get_authorization(
        self,
        authorization_id: int,
    ) -> "Response[Authorization]":
        url = f"/authorizations/{authorization_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Authorization,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_authorization(
        self,
        authorization_id: int,
    ) -> "Response[Authorization]":
        url = f"/authorizations/{authorization_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Authorization,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_authorization(
        self,
        authorization_id: int,
    ) -> "Response":
        url = f"/authorizations/{authorization_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_authorization(
        self,
        authorization_id: int,
    ) -> "Response":
        url = f"/authorizations/{authorization_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def update_authorization(
        self,
        authorization_id: int,
        *,
        scopes: Union[Unset, Union[List[str], None]] = UNSET,
        add_scopes: Union[Unset, List[str]] = UNSET,
        remove_scopes: Union[Unset, List[str]] = UNSET,
        note: Union[Unset, str] = UNSET,
        note_url: Union[Unset, str] = UNSET,
        fingerprint: Union[Unset, str] = UNSET,
    ) -> "Response[Authorization]":
        url = f"/authorizations/{authorization_id}"

        json = AuthorizationsAuthorizationIdPatchBody(
            **{
                "scopes": scopes,
                "add_scopes": add_scopes,
                "remove_scopes": remove_scopes,
                "note": note,
                "note_url": note_url,
                "fingerprint": fingerprint,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
            },
        )

    async def async_update_authorization(
        self,
        authorization_id: int,
        *,
        scopes: Union[Unset, Union[List[str], None]] = UNSET,
        add_scopes: Union[Unset, List[str]] = UNSET,
        remove_scopes: Union[Unset, List[str]] = UNSET,
        note: Union[Unset, str] = UNSET,
        note_url: Union[Unset, str] = UNSET,
        fingerprint: Union[Unset, str] = UNSET,
    ) -> "Response[Authorization]":
        url = f"/authorizations/{authorization_id}"

        json = AuthorizationsAuthorizationIdPatchBody(
            **{
                "scopes": scopes,
                "add_scopes": add_scopes,
                "remove_scopes": remove_scopes,
                "note": note,
                "note_url": note_url,
                "fingerprint": fingerprint,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
            },
        )
