"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union, Literal

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    UserMigrationsPostBodyType,
    OrgsOrgMigrationsPostBodyType,
    ReposOwnerRepoImportPutBodyType,
    ReposOwnerRepoImportPatchBodyType,
    ReposOwnerRepoImportLfsPatchBodyType,
    ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType,
)
from .models import (
    Import,
    Migration,
    BasicError,
    PorterAuthor,
    PorterLargeFile,
    ValidationError,
    MinimalRepository,
    UserMigrationsPostBody,
    OrgsOrgMigrationsPostBody,
    ReposOwnerRepoImportPutBody,
    ReposOwnerRepoImportPatchBody,
    ReposOwnerRepoImportLfsPatchBody,
    ReposOwnerRepoImportAuthorsAuthorIdPatchBody,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class MigrationsClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
    ) -> "Response[List[Migration]]":
        url = f"/orgs/{org}/migrations"

        params = {
            "per_page": per_page,
            "page": page,
            "exclude": exclude,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Migration],
        )

    async def async_list_for_org(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
    ) -> "Response[List[Migration]]":
        url = f"/orgs/{org}/migrations"

        params = {
            "per_page": per_page,
            "page": page,
            "exclude": exclude,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Migration],
        )

    def start_for_org(
        self,
        org: str,
        *,
        repositories: List[str],
        lock_repositories: Union[Unset, bool] = False,
        exclude_metadata: Union[Unset, bool] = False,
        exclude_git_data: Union[Unset, bool] = False,
        exclude_attachments: Union[Unset, bool] = False,
        exclude_releases: Union[Unset, bool] = False,
        exclude_owner_projects: Union[Unset, bool] = False,
        org_metadata_only: Union[Unset, bool] = False,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
    ) -> "Response[Migration]":
        url = f"/orgs/{org}/migrations"

        json = OrgsOrgMigrationsPostBody(
            **{
                "repositories": repositories,
                "lock_repositories": lock_repositories,
                "exclude_metadata": exclude_metadata,
                "exclude_git_data": exclude_git_data,
                "exclude_attachments": exclude_attachments,
                "exclude_releases": exclude_releases,
                "exclude_owner_projects": exclude_owner_projects,
                "org_metadata_only": org_metadata_only,
                "exclude": exclude,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Migration,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_start_for_org(
        self,
        org: str,
        *,
        repositories: List[str],
        lock_repositories: Union[Unset, bool] = False,
        exclude_metadata: Union[Unset, bool] = False,
        exclude_git_data: Union[Unset, bool] = False,
        exclude_attachments: Union[Unset, bool] = False,
        exclude_releases: Union[Unset, bool] = False,
        exclude_owner_projects: Union[Unset, bool] = False,
        org_metadata_only: Union[Unset, bool] = False,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
    ) -> "Response[Migration]":
        url = f"/orgs/{org}/migrations"

        json = OrgsOrgMigrationsPostBody(
            **{
                "repositories": repositories,
                "lock_repositories": lock_repositories,
                "exclude_metadata": exclude_metadata,
                "exclude_git_data": exclude_git_data,
                "exclude_attachments": exclude_attachments,
                "exclude_releases": exclude_releases,
                "exclude_owner_projects": exclude_owner_projects,
                "org_metadata_only": org_metadata_only,
                "exclude": exclude,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Migration,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_status_for_org(
        self,
        org: str,
        migration_id: int,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
    ) -> "Response[Migration]":
        url = f"/orgs/{org}/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Migration,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_status_for_org(
        self,
        org: str,
        migration_id: int,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
    ) -> "Response[Migration]":
        url = f"/orgs/{org}/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Migration,
            error_models={
                "404": BasicError,
            },
        )

    def download_archive_for_org(
        self,
        org: str,
        migration_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        return self._github.request(
            "GET",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_download_archive_for_org(
        self,
        org: str,
        migration_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        return await self._github.arequest(
            "GET",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def delete_archive_for_org(
        self,
        org: str,
        migration_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_archive_for_org(
        self,
        org: str,
        migration_id: int,
    ) -> "Response":
        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def unlock_repo_for_org(
        self,
        org: str,
        migration_id: int,
        repo_name: str,
    ) -> "Response":
        url = f"/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_unlock_repo_for_org(
        self,
        org: str,
        migration_id: int,
        repo_name: str,
    ) -> "Response":
        url = f"/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def list_repos_for_org(
        self,
        org: str,
        migration_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_for_org(
        self,
        org: str,
        migration_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    def get_import_status(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import"

        return self._github.request(
            "GET",
            url,
            response_model=Import,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_import_status(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Import,
            error_models={
                "404": BasicError,
            },
        )

    def start_import(
        self,
        owner: str,
        repo: str,
        *,
        vcs_url: str,
        vcs: Union[Unset, Literal["subversion", "git", "mercurial", "tfvc"]] = UNSET,
        vcs_username: Union[Unset, str] = UNSET,
        vcs_password: Union[Unset, str] = UNSET,
        tfvc_project: Union[Unset, str] = UNSET,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import"

        json = ReposOwnerRepoImportPutBody(
            **{
                "vcs_url": vcs_url,
                "vcs": vcs,
                "vcs_username": vcs_username,
                "vcs_password": vcs_password,
                "tfvc_project": tfvc_project,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Import,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_start_import(
        self,
        owner: str,
        repo: str,
        *,
        vcs_url: str,
        vcs: Union[Unset, Literal["subversion", "git", "mercurial", "tfvc"]] = UNSET,
        vcs_username: Union[Unset, str] = UNSET,
        vcs_password: Union[Unset, str] = UNSET,
        tfvc_project: Union[Unset, str] = UNSET,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import"

        json = ReposOwnerRepoImportPutBody(
            **{
                "vcs_url": vcs_url,
                "vcs": vcs,
                "vcs_username": vcs_username,
                "vcs_password": vcs_password,
                "tfvc_project": tfvc_project,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Import,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def cancel_import(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/import"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_cancel_import(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/import"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_import(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[Unset, Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import"

        json = body

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Import,
        )

    async def async_update_import(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[Unset, Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import"

        json = body

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Import,
        )

    def get_commit_authors(
        self,
        owner: str,
        repo: str,
        since: Union[Unset, int] = UNSET,
    ) -> "Response[List[PorterAuthor]]":
        url = f"/repos/{owner}/{repo}/import/authors"

        params = {
            "since": since,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PorterAuthor],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_authors(
        self,
        owner: str,
        repo: str,
        since: Union[Unset, int] = UNSET,
    ) -> "Response[List[PorterAuthor]]":
        url = f"/repos/{owner}/{repo}/import/authors"

        params = {
            "since": since,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PorterAuthor],
            error_models={
                "404": BasicError,
            },
        )

    def map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        email: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
    ) -> "Response[PorterAuthor]":
        url = f"/repos/{owner}/{repo}/import/authors/{author_id}"

        json = ReposOwnerRepoImportAuthorsAuthorIdPatchBody(
            **{
                "email": email,
                "name": name,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=PorterAuthor,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        email: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
    ) -> "Response[PorterAuthor]":
        url = f"/repos/{owner}/{repo}/import/authors/{author_id}"

        json = ReposOwnerRepoImportAuthorsAuthorIdPatchBody(
            **{
                "email": email,
                "name": name,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=PorterAuthor,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_large_files(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[PorterLargeFile]]":
        url = f"/repos/{owner}/{repo}/import/large_files"

        return self._github.request(
            "GET",
            url,
            response_model=List[PorterLargeFile],
        )

    async def async_get_large_files(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[PorterLargeFile]]":
        url = f"/repos/{owner}/{repo}/import/large_files"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[PorterLargeFile],
        )

    def set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        use_lfs: Literal["opt_in", "opt_out"],
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import/lfs"

        json = ReposOwnerRepoImportLfsPatchBody(
            **{
                "use_lfs": use_lfs,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Import,
            error_models={
                "422": ValidationError,
            },
        )

    async def async_set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        use_lfs: Literal["opt_in", "opt_out"],
    ) -> "Response[Import]":
        url = f"/repos/{owner}/{repo}/import/lfs"

        json = ReposOwnerRepoImportLfsPatchBody(
            **{
                "use_lfs": use_lfs,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Import,
            error_models={
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Migration]]":
        url = "/user/migrations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Migration],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Migration]]":
        url = "/user/migrations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Migration],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def start_for_authenticated_user(
        self,
        *,
        lock_repositories: Union[Unset, bool] = UNSET,
        exclude_metadata: Union[Unset, bool] = UNSET,
        exclude_git_data: Union[Unset, bool] = UNSET,
        exclude_attachments: Union[Unset, bool] = UNSET,
        exclude_releases: Union[Unset, bool] = UNSET,
        exclude_owner_projects: Union[Unset, bool] = UNSET,
        org_metadata_only: Union[Unset, bool] = False,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
        repositories: List[str],
    ) -> "Response[Migration]":
        url = "/user/migrations"

        json = UserMigrationsPostBody(
            **{
                "lock_repositories": lock_repositories,
                "exclude_metadata": exclude_metadata,
                "exclude_git_data": exclude_git_data,
                "exclude_attachments": exclude_attachments,
                "exclude_releases": exclude_releases,
                "exclude_owner_projects": exclude_owner_projects,
                "org_metadata_only": org_metadata_only,
                "exclude": exclude,
                "repositories": repositories,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Migration,
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_start_for_authenticated_user(
        self,
        *,
        lock_repositories: Union[Unset, bool] = UNSET,
        exclude_metadata: Union[Unset, bool] = UNSET,
        exclude_git_data: Union[Unset, bool] = UNSET,
        exclude_attachments: Union[Unset, bool] = UNSET,
        exclude_releases: Union[Unset, bool] = UNSET,
        exclude_owner_projects: Union[Unset, bool] = UNSET,
        org_metadata_only: Union[Unset, bool] = False,
        exclude: Union[Unset, List[Literal["repositories"]]] = UNSET,
        repositories: List[str],
    ) -> "Response[Migration]":
        url = "/user/migrations"

        json = UserMigrationsPostBody(
            **{
                "lock_repositories": lock_repositories,
                "exclude_metadata": exclude_metadata,
                "exclude_git_data": exclude_git_data,
                "exclude_attachments": exclude_attachments,
                "exclude_releases": exclude_releases,
                "exclude_owner_projects": exclude_owner_projects,
                "org_metadata_only": org_metadata_only,
                "exclude": exclude,
                "repositories": repositories,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Migration,
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_status_for_authenticated_user(
        self,
        migration_id: int,
        exclude: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Migration]":
        url = f"/user/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Migration,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_status_for_authenticated_user(
        self,
        migration_id: int,
        exclude: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Migration]":
        url = f"/user/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Migration,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_archive_for_authenticated_user(
        self,
        migration_id: int,
    ) -> "Response":
        url = f"/user/migrations/{migration_id}/archive"

        return self._github.request(
            "GET",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_archive_for_authenticated_user(
        self,
        migration_id: int,
    ) -> "Response":
        url = f"/user/migrations/{migration_id}/archive"

        return await self._github.arequest(
            "GET",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_archive_for_authenticated_user(
        self,
        migration_id: int,
    ) -> "Response":
        url = f"/user/migrations/{migration_id}/archive"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_archive_for_authenticated_user(
        self,
        migration_id: int,
    ) -> "Response":
        url = f"/user/migrations/{migration_id}/archive"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def unlock_repo_for_authenticated_user(
        self,
        migration_id: int,
        repo_name: str,
    ) -> "Response":
        url = f"/user/migrations/{migration_id}/repos/{repo_name}/lock"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_unlock_repo_for_authenticated_user(
        self,
        migration_id: int,
        repo_name: str,
    ) -> "Response":
        url = f"/user/migrations/{migration_id}/repos/{repo_name}/lock"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_repos_for_authenticated_user(
        self,
        migration_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/user/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_for_authenticated_user(
        self,
        migration_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/user/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )
