"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Union, Literal

from githubkit.utils import UNSET, Unset, exclude_unset

from .models import MarkdownPostBody
from .types import MarkdownPostBodyType

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class MarkdownClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def render(
        self,
        *,
        text: str,
        mode: Union[Unset, Literal["markdown", "gfm"]] = "markdown",
        context: Union[Unset, str] = UNSET,
    ) -> "Response[str]":
        url = "/markdown"

        json = MarkdownPostBody(
            **{
                "text": text,
                "mode": mode,
                "context": context,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=str,
        )

    async def async_render(
        self,
        *,
        text: str,
        mode: Union[Unset, Literal["markdown", "gfm"]] = "markdown",
        context: Union[Unset, str] = UNSET,
    ) -> "Response[str]":
        url = "/markdown"

        json = MarkdownPostBody(
            **{
                "text": text,
                "mode": mode,
                "context": context,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=str,
        )

    def render_raw(
        self,
        *,
        body: Union[Unset, str] = UNSET,
    ) -> "Response[str]":
        url = "/markdown/raw"

        content = body

        return self._github.request(
            "POST",
            url,
            content=exclude_unset(content),
            response_model=str,
        )

    async def async_render_raw(
        self,
        *,
        body: Union[Unset, str] = UNSET,
    ) -> "Response[str]":
        url = "/markdown/raw"

        content = body

        return await self._github.arequest(
            "POST",
            url,
            content=exclude_unset(content),
            response_model=str,
        )
