"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union, Literal

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    SelectedActionsType,
    ScimV2EnterprisesEnterpriseUsersPostBodyType,
    ScimV2EnterprisesEnterpriseGroupsPostBodyType,
    EnterprisesEnterpriseActionsPermissionsPutBodyType,
    EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
    ScimV2EnterprisesEnterpriseUsersPostBodyPropNameType,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyType,
    ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyType,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyType,
    ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyType,
    ScimV2EnterprisesEnterpriseUsersPostBodyPropEmailsItemsType,
    ScimV2EnterprisesEnterpriseUsersPostBodyPropGroupsItemsType,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
    ScimV2EnterprisesEnterpriseGroupsPostBodyPropMembersItemsType,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropNameType,
    EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropEmailsItemsType,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropGroupsItemsType,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyPropMembersItemsType,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyPropOperationsItemsType,
    ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyPropOperationsItemsType,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
)
from .models import (
    Runner,
    BasicError,
    AuditLogEvent,
    SelectedActions,
    RunnerApplication,
    ScimEnterpriseUser,
    AuthenticationToken,
    ScimEnterpriseGroup,
    ValidationErrorSimple,
    RunnerGroupsEnterprise,
    ScimUserListEnterprise,
    ScimGroupListEnterprise,
    ActionsEnterprisePermissions,
    ScimV2EnterprisesEnterpriseUsersPostBody,
    ScimV2EnterprisesEnterpriseGroupsPostBody,
    EnterprisesEnterpriseActionsPermissionsPutBody,
    EnterprisesEnterpriseActionsRunnerGroupsPostBody,
    EnterprisesEnterpriseActionsRunnersGetResponse200,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPutBody,
    ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBody,
    ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBody,
    ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBody,
    EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody,
    EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
    EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class EnterpriseAdminClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get_github_actions_permissions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[ActionsEnterprisePermissions]":
        url = f"/enterprises/{enterprise}/actions/permissions"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsEnterprisePermissions,
        )

    async def async_get_github_actions_permissions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[ActionsEnterprisePermissions]":
        url = f"/enterprises/{enterprise}/actions/permissions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsEnterprisePermissions,
        )

    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        enabled_organizations: Literal["all", "none", "selected"],
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions"

        json = EnterprisesEnterpriseActionsPermissionsPutBody(
            **{
                "enabled_organizations": enabled_organizations,
                "allowed_actions": allowed_actions,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        enabled_organizations: Literal["all", "none", "selected"],
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions"

        json = EnterprisesEnterpriseActionsPermissionsPutBody(
            **{
                "enabled_organizations": enabled_organizations,
                "allowed_actions": allowed_actions,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def list_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

    async def async_list_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        selected_organization_ids: List[int],
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        json = EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody(
            **{
                "selected_organization_ids": selected_organization_ids,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        selected_organization_ids: List[int],
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        json = EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody(
            **{
                "selected_organization_ids": selected_organization_ids,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def enable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_enable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def disable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_disable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_allowed_actions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[SelectedActions]":
        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        return self._github.request(
            "GET",
            url,
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[SelectedActions]":
        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=SelectedActions,
        )

    def set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        json = SelectedActions(
            **{
                "github_owned_allowed": github_owned_allowed,
                "verified_allowed": verified_allowed,
                "patterns_allowed": patterns_allowed,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        json = SelectedActions(
            **{
                "github_owned_allowed": github_owned_allowed,
                "verified_allowed": verified_allowed,
                "patterns_allowed": patterns_allowed,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def list_self_hosted_runner_groups_for_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        visible_to_organization: Union[Unset, str] = UNSET,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_organization": visible_to_organization,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        )

    async def async_list_self_hosted_runner_groups_for_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        visible_to_organization: Union[Unset, str] = UNSET,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_organization": visible_to_organization,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        )

    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        name: str,
        visibility: Union[Unset, Literal["selected", "all"]] = UNSET,
        selected_organization_ids: Union[Unset, List[int]] = UNSET,
        runners: Union[Unset, List[int]] = UNSET,
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups"

        json = EnterprisesEnterpriseActionsRunnerGroupsPostBody(
            **{
                "name": name,
                "visibility": visibility,
                "selected_organization_ids": selected_organization_ids,
                "runners": runners,
                "allows_public_repositories": allows_public_repositories,
                "restricted_to_workflows": restricted_to_workflows,
                "selected_workflows": selected_workflows,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsEnterprise,
        )

    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        name: str,
        visibility: Union[Unset, Literal["selected", "all"]] = UNSET,
        selected_organization_ids: Union[Unset, List[int]] = UNSET,
        runners: Union[Unset, List[int]] = UNSET,
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups"

        json = EnterprisesEnterpriseActionsRunnerGroupsPostBody(
            **{
                "name": name,
                "visibility": visibility,
                "selected_organization_ids": selected_organization_ids,
                "runners": runners,
                "allows_public_repositories": allows_public_repositories,
                "restricted_to_workflows": restricted_to_workflows,
                "selected_workflows": selected_workflows,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsEnterprise,
        )

    def get_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        return self._github.request(
            "GET",
            url,
            response_model=RunnerGroupsEnterprise,
        )

    async def async_get_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=RunnerGroupsEnterprise,
        )

    def delete_self_hosted_runner_group_from_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_self_hosted_runner_group_from_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        name: Union[Unset, str] = UNSET,
        visibility: Union[Unset, Literal["selected", "all"]] = "all",
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        json = EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody(
            **{
                "name": name,
                "visibility": visibility,
                "allows_public_repositories": allows_public_repositories,
                "restricted_to_workflows": restricted_to_workflows,
                "selected_workflows": selected_workflows,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsEnterprise,
        )

    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        name: Union[Unset, str] = UNSET,
        visibility: Union[Unset, Literal["selected", "all"]] = "all",
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        json = EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody(
            **{
                "name": name,
                "visibility": visibility,
                "allows_public_repositories": allows_public_repositories,
                "restricted_to_workflows": restricted_to_workflows,
                "selected_workflows": selected_workflows,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsEnterprise,
        )

    def list_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

    async def async_list_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        selected_organization_ids: List[int],
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        json = (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody(
                **{
                    "selected_organization_ids": selected_organization_ids,
                }
            ).dict(by_alias=True)
        )

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        selected_organization_ids: List[int],
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        json = (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody(
                **{
                    "selected_organization_ids": selected_organization_ids,
                }
            ).dict(by_alias=True)
        )

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def add_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_add_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def remove_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200]":
        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200]":
        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        runners: List[int],
    ) -> "Response":
        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        json = EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody(
            **{
                "runners": runners,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        runners: List[int],
    ) -> "Response":
        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        json = EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody(
            **{
                "runners": runners,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def add_self_hosted_runner_to_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_add_self_hosted_runner_to_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def remove_self_hosted_runner_from_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_self_hosted_runner_from_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_self_hosted_runners_for_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/enterprises/{enterprise}/actions/runners/downloads"

        return self._github.request(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    async def async_list_runner_applications_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/enterprises/{enterprise}/actions/runners/downloads"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    def create_registration_token_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/enterprises/{enterprise}/actions/runners/registration-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/enterprises/{enterprise}/actions/runners/registration-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/enterprises/{enterprise}/actions/runners/remove-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/enterprises/{enterprise}/actions/runners/remove-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_self_hosted_runner_from_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "GET",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "GET",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        json = EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody(
            **{
                "labels": labels,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        json = EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody(
            **{
                "labels": labels,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        json = EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody(
            **{
                "labels": labels,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        json = EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody(
            **{
                "labels": labels,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        name: str,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}"

        return self._github.request(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        name: str,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_audit_log(
        self,
        enterprise: str,
        phrase: Union[Unset, str] = UNSET,
        include: Union[Unset, Literal["web", "git", "all"]] = UNSET,
        after: Union[Unset, str] = UNSET,
        before: Union[Unset, str] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = UNSET,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[List[AuditLogEvent]]":
        url = f"/enterprises/{enterprise}/audit-log"

        params = {
            "phrase": phrase,
            "include": include,
            "after": after,
            "before": before,
            "order": order,
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[AuditLogEvent],
        )

    async def async_get_audit_log(
        self,
        enterprise: str,
        phrase: Union[Unset, str] = UNSET,
        include: Union[Unset, Literal["web", "git", "all"]] = UNSET,
        after: Union[Unset, str] = UNSET,
        before: Union[Unset, str] = UNSET,
        order: Union[Unset, Literal["desc", "asc"]] = UNSET,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[List[AuditLogEvent]]":
        url = f"/enterprises/{enterprise}/audit-log"

        params = {
            "phrase": phrase,
            "include": include,
            "after": after,
            "before": before,
            "order": order,
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[AuditLogEvent],
        )

    def list_provisioned_groups_enterprise(
        self,
        enterprise: str,
        start_index: Union[Unset, int] = UNSET,
        count: Union[Unset, int] = UNSET,
        filter_: Union[Unset, str] = UNSET,
        excluded_attributes: Union[Unset, str] = UNSET,
    ) -> "Response[ScimGroupListEnterprise]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        params = {
            "startIndex": start_index,
            "count": count,
            "filter": filter_,
            "excludedAttributes": excluded_attributes,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ScimGroupListEnterprise,
        )

    async def async_list_provisioned_groups_enterprise(
        self,
        enterprise: str,
        start_index: Union[Unset, int] = UNSET,
        count: Union[Unset, int] = UNSET,
        filter_: Union[Unset, str] = UNSET,
        excluded_attributes: Union[Unset, str] = UNSET,
    ) -> "Response[ScimGroupListEnterprise]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        params = {
            "startIndex": start_index,
            "count": count,
            "filter": filter_,
            "excludedAttributes": excluded_attributes,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ScimGroupListEnterprise,
        )

    def provision_and_invite_enterprise_group(
        self,
        enterprise: str,
        *,
        schemas: List[str],
        display_name: str,
        members: Union[
            Unset, List[ScimV2EnterprisesEnterpriseGroupsPostBodyPropMembersItemsType]
        ] = UNSET,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        json = ScimV2EnterprisesEnterpriseGroupsPostBody(
            **{
                "schemas": schemas,
                "displayName": display_name,
                "members": members,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseGroup,
        )

    async def async_provision_and_invite_enterprise_group(
        self,
        enterprise: str,
        *,
        schemas: List[str],
        display_name: str,
        members: Union[
            Unset, List[ScimV2EnterprisesEnterpriseGroupsPostBodyPropMembersItemsType]
        ] = UNSET,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        json = ScimV2EnterprisesEnterpriseGroupsPostBody(
            **{
                "schemas": schemas,
                "displayName": display_name,
                "members": members,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseGroup,
        )

    def get_provisioning_information_for_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        excluded_attributes: Union[Unset, str] = UNSET,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        params = {
            "excludedAttributes": excluded_attributes,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ScimEnterpriseGroup,
        )

    async def async_get_provisioning_information_for_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        excluded_attributes: Union[Unset, str] = UNSET,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        params = {
            "excludedAttributes": excluded_attributes,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ScimEnterpriseGroup,
        )

    def set_information_for_provisioned_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        schemas: List[str],
        display_name: str,
        members: Union[
            Unset,
            List[
                ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyPropMembersItemsType
            ],
        ] = UNSET,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        json = ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBody(
            **{
                "schemas": schemas,
                "displayName": display_name,
                "members": members,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseGroup,
        )

    async def async_set_information_for_provisioned_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        schemas: List[str],
        display_name: str,
        members: Union[
            Unset,
            List[
                ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBodyPropMembersItemsType
            ],
        ] = UNSET,
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        json = ScimV2EnterprisesEnterpriseGroupsScimGroupIdPutBody(
            **{
                "schemas": schemas,
                "displayName": display_name,
                "members": members,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseGroup,
        )

    def delete_scim_group_from_enterprise(
        self,
        enterprise: str,
        scim_group_id: str,
    ) -> "Response":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_scim_group_from_enterprise(
        self,
        enterprise: str,
        scim_group_id: str,
    ) -> "Response":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_attribute_for_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        schemas: List[str],
        operations: List[
            ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyPropOperationsItemsType
        ],
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        json = ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBody(
            **{
                "schemas": schemas,
                "Operations": operations,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseGroup,
        )

    async def async_update_attribute_for_enterprise_group(
        self,
        enterprise: str,
        scim_group_id: str,
        *,
        schemas: List[str],
        operations: List[
            ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBodyPropOperationsItemsType
        ],
    ) -> "Response[ScimEnterpriseGroup]":
        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        json = ScimV2EnterprisesEnterpriseGroupsScimGroupIdPatchBody(
            **{
                "schemas": schemas,
                "Operations": operations,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseGroup,
        )

    def list_provisioned_identities_enterprise(
        self,
        enterprise: str,
        start_index: Union[Unset, int] = UNSET,
        count: Union[Unset, int] = UNSET,
        filter_: Union[Unset, str] = UNSET,
    ) -> "Response[ScimUserListEnterprise]":
        url = f"/scim/v2/enterprises/{enterprise}/Users"

        params = {
            "startIndex": start_index,
            "count": count,
            "filter": filter_,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ScimUserListEnterprise,
        )

    async def async_list_provisioned_identities_enterprise(
        self,
        enterprise: str,
        start_index: Union[Unset, int] = UNSET,
        count: Union[Unset, int] = UNSET,
        filter_: Union[Unset, str] = UNSET,
    ) -> "Response[ScimUserListEnterprise]":
        url = f"/scim/v2/enterprises/{enterprise}/Users"

        params = {
            "startIndex": start_index,
            "count": count,
            "filter": filter_,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ScimUserListEnterprise,
        )

    def provision_and_invite_enterprise_user(
        self,
        enterprise: str,
        *,
        schemas: List[str],
        user_name: str,
        name: ScimV2EnterprisesEnterpriseUsersPostBodyPropNameType,
        emails: List[ScimV2EnterprisesEnterpriseUsersPostBodyPropEmailsItemsType],
        groups: Union[
            Unset, List[ScimV2EnterprisesEnterpriseUsersPostBodyPropGroupsItemsType]
        ] = UNSET,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users"

        json = ScimV2EnterprisesEnterpriseUsersPostBody(
            **{
                "schemas": schemas,
                "userName": user_name,
                "name": name,
                "emails": emails,
                "groups": groups,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseUser,
        )

    async def async_provision_and_invite_enterprise_user(
        self,
        enterprise: str,
        *,
        schemas: List[str],
        user_name: str,
        name: ScimV2EnterprisesEnterpriseUsersPostBodyPropNameType,
        emails: List[ScimV2EnterprisesEnterpriseUsersPostBodyPropEmailsItemsType],
        groups: Union[
            Unset, List[ScimV2EnterprisesEnterpriseUsersPostBodyPropGroupsItemsType]
        ] = UNSET,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users"

        json = ScimV2EnterprisesEnterpriseUsersPostBody(
            **{
                "schemas": schemas,
                "userName": user_name,
                "name": name,
                "emails": emails,
                "groups": groups,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseUser,
        )

    def get_provisioning_information_for_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        return self._github.request(
            "GET",
            url,
            response_model=ScimEnterpriseUser,
        )

    async def async_get_provisioning_information_for_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ScimEnterpriseUser,
        )

    def set_information_for_provisioned_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        schemas: List[str],
        user_name: str,
        name: ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropNameType,
        emails: List[
            ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropEmailsItemsType
        ],
        groups: Union[
            Unset,
            List[ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropGroupsItemsType],
        ] = UNSET,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        json = ScimV2EnterprisesEnterpriseUsersScimUserIdPutBody(
            **{
                "schemas": schemas,
                "userName": user_name,
                "name": name,
                "emails": emails,
                "groups": groups,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseUser,
        )

    async def async_set_information_for_provisioned_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        schemas: List[str],
        user_name: str,
        name: ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropNameType,
        emails: List[
            ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropEmailsItemsType
        ],
        groups: Union[
            Unset,
            List[ScimV2EnterprisesEnterpriseUsersScimUserIdPutBodyPropGroupsItemsType],
        ] = UNSET,
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        json = ScimV2EnterprisesEnterpriseUsersScimUserIdPutBody(
            **{
                "schemas": schemas,
                "userName": user_name,
                "name": name,
                "emails": emails,
                "groups": groups,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseUser,
        )

    def delete_user_from_enterprise(
        self,
        enterprise: str,
        scim_user_id: str,
    ) -> "Response":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_user_from_enterprise(
        self,
        enterprise: str,
        scim_user_id: str,
    ) -> "Response":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def update_attribute_for_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        schemas: List[str],
        operations: List[
            ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyPropOperationsItemsType
        ],
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        json = ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBody(
            **{
                "schemas": schemas,
                "Operations": operations,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseUser,
        )

    async def async_update_attribute_for_enterprise_user(
        self,
        enterprise: str,
        scim_user_id: str,
        *,
        schemas: List[str],
        operations: List[
            ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBodyPropOperationsItemsType
        ],
    ) -> "Response[ScimEnterpriseUser]":
        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        json = ScimV2EnterprisesEnterpriseUsersScimUserIdPatchBody(
            **{
                "schemas": schemas,
                "Operations": operations,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ScimEnterpriseUser,
        )
