"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    UserCodespacesPostBodyOneof0Type,
    UserCodespacesPostBodyOneof1Type,
    ReposOwnerRepoCodespacesPostBodyType,
    UserCodespacesCodespaceNamePatchBodyType,
    UserCodespacesSecretsSecretNamePutBodyType,
    ReposOwnerRepoPullsPullNumberCodespacesPostBodyType,
    ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType,
    UserCodespacesSecretsSecretNameRepositoriesPutBodyType,
)
from .models import (
    Codespace,
    BasicError,
    ValidationError,
    CodespacesSecret,
    CodespacesPublicKey,
    RepoCodespacesSecret,
    CodespaceExportDetails,
    CodespacesUserPublicKey,
    UserCodespacesGetResponse200,
    UserCodespacesPostBodyOneof0,
    UserCodespacesPostBodyOneof1,
    OrgsOrgCodespacesGetResponse200,
    ReposOwnerRepoCodespacesPostBody,
    UserCodespacesSecretsGetResponse200,
    UserCodespacesCodespaceNamePatchBody,
    ReposOwnerRepoCodespacesGetResponse200,
    UserCodespacesSecretsSecretNamePutBody,
    ReposOwnerRepoCodespacesNewGetResponse200,
    ReposOwnerRepoCodespacesSecretsGetResponse200,
    UserCodespacesSecretsSecretNamePutResponse201,
    ReposOwnerRepoCodespacesMachinesGetResponse200,
    ReposOwnerRepoPullsPullNumberCodespacesPostBody,
    ReposOwnerRepoCodespacesSecretsSecretNamePutBody,
    UserCodespacesCodespaceNameMachinesGetResponse200,
    AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
    UserCodespacesSecretsSecretNameRepositoriesPutBody,
    ReposOwnerRepoCodespacesDevcontainersGetResponse200,
    ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201,
    UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class CodespacesClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_in_organization(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgCodespacesGetResponse200]":
        url = f"/orgs/{org}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_in_organization(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgCodespacesGetResponse200]":
        url = f"/orgs/{org}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_from_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}"

        return self._github.request(
            "DELETE",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_from_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def stop_in_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop"

        return self._github.request(
            "POST",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_stop_in_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop"

        return await self._github.arequest(
            "POST",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCodespacesGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCodespacesGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[ReposOwnerRepoCodespacesPostBodyType, None],
    ) -> "Response[Codespace]":
        url = f"/repos/{owner}/{repo}/codespaces"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[ReposOwnerRepoCodespacesPostBodyType, None],
    ) -> "Response[Codespace]":
        url = f"/repos/{owner}/{repo}/codespaces"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_devcontainers_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCodespacesDevcontainersGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/devcontainers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesDevcontainersGetResponse200,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_devcontainers_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCodespacesDevcontainersGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/devcontainers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesDevcontainersGetResponse200,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def repo_machines_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        location: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoCodespacesMachinesGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/machines"

        params = {
            "location": location,
            "client_ip": client_ip,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_repo_machines_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        location: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoCodespacesMachinesGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/machines"

        params = {
            "location": location,
            "client_ip": client_ip,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def pre_flight_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        ref: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoCodespacesNewGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/new"

        params = {
            "ref": ref,
            "client_ip": client_ip,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesNewGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_pre_flight_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        ref: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoCodespacesNewGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/new"

        params = {
            "ref": ref,
            "client_ip": client_ip,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesNewGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesSecretsGetResponse200,
        )

    async def async_list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesSecretsGetResponse200,
        )

    def get_repo_public_key(
        self,
        owner: str,
        repo: str,
    ) -> "Response[CodespacesPublicKey]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/public-key"

        return self._github.request(
            "GET",
            url,
            response_model=CodespacesPublicKey,
        )

    async def async_get_repo_public_key(
        self,
        owner: str,
        repo: str,
    ) -> "Response[CodespacesPublicKey]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/public-key"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CodespacesPublicKey,
        )

    def get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response[RepoCodespacesSecret]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        return self._github.request(
            "GET",
            url,
            response_model=RepoCodespacesSecret,
        )

    async def async_get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response[RepoCodespacesSecret]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=RepoCodespacesSecret,
        )

    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        json = ReposOwnerRepoCodespacesSecretsSecretNamePutBody(
            **{
                "encrypted_value": encrypted_value,
                "key_id": key_id,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201,
        )

    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        json = ReposOwnerRepoCodespacesSecretsSecretNamePutBody(
            **{
                "encrypted_value": encrypted_value,
                "key_id": key_id,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201,
        )

    def delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        body: Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None],
    ) -> "Response[Codespace]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/codespaces"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        body: Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None],
    ) -> "Response[Codespace]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/codespaces"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        repository_id: Union[Unset, int] = UNSET,
    ) -> "Response[UserCodespacesGetResponse200]":
        url = "/user/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_id": repository_id,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=UserCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        repository_id: Union[Unset, int] = UNSET,
    ) -> "Response[UserCodespacesGetResponse200]":
        url = "/user/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_id": repository_id,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=UserCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def create_for_authenticated_user(
        self,
        *,
        body: Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type],
    ) -> "Response[Codespace]":
        url = "/user/codespaces"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_create_for_authenticated_user(
        self,
        *,
        body: Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type],
    ) -> "Response[Codespace]":
        url = "/user/codespaces"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_secrets_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[UserCodespacesSecretsGetResponse200]":
        url = "/user/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=UserCodespacesSecretsGetResponse200,
        )

    async def async_list_secrets_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[UserCodespacesSecretsGetResponse200]":
        url = "/user/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=UserCodespacesSecretsGetResponse200,
        )

    def get_public_key_for_authenticated_user(
        self,
    ) -> "Response[CodespacesUserPublicKey]":
        url = "/user/codespaces/secrets/public-key"

        return self._github.request(
            "GET",
            url,
            response_model=CodespacesUserPublicKey,
        )

    async def async_get_public_key_for_authenticated_user(
        self,
    ) -> "Response[CodespacesUserPublicKey]":
        url = "/user/codespaces/secrets/public-key"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CodespacesUserPublicKey,
        )

    def get_secret_for_authenticated_user(
        self,
        secret_name: str,
    ) -> "Response[CodespacesSecret]":
        url = f"/user/codespaces/secrets/{secret_name}"

        return self._github.request(
            "GET",
            url,
            response_model=CodespacesSecret,
        )

    async def async_get_secret_for_authenticated_user(
        self,
        secret_name: str,
    ) -> "Response[CodespacesSecret]":
        url = f"/user/codespaces/secrets/{secret_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CodespacesSecret,
        )

    def create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: str,
        selected_repository_ids: Union[Unset, List[str]] = UNSET,
    ) -> "Response[UserCodespacesSecretsSecretNamePutResponse201]":
        url = f"/user/codespaces/secrets/{secret_name}"

        json = UserCodespacesSecretsSecretNamePutBody(
            **{
                "encrypted_value": encrypted_value,
                "key_id": key_id,
                "selected_repository_ids": selected_repository_ids,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=UserCodespacesSecretsSecretNamePutResponse201,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: str,
        selected_repository_ids: Union[Unset, List[str]] = UNSET,
    ) -> "Response[UserCodespacesSecretsSecretNamePutResponse201]":
        url = f"/user/codespaces/secrets/{secret_name}"

        json = UserCodespacesSecretsSecretNamePutBody(
            **{
                "encrypted_value": encrypted_value,
                "key_id": key_id,
                "selected_repository_ids": selected_repository_ids,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=UserCodespacesSecretsSecretNamePutResponse201,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def delete_secret_for_authenticated_user(
        self,
        secret_name: str,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_secret_for_authenticated_user(
        self,
        secret_name: str,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
    ) -> "Response[UserCodespacesSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        return self._github.request(
            "GET",
            url,
            response_model=UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_list_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
    ) -> "Response[UserCodespacesSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        return await self._github.arequest(
            "GET",
            url,
            response_model=UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        selected_repository_ids: List[int],
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        json = UserCodespacesSecretsSecretNameRepositoriesPutBody(
            **{
                "selected_repository_ids": selected_repository_ids,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        selected_repository_ids: List[int],
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        json = UserCodespacesSecretsSecretNameRepositoriesPutBody(
            **{
                "selected_repository_ids": selected_repository_ids,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def add_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        return self._github.request(
            "PUT",
            url,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_add_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def remove_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_remove_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}"

        return self._github.request(
            "GET",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/user/codespaces/{codespace_name}"

        return self._github.request(
            "DELETE",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/user/codespaces/{codespace_name}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        machine: Union[Unset, str] = UNSET,
        display_name: Union[Unset, str] = UNSET,
        recent_folders: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}"

        json = UserCodespacesCodespaceNamePatchBody(
            **{
                "machine": machine,
                "display_name": display_name,
                "recent_folders": recent_folders,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        machine: Union[Unset, str] = UNSET,
        display_name: Union[Unset, str] = UNSET,
        recent_folders: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}"

        json = UserCodespacesCodespaceNamePatchBody(
            **{
                "machine": machine,
                "display_name": display_name,
                "recent_folders": recent_folders,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def export_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[CodespaceExportDetails]":
        url = f"/user/codespaces/{codespace_name}/exports"

        return self._github.request(
            "POST",
            url,
            response_model=CodespaceExportDetails,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_export_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[CodespaceExportDetails]":
        url = f"/user/codespaces/{codespace_name}/exports"

        return await self._github.arequest(
            "POST",
            url,
            response_model=CodespaceExportDetails,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_export_details_for_authenticated_user(
        self,
        codespace_name: str,
        export_id: str,
    ) -> "Response[CodespaceExportDetails]":
        url = f"/user/codespaces/{codespace_name}/exports/{export_id}"

        return self._github.request(
            "GET",
            url,
            response_model=CodespaceExportDetails,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_export_details_for_authenticated_user(
        self,
        codespace_name: str,
        export_id: str,
    ) -> "Response[CodespaceExportDetails]":
        url = f"/user/codespaces/{codespace_name}/exports/{export_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CodespaceExportDetails,
            error_models={
                "404": BasicError,
            },
        )

    def codespace_machines_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[UserCodespacesCodespaceNameMachinesGetResponse200]":
        url = f"/user/codespaces/{codespace_name}/machines"

        return self._github.request(
            "GET",
            url,
            response_model=UserCodespacesCodespaceNameMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_codespace_machines_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[UserCodespacesCodespaceNameMachinesGetResponse200]":
        url = f"/user/codespaces/{codespace_name}/machines"

        return await self._github.arequest(
            "GET",
            url,
            response_model=UserCodespacesCodespaceNameMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def start_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}/start"

        return self._github.request(
            "POST",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "402": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_start_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}/start"

        return await self._github.arequest(
            "POST",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "402": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def stop_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}/stop"

        return self._github.request(
            "POST",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_stop_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}/stop"

        return await self._github.arequest(
            "POST",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )
