"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Any, List, Union, Literal

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    ReposOwnerRepoCheckSuitesPostBodyType,
    ReposOwnerRepoCheckSuitesPreferencesPatchBodyType,
    ReposOwnerRepoCheckSuitesPreferencesPatchBodyPropAutoTriggerChecksItemsType,
)
from .models import (
    CheckRun,
    BasicError,
    CheckSuite,
    CheckAnnotation,
    CheckSuitePreference,
    ReposOwnerRepoCheckSuitesPostBody,
    ReposOwnerRepoCheckSuitesPreferencesPatchBody,
    ReposOwnerRepoCommitsRefCheckRunsGetResponse200,
    ReposOwnerRepoCommitsRefCheckSuitesGetResponse200,
    ReposOwnerRepoCheckRunsCheckRunIdRerequestPostResponse201,
    ReposOwnerRepoCheckSuitesCheckSuiteIdCheckRunsGetResponse200,
    ReposOwnerRepoCheckSuitesCheckSuiteIdRerequestPostResponse201,
)

if TYPE_CHECKING:
    from githubkit.core import GitHubCore
    from githubkit.response import Response


class ChecksClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def create(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[Any, Any],
    ) -> "Response[CheckRun]":
        url = f"/repos/{owner}/{repo}/check-runs"

        json = body

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=CheckRun,
        )

    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        body: Union[Any, Any],
    ) -> "Response[CheckRun]":
        url = f"/repos/{owner}/{repo}/check-runs"

        json = body

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=CheckRun,
        )

    def get(
        self,
        owner: str,
        repo: str,
        check_run_id: int,
    ) -> "Response[CheckRun]":
        url = f"/repos/{owner}/{repo}/check-runs/{check_run_id}"

        return self._github.request(
            "GET",
            url,
            response_model=CheckRun,
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        check_run_id: int,
    ) -> "Response[CheckRun]":
        url = f"/repos/{owner}/{repo}/check-runs/{check_run_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CheckRun,
        )

    def update(
        self,
        owner: str,
        repo: str,
        check_run_id: int,
        *,
        body: Union[Any, Any],
    ) -> "Response[CheckRun]":
        url = f"/repos/{owner}/{repo}/check-runs/{check_run_id}"

        json = body

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=CheckRun,
        )

    async def async_update(
        self,
        owner: str,
        repo: str,
        check_run_id: int,
        *,
        body: Union[Any, Any],
    ) -> "Response[CheckRun]":
        url = f"/repos/{owner}/{repo}/check-runs/{check_run_id}"

        json = body

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=CheckRun,
        )

    def list_annotations(
        self,
        owner: str,
        repo: str,
        check_run_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[CheckAnnotation]]":
        url = f"/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[CheckAnnotation],
        )

    async def async_list_annotations(
        self,
        owner: str,
        repo: str,
        check_run_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[CheckAnnotation]]":
        url = f"/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[CheckAnnotation],
        )

    def rerequest_run(
        self,
        owner: str,
        repo: str,
        check_run_id: int,
    ) -> "Response[ReposOwnerRepoCheckRunsCheckRunIdRerequestPostResponse201]":
        url = f"/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest"

        return self._github.request(
            "POST",
            url,
            response_model=ReposOwnerRepoCheckRunsCheckRunIdRerequestPostResponse201,
            error_models={
                "403": BasicError,
                "422": BasicError,
                "404": BasicError,
            },
        )

    async def async_rerequest_run(
        self,
        owner: str,
        repo: str,
        check_run_id: int,
    ) -> "Response[ReposOwnerRepoCheckRunsCheckRunIdRerequestPostResponse201]":
        url = f"/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest"

        return await self._github.arequest(
            "POST",
            url,
            response_model=ReposOwnerRepoCheckRunsCheckRunIdRerequestPostResponse201,
            error_models={
                "403": BasicError,
                "422": BasicError,
                "404": BasicError,
            },
        )

    def create_suite(
        self,
        owner: str,
        repo: str,
        *,
        head_sha: str,
    ) -> "Response[CheckSuite]":
        url = f"/repos/{owner}/{repo}/check-suites"

        json = ReposOwnerRepoCheckSuitesPostBody(
            **{
                "head_sha": head_sha,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=CheckSuite,
        )

    async def async_create_suite(
        self,
        owner: str,
        repo: str,
        *,
        head_sha: str,
    ) -> "Response[CheckSuite]":
        url = f"/repos/{owner}/{repo}/check-suites"

        json = ReposOwnerRepoCheckSuitesPostBody(
            **{
                "head_sha": head_sha,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=CheckSuite,
        )

    def set_suites_preferences(
        self,
        owner: str,
        repo: str,
        *,
        auto_trigger_checks: Union[
            Unset,
            List[
                ReposOwnerRepoCheckSuitesPreferencesPatchBodyPropAutoTriggerChecksItemsType
            ],
        ] = UNSET,
    ) -> "Response[CheckSuitePreference]":
        url = f"/repos/{owner}/{repo}/check-suites/preferences"

        json = ReposOwnerRepoCheckSuitesPreferencesPatchBody(
            **{
                "auto_trigger_checks": auto_trigger_checks,
            }
        ).dict(by_alias=True)

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=CheckSuitePreference,
        )

    async def async_set_suites_preferences(
        self,
        owner: str,
        repo: str,
        *,
        auto_trigger_checks: Union[
            Unset,
            List[
                ReposOwnerRepoCheckSuitesPreferencesPatchBodyPropAutoTriggerChecksItemsType
            ],
        ] = UNSET,
    ) -> "Response[CheckSuitePreference]":
        url = f"/repos/{owner}/{repo}/check-suites/preferences"

        json = ReposOwnerRepoCheckSuitesPreferencesPatchBody(
            **{
                "auto_trigger_checks": auto_trigger_checks,
            }
        ).dict(by_alias=True)

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=CheckSuitePreference,
        )

    def get_suite(
        self,
        owner: str,
        repo: str,
        check_suite_id: int,
    ) -> "Response[CheckSuite]":
        url = f"/repos/{owner}/{repo}/check-suites/{check_suite_id}"

        return self._github.request(
            "GET",
            url,
            response_model=CheckSuite,
        )

    async def async_get_suite(
        self,
        owner: str,
        repo: str,
        check_suite_id: int,
    ) -> "Response[CheckSuite]":
        url = f"/repos/{owner}/{repo}/check-suites/{check_suite_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CheckSuite,
        )

    def list_for_suite(
        self,
        owner: str,
        repo: str,
        check_suite_id: int,
        check_name: Union[Unset, str] = UNSET,
        status: Union[Unset, Literal["queued", "in_progress", "completed"]] = UNSET,
        filter_: Union[Unset, Literal["latest", "all"]] = "latest",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCheckSuitesCheckSuiteIdCheckRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs"

        params = {
            "check_name": check_name,
            "status": status,
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCheckSuitesCheckSuiteIdCheckRunsGetResponse200,
        )

    async def async_list_for_suite(
        self,
        owner: str,
        repo: str,
        check_suite_id: int,
        check_name: Union[Unset, str] = UNSET,
        status: Union[Unset, Literal["queued", "in_progress", "completed"]] = UNSET,
        filter_: Union[Unset, Literal["latest", "all"]] = "latest",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCheckSuitesCheckSuiteIdCheckRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs"

        params = {
            "check_name": check_name,
            "status": status,
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCheckSuitesCheckSuiteIdCheckRunsGetResponse200,
        )

    def rerequest_suite(
        self,
        owner: str,
        repo: str,
        check_suite_id: int,
    ) -> "Response[ReposOwnerRepoCheckSuitesCheckSuiteIdRerequestPostResponse201]":
        url = f"/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest"

        return self._github.request(
            "POST",
            url,
            response_model=ReposOwnerRepoCheckSuitesCheckSuiteIdRerequestPostResponse201,
        )

    async def async_rerequest_suite(
        self,
        owner: str,
        repo: str,
        check_suite_id: int,
    ) -> "Response[ReposOwnerRepoCheckSuitesCheckSuiteIdRerequestPostResponse201]":
        url = f"/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest"

        return await self._github.arequest(
            "POST",
            url,
            response_model=ReposOwnerRepoCheckSuitesCheckSuiteIdRerequestPostResponse201,
        )

    def list_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        check_name: Union[Unset, str] = UNSET,
        status: Union[Unset, Literal["queued", "in_progress", "completed"]] = UNSET,
        filter_: Union[Unset, Literal["latest", "all"]] = "latest",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        app_id: Union[Unset, int] = UNSET,
    ) -> "Response[ReposOwnerRepoCommitsRefCheckRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/check-runs"

        params = {
            "check_name": check_name,
            "status": status,
            "filter": filter_,
            "per_page": per_page,
            "page": page,
            "app_id": app_id,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCommitsRefCheckRunsGetResponse200,
        )

    async def async_list_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        check_name: Union[Unset, str] = UNSET,
        status: Union[Unset, Literal["queued", "in_progress", "completed"]] = UNSET,
        filter_: Union[Unset, Literal["latest", "all"]] = "latest",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        app_id: Union[Unset, int] = UNSET,
    ) -> "Response[ReposOwnerRepoCommitsRefCheckRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/check-runs"

        params = {
            "check_name": check_name,
            "status": status,
            "filter": filter_,
            "per_page": per_page,
            "page": page,
            "app_id": app_id,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCommitsRefCheckRunsGetResponse200,
        )

    def list_suites_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        app_id: Union[Unset, int] = UNSET,
        check_name: Union[Unset, str] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCommitsRefCheckSuitesGetResponse200]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/check-suites"

        params = {
            "app_id": app_id,
            "check_name": check_name,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCommitsRefCheckSuitesGetResponse200,
        )

    async def async_list_suites_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        app_id: Union[Unset, int] = UNSET,
        check_name: Union[Unset, str] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCommitsRefCheckSuitesGetResponse200]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/check-suites"

        params = {
            "app_id": app_id,
            "check_name": check_name,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCommitsRefCheckSuitesGetResponse200,
        )
